package com.adpdigital.push.notification;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.RemoteViews;

import com.adpdigital.push.R;

import java.util.ArrayList;
import java.util.Collections;

import static com.adpdigital.push.AdpPushClient.TAG;

public class SimpleCollapseNotification {

    private SimpleCollapseNotification() {
    }

    public static class Builder {
        private int color = -1;
        private Bitmap largeIcon;
        private Context mContext;
        private CharSequence body;
        private CharSequence title;
        private RemoteViews mCollapseView;
        private boolean showActionRtl = false;
        private boolean alignActionsRtl = false;
        private ArrayList<NotificationCompat.Action> actions;

        public Builder(Context context) {
            this.mContext = context;

            if (context != null) {
                mCollapseView = new RemoteViews(context.getPackageName(), R.layout.simple_notification);
            } else {
                Log.e(TAG, "Builder: context is null");
            }
        }

        public CharSequence getBody() {
            return body;
        }

        public Builder setBody(CharSequence body) {
            this.body = body.toString().replace(System.getProperty("line.separator"), " ");

            if (mCollapseView == null){
                Log.e(TAG, "setBody: mCollapseView is null");

                return this;
            }

            if (body != null) {
                mCollapseView.setTextViewText(R.id.bodyTextView, body);
            } else {
                mCollapseView.setViewVisibility(R.id.bodyTextView, View.GONE);
            }

            return this;
        }

        public CharSequence getTitle() {
            return title;
        }

        public Builder setTitle(CharSequence title) {
            this.title = title;

            if (mCollapseView == null){
                Log.e(TAG, "setTitle: mCollapseView is null");

                return this;
            }

            if (title != null) {
                mCollapseView.setTextViewText(R.id.titleTextView, title);
            } else {
                mCollapseView.setViewVisibility(R.id.titleTextView, View.GONE);
            }

            return this;
        }

        public Bitmap getLargeIcon() {
            return largeIcon;
        }

        public Builder setLargeIcon(Bitmap largeIcon) {
            this.largeIcon = largeIcon;

            if (mCollapseView == null){
                Log.e(TAG, "setLargeIcon: mCollapseView is null");

                return this;
            }

            if (largeIcon == null) {
                mCollapseView.setViewVisibility(R.id.leftLargeIconImageView, View.GONE);
                mCollapseView.setViewVisibility(R.id.rightLargeIconImageView, View.GONE);
            }

            return this;
        }

        public int getColor() {
            return color;
        }

        public Builder setColor(int color) {
            this.color = color;

            return this;
        }

        public ArrayList<NotificationCompat.Action> getActions() {
            return actions;
        }

        public Builder setActions(ArrayList<NotificationCompat.Action> actions) {
            this.actions = actions;

            return this;
        }

        public boolean isAlignActionsRtl() {
            return alignActionsRtl;
        }

        public Builder setAlignActionsRtl(boolean alignActionsRtl) {
            this.alignActionsRtl = alignActionsRtl;

            return this;
        }

        public boolean isShowActionRtl() {
            return showActionRtl;
        }

        public Builder setShowActionRtl(boolean showActionRtl) {
            this.showActionRtl = showActionRtl;

            return this;
        }

        @Nullable
        public RemoteViews remoteViewsBuilder() {
            if (mCollapseView == null){
                Log.e(TAG, "remoteViewsBuilder: mCollapseView is null");

                return null;
            }

            boolean isLTR = StringUtils.isLTR(this.getBody().toString());

            if (isLTR) {
                mCollapseView.setInt(R.id.titleAndBodyLayout,"setGravity", Gravity.START);
            } else {
                mCollapseView.setInt(R.id.titleAndBodyLayout,"setGravity", Gravity.END);
            }

            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.M) {
                this.provideFullscreenAlign();
            }

            if (this.getBody() == null){
                mCollapseView.setViewVisibility(R.id.bodyTextView, View.GONE);
            } else {
                mCollapseView.setTextViewText(R.id.bodyTextView, this.getBody());
            }

            if (this.getTitle() == null || this.getTitle().toString().trim().length() == 0) {
                mCollapseView.setViewVisibility(R.id.titleTextView, View.GONE);
                float scale = mContext.getResources().getDisplayMetrics().density;
                int padding = (int) (10*scale + 0.5f);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                    mCollapseView.setViewPadding(R.id.bodyTextView, 0,padding, 0, 0);
                }

            } else {
                mCollapseView.setTextViewText(R.id.titleTextView, this.getTitle());
            }

            mCollapseView.setViewVisibility(R.id.leftLargeIconImageView, View.GONE);
            mCollapseView.setViewVisibility(R.id.rightLargeIconImageView, View.GONE);

            if (this.largeIcon != null){
                if (isLTR) {
                    mCollapseView.setImageViewBitmap(R.id.leftLargeIconImageView, largeIcon);
                    mCollapseView.setViewVisibility(R.id.leftLargeIconImageView, View.VISIBLE);
                } else {
                    mCollapseView.setImageViewBitmap(R.id.rightLargeIconImageView, largeIcon);
                    mCollapseView.setViewVisibility(R.id.rightLargeIconImageView, View.VISIBLE);
                }
            }

            if (this.isShowActionRtl()){
                mCollapseView.setInt(R.id.actionsLayout, "setGravity", Gravity.END);
            } else {
                mCollapseView.setInt(R.id.actionsLayout, "setGravity", Gravity.START);
            }

            if (this.actions == null || this.actions.isEmpty()){
                mCollapseView.setViewVisibility(R.id.actionsLayout, View.GONE);
            } else {
                ArrayList<NotificationCompat.Action> actions = this.getActions();
                if (this.isAlignActionsRtl()){
                    Collections.reverse(actions);
                }

                int count = Math.min(actions.size(), 3);
                for (int i = 0; i < count; i++) {
                    mCollapseView.addView(
                            R.id.actionsLayout,
                            NotificationUtil.generateActionButton(actions.get(i), this.getColor(), this.mContext)
                    );
                }
            }


            return mCollapseView;
        }

        public void provideFullscreenAlign(){
            if (mCollapseView == null) {
                Log.e(TAG, "remoteViewsBuilder: mCollapseView is null");
                return;
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                float scale = mContext.getResources().getDisplayMetrics().density;
                int padding = (int) (10*scale + 0.5f);

                mCollapseView.setViewPadding(R.id.parentLayout, padding,padding, padding, 0);
            }
        }
    }
}


