package com.adpdigital.push.notification;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import android.view.View;
import android.widget.RemoteViews;

import com.adpdigital.push.R;

public class NotificationUtil {

    public static RemoteViews generateActionButton(NotificationCompat.Action action, int color , Context context) {
        boolean tombstone = action.actionIntent == null;
        RemoteViews button = new RemoteViews(context.getPackageName(), R.layout.notification_action);

        Bitmap coloredIcon = createColoredBitmap(
                action.getIcon(),
                color,
                context
        );

        if (coloredIcon != null) {
            button.setImageViewBitmap(R.id.action_image, coloredIcon);
            button.setViewVisibility(R.id.action_image, View.VISIBLE);
        } else {
            button.setViewVisibility(R.id.action_image, View.GONE);

            int topAndBottom = getSizeFromScreenDp(5, context);
            int rightAndLeft = getSizeFromScreenDp(20, context);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                button.setViewPadding(R.id.action_text ,rightAndLeft,topAndBottom,rightAndLeft,topAndBottom);
            }
        }

        if (color != -1) {
            button.setTextColor(R.id.action_text, color);
        }

        button.setTextViewText(R.id.action_text, action.title);

        if (!tombstone) {
            button.setOnClickPendingIntent(R.id.action_container, action.actionIntent);
        }

        if (Build.VERSION.SDK_INT >= 15) {
            button.setContentDescription(R.id.action_container, action.title);
        }

        return button;
    }

    public static Bitmap createColoredBitmap(int iconId, int color, Context context) {
        return createColoredBitmap(iconId, color, 0, context);
    }

    @Nullable
    private static Bitmap createColoredBitmap(int iconId, int color, int size, Context context) {
        try {
            Drawable drawable;

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                drawable = context.getResources().getDrawable(iconId, context.getTheme());
            } else {
                drawable = context.getResources().getDrawable(iconId);
            }

            int width = size == 0 ? drawable.getIntrinsicWidth() : size;
            int height = size == 0 ? drawable.getIntrinsicHeight() : size;
            Bitmap resultBitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            drawable.setBounds(0, 0, width, height);
            if (color != 0) {
                drawable.mutate().setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
            }

            Canvas canvas = new Canvas(resultBitmap);
            drawable.draw(canvas);

            return resultBitmap;
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        return null;
    }

    public static int getSizeFromScreenDp(int pixelSize, Context context){
        float scale = context.getResources().getDisplayMetrics().density;
        return  (int) (pixelSize*scale + 0.5f);
    }
}
