package com.adpdigital.push.config;

public abstract class ConfigurationFactory {

    public static Configuration getConfiguration(Environment environment) {
        if (environment == null){
            return new DevelopConfig();
        }
        switch (environment) {
            case SANDBOX:
                return new SandboxConfig();
            case PRODUCTION:
                return new ProductionConfig();
            default:
                return null;
        }
    }
}
