package com.adpdigital.push.config;

import android.content.res.Resources;

import com.adpdigital.push.Base64Support;

import java.io.UnsupportedEncodingException;

public abstract class Configuration {
    String apiKey = "";
    String appId = "";
    String username = "";
    String password = "";
    boolean realtime = false;
    boolean pushNotification = false;

    Configuration() {
        try {
            init();
        } catch (Resources.NotFoundException e) {
            throw new IllegalStateException("AdpPushClient not initialized, " +
                    "Make sure to put the json files in root of your project. Please see http://bit.ly/32x1Tsn");
        }
    }

    protected abstract void init();

    public abstract String environment();

    public String apiKey() {
        return apiKey;
    }

    public String appId() {
        return appId;
    }

    public String username() {
        return username;
    }

    public String password() {
        return password;
    }

    public boolean realtime() {
        return realtime;
    }

    public boolean pushNotification() {
        return pushNotification;
    }

    static String decrypt(String value) {
        String output = value;
        try {
            output = fromHexString(new String(Base64Support.decode(value.getBytes("UTF-8"),
                    Base64Support.NO_WRAP)));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return output;
    }

    private static String fromHexString(String hex) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            str.append((char) Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return str.toString();
    }
}
