package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.IBinder;


/**
 * @author Behrad
 */
@SuppressWarnings("unused")
public class PushService extends Service {

    private final static String TAG = PushService.class.getName();


    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        Logger.d(TAG, "PushService action " + action);

        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) { // Android 8.0 or higher
                if (!AdpPushClient.get().isForeground()) {
                    return;
                }
            }

            context.startService(actionIntent);
        } catch (Exception exc){
            Logger.w(TAG, "Couldn't start service in foreground ("
                    + AdpPushClient.get().isForeground() + ") with action " + action );
            exc.printStackTrace();
        }
    }


    public static boolean isRunning(Context ctx) {
        ActivityManager manager = (ActivityManager) ctx.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (PushService.class.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }

    private static SharedPreferences getSharedPreferences(Context ctx) {
        return ChabokLocalStorage.getSharedPreferences(ctx);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Logger.d(TAG, "Creating Chabok PushService");

        PushServiceManager.getInstance(this).setupAndStart();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Logger.i(TAG, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + flags + ", " + startId);
        if ((intent == null) || (intent.getAction() == null)) {
            Logger.i(TAG, "Start PushService with empty action");
            PushServiceManager.getInstance(this).start();
        } else {
            Logger.i(TAG, "PushService action " + intent.getAction()
                    + ", foreground:" + AdpPushClient.get().isForeground()
                    + ", screenOn:" + PushServiceManager.isScreenOn()
            );
            switch (intent.getAction()) {
                case "START":
                    PushServiceManager.getInstance(this).start();
                    break;
                case "RESTART":
                    PushServiceManager.getInstance(this).restart();
                    break;
                case "KEEP_ALIVE":
                    PushServiceManager.getInstance(this).sendKeepAlive();
                    break;
                case "RECONNECT":
                    PushServiceManager.getInstance(this).attemptReconnect();
                    break;
                case "DISCONNECT":
                    PushServiceManager.getInstance(this).cancelReconnect();
                    PushServiceManager.getInstance(this).stopKeepAliveTimerAndWifilock();
                    if (PushServiceManager.connection != null) {
                        PushServiceManager.connection.disconnectExistingClient();
                    }
                    break;
                case "BackgroundTimeExceeded":
                    PushServiceManager.getInstance(this).cleanUp();
                    break;
                default:
                    Logger.w(TAG, "Unrecognized action " + intent.getAction());
            }
        }

        if (AdpPushClient.get().shouldBeSticky()) {
            Logger.d(TAG, "service is sticky");
            return START_STICKY;
        }
        Logger.d(TAG, "service is not sticky");
        return START_NOT_STICKY;
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        Logger.w(TAG, "PushService removed: " + rootIntent.getAction() + rootIntent);

        PushServiceManager.getInstance(this).cleanUp();
        AdpPushClient.get().dismiss();

        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onLowMemory() {
        Logger.w(TAG, "push service low memory...");
        //TODO should we optimize background here?

        PushServiceManager.getInstance(this).cleanUp();
        AdpPushClient.get().dismiss();

        super.onLowMemory();
    }

    @Override
    public void onTrimMemory(int level) {
        Logger.w(TAG, "push service trim memory " + level);
        super.onTrimMemory(level);
    }

    @Override
    public void onDestroy() {
        Logger.i(TAG, "destroying push service");

        //TODO should I scheduleServiceRestart here instead of START_STICKY?
        PushServiceManager.getInstance(this).cleanUp();
//        getHAdpPushClient.get().dismiss();

        super.onDestroy();
    }


    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

}