package com.adpdigital.push;

import androidx.annotation.NonNull;
import android.text.TextUtils;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ChabokManufacturer {

    String convertToMd5(String manStr) {
        String adId = "";
        MessageDigest mdEnc;
        try {
            mdEnc = MessageDigest.getInstance("MD5");
            mdEnc.update(manStr.getBytes(), 0, manStr.length());
            StringBuilder manStrBuilder = new StringBuilder(new BigInteger(1, mdEnc.digest()).toString(16));
            while (manStrBuilder.length() < 32) {
                manStrBuilder.insert(0, "0");
            }
            manStr = manStrBuilder.toString();
            adId = manStr;
        } catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        return adId;
    }

    int getTypeCode(String deviceType) {
        int deviceTypeCode = 2;
        if (deviceType.length() > deviceTypeCode) {
            deviceTypeCode = deviceType.charAt(deviceTypeCode);
        }
        return deviceTypeCode;
    }

    String getSugarString(int typeCode, long modified) {
        String modifiedStr = Long.toString(modified);
        int sugar = typeCode % getModifiedChar(modifiedStr);
        int sugarPlacement = Integer.parseInt(Character.toString(modifiedStr.charAt(modifiedStr.length() - 3)));

        long[] modifiers = convertToArray(modified);
        long[] placementCharFir = Arrays.copyOfRange(modifiers, 0, sugarPlacement);
        List<Long> firstList = charsToList(placementCharFir);

        long[] placementCharSec = Arrays.copyOfRange(modifiers, sugarPlacement, modifiedStr.length());
        List<Long> secondList = charsToList(placementCharSec);

        firstList.add((long) sugar);
        firstList.addAll(secondList);

        return listToString(firstList);
    }

    List<Long> charsToList(long[] chars){
        List<Long> cList = new ArrayList<>();
        for(long n : chars) {
            cList.add(n);
        }
        return cList;
    }

    int getModifiedChar(String modified) {
        char[] modChar = modified.toCharArray();
        for (int i = modChar.length - 1; i >= 0; i--) {
            if (!Character.toString(modChar[i]).contains("0")) {
                return Integer.parseInt(Character.toString(modChar[i]));
            }
        }
        return 9;
    }

    String listToString(List<Long> ints) {
        StringBuilder iStr = new StringBuilder();
        for (long n : ints) {
            iStr.append(Long.toString(n));
        }
        return iStr.toString();
    }

    long[] convertToArray(long number) {
        String str = (Long.valueOf(number)).toString();
        char[] chArr = str.toCharArray();
        long[] arr = new long[chArr.length];
        for (int i = 0; i < chArr.length; i++) {
            arr[i] = Character.getNumericValue(chArr[i]);
        }
        return arr;
    }

    SecureString getManufacturerDevice(@NonNull SecureString str1, String str2, String str3) {
        if (str1.asString() == null || str2 == null || str3 == null) {
            return SecureString.instance("");
        }
        String[] list = {str1.asString(), str2, str3};

        return SecureString.instance(TextUtils.join(getJoinId().asString(), list));
    }

    SecureString getJoinId() {
        SecureString bitString = new SecureString("");
        byte[] bitCode = new byte[]{49, 56, 49, 55, 49};

        for (byte c : bitCode) {
            bitString = SecureString.instance(bitString.asString() + Character.getNumericValue(c));
        }

        String payloadId = getManufacturerId(bitString.asString());
        String payloadForm = getManufacturerForm(payloadId);
        char[] payloadChr = payloadForm.toCharArray();
        bitString = new SecureString("");

        for (int i = 0; i < payloadChr.length; i = i + 2) {
            if ((i + 1) < payloadChr.length)
                bitString = SecureString.instance(bitString.asString() +
                        ((char) Integer.parseInt(payloadChr[i] + "" + payloadChr[i + 1]))
                );
        }
        return bitString;
    }

    String getManufacturerId(String bitCode) {
        if (bitCode == null || bitCode.isEmpty()) {
            return "";
        }
        StringBuilder charString = new StringBuilder();
        char[] bits = bitCode.toCharArray();
        for (int i = 0; i < bits.length; i++) {
            if (i % 2 == 0 && i < bits.length - 1) {
                charString.append(Character.getNumericValue(bits[i]) + (Character.getNumericValue(bits[i]) << Character.getNumericValue(bits[i]))).append(Character.getNumericValue(bits[i]) << Character.getNumericValue(bits[i]));
            } else if (i < bits.length - 1) {
                charString.append(Math.abs((Character.getNumericValue(bits[i]) - Character.getNumericValue(bits[4 - i])))).append(Character.getNumericValue(bits[i]) + Math.abs((Character.getNumericValue(bits[i]) - Character.getNumericValue(bits[4 - i]))));
            } else {
                charString.append(bits[i]).append("0");
            }
        }
        return charString.toString();
    }

    String getManufacturerForm(String manufacturer) {
        if (manufacturer == null || manufacturer.isEmpty()) {
            return "";
        }
        StringBuilder charString = new StringBuilder();
        char[] payBits = manufacturer.toCharArray();
        for (int i = 0; i < payBits.length; i = i + 2) {
            if (i < 4 && (i + 1) < payBits.length) {
                charString.append(Character.getNumericValue(payBits[i]) * Character.getNumericValue(payBits[i + 1])).append(Character.getNumericValue(payBits[i + 1]));
            } else if (i < 8 && (i + 1) < payBits.length) {
                charString.append((Character.getNumericValue(payBits[i]) * Character.getNumericValue(payBits[i + 1])) + 1).append(Character.getNumericValue(payBits[i + 1]));
            } else {
                charString.append(Character.getNumericValue(payBits[i]) * 6).append("0");
            }
        }
        return charString.toString();
    }
}