package com.adpdigital.push;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import static com.adpdigital.push.AdpPushClient.TAG;

class ChabokEventDataStorage {

    private static boolean directInfluenced = false;
    private static boolean hasData = false;
    private static Set<String> publishIds = new HashSet<>();

    static boolean hasData() {
        hasData = AdpPushClient.get().getSharedPreferences().getBoolean(Constants.CHK_HAS_DATA, hasData);
        return hasData;
    }

    static void setHasData(boolean has) {
        hasData = has;
        AdpPushClient.get().getSharedPreferences().edit().putBoolean(Constants.CHK_HAS_DATA, hasData).apply();
    }

    static boolean insertData(JSONObject data) {
        if (data == null){
            return false;
        }
        Logger.d(Logger.TAG, "---- Store data to storage. json  " + SecureString.instance(data.toString()));

        try {
            JSONArray payloads = getAllData();

            if (payloads == null) {
                payloads = new JSONArray();
            }

            data.put("dirty", false);
            payloads.put(data);

            AdpPushClient.get().getSharedPreferences()
                    .edit()
                    .putString(
                            Constants.CHK_EVENT_PAYLOADS,
                            ChabokCrypto.encrypt(AdpPushClient.get().getContext(), payloads.toString())
                    ).apply();

            setHasData(true);

            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return false;
    }

    private static JSONArray getAllData() {
        String jsonEnc = AdpPushClient.get().getSharedPreferences().getString(Constants.CHK_EVENT_PAYLOADS, null);

        if (jsonEnc != null) {
            String json = ChabokCrypto.decrypt(AdpPushClient.get().getContext(), jsonEnc);
            try {
                JSONArray payloads = new JSONArray(json);

                return payloads;
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        return null;
    }

    static void resetAllDirtyDataStatus(){
        JSONArray allData = getAllData();

        if (allData == null){
            return;
        }

        for (int i = 0; i < allData.length(); i++) {
            try {
                JSONObject data = allData.getJSONObject(i);

                data.put("dirty", false);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        AdpPushClient.get().getSharedPreferences()
                .edit()
                .putString(
                        Constants.CHK_EVENT_PAYLOADS,
                        ChabokCrypto.encrypt(AdpPushClient.get().getContext(), allData.toString())
                ).apply();
    }


    static JSONArray changeToDirtyInStorage() {
        JSONArray allData = getAllData();
        JSONArray changedToDirtyData = new JSONArray();

        if (allData == null){
            return null;
        }

        for (int i = 0; i < allData.length(); i++) {
            try {
                JSONObject data = allData.getJSONObject(i);

                if (!checkIsDirty(data)){
                    JSONObject copy = new JSONObject(data.toString());
                    copy.remove("dirty");

                    changedToDirtyData.put(copy);
                }

                data.put("dirty", true);
                data.put("dirtyExpire", System.currentTimeMillis() + (60 * 1000));

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        AdpPushClient.get().getSharedPreferences()
                .edit()
                .putString(
                        Constants.CHK_EVENT_PAYLOADS,
                        ChabokCrypto.encrypt(AdpPushClient.get().getContext(), allData.toString())
                ).apply();

        Logger.d(TAG, "========= dirtyData = "+ SecureString.instance(changedToDirtyData.toString()) +
                "\n allData = " + SecureString.instance(allData.toString()));

        return changedToDirtyData;
    }

    private static boolean checkIsDirty(JSONObject data) throws JSONException {
        boolean isDirty = data.getBoolean("dirty");

        if (data.has("dirtyExpire")){
            long expireTs = data.getLong("dirtyExpire");

            Date expireDate = new Date(expireTs);

            if (expireDate.before(new Date())){
                isDirty = false;
            }
        }
        return isDirty;
    }

    static void removeDirtyData() {
        JSONArray notSentData = getNotSentData();

        if (notSentData == null || notSentData.length() == 0){
            setHasData(false);

            AdpPushClient.get().getSharedPreferences()
                    .edit()
                    .remove(Constants.CHK_EVENT_PAYLOADS)
                    .apply();
        } else {
            AdpPushClient.get().getSharedPreferences()
                    .edit()
                    .putString(
                            Constants.CHK_EVENT_PAYLOADS,
                            ChabokCrypto.encrypt(AdpPushClient.get().getContext(), notSentData.toString())
                    ).apply();
        }

        Logger.d(Logger.TAG, "---- Clear dirty event data from storage.");
    }

    static JSONArray getNotSentData() {
        JSONArray allData = getAllData();
        JSONArray notSentData = new JSONArray();

        if (allData == null){
            return null;
        }

        for (int i = 0; i < allData.length(); i++) {
            try {
                JSONObject data = allData.getJSONObject(i);

                if (!checkIsDirty(data)){
                    notSentData.put(data);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        return notSentData;
    }

    static void addPublishId(String id) {
        publishIds.add(id);
    }

    static boolean removePublishId(String id){
        if (publishIds.contains(id)){
            publishIds.remove(id);
            return true;
        }
        return false;
    }

    static void removeLastNotificationOpenedInfluence(){
        AdpPushClient.get().getSharedPreferences()
                .edit()
                .remove(Constants.CHK_INFLUENCE)
                .apply();
    }

    static void storeLastNotificationOpenedInfluence(JSONObject message){
        if (message == null){
            AdpPushClient.get().getSharedPreferences()
                    .edit()
                    .remove(Constants.CHK_INFLUENCE)
                    .apply();
            return;
        }
        long expireTs = System.currentTimeMillis() + (12 * 60 * 60 * 1000);

        try {
            message.put("expire", expireTs);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        String jsonEnc = ChabokCrypto.encrypt(AdpPushClient.get().getContext(), message.toString());

        AdpPushClient.get().getSharedPreferences()
                .edit()
                .putString(Constants.CHK_INFLUENCE, jsonEnc)
                .apply();
    }

    static JSONObject getLastNotificationOpenedInfluence(){
        String jsonEnc = AdpPushClient.get().getSharedPreferences().getString(Constants.CHK_INFLUENCE, null);
        if (jsonEnc == null){
            return null;
        }

        String json = ChabokCrypto.decrypt(AdpPushClient.get().getContext(), jsonEnc);

        try {
            JSONObject lastNotifOpenedData = new JSONObject(json);

            if (lastNotifOpenedData.has("expire")){
                long expireTs = lastNotifOpenedData.getLong("expire");

                Date expireDate = new Date(expireTs);

                if (expireDate.before(new Date())){
                    removeLastNotificationOpenedInfluence();

                    return null;
                }
                lastNotifOpenedData.remove("expire");
            }
            return lastNotifOpenedData;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    static void setIsDirectInfluenced(boolean direct){
        directInfluenced = direct;
    }

    static boolean isDirectInfluenced(){
        return directInfluenced;
    }
}