/*
 * Decompiled with CFR 0.152.
 */
package org.MRR.NZV.NZV.NZV.NZV.MRR;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.MRR.NZV.NZV.NZV.HXH;
import org.MRR.NZV.NZV.NZV.LMH;
import org.MRR.NZV.NZV.NZV.NZV.MRR.DYH;
import org.MRR.NZV.NZV.NZV.NZV.MRR.GMT;
import org.MRR.NZV.NZV.NZV.NZV.MRR.HUI;
import org.MRR.NZV.NZV.NZV.NZV.MRR.IRK;
import org.MRR.NZV.NZV.NZV.NZV.MRR.IZX;
import org.MRR.NZV.NZV.NZV.NZV.MRR.KEM;
import org.MRR.NZV.NZV.NZV.NZV.MRR.NZV;
import org.MRR.NZV.NZV.NZV.NZV.MRR.OJW;
import org.MRR.NZV.NZV.NZV.NZV.MRR.RGI;
import org.MRR.NZV.NZV.NZV.NZV.MRR.RPN;
import org.MRR.NZV.NZV.NZV.NZV.MRR.SUU;
import org.MRR.NZV.NZV.NZV.NZV.MRR.UFF;
import org.MRR.NZV.NZV.NZV.NZV.MRR.VIN;
import org.MRR.NZV.NZV.NZV.NZV.MRR.VLN;
import org.MRR.NZV.NZV.NZV.NZV.MRR.YCE;

public abstract class CVA {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final String STRING_ENCODING = "UTF-8";
    private static final String[] NZV = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private byte MRR;
    protected int msgId;
    protected boolean duplicate = false;

    /*
     * WARNING - void declaration
     */
    public CVA(byte type) {
        void var1_1;
        this.MRR = var1_1;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws HXH {
        return new byte[0];
    }

    public byte getType() {
        return this.MRR;
    }

    public int getMessageId() {
        return this.msgId;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessageId(int msgId) {
        void var1_1;
        this.msgId = var1_1;
    }

    public String getKey() {
        return new Integer(this.getMessageId()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getHeader() throws HXH {
        try {
            void var2_3;
            void var3_4;
            int first = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] varHeader = this.getVariableHeader();
            int remLen = varHeader.length + this.getPayload().length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(first);
            dos.write(CVA.encodeMBI((long)var3_4));
            dos.write((byte[])var2_3);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            void var1_2;
            throw new HXH((Throwable)var1_2);
        }
    }

    protected abstract byte[] getVariableHeader() throws HXH;

    public boolean isMessageIdRequired() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static CVA createWireMessage(LMH data) throws HXH {
        VIN vIN;
        void var1_1;
        byte[] payload = data.getPayloadBytes();
        if (payload == null) {
            payload = new byte[]{};
        }
        vIN = new VIN(data.getHeaderBytes(), data.getHeaderOffset(), data.getHeaderLength(), (byte[])var1_1, data.getPayloadOffset(), vIN.getPayloadLength());
        return CVA.NZV(vIN);
    }

    public static CVA createWireMessage(byte[] bytes) throws HXH {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = byteArrayInputStream;
        return CVA.NZV(byteArrayInputStream);
    }

    /*
     * WARNING - void declaration
     */
    private static CVA NZV(InputStream inputStream) throws HXH {
        try {
            void var3_4;
            NZV result;
            NZV counter = new NZV(inputStream);
            DataInputStream in = new DataInputStream(counter);
            int first = in.readUnsignedByte();
            byte type = (byte)(first >> 4);
            byte info = (byte)(first & 0xF);
            long remLen = CVA.readMBI(in).getValue();
            long l = (long)counter.getCounter() + remLen;
            long remainder = l - (long)counter.getCounter();
            NZV data = (NZV)new byte[0];
            if (remainder > 0L) {
                void var1_2;
                data = (NZV)new byte[(int)remainder];
                var1_2.readFully((byte[])data, 0, ((Object)data).length);
            }
            if (type == 1) {
                result = new HUI(info, (byte[])data);
            } else if (type == 3) {
                result = new SUU(info, (byte[])result);
            } else if (type == 4) {
                result = new IZX(info, (byte[])result);
            } else if (type == 7) {
                result = new org.MRR.NZV.NZV.NZV.NZV.MRR.HXH(info, (byte[])result);
            } else if (type == 2) {
                result = new OJW(info, (byte[])result);
            } else if (type == 12) {
                result = new DYH(info, (byte[])result);
            } else if (type == 13) {
                result = new KEM(info, (byte[])result);
            } else if (type == 8) {
                result = new IRK(info, (byte[])result);
            } else if (type == 9) {
                result = new VLN(info, (byte[])result);
            } else if (type == 10) {
                result = new RPN(info, (byte[])result);
            } else if (type == 11) {
                result = new RGI(info, (byte[])result);
            } else if (type == 6) {
                result = new org.MRR.NZV.NZV.NZV.NZV.MRR.LMH(info, (byte[])result);
            } else if (type == 5) {
                result = new UFF(info, (byte[])result);
            } else if (var3_4 == 14) {
                void var2_3;
                result = new YCE((byte)var2_3, (byte[])result);
            } else {
                throw com.adpdigital.push.HUI.createBrokerException(6);
            }
            return result;
        }
        catch (IOException io) {
            void var0_1;
            throw new HXH((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static byte[] encodeMBI(long number) {
        void var0_1;
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        do {
            void var1_4;
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            bos.write((int)var1_4);
        } while (no > 0L && ++numBytes < 4);
        return var0_1.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    protected static GMT readMBI(DataInputStream in) throws IOException {
        void var2_1;
        void var1_4;
        long msgLength = 0L;
        int multiplier = 1;
        int count = 0;
        do {
            byte digit = in.readByte();
            ++count;
            msgLength += (long)((digit & 0x7F) * multiplier);
            multiplier <<= 7;
        } while ((var1_4 & 0x80) != 0);
        return new GMT((long)var2_1, count);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] encodeMessageId() throws HXH {
        try {
            void var2_3;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            var2_3.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            void var1_2;
            throw new HXH((Throwable)var1_2);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setDuplicate(boolean duplicate) {
        void var1_1;
        this.duplicate = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void encodeUTF8(DataOutputStream dos, String stringToEncode) throws HXH {
        try {
            void var1_1;
            void var3_5;
            byte[] encodedString = stringToEncode.getBytes(STRING_ENCODING);
            byte byte1 = (byte)(encodedString.length >>> 8);
            byte byte2 = (byte)encodedString.length;
            dos.write((int)var3_5);
            dos.write(byte2);
            var1_1.write(encodedString);
            return;
        }
        catch (UnsupportedEncodingException ex) {
            throw new HXH(ex);
        }
        catch (IOException ex) {
            void var2_4;
            throw new HXH((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String decodeUTF8(DataInputStream input) throws HXH {
        try {
            void var1_1;
            int n = input.readUnsignedShort();
            byte[] encodedString = new byte[n];
            var1_1.readFully(encodedString);
            return new String(encodedString, STRING_ENCODING);
        }
        catch (IOException ex) {
            void var2_4;
            throw new HXH((Throwable)var2_4);
        }
    }

    public String toString() {
        return NZV[this.MRR];
    }
}

