/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

final class OWQ {
    public static MRR getGooglePlayServicesInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Google Play Services info can't be accessed from the main thread");
        }
        context.getPackageManager().getPackageInfo("com.android.vending", 0);
        NZV connection = new NZV(0);
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                OJW gpsInterface = new OJW(connection.getBinder());
                MRR mRR = new MRR(gpsInterface.getGpsAdid(), gpsInterface.getTrackingEnabled(true));
                return mRR;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    private static final class OJW
    implements IInterface {
        private IBinder NZV;

        public OJW(IBinder pBinder) {
            this.NZV = pBinder;
        }

        public final IBinder asBinder() {
            return this.NZV;
        }

        public final String getGpsAdid() throws RemoteException {
            String id2;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.NZV.transact(1, data, reply, 0);
                reply.readException();
                id2 = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id2;
        }

        public final Boolean getTrackingEnabled(boolean paramBoolean) throws RemoteException {
            Boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.NZV.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            if (limitAdTracking != null) {
                return limitAdTracking == false;
            }
            return null;
        }
    }

    private static final class NZV
    implements ServiceConnection {
        boolean NZV = false;
        private final LinkedBlockingQueue<IBinder> MRR = new LinkedBlockingQueue(1);

        private NZV() {
        }

        public final void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.MRR.put(service);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
        }

        public final IBinder getBinder() throws InterruptedException {
            if (this.NZV) {
                throw new IllegalStateException();
            }
            this.NZV = true;
            return this.MRR.take();
        }

        /* synthetic */ NZV(byte by) {
            this();
        }
    }

    public static final class MRR {
        private final String NZV;
        private final Boolean MRR;

        MRR(String gpdAdid, Boolean trackingEnabled) {
            this.NZV = gpdAdid;
            this.MRR = trackingEnabled;
        }

        public final String getGpsAdid() {
            return this.NZV;
        }

        public final Boolean isTrackingEnabled() {
            return this.MRR;
        }
    }
}

