/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.os.Bundle;
import com.adpdigital.push.PushMessage;
import java.util.Map;

public class ChabokNotification {
    private String id;
    private String title;
    private String text;
    private PushMessage message;
    private Bundle extras;
    private int badge;
    private String sound;
    private boolean alert = true;
    private String topicName;
    private String trackId;

    public ChabokNotification(String id2, String title, String text, int badge) {
        this.id = id2;
        this.title = title;
        this.badge = badge;
        this.text = text;
    }

    public ChabokNotification(String id2, String title, String text, int badge, Map<String, String> extras) {
        this.id = id2;
        this.title = title;
        this.badge = badge;
        this.text = text;
        if (extras != null) {
            this.sound = extras.get("sound");
        }
        this.extras = this.mapToBundle(extras);
    }

    public ChabokNotification(String id2, String title, String text, int badge, Bundle extras) {
        this.id = id2;
        this.title = title;
        this.badge = badge;
        this.text = text;
        if (extras != null) {
            this.sound = extras.getString("sound");
        }
        this.extras = extras;
    }

    public ChabokNotification(PushMessage message, int badge) {
        this.message = message;
        this.id = message.getId();
        this.title = message.getAlertTitle();
        if (this.title == null) {
            this.title = message.getAlertText();
        }
        this.text = message.getBody();
        if (message.getAlertText() != null && !message.getAlertText().trim().equalsIgnoreCase("")) {
            this.text = message.getAlertText();
        }
        this.badge = badge;
        if (message.getSound() != null) {
            this.sound = message.getSound();
        }
    }

    private Bundle mapToBundle(Map<String, String> data) {
        if (data == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (entry.getValue() == null) continue;
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getBadge() {
        return this.badge;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage getMessage() {
        return this.message;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String trackId) {
        this.trackId = trackId;
    }
}

