/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.adpdigital.push.AGP;
import com.adpdigital.push.AOP;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.AppState;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.CVA;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokEvent;
import com.adpdigital.push.ChabokFirebaseMessaging;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.DYH;
import com.adpdigital.push.Datetime;
import com.adpdigital.push.DeferredDataListener;
import com.adpdigital.push.EIW;
import com.adpdigital.push.ELX;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GKV;
import com.adpdigital.push.GMT;
import com.adpdigital.push.GTE;
import com.adpdigital.push.HCZ;
import com.adpdigital.push.HWU;
import com.adpdigital.push.IMV;
import com.adpdigital.push.IRK;
import com.adpdigital.push.IXL;
import com.adpdigital.push.IZX;
import com.adpdigital.push.JAZ;
import com.adpdigital.push.JHA;
import com.adpdigital.push.JMY;
import com.adpdigital.push.JYK;
import com.adpdigital.push.JZR;
import com.adpdigital.push.KEM;
import com.adpdigital.push.KPZ;
import com.adpdigital.push.KTB;
import com.adpdigital.push.LMH;
import com.adpdigital.push.LOX;
import com.adpdigital.push.LPP;
import com.adpdigital.push.LogLevel;
import com.adpdigital.push.MRQ;
import com.adpdigital.push.MRR;
import com.adpdigital.push.NAU;
import com.adpdigital.push.NHW;
import com.adpdigital.push.NZV;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.OJW;
import com.adpdigital.push.OWQ;
import com.adpdigital.push.OnDeeplinkResponseListener;
import com.adpdigital.push.PWW;
import com.adpdigital.push.PZH;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.QHG;
import com.adpdigital.push.QHM;
import com.adpdigital.push.RFF;
import com.adpdigital.push.RGI;
import com.adpdigital.push.RPN;
import com.adpdigital.push.RTB;
import com.adpdigital.push.RTU;
import com.adpdigital.push.SCK;
import com.adpdigital.push.SUU;
import com.adpdigital.push.TUY;
import com.adpdigital.push.UFF;
import com.adpdigital.push.UGK;
import com.adpdigital.push.UIR;
import com.adpdigital.push.UYC;
import com.adpdigital.push.VIN;
import com.adpdigital.push.VLN;
import com.adpdigital.push.VMB;
import com.adpdigital.push.WAW;
import com.adpdigital.push.WFM;
import com.adpdigital.push.WGR;
import com.adpdigital.push.WVK;
import com.adpdigital.push.XTU;
import com.adpdigital.push.XXU;
import com.adpdigital.push.YCE;
import com.adpdigital.push.ZTV;
import com.adpdigital.push.ZWK;
import com.adpdigital.push.config.Environment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static final String SDK_VERSION = "3.2.0";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final String USE_BADGE_COUNT = "com.adpdigital.push.client.BadgeCount";
    public static final String ADVERTISING_ID_ENABLED = "com.adpdigital.push.client.ADVERTISING_ID_ENABLED";
    public static final String FB_DEFAULT_NOTIFICATION_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String CHABOK_DEFAULT_NOTIFICATION_ICON = "com.adpdigital.push.client.default_notification_icon";
    public static final String SHOW_ONLY_CHABOK_NOTIFICATIONS = "com.adpdigital.push.client.SHOW_ONLY_CHABOK_NOTIFICATIONS";
    public static final String DISABLE_REALTIME = "com.adpdigital.push.client.DISABLE_REALTIME";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    public static final String PURCHASE_EVENT_NAME = "purchase";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int installationRetries;
    private static int tokenRetries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    private static boolean disableSdk;
    private static Environment chabokEnvironment;
    private Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private MRR.LMH adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long lastLaunchTime;
    private long installDate;
    private boolean isLaunched = false;
    private XTU.OJW eventBus = XTU.OJW.getDefault();
    private static Context context;
    private static Class activityClass;
    private WeakReference<Activity> currentActivity;
    private ChabokNotificationAction lastNotificationAction;
    private ChabokNotification lastNotificationData;
    private OnDeeplinkResponseListener onDeeplinkResponseListener;
    private DeferredDataListener deferredDataListener;
    private com.adpdigital.push.config.NZV config;
    private String userHash;
    private boolean isLoggedIn = false;
    private static Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    private final Object _installationLock = new Object();
    private final Object _tokenLock = new Object();
    private static final ScheduledExecutorService tokenWorker;
    private static String defaultTracker;
    private String userId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private HCZ communicateFallbackMachine = HCZ.getInstance();
    private static final String GUEST_TAG = "CHABOK_GUEST";
    private static final String META_DATA = "__meta";
    private Callback<String> registerCallback;

    public static void setLogLevel(LogLevel logLevel) {
        UYC.setLogLevel(logLevel);
    }

    public static void setApplicationContext(Context context) {
        UYC.d(TAG, "setApplicationContext is called with context = " + context);
        AdpPushClient.context = context.getApplicationContext() == null ? context : context.getApplicationContext();
        if (AdpPushClient.context instanceof Application) {
            AdpPushClient.registerOnActivityLifeCycle((Application)context);
        }
        activityClass = AdpPushClient.getActivityClass(AdpPushClient.context);
    }

    private static void registerOnActivityLifeCycle(Application context) {
        try {
            if (lifecycleCallbacks == null) {
                lifecycleCallbacks = new NZV();
                context.registerActivityLifecycleCallbacks(lifecycleCallbacks);
            }
            return;
        }
        catch (Exception ignored) {
            UYC.e(TAG, "can not register activity life cycle listener", ignored);
            return;
        }
    }

    static Class getActivityClass(Context context) {
        try {
            return Class.forName(context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent().getClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UYC.w(TAG, "Could not find main activity class. Please before calling Chabok init method call AdpPushClient.setActivityClass(MainActivity.getClass())");
            return null;
        }
    }

    private AdpPushClient(String appId, String apiKey, String username, String password) {
        UYC.i(TAG, "Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate(appId, apiKey, username, password);
        this.eventBus.register(this);
        if (!this.checkPlayServices()) {
            IMV.setIsSupportPlayServices(this.getApplicationContext(), true);
            UYC.w(TAG, "No valid Google Play Services found.");
        } else {
            IMV.setIsSupportPlayServices(this.getApplicationContext(), false);
        }
        if (this.shouldBeSticky() && this.hasProtectedAppSupport()) {
            this.eventBus.post((Object)AppState.PROTECTED_GRANT_NEEDED);
        }
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new LMH(this));
        this.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static AdpPushClient init(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            if (pushClientInstance != null) return pushClientInstance;
            packageName = AdpPushClient.context.getPackageName();
            pushClientInstance = new AdpPushClient(appId, apiKey, username, password);
            XTU.OJW.getDefault().post((Object)AppState.INITIALIZED);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    private static AdpPushClient init(String appId, String apiKey, String username, String password) {
        return AdpPushClient.init(context, activityClass, appId, apiKey, username, password);
    }

    public static void setDisableSdk(boolean disableSdk) {
        AdpPushClient.disableSdk = disableSdk;
        if (disableSdk) {
            UYC.w(TAG, "Chabok has been disabled.");
        }
    }

    public static boolean isDisabledSdk() {
        if (disableSdk) {
            UYC.w(TAG, "Chabok has been disabled by calling setDisableSdk(boolean) method.");
            return true;
        }
        return false;
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to call AdpPushClient.configureEnvironment(Environment) in onCreate() method of your Application class. Please see http://bit.ly/32x1Tsn");
        }
        return pushClientInstance;
    }

    public static Context getContext() {
        return context;
    }

    static boolean hasNotified(String id) {
        return notifs.contains(id);
    }

    private void initializeAdapter() {
        String restApi = "http://" + NAU.NZV + ":80/api/";
        String currentHost = NAU.NZV;
        String currentPortBroker = ":1880";
        this.useDev = this.getSharedPreferences().getBoolean("useDev", true);
        if (this.useSecure) {
            String appSubDomain = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                appSubDomain = this.appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + NAU.NZV + ":443/api/";
            currentHost = appSubDomain + NAU.NZV;
            currentPortBroker = ":4443";
        }
        if (this.useDev) {
            restApi = "http://sandbox.push.adpdigital.com:80/api/";
            currentHost = "sandbox.push.adpdigital.com";
            currentPortBroker = ":1880";
        }
        if (this.useDev && this.useSecure) {
            if (chabokEnvironment == null) {
                restApi = "https://dev.push.adpdigital.com:443/api/";
                currentHost = "dev.push.adpdigital.com";
            } else {
                restApi = "https://sandbox.push.adpdigital.com:443/api/";
                currentHost = "sandbox.push.adpdigital.com";
            }
            currentPortBroker = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", currentHost).putString("port", currentPortBroker).putBoolean("useSecure", this.useSecure).apply();
        this.adapter = new MRR.LMH(this.getApplicationContext(), restApi);
        this.adapter.setAccessToken(this.apiKey);
    }

    private void validateAndPopulate(String appId, String apiKey, String username, String password) {
        Set cache;
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, Please call AdpPushClient.setApplicationContext(getApplicationContext()) method before Chabok init method.");
        }
        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        IMV.setUsername(this.getApplicationContext(), username);
        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        IMV.setPassword(this.getApplicationContext(), password);
        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String applicationId = appId;
        String[] token = appId.split("/");
        if (token.length > 1) {
            applicationId = token[0];
            if (token.length == 2) {
                UYC.i(UYC.TAG, "SenderId is removed from Chabok SDK v3.0.0. Remove it from appId.");
            }
        }
        this.apiKey = apiKey;
        this.appId = applicationId;
        IMV.setAppId(this.getApplicationContext(), this.appId);
        Set<String> storedChannels = IMV.getTopics(this.getApplicationContext(), new HashSet<String>(Arrays.asList(this.channels)));
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);
        String storedNotifSettings = this.getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                this.notificationSettings = new JSONObject(storedNotifSettings);
            }
            catch (JSONException e) {
                UYC.e(TAG, e.getMessage(), e);
            }
        }
        if ((cache = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            notifs.addAll(cache);
        }
        this.isNewInstall = !this.getSharedPreferences().getBoolean("chabokInstallation", false);
        this.installDate = this.getSharedPreferences().getLong("installDate", -1L);
        if (this.installDate == -1L) {
            long unixTime = System.currentTimeMillis();
            this.getSharedPreferences().edit().putLong("installDate", unixTime).apply();
            this.installDate = unixTime;
        }
    }

    private void resetBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        alarm.cancel(this.getBackgroundIntent());
    }

    private void startBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        PendingIntent backgroundIntent = this.getBackgroundIntent();
        if (Build.VERSION.SDK_INT < 19) {
            alarm.set(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
            return;
        }
        alarm.setExact(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
    }

    private PendingIntent getBackgroundIntent() {
        Intent background = new Intent();
        background.setClass(this.getApplicationContext(), PushService.class);
        background.setAction("BackgroundTimeExceeded");
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)background, (int)0);
    }

    public void onEvent(KPZ gcmMessage) {
        UYC.w(TAG, "New GCM message (foreground:" + this.isForeground() + "): " + gcmMessage.getIntent().getExtras());
        if (this.isForeground()) {
            UYC.w(TAG, "How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient that = this;
        this.isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"), new ELX(this, that, gcmMessage));
    }

    public void publish(PushMessage message, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }
        HWU.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    public void publish(String channel, String text, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (channel.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel should not contain slashes"));
            }
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        HWU.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    public void publish(String user, String channel, String text, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (channel.contains("/") || user.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        message.setUser(user);
        HWU.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    void publishMessageEvent(String subject, String messageId) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        try {
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            this.emit(JHA.event, subject, messageId, obj, true, false);
            return;
        }
        catch (Exception e) {
            UYC.e(TAG, "Couldnt publish message event " + messageId, e);
            return;
        }
    }

    public void publishEvent(String event, JSONObject data) {
        this.publishEvent(event, data, true, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live) {
        this.publishEvent(event, data, live, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live, boolean stateful) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            UYC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            UYC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject eventData = new JSONObject();
        try {
            boolean isMatchFeedback;
            boolean bl = isMatchFeedback = event.contentEquals("matchUserFeedback") && (AdpPushClient.get().getAppId().contentEquals("90-dev") || AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                data.put("id", (Object)UUID.randomUUID().toString());
                data.put("createdAt", System.currentTimeMillis());
                eventData = data;
            } else {
                eventData.put("id", (Object)UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", (Object)data);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = eventData;
            this.eventBus.register(new ZTV(this, event, finalEventData, live, stateful));
            return;
        }
        UYC.d(TAG, "publishEvent: sending data, event: " + event);
        this.emit(JHA.event, event, this.getInstallationId(), eventData, live, stateful);
    }

    public void publishEvent(String event, Bundle data) {
        this.publishEvent(event, data, true, false);
    }

    public void publishEvent(String event, Bundle data, boolean live) {
        this.publishEvent(event, data, live, false);
    }

    public void publishEvent(String event, Bundle data, boolean live, boolean stateful) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            UYC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            UYC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        JSONObject convertedData = LPP.MRR(data);
        JSONObject eventData = new JSONObject();
        try {
            boolean isMatchFeedback;
            boolean bl = isMatchFeedback = event.contentEquals("matchUserFeedback") && (AdpPushClient.get().getAppId().contentEquals("90-dev") || AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                convertedData.put("id", (Object)UUID.randomUUID().toString());
                convertedData.put("createdAt", System.currentTimeMillis());
                if (metadata != null) {
                    convertedData.put(META_DATA, (Object)metadata);
                }
                eventData = convertedData;
            } else {
                eventData.put("id", (Object)UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", (Object)convertedData);
                if (metadata != null) {
                    eventData.put(META_DATA, (Object)metadata);
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = eventData;
            this.eventBus.register(new AGP(this, event, finalEventData, live, stateful));
            return;
        }
        UYC.d(TAG, "publishEvent: sending data, event: " + event);
        this.emit(JHA.event, event, this.getInstallationId(), eventData, live, stateful);
    }

    @Deprecated
    public void publishBackground(String event, JSONObject data) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            UYC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            UYC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject json = new JSONObject();
        JSONObject eventData = new JSONObject();
        try {
            if (event.equals("geo")) {
                eventData = data;
            } else {
                eventData.put("data", (Object)data);
            }
            eventData.put("eventName", (Object)event);
            eventData.put("id", (Object)UUID.randomUUID().toString());
            eventData.put("createdAt", System.currentTimeMillis());
            json.put("type", 3);
            json.put("data", (Object)eventData);
            PWW communicateEvent = new PWW(json, JZR.PublishInBackground);
            this.eventBus.post(communicateEvent);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private void emit(JHA type, String event, String subject, JSONObject data, boolean live, boolean stateful) {
        String string;
        String payload;
        String dataStr = "";
        if (data != null) {
            dataStr = data.toString();
            UYC.d(TAG, "emit: data: " + dataStr + " , subject: " + subject);
        }
        String string2 = payload = dataStr;
        String string3 = subject;
        String string4 = event;
        JHA jHA = type;
        HWU hWU = HWU.getInstance(this.getApplicationContext());
        switch (jHA) {
            case event: {
                string = hWU.NZV(string4, string3);
                break;
            }
            case track: {
                String string5 = string3;
                String string6 = string4;
                HWU hWU2 = hWU;
                string = "app/" + hWU2.VMB + "/track/" + string6 + "/" + string5;
                break;
            }
            default: {
                string = hWU.NZV(string4, string3);
            }
        }
        hWU.MRR(string, string2, live, stateful, new UGK(hWU));
    }

    private void isReceivedMessage(String messageId, Callback clbk) {
        HWU.getInstance(this.getApplicationContext());
        clbk.onSuccess(HWU.NZV(messageId));
    }

    public void getStatus(Callback<ConnectionStatus> clbk) {
        if (!PushService.isRunning(this.getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        clbk.onSuccess(HWU.getInstance(this.getApplicationContext()).getStatus());
    }

    public void setEnableAlertForNotSupportingGcm(boolean supportGCMDialog) {
        this.getSharedPreferences().edit().putBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", supportGCMDialog).apply();
    }

    private boolean isEnabledAlertForNotSupportingGcm() {
        return this.getSharedPreferences().getBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", true);
    }

    public void subscribe(String channel, Callback clbk) {
        this.subscribe(channel, false, clbk);
    }

    public void subscribe(String channel, boolean live, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (!live) {
            HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
            allChannels.add(this.convertChannelName2OldConvention(channel));
            IMV.setTopics(this.getApplicationContext(), allChannels);
            this.channels = allChannels.toArray(new String[allChannels.size()]);
            this.updateInstallation(new HashMap<String, Object>());
            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                ChabokFirebaseMessaging.subscribe(channel);
            }
        }
        String channelName = ChabokFirebaseMessaging.NZV(channel);
        this.createOrUpdateNotificationChannel(channel, channelName);
        HWU.getInstance(this.getApplicationContext()).NZV(channel, live, clbk);
    }

    private String convertChannelName2OldConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        if (channel.startsWith("public/")) {
            return channel;
        }
        return "public/" + channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String channel, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
        allChannels.remove(this.convertChannelName2OldConvention(channel));
        IMV.setTopics(this.getApplicationContext(), allChannels);
        this.channels = allChannels.toArray(new String[allChannels.size()]);
        this.updateInstallation(new HashMap<String, Object>());
        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            ChabokFirebaseMessaging.unsubscribe(channel);
        }
        if (this.hasNotificationChannel(channel)) {
            this.deleteNotificationChannel(channel);
        }
        Callback callback = clbk;
        String string = channel;
        HWU hWU = HWU.getInstance(this.getApplicationContext());
        Class<HWU> clazz = HWU.class;
        synchronized (HWU.class) {
            if (!hWU.isConnected()) {
                UYC.w(HWU.NZV, "No Connection or not connected, How to unsub?");
                callback.onFailure(new Exception("Not Connected"));
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            String string2 = hWU.MRR(string);
            new RTU(hWU, string2, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        this.notificationSettings.remove(topicName);
        try {
            topicSetting.put("sound", (Object)sound);
            topicSetting.put("alert", alert);
            this.notificationSettings.put(topicName, (Object)topicSetting);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            HashMap<String, Object> props = new HashMap<String, Object>();
            HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
            if (notifSettings != null) {
                props.put("notificationSettings", notifSettings);
            }
            this.updateInstallation(props);
            return;
        }
        catch (JSONException e) {
            UYC.e(TAG, e.getMessage(), e);
            return;
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            this.eventBus.register(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            this.eventBus.post(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            this.eventBus.unregister(object);
        }
        return this;
    }

    public AdpPushClient setPushListener(Object ctx) {
        return this.addListener(ctx);
    }

    public AdpPushClient removePushListener(Object activity) {
        return this.removeListener(activity);
    }

    private AdpPushClient register(String userId) {
        return this.register(userId, new String[0], null);
    }

    private AdpPushClient register(String userId, Callback<String> registrationCallback) {
        return this.register(userId, new String[0], registrationCallback);
    }

    private AdpPushClient register(String userId, String[] channels, Callback<String> registrationCallback) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            UYC.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }
        if (!this.isValid(userId)) {
            UYC.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }
        String guid = this.getGuestUserId();
        if (guid != null && !userId.contentEquals(guid)) {
            this.isLoggedIn = true;
            this.setGuestUserId(null);
        }
        return this._register(userId, channels, registrationCallback);
    }

    private AdpPushClient registerAsGuest() {
        return this._registerAsGuest(null, null);
    }

    private AdpPushClient registerAsGuest(Callback<String> registrationCallback) {
        return this._registerAsGuest(null, registrationCallback);
    }

    private AdpPushClient registerAsGuest(String guestId) {
        return this._registerAsGuest(guestId, null);
    }

    private AdpPushClient registerAsGuest(String guestId, Callback<String> registrationCallback) {
        return this._registerAsGuest(guestId, registrationCallback);
    }

    private AdpPushClient _registerAsGuest(String guestId, Callback<String> registrationCallback) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        String userId = this.getGuestUserId();
        if (guestId != null && userId == null || guestId != null && !guestId.contentEquals(userId)) {
            userId = guestId;
            this.setGuestUserId(userId);
        }
        if (userId == null) {
            userId = UUID.randomUUID().toString().replace("-", "");
            this.setGuestUserId(userId);
        }
        this.isLoggedIn = false;
        this.userHash = "";
        return this._register(userId, new String[0], registrationCallback);
    }

    private AdpPushClient reRegister(String userId) {
        return this.reRegister(userId, new String[0]);
    }

    private AdpPushClient reRegister(String userId, String[] channels) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        IMV.setReregisteredFrom(this.getApplicationContext(), this.userId);
        this.unregister(true);
        this._register(userId, channels, null);
        return this;
    }

    private AdpPushClient _register(String userId, String[] channels, Callback<String> registrationCallback) {
        String currentUserId;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            UYC.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }
        if (!this.isValid(userId)) {
            UYC.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }
        if (this.registering) {
            UYC.w(TAG, "Already in registering...");
            this.eventBus.register(new XXU(this, userId, channels, registrationCallback));
            return this;
        }
        this.registerCallback = registrationCallback;
        if (this.hasNotificationChannel(this.getInstallationId())) {
            this.deleteNotificationChannel(this.getInstallationId());
        }
        if (!userId.equalsIgnoreCase(currentUserId = this.getUserId())) {
            this.setRegisterTs(System.currentTimeMillis());
        }
        if (currentUserId != null && !userId.equalsIgnoreCase(currentUserId)) {
            return this.reRegister(userId, channels);
        }
        this.registeredOnce = false;
        this.userId = userId;
        IMV.setUserId(context, this.userId);
        HashSet<String> allTopics = new HashSet<String>(Arrays.asList(this.channels));
        ArrayList<String> newChannels = new ArrayList<String>();
        boolean userHasNewTopic = false;
        String[] stringArray = channels;
        int n = channels.length;
        for (int i = 0; i < n; ++i) {
            String ch = stringArray[i];
            String chName = this.convertChannelName2OldConvention(ch);
            newChannels.add(chName);
            if (allTopics.contains(chName)) continue;
            userHasNewTopic = true;
        }
        allTopics.addAll(newChannels);
        if (userHasNewTopic) {
            this.makeSubsDirty();
        }
        IMV.setTopics(this.getApplicationContext(), allTopics);
        this.channels = allTopics.toArray(new String[allTopics.size()]);
        installationRetries = 0;
        if (!this.checkPlayServices()) {
            IMV.setIsSupportPlayServices(this.getApplicationContext(), true);
            UYC.w(TAG, "No valid Google Play Services found.");
        } else {
            IMV.setIsSupportPlayServices(this.getApplicationContext(), false);
        }
        this.getApplicationInstallReferrer();
        this.doRegister();
        return this;
    }

    private boolean isValid(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (userId.length() <= 0 || userId.length() > 64) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !userId.matches(REGEX);
    }

    private void doRegister() {
        this.doRegister(false);
    }

    private void doRegister(boolean restartService) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            UYC.e(TAG, "userId not initialized yet");
            return;
        }
        if (this.registering) {
            UYC.d(TAG, "Register already in progress for " + this.userId);
            return;
        }
        this.registering = true;
        UYC.d(TAG, "-- Post Event REGISTERING");
        this.eventBus.post((Object)AppState.REGISTERING);
        this.initializeAdapter();
        worker.schedule(new LOX(this, restartService), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        if (AdpPushClient.isDisabledSdk()) {
            return false;
        }
        return this.adapter != null && this.adapter.isConnected();
    }

    @Deprecated
    public void dismiss() {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        UYC.i(TAG, "Dismiss AdpPushClient");
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
        this.deferredDataListener = null;
        this.onDeeplinkResponseListener = null;
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    private boolean checkPlayServices() {
        try {
            GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
            if (resultCode != 0 && resultCode != 2) {
                if (apiAvailability.isUserResolvableError(resultCode) && this.currentActivity != null && this.currentActivity.get() != null) {
                    try {
                        if (this.isEnabledAlertForNotSupportingGcm() && !AdpPushClient.isDisabledSdk()) {
                            apiAvailability.getErrorDialog((Activity)this.currentActivity.get(), resultCode, 9000).show();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                UYC.i(TAG, "This device is not supported, but google api is available");
                return false;
            }
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            UYC.i(TAG, "This device is not supported and google api is not available");
            return false;
        }
    }

    private AdpPushClient updateRegistration(boolean restartService) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.restartServiceState = restartService;
        this.registerInBackground(installation);
        return this;
    }

    private void fetchAndSetAdId(MRR.NZV installation) {
        if (this.isAdvertisingIdEnabled() && Boolean.valueOf(this.checkPlayServices()).booleanValue()) {
            UYC.d(UYC.TAG, "\n\n ==================================== \n\nStart getting AdvertisingId at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
            try {
                String adId = this.getPlayAdId(context);
                if (adId != null) {
                    installation.setAdId(adId);
                }
                Boolean trackingEnabled = this.isPlayTrackingEnabled(context);
                installation.setAdIdEnabled(trackingEnabled);
            }
            catch (Exception ex) {
                UYC.e(TAG, "Exception happen for get advertisingId doInBackground: -----> ", ex);
                ex.printStackTrace();
            }
            UYC.d(UYC.TAG, "\n\n ==================================== \n\nGet AdvertisingId = " + installation.getAdId() + " at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
        }
    }

    private synchronized void registerInBackground(MRR.NZV installation) {
        UYC.d(TAG, String.format(Locale.getDefault(), "registerInBackground called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        this.fetchAndSetAdId(installation);
        if (!this.isEnabledPushNotification()) {
            RFF deviceToken = new RFF("disabled");
            deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
            XTU.OJW.getDefault().post(deviceToken);
            return;
        }
        UYC.d(TAG, "registerInBackground...");
        this.getToken(true);
    }

    private synchronized void getToken(boolean installationRequired) {
        UYC.d(TAG, String.format(Locale.getDefault(), "getToken called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new GTE(this, installationRequired)).addOnCanceledListener((OnCanceledListener)new JMY(this, installationRequired));
    }

    public void onEvent(RFF token) {
        UYC.d(TAG, String.format(Locale.getDefault(), "DeviceToken onEvent called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        MRR.NZV installation = this.getLocalInstallation();
        UYC.d(TAG, "on event DeviceToken " + token.getToken() + " ?== " + installation.getDeviceToken());
        new MRR(this, token, installation).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private void saveInstallation(MRR.NZV installation, boolean restartService) {
        String isReregistered;
        HashMap<String, HashMap> notifSettings;
        JSONArray cachedData;
        String installReferrer;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("launchCount", this.getAppLaunchCount());
        props.put("launchTime", this.getAppLaunchTime());
        props.put("realtime", this.isEnabledRealtime());
        if (this.getLastAppLaunchTime() > 0L) {
            props.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if (this.hasInstallReferrerData() && (installReferrer = this.getInstallReferrer()) != null) {
            props.put("referrer", installReferrer);
            props.put("refClickTs", this.getInstallReferrerClickTs());
            props.put("refBeginTs", this.getInstallReferrerInstallBeginTs());
        }
        if (this.getRawInstallReferrer() != null) {
            props.put("rawReferrer", this.getRawInstallReferrer());
            props.put("rawRefClickTs", this.getRawInstallReferrerClickTs());
        }
        if (defaultTracker != null && !defaultTracker.trim().isEmpty()) {
            props.put("defaultTracker", defaultTracker);
        }
        if ((cachedData = this.communicateFallbackMachine.getReadyToSendEventData()) != null) {
            props.put("eventData", cachedData);
        }
        props.put("deviceId", this.getDeviceId());
        String uniqueId = this.getUniqueID();
        if (uniqueId != null && uniqueId.trim() != "") {
            props.put("uniqueId", uniqueId);
        }
        if (!this.checkPlayServices()) {
            props.put("gpsVersionFound", -1);
        } else {
            try {
                if (context != null && context.getPackageManager() != null) {
                    int installedPlayServices = AdpPushClient.context.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode;
                    props.put("gpsVersionFound", installedPlayServices);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int appRequiredPlayServices = GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        props.put("gpsVersionRequired", appRequiredPlayServices);
        props.put("connection", ZWK.getNetworkClass(this.getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("osBuild", Build.ID);
        props.put("locale", Locale.getDefault());
        props.put("clientVersion", this.getClientVersion());
        props.put("launched", this.isLaunched);
        props.put("newInstall", this.isNewInstall);
        if (this.isLoggedIn) {
            props.put("isLoggedIn", this.isLoggedIn);
        }
        if (this.userHash != null && !this.userHash.isEmpty()) {
            props.put("userHash", this.userHash);
        }
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            props.put("userInfo", this.userInfo);
        }
        if ((notifSettings = this.getNotificationSettings()) != null) {
            props.put("notificationSettings", notifSettings);
        }
        props.put("installSource", this.getInstallSource());
        props.put("installDate", this.installDate);
        String screenRes = this.getDeviceScreenResolution();
        if (screenRes != null) {
            props.put("screenResolution", screenRes);
        }
        if ((isReregistered = this.getReregisteredFrom()) != null) {
            props.put("reregisteredFrom", isReregistered);
        }
        if (context != null && context.getPackageName() != null) {
            props.put("appBundleId", context.getPackageName());
        }
        if (installation.getTokenStatus() == null) {
            try {
                if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                    installation.setTokenStatus("ALLOWED");
                } else {
                    installation.setTokenStatus("DENIED");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        props.put("isProduction", true);
        AdpPushClient finalThis = this;
        new OJW(this, installation, props, finalThis, restartService).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private OJW.YCE beforeSend() {
        return new YCE(this);
    }

    private String getPlayAdId(Context context) {
        String playAdId = null;
        for (int i = 0; i < 3; ++i) {
            try {
                playAdId = OWQ.getGooglePlayServicesInfo(context).getGpsAdid();
                if (playAdId != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((playAdId = PZH.NZV(context)) != null) break;
        }
        return playAdId;
    }

    private boolean isPlayTrackingEnabled(Context context) {
        Boolean isTrackingEnabled = null;
        for (int i = 0; i < 3; ++i) {
            try {
                isTrackingEnabled = OWQ.getGooglePlayServicesInfo(context).isTrackingEnabled();
                if (isTrackingEnabled != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((isTrackingEnabled = PZH.MRR(context)) != null) break;
        }
        if (isTrackingEnabled == null) {
            return false;
        }
        return isTrackingEnabled;
    }

    private String getInstallSource() {
        try {
            if (context != null && context.getPackageManager() != null) {
                String installationSource;
                PackageManager pm = context.getPackageManager();
                if (context.getPackageName() != null && (installationSource = pm.getInstallerPackageName(context.getPackageName())) != null) {
                    return installationSource;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "notSet";
    }

    @Nullable
    private String getDeviceScreenResolution() {
        if (this.currentActivity == null || this.currentActivity.get() == null) {
            return null;
        }
        Display display = ((Activity)this.currentActivity.get()).getWindowManager().getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {}
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception exception) {}
        }
        return mWidthPixels + "x" + mHeightPixels;
    }

    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            HashMap<String, HashMap> notifSettings = new HashMap<String, HashMap>();
            Iterator channelSettings = this.notificationSettings.keys();
            while (channelSettings.hasNext()) {
                String topic = (String)channelSettings.next();
                JSONObject channelSetting = this.notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<String, String>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(topic, setting);
            }
            return notifSettings;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++installationRetries <= 10) {
            XTU retryTask = new XTU(this);
            long nextTry = (long)Math.max(Math.pow(2.0, installationRetries), 32.0);
            UYC.d(TAG, String.format(Locale.getDefault(), "retryRegistration with `%d` seconds Backoff", nextTry));
            worker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    private void retryGetTokenBackoff() {
        if (++tokenRetries <= 5) {
            VMB retryTask = new VMB(this);
            long nextTry = (long)Math.max(Math.pow(2.0, tokenRetries), 10.0);
            UYC.d(TAG, String.format(Locale.getDefault(), "retryGetToken with `%d` seconds Backoff", nextTry));
            tokenWorker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    @Deprecated
    private String getDeviceId() {
        return Build.SERIAL;
    }

    private String getUniqueID() {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public String getClientVersion() {
        String userClientVersion = RTB.decrypt(context, this.getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                userClientVersion = this.getApplicationContext().getPackageManager().getPackageInfo((String)AdpPushClient.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return userClientVersion;
    }

    public void setClientVersion(String version) {
        this.getSharedPreferences().edit().putString("clientVersion", RTB.encrypt(context, version)).apply();
    }

    public void incBadge() {
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        int currentBadge = this.getSharedPreferences().getInt("androidBadge", 0);
        this.setBadge(++currentBadge);
    }

    boolean isBadgeEnabled() {
        try {
            if (context != null) {
                String badgeStatus;
                Bundle bundle = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
                if (bundle != null && (badgeStatus = bundle.getString(USE_BADGE_COUNT)) != null && badgeStatus.toLowerCase().equals("disable")) {
                    return false;
                }
                if (!ShortcutBadger.isBadgeCounterSupported((Context)context)) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            UYC.e(TAG, "isBadgeEnabled: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            UYC.e(TAG, "isBadgeEnabled: NullPointerException -->", e);
        }
        return true;
    }

    boolean isEnabledRealtime() {
        block8: {
            if (this.config == null) break block8;
            if (!this.config.realtime()) {
                UYC.i(TAG, String.format(Locale.getDefault(), "Chabok realtime is disabled. To enable set realtime in Chabok.%s.json file to true.", this.config.environment()));
                return false;
            }
            return true;
        }
        try {
            Bundle bundle;
            if (this.getSharedPreferences().contains("CHK_DISABLE_REALTIME")) {
                return !this.getSharedPreferences().getBoolean("CHK_DISABLE_REALTIME", true);
            }
            if (context != null && (bundle = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData) != null && bundle.containsKey(DISABLE_REALTIME)) {
                UYC.i(UYC.TAG, "com.adpdigital.push.client.DISABLE_REALTIME meta-data does not support anymore.");
                if (this.config != null) {
                    UYC.i(UYC.TAG, String.format(Locale.getDefault(), "For config realtime change it from Chabok.%s.json file.", this.config.environment()));
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            UYC.e(TAG, "isEnabledRealtime: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            UYC.e(TAG, "isEnabledRealtime: NullPointerException -->", e);
        }
        return true;
    }

    boolean isEnabledPushNotification() {
        if (this.config == null || this.config.pushNotification()) {
            return true;
        }
        UYC.w(TAG, "Chabok push notification has been disabled in configuration.");
        return false;
    }

    @Deprecated
    public void setEnableRealtime(boolean enableRealtime) {
        this.getSharedPreferences().edit().putBoolean("CHK_DISABLE_REALTIME", !enableRealtime).apply();
    }

    @Deprecated
    public boolean isChabokPushNotification(Bundle data) {
        return data != null && data.containsKey("fromChabok");
    }

    @Deprecated
    public boolean isChabokPushNotification(Map<String, String> data) {
        return data != null && data.containsKey("fromChabok");
    }

    boolean isAdvertisingIdEnabled() {
        try {
            String advertisingIdStatus;
            Bundle bundle;
            if (context != null && (bundle = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData) != null && (advertisingIdStatus = bundle.getString(ADVERTISING_ID_ENABLED)) != null && advertisingIdStatus.toLowerCase().equals("disable")) {
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            UYC.e(TAG, "isAdvertisingIdEnabled: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            UYC.e(TAG, "isAdvertisingIdEnabled: NullPointerException -->", e);
        }
        return true;
    }

    int getDefaultNotificationIconIdFromMetadata() {
        try {
            Bundle bundle;
            if (context != null && (bundle = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData) != null) {
                int defaultIcon = -1;
                if (bundle.containsKey(FB_DEFAULT_NOTIFICATION_ICON) && (defaultIcon = bundle.getInt(FB_DEFAULT_NOTIFICATION_ICON)) >= 0) {
                    return defaultIcon;
                }
                if (bundle.containsKey(CHABOK_DEFAULT_NOTIFICATION_ICON)) {
                    defaultIcon = bundle.getInt(CHABOK_DEFAULT_NOTIFICATION_ICON);
                }
                return defaultIcon;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            UYC.e(TAG, "getDefaultNotificationIconFromMetadata: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            UYC.e(TAG, "getDefaultNotificationIconFromMetadata: NullPointerException -->", e);
        }
        return -1;
    }

    private void updateLaunchStats() {
        this.lastLaunchTime = this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, -1L);
        int count = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++count).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
        this.isLaunched = true;
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public long getLastAppLaunchTime() {
        return this.lastLaunchTime;
    }

    public String getReregisteredFrom() {
        return IMV.getReregisteredFrom(this.getApplicationContext());
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    AdpPushClient setBadge(int badgeNumber) {
        this.getSharedPreferences().edit().putInt("androidBadge", badgeNumber).apply();
        this.eventBus.post(new BadgeUpdate(badgeNumber));
        if (this.isBadgeEnabled() && !ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)badgeNumber)) {
            UYC.i(TAG, "Could not apply the badge " + badgeNumber);
        }
        return this;
    }

    public AdpPushClient resetBadge() {
        ((NotificationManager)this.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return this.setBadge(0);
    }

    private void unregister(boolean isReregister) {
        if (!isReregister) {
            this.deleteInstallation(new AOP(this));
        }
        IMV.removeUserId(context);
        try {
            if (this.getGuestUserId() == null || this.userId == null || this.userId.equalsIgnoreCase(this.getGuestUserId())) {
                this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!isReregister) {
            this.getSharedPreferences().edit().remove("deviceToken").apply();
            this.getSharedPreferences().edit().remove("installationId").apply();
        }
        IMV.removeTopicsFromStorage(this.getApplicationContext());
        this.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        this.getSharedPreferences().edit().remove("offlineCache").apply();
        this.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        this.getSharedPreferences().edit().remove("dataCache").apply();
        this.channels = new String[]{"default"};
        PushService.performAction(this.getApplicationContext(), "DISCONNECT");
    }

    public String getInstallationId() {
        String idJson = RTB.decrypt(context, this.getSharedPreferences().getString("installationId", null));
        if (idJson != null) {
            try {
                return (String)new JSONArray(idJson).get(0);
            }
            catch (JSONException var5) {
                String currentVersionCode = "Cannot parse installation id '" + idJson + "'";
                UYC.e(TAG, currentVersionCode, var5);
            }
        }
        return null;
    }

    private void deleteInstallation(Callback clbk) {
        MRR.UFF<MRR.KEM> repository = this.adapter.createRepository("installation");
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        MRR.KEM model = repository.createModel(HUI.NZV.getProperties(installation, false, false));
        model.putAll(installation.getRequireParams());
        if (model.getId() == null) {
            UYC.w(TAG, "------ Warning : Device was unregistered before!! -------");
            return;
        }
        model.destroy(new DYH(this, clbk, installation));
    }

    private void updateInstallation(Map<String, Object> properties) {
        this.updateInstallation(properties, new KEM(this));
    }

    private void updateInstallation(Map<String, Object> properties, Callback<MRR.NZV> clbk) {
        JSONArray cachedData;
        String uniqueId;
        this.eventBus.post((Object)JZR.UpdatingInstallation);
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        properties.put("launched", this.isLaunched);
        properties.put("newInstall", this.isNewInstall);
        properties.put("launchTime", this.getAppLaunchTime());
        properties.put("realtime", this.isEnabledRealtime());
        if (this.getLastAppLaunchTime() > 0L) {
            properties.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if ((uniqueId = this.getUniqueID()) != null && !uniqueId.isEmpty()) {
            properties.put("uniqueId", this.getUniqueID());
        }
        if ((cachedData = this.communicateFallbackMachine.getReadyToSendEventData()) != null) {
            properties.put("eventData", cachedData);
        }
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            properties.put("userInfo", this.userInfo);
        }
        this.updateInstallation(installation, properties, clbk);
    }

    private MRR.NZV getLocalInstallation() {
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        return installation;
    }

    private void updateInstallation(MRR.NZV installation, Map<String, ?> properties, Callback<MRR.NZV> clbk) {
        MRR.KEM model = this.adapter.createRepository("installation").createModel(HUI.NZV.getProperties(installation, false, false));
        model.putAll(installation.getRequireParams());
        model.putAll(properties);
        new IZX(this, model, clbk, installation).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    public void requestVerificationCode(String userId, String media, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        MRR.UFF<MRR.KEM> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("appId", this.appId);
        map.put("media", media);
        repository.invokeStaticMethod("requestCode", map, new UFF(this, clbk));
    }

    private void requestCode(String userId, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.adapter.createRepository("verification").requestCode(userId, new SUU(this, clbk));
    }

    public void requestVerificationCode(String userId, Callback clbk) {
        this.requestCode(userId, clbk);
    }

    public void verifyUserCode(String userId, String code, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        MRR.UFF<MRR.KEM> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("code", code);
        repository.invokeStaticMethod("verifyCode", map, new QHM(this, clbk));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && AdpPushClient.getActivityClass(this.getApplicationContext()).getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener listener) {
        this.getForegroundManager().addListener(listener);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return activityClass;
    }

    private Context getApplicationContext() {
        return context;
    }

    public String getUserId() {
        return IMV.getUserId(this.getApplicationContext());
    }

    public void setAutoResetBadge(boolean autoResetBadge) {
        this.getSharedPreferences().edit().putBoolean("CHK_AUTO_RESET_BADGE", autoResetBadge).apply();
    }

    public boolean isAutoResetBadge() {
        return this.getSharedPreferences().getBoolean("CHK_AUTO_RESET_BADGE", true);
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                int appIcon = this.getDefaultNotificationIconIdFromMetadata();
                if (appIcon >= 0) {
                    return appIcon;
                }
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                return this.getApplicationContext().getPackageManager().getApplicationInfo((String)packageInfo.packageName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        this.notificationIconSilhouette = notificationIconSilhouette;
    }

    private long getRegisterTs() {
        return this.getSharedPreferences().getLong("CHK_REGISTER_TS", 0L);
    }

    private void setRegisterTs(long registerTs) {
        this.getSharedPreferences().edit().putLong("CHK_REGISTER_TS", registerTs).apply();
    }

    private boolean isGuestUser() {
        return this.getGuestUserId() != null;
    }

    private void setGuestUserId(String guestUserId) {
        if (guestUserId == null) {
            this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            return;
        }
        this.getSharedPreferences().edit().putString("CHK_GUI", RTB.encrypt(context, guestUserId)).apply();
    }

    private String getGuestUserId() {
        String guestUserId = this.getSharedPreferences().getString("CHK_GUI", null);
        if (guestUserId != null) {
            return RTB.decrypt(context, guestUserId);
        }
        return null;
    }

    public void unsetUserAttribute(String attributeKey) {
        this.unsetUserAttributes(new String[]{attributeKey});
    }

    public void unsetUserAttributes(String[] attributeKeys) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKeys == null || attributeKeys.length == 0) {
            UYC.e(TAG, "attribute keys parameter should has a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            JSONObject keys = new JSONObject();
            String[] stringArray = attributeKeys;
            int n = attributeKeys.length;
            for (int i = 0; i < n; ++i) {
                String key = stringArray[i];
                keys.put(key, (Object)new JSONObject().put("operation", (Object)"unset"));
            }
            metadata.put("keys", (Object)keys);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), metadata, null);
    }

    public void addToUserAttributeArray(String attributeKey, String attributeValue) {
        this.addToUserAttributeArrayInternal(attributeKey, new String[]{attributeValue}, null);
    }

    public void addToUserAttributeArray(String attributeKey, String[] attributeValues) {
        this.addToUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void addToUserAttributeArray(String attributeKey, Integer attributeValue) {
        this.addToUserAttributeArrayInternal(attributeKey, new Integer[]{attributeValue}, null);
    }

    private void addToUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        this.addToUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    public void removeFromUserAttributeArray(String attributeKey, String attributeValue) {
        this.removeFromUserAttributeArrayInternal(attributeKey, new String[]{attributeValue}, null);
    }

    public void removeFromUserAttributeArray(String attributeKey, String[] attributeValues) {
        this.removeFromUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void removeFromUserAttributeArray(String attributeKey, Integer attributeValue) {
        this.removeFromUserAttributeArrayInternal(attributeKey, new Integer[]{attributeValue}, null);
    }

    private void removeFromUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        this.removeFromUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void addToUserAttributeArrayInternal(String attributeKey, Object[] attributeValues, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKey == null || attributeKey.isEmpty()) {
            UYC.e(TAG, "attribute key parameter should has a value.");
            return;
        }
        if (attributeValues == null || attributeValues.length <= 0) {
            UYC.e(TAG, "attribute values parameter should have a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("keys", (Object)new JSONObject().put(attributeKey, (Object)new JSONObject().put("operation", (Object)"addToArray").put("type", (Object)"array").put("value", (Object)LPP.MRR(attributeValues))));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), metadata, callback);
    }

    private void removeFromUserAttributeArrayInternal(String attributeKey, Object[] attributeValues, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKey == null || attributeKey.isEmpty()) {
            UYC.e(TAG, "attribute key parameter should has a value.");
            return;
        }
        if (attributeValues == null || attributeValues.length <= 0) {
            UYC.e(TAG, "attribute values parameter should have a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("keys", (Object)new JSONObject().put(attributeKey, (Object)new JSONObject().put("operation", (Object)"removeFromArray").put("type", (Object)"array").put("value", (Object)LPP.MRR(attributeValues))));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), metadata, callback);
    }

    public HashMap<String, Object> getUserAttributes() {
        try {
            try {
                String jsonStringEnc = this.getSharedPreferences().getString("CHK_USER_INFO", null);
                if (jsonStringEnc != null) {
                    return (HashMap)LPP.OJW(new JSONObject(RTB.decrypt(context, jsonStringEnc)));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setUserAttributesInternal(HashMap<String, Object> attributes, JSONObject metadata, Callback callback) {
        if (this.isRegistered()) {
            this.getLocalInstallation().userInfo(this.getInstallationId(), attributes, metadata, new VLN(this, callback));
        }
    }

    private void saveUserAttributes(HashMap<String, Object> attributes) {
        if (attributes == null) {
            return;
        }
        this.userInfo = attributes;
        try {
            JSONObject json = new JSONObject(this.userInfo);
            this.getSharedPreferences().edit().putString("CHK_USER_INFO", RTB.encrypt(context, json.toString())).apply();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setUserAttributes(Bundle attributes) {
        this.setUserAttributes(attributes, null);
    }

    private void setUserAttributes(Bundle attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            UYC.e(TAG, "attributes parameter should have a value. To removing attributes data, provide an empty Bundle");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter should have a value. To removing attributes data, provide an empty Bundle"));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(attributes);
        HashMap userInfoMap = (HashMap)LPP.NZV(attributes);
        if (userInfoMap == null) {
            UYC.e(TAG, "cannot convert attributes parameter to map.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("cannot convert attributes parameter to map."));
            }
            return;
        }
        this.saveUserAttributes(userInfoMap);
        this.setUserAttributesInternal(userInfoMap, metadata, callback);
    }

    public void setUserAttributes(HashMap<String, Object> attribute) {
        this.setUserAttributes(attribute, null);
    }

    private void setUserAttributes(HashMap<String, Object> attribute, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attribute == null) {
            UYC.e(TAG, "attribute parameter should has a value. To removing attribute data, provide an empty HashMap");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attribute parameter should has a value. To removing attribute data, provide an empty HashMap"));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(attribute);
        this.saveUserAttributes(attribute);
        this.setUserAttributesInternal(attribute, metadata, callback);
    }

    public void incrementUserAttribute(String attributeName) {
        this.incrementUserAttribute(attributeName, 1.0, null);
    }

    private void incrementUserAttribute(String attributeName, Callback callback) {
        this.incrementUserAttribute(attributeName, 1.0, callback);
    }

    public void incrementUserAttribute(String attributeName, double value) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            UYC.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put(attributeName, value);
        this.incrementUserAttribute(attributesArray, null);
    }

    private void incrementUserAttribute(String attributeName, double value, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            UYC.e(TAG, "attributeName is null. Please provide an attributeName");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributeName is null. Please provide an attributeName"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put(attributeName, value);
        this.incrementUserAttribute(attributesArray, callback);
    }

    public void incrementUserAttribute(ArrayList<String> attributes) {
        this.incrementUserAttribute(attributes, null);
    }

    private void incrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            UYC.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        for (String attribute : attributes) {
            attributesArray.put(attribute, 1.0);
        }
        this.incrementUserAttribute(attributesArray, callback);
    }

    public void incrementUserAttribute(HashMap<String, Double> attributes) {
        this.incrementUserAttribute(attributes, null);
    }

    private void incrementUserAttribute(HashMap<String, Double> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            UYC.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }
        JSONArray attributesArray = new JSONArray();
        for (Map.Entry<String, Double> me : attributes.entrySet()) {
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", (Object)me.getKey());
                attribute.put("value", (Object)me.getValue());
                attributesArray.put((Object)attribute);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (this.isRegistered()) {
            this.getLocalInstallation().incrementAttribute(this.getInstallationId(), attributesArray, new IRK(this, attributes, callback));
            return;
        }
        UYC.d(TAG, "User not registered yet, try to increment attributes (" + attributes.toString() + ") after send successfully installation request");
        this.eventBus.register(new RGI(this, attributes));
    }

    public void decrementUserAttribute(String attributeName) {
        this.incrementUserAttribute(attributeName, -1.0, null);
    }

    public void decrementUserAttribute(String attributeName, double value) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            UYC.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put(attributeName, -value);
        this.incrementUserAttribute(attributesArray, null);
    }

    public void decrementUserAttribute(ArrayList<String> attributes) {
        this.decrementUserAttribute(attributes, null);
    }

    private void decrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            UYC.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        for (String attribute : attributes) {
            attributesArray.put(attribute, -1.0);
        }
        this.incrementUserAttribute(attributesArray, callback);
    }

    public void decrementUserAttribute(HashMap<String, Double> attributes) {
        this.decrementUserAttribute(attributes, null);
    }

    private void decrementUserAttribute(HashMap<String, Double> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            UYC.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }
        JSONArray attributesArray = new JSONArray();
        for (Map.Entry<String, Double> me : attributes.entrySet()) {
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", (Object)me.getKey());
                attribute.put("value", -me.getValue().doubleValue());
                attributesArray.put((Object)attribute);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (this.isRegistered()) {
            this.getLocalInstallation().incrementAttribute(this.getInstallationId(), attributesArray, new RPN(this, attributes, callback));
            return;
        }
        UYC.d(TAG, "User not registered yet, try to increment attributes (" + attributes.toString() + ") after send successfully installation request");
        this.eventBus.register(new CVA(this, attributes));
    }

    private HashMap<String, Object> loadMap(String key) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            String jsonStringEnc = this.getSharedPreferences().getString(key, null);
            if (jsonStringEnc != null) {
                JSONObject jsonObject = new JSONObject(RTB.decrypt(context, jsonStringEnc));
                Iterator keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String k = (String)keysItr.next();
                    Object v = jsonObject.get(k);
                    outputMap.put(k, v);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return outputMap;
    }

    private JSONObject prepareMetaData(JSONObject data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            Iterator it = data.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
                data.put(key, ((Datetime)data.get(key)).getTime());
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)dateParams);
                return metaData;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private JSONObject prepareMetaData(HashMap<String, Object> data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            for (String key : data.keySet()) {
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
                data.put(key, ((Datetime)data.get(key)).getTime());
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)dateParams);
                return metaData;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private JSONObject prepareMetaData(Bundle data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            for (String key : data.keySet()) {
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)dateParams);
                return metaData;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static void setDefaultTracker(String defaultTracker) {
        AdpPushClient.defaultTracker = defaultTracker;
    }

    @Deprecated
    public AdpPushClient setDevelopment(boolean isDev) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        this.useDev = isDev;
        this.getSharedPreferences().edit().putBoolean("useDev", this.useDev).apply();
        this.initializeAdapter();
        return this;
    }

    public static void setEnvironment(Environment environment) {
        chabokEnvironment = environment;
    }

    public void setDefaultNotificationChannel(String channelName) {
        String defaultChannelId = "default";
        if (Build.VERSION.SDK_INT >= 26) {
            this.createOrUpdateNotificationChannel(defaultChannelId, channelName);
        }
    }

    void createOrUpdateNotificationChannel(String channelId, String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            new TUY(channelId, this.getApplicationContext()).setChannelName(channelName).build();
        }
    }

    void deleteNotificationChannel(String channelId) {
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            if (notificationManager != null) {
                notificationManager.deleteNotificationChannel(channelId);
                return;
            }
        } else {
            UYC.d(TAG, "Couldn't delete notification channel, because is require api level 26");
        }
    }

    boolean hasNotificationChannel(String channelId) {
        if (channelId == null) {
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && notificationManager != null) {
            return notificationManager.getNotificationChannel(channelId) != null;
        }
        return false;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    public void subscribeEvent(String eventName, Callback clbk) {
        this.subscribeEvent(eventName, "+", false, clbk);
    }

    public void subscribeEvent(String eventName, boolean live, Callback clbk) {
        this.subscribeEvent(eventName, "+", live, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, Callback clbk) {
        this.subscribeEvent(eventName, installationId, false, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, boolean live, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        HWU.getInstance(this.getApplicationContext()).NZV(eventName, installationId, live, clbk);
    }

    public void unsubscribeEvent(String eventName, Callback clbk) {
        this.unsubscribeEvent(eventName, "+", clbk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(String eventName, String installationId, Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        Callback callback = clbk;
        String string = installationId;
        String string2 = eventName;
        HWU hWU = HWU.getInstance(this.getApplicationContext());
        Class<HWU> clazz = HWU.class;
        synchronized (HWU.class) {
            if (!hWU.isConnected()) {
                UYC.w(HWU.NZV, "No Connection or not connected, Delay event unsubscribe");
                callback.onFailure(new Exception("Not Connected"));
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return;
            }
            String string3 = hWU.NZV(string2, string);
            new SCK(hWU, string3, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public void track(String eventName) {
        this.track(eventName, (Bundle)null);
    }

    public void track(String eventName, Bundle data) {
        this.track(eventName, data, null);
    }

    private void track(String eventName, Bundle data, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (eventName == null) {
            UYC.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            UYC.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        JSONObject convertedData = LPP.MRR(data);
        this.trackInternal(eventName, convertedData, metadata);
    }

    public void track(String eventName, JSONObject data) {
        this.track(eventName, data, null);
    }

    private void track(String eventName, JSONObject data, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (eventName == null) {
            UYC.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            UYC.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        this.trackInternal(eventName, data, metadata);
    }

    private void trackInternal(String eventName, JSONObject data, JSONObject metadata) {
        JSONObject trackData = new JSONObject();
        try {
            JSONObject influenceData;
            trackData.put("id", (Object)UUID.randomUUID().toString());
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                if (metadata != null) {
                    trackData.put(META_DATA, (Object)metadata);
                }
                trackData.put("data", (Object)data);
            }
            if ((influenceData = JYK.YCE()) != null) {
                if (JYK.VMB()) {
                    influenceData.put("direct", JYK.VMB());
                }
                trackData.put("influence", (Object)influenceData);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalTrackData = trackData;
            this.eventBus.register(new VIN(this, eventName, finalTrackData));
            return;
        }
        UYC.d(TAG, "Track event: " + eventName);
        this.emit(JHA.track, eventName, this.getInstallationId(), trackData, true, false);
    }

    public void trackPurchase(String eventName, ChabokEvent chabokEvent) {
        if (chabokEvent == null) {
            UYC.e(TAG, "chabokEvent is null, please provide a revenue");
            return;
        }
        if (chabokEvent.revenue < 0.0) {
            UYC.e(TAG, "Could not track event, Invalid amount");
        }
        new JSONObject();
        try {
            JSONObject data = new JSONObject();
            if (chabokEvent.data != null) {
                data = chabokEvent.data;
            }
            data.put("isRevenue", true);
            data.put("value", (Object)chabokEvent.revenue);
            if (chabokEvent.currency != null) {
                data.put("currency", (Object)chabokEvent.currency);
            }
            JSONObject metadata = this.prepareMetaData(data);
            this.trackInternal(eventName, data, metadata);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    public void trackRevenue(double revenue) {
        this.trackPurchase("Purchase", new ChabokEvent(revenue));
    }

    void publishClientEvents(String id, JSONArray data) {
        JSONObject trackData = new JSONObject();
        try {
            trackData.put("id", (Object)id);
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                trackData.put("eventData", (Object)data);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = trackData;
            this.eventBus.register(new GMT(this, finalEventData));
            return;
        }
        UYC.d(TAG, "-- Publish cached data " + data);
        this.emit(JHA.event, "clientEvent", this.getInstallationId(), trackData, true, false);
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    private AdpPushClient setSecure(boolean isSecure) {
        this.useSecure = isSecure;
        this.initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        ArrayList<String> newChannels = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n = this.channels.length;
        for (int i = 0; i < n; ++i) {
            String ch = stringArray[i];
            String chName = this.convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }
        return newChannels.toArray(new String[newChannels.size()]);
    }

    private String convertChannelName2newConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel;
        }
        if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        return "private/" + channel;
    }

    SharedPreferences getSharedPreferences() {
        return IMV.getSharedPreferences(this.getApplicationContext());
    }

    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        AdpPushClient.get().currentActivity = new WeakReference<Activity>(currentActivity);
        return this;
    }

    public static void setActivityClass(Class activityClass) {
        AdpPushClient.activityClass = activityClass;
    }

    void notifyNewMessage(PushMessage message) {
        Class clazz = activityClass;
        if (AdpPushClient.hasNotified(message.getId())) {
            return;
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification notif;
            Class theirs = h.getActivityClass(notif = new ChabokNotification(message, 0));
            if (theirs == null) continue;
            clazz = theirs;
        }
        Class finalClazz = clazz;
        PushMessage finalMessage = message;
        new WFM(this, finalClazz, finalMessage).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    boolean addNotifiedMessage(String id) {
        boolean val = notifs.add(id);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return val;
    }

    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        Class clazz = activityClass;
        String title = data.getString("title");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification gcmNotif;
            Class theirs = h.getActivityClass(gcmNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), (int)Integer.valueOf(data.getString("androidBadge", "0")), data));
            if (theirs == null) continue;
            clazz = theirs;
        }
        return clazz;
    }

    boolean notificationOpened(Bundle data, ChabokNotificationAction notificationAction) {
        ChabokNotification chabokNotif;
        this.lastNotificationAction = notificationAction;
        String title = data.getString("title");
        boolean shouldLaunchActivity = true;
        if (title == null) {
            title = data.getString("messageFrom");
        }
        this.lastNotificationData = chabokNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), (int)Integer.valueOf(data.getString("androidBadge", "0")), data);
        Iterator<NotificationHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            shouldLaunchActivity = iterator.next().notificationOpened(chabokNotif, notificationAction);
        }
        return shouldLaunchActivity;
    }

    public ChabokNotificationAction getLastNotificationAction() {
        return this.lastNotificationAction;
    }

    public ChabokNotification getLastNotificationData() {
        return this.lastNotificationData;
    }

    public boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        boolean showNotification = true;
        for (NotificationHandler h : this.handlers) {
            showNotification &= h.buildNotification(notif, builder);
        }
        return showNotification;
    }

    public void addNotificationHandler(NotificationHandler handler) {
        this.handlers.add(handler);
    }

    void launchSingleTaskUri(String uri, String logMessage) {
        try {
            String url = uri;
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            Intent i = new Intent("android.intent.action.VIEW");
            i.addFlags(0x10020000);
            i.setData(Uri.parse((String)url));
            UYC.d(UYC.TAG, logMessage + " " + url);
            context.startActivity(i);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Deprecated
    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener deeplinkResponseListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.onDeeplinkResponseListener = deeplinkResponseListener;
    }

    public void setDeferredDataListener(DeferredDataListener deferredDataListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.deferredDataListener = deferredDataListener;
    }

    private void getDeferredDeepLink() {
        this.getLocalInstallation().deferredDeepLink(this.getInstallationId(), new QHG(this));
    }

    public void appWillOpenUrl(Uri url) {
        if (url == null || url.toString().trim().isEmpty()) {
            UYC.d(TAG, "Deeplink url is not vaild!!");
            return;
        }
        long clickTime = System.currentTimeMillis();
        JSONObject json = new JSONObject();
        try {
            json.put("type", 0);
            json.put("deepLinkClickTs", clickTime);
            json.put("deepLinkUrl", (Object)url.toString());
            PWW communicateEvent = new PWW(json, JZR.GotDeepLink);
            this.eventBus.post(communicateEvent);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean hasProtectedAppSupport() {
        String deviceManufacturer = this.getDeviceManufacturer().toLowerCase();
        return !TextUtils.isEmpty((CharSequence)deviceManufacturer) && (deviceManufacturer.contains("huawei") || deviceManufacturer.contains("xiaomi"));
    }

    private String getDeviceManufacturer() {
        String deviceMan = Build.MANUFACTURER;
        UYC.d("deviceMan", deviceMan);
        return deviceMan;
    }

    public void showProtectedAppSettings(Activity ctx, String app_name, String title, String msg) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        title = title != null && !title.isEmpty() ? title : "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647";
        msg = msg != null && !msg.isEmpty() ? msg : String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", app_name);
        this.showGuide(ctx, title, msg);
    }

    private void showGuide(Activity ctx, String title, String message) {
        this.getApplicationContext();
        SharedPreferences settings = ctx.getSharedPreferences("ProtectedApps", 0);
        if (!settings.getBoolean("skipProtectedAppsMessage", false)) {
            SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                CheckBox dontShowAgain = new CheckBox(this.getApplicationContext());
                dontShowAgain.setTextColor(-16777216);
                dontShowAgain.setText((CharSequence)"     \u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                dontShowAgain.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new NHW(this, editor));
                new AlertDialog.Builder((Context)ctx).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setView((View)dontShowAgain).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new WGR(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            editor.putBoolean("skipProtectedAppsMessage", true);
            editor.apply();
        }
    }

    private boolean isCallable(Intent intent) {
        return this.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String getUserSerial() {
        Object userManager = this.getApplicationContext().getSystemService("user");
        if (userManager == null) {
            return "";
        }
        try {
            Object myUserHandle = Process.class.getMethod("myUserHandle", null).invoke(Process.class, null);
            Long userSerial = (Long)userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass()).invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !this.isPlayServicesSupported();
    }

    public boolean isPlayServicesSupported() {
        return !IMV.isSupportPlayServices(this.getApplicationContext());
    }

    private synchronized void updateDeviceToken(RFF token) {
        this.updateDeviceToken(token, null);
    }

    private synchronized void updateDeviceToken(RFF token, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (token == null || TextUtils.isEmpty((CharSequence)token.getToken())) {
            String msg = "updateDeviceToken: token is empty";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to update device token...";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        long ts = System.currentTimeMillis();
        String userId = this.getUserId();
        String installationId = this.getInstallationId();
        HashMap<String, Object> tokenError = null;
        if (token.getTokenErr() != null) {
            tokenError = new HashMap<String, Object>();
            tokenError.put("code", token.getTokenErrCode());
            tokenError.put("message", token.getTokenErr());
        }
        data.put("createdAt", ts);
        data.put("userId", userId);
        data.put("installationId", installationId);
        data.put("deviceType", "android");
        data.put("deviceToken", token.getToken());
        if (tokenError != null) {
            data.put("tokenError", tokenError);
        }
        if (token.getTokenStatus() != null) {
            data.put("tokenStatus", token.getTokenStatus());
        }
        this.getLocalInstallation().updateDeviceToken(data, callback);
    }

    public void addTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "addTag: tag is empty";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        this.addTag(tagsName, callback);
    }

    public void addTag(String[] tagsName, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            UYC.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }
        String[] msg = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)msg[i])) continue;
            String msg2 = "addTags: tag is empty";
            UYC.e(TAG, msg2);
            if (callback != null) {
                callback.onFailure(new Throwable(msg2));
            }
            return;
        }
        this.getLocalInstallation().addTag(tagsName, callback);
    }

    public void removeTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "removeTag: tag is empty";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        this.removeTag(tagsName, callback);
    }

    public void removeTag(String[] tagsName, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] msg = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)msg[i])) continue;
            String msg2 = "removeTag: tag is empty";
            UYC.e(TAG, msg2);
            callback.onFailure(new Throwable(msg2));
            return;
        }
        this.getLocalInstallation().removeTag(tagsName, callback);
    }

    void sendEventData(JSONArray datas, Callback callback) {
        if (datas == null) {
            String msg = "Please provide a data parameter";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to send fallback event...";
            UYC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        long ts = System.currentTimeMillis();
        String userId = this.getUserId();
        String installationId = this.getInstallationId();
        body.put("createdAt", ts);
        body.put("userId", userId);
        body.put("installationId", installationId);
        body.put("deviceType", "android");
        body.put("eventData", datas);
        try {
            Integer l = String.valueOf(HUI.MRR.toJson(body)).replaceAll("(\\\\.)", "/").length();
            String type = body.get("deviceType").toString();
            String manId = AdpPushClient.get().getManufacturerId(userId, installationId, type, ts, l);
            if (manId != null) {
                body.put("sessionId", manId);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UYC.d(TAG, "-- Sending eventData");
        this.getLocalInstallation().events(body, callback);
    }

    boolean hasInstallReferrerData() {
        return this.getSharedPreferences().contains("CHK_INSTALL_REFERRER") && this.getSharedPreferences().contains("CHK_INSTALL_REF_CLICK_TS_L") && this.getSharedPreferences().contains("CHK_INSTALL_REF_BEGIN_TS_L");
    }

    String getInstallReferrer() {
        String encryptInstallReferrer = this.getSharedPreferences().getString("CHK_INSTALL_REFERRER", null);
        if (encryptInstallReferrer == null) {
            return null;
        }
        return RTB.decrypt(context, encryptInstallReferrer);
    }

    long getInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            UYC.e("AdpPushLibrary", "Exception happen to get ReferrerClickTimestampSeconds", ex);
            return 0L;
        }
    }

    long getInstallReferrerInstallBeginTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_BEGIN_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            UYC.e("AdpPushLibrary", "Exception happen to get InstallBeginTimestampSeconds", ex);
            return 0L;
        }
    }

    void getApplicationInstallReferrer() {
        new MRQ(context, new JAZ(this));
    }

    void sendInstallReferrer(String rawReferrer, Context context) {
        long clickTime = System.currentTimeMillis();
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        AdpPushClient.context = context;
        this.getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REFERRER", RTB.encrypt(context, rawReferrer)).apply();
        this.getSharedPreferences().edit().putLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", clickTime).apply();
    }

    private String getRawInstallReferrer() {
        String encryptRawInstallReferrer = this.getSharedPreferences().getString("CHK_RAW_INSTALL_REFERRER", null);
        if (encryptRawInstallReferrer == null) {
            return null;
        }
        return RTB.decrypt(context, encryptRawInstallReferrer);
    }

    private long getRawInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            UYC.e("AdpPushLibrary", "Exception happen to get RawInstallRefClickTs", ex);
            return 0L;
        }
    }

    private Map<String, String> getRawInstallReferrerParams() {
        String referrer = this.getRawInstallReferrer();
        try {
            referrer = URLDecoder.decode(referrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
            UYC.d(UYC.TAG, "Referrer decoding failed due to UnsupportedEncodingException. Message: (" + e.getMessage() + ")");
        }
        catch (IllegalArgumentException e) {
            referrer = "malformed";
            UYC.d(UYC.TAG, "Referrer decoding failed due to IllegalArgumentException. Message: (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            referrer = "malformed";
            UYC.d(UYC.TAG, "Referrer decoding failed. Message: (" + e.getMessage() + ")");
        }
        UYC.v(UYC.TAG, "Referrer to parse (" + referrer + ")");
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        for (UrlQuerySanitizer.ParameterValuePair params : querySanitizer.getParameterList()) {
            extraParameters.put(params.mParameter, params.mValue);
        }
        return extraParameters;
    }

    String getManufacturerId(String userId, String uid, String type, long launchTs, Integer len) {
        try {
            String string;
            int n;
            Object object;
            Object[] objectArray;
            int n2;
            long l;
            block8: {
                new WAW();
                String string2 = type;
                int n3 = 2;
                if (string2.length() > 2) {
                    n3 = string2.charAt(2);
                }
                l = Long.parseLong(Long.toString(launchTs));
                n2 = n3;
                objectArray = Long.toString(l);
                object = objectArray.toCharArray();
                for (int i = ((char[])object).length - 1; i >= 0; --i) {
                    if (Character.toString(object[i]).contains("0")) continue;
                    n = Integer.parseInt(Character.toString(object[i]));
                    break block8;
                }
                n = 9;
            }
            int n4 = n2 % n;
            int n5 = Integer.parseInt(Character.toString(objectArray.charAt(objectArray.length() - 3)));
            char[] cArray = Long.valueOf(l).toString().toCharArray();
            long[] lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = Character.getNumericValue(cArray[i]);
            }
            long[] lArray2 = lArray;
            List<Long> list = WAW.NZV(Arrays.copyOfRange(lArray, 0, n5));
            List<Long> list2 = WAW.NZV(Arrays.copyOfRange(lArray2, n5, objectArray.length()));
            list.add(Long.valueOf(n4));
            list.addAll(list2);
            List<Long> list3 = list;
            object = new StringBuilder();
            for (long l2 : list3) {
                ((StringBuilder)object).append(Long.toString(l2));
            }
            String sugar = ((StringBuilder)object).toString();
            sugar = new StringBuilder(sugar).insert(sugar.length() / 2, len).toString();
            String string3 = Long.toString(launchTs);
            String string4 = uid;
            String string5 = userId;
            if (string5 == null || string4 == null || string3 == null) {
                string = "";
            } else {
                objectArray = new String[]{string5, string4, string3};
                string = TextUtils.join((CharSequence)WAW.NZV(), (Object[])objectArray);
            }
            String ManufacturerId = string;
            return WAW.NZV(ManufacturerId + sugar);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void configureEnvironment(Environment environment) {
        AdpPushClient.configureEnvironment(environment, null);
    }

    public static void configureEnvironment(Environment environment, String guestId) {
        if (context == null) {
            throw new IllegalStateException("AdpPushClient is not initialized in this process " + GKV.getMyProcessName() + ". Make sure to call AdpPushClient.setApplicationContext(Context) first.");
        }
        com.adpdigital.push.config.NZV config = com.adpdigital.push.config.MRR.getConfiguration(environment);
        if (config == null) {
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to configure correct environment. Please see http://bit.ly/32x1Tsn");
        }
        AdpPushClient.init(config.appId(), config.apiKey(), config.username(), config.password());
        chabokEnvironment = environment;
        if (environment == null) {
            AdpPushClient.get().setDevelopment(true);
        } else {
            AdpPushClient.get().setDevelopment(environment != Environment.PRODUCTION);
        }
        AdpPushClient.get().setEnableRealtime(config.realtime());
        AdpPushClient.get().setConfiguration(config);
        String userId = AdpPushClient.get().getUserId();
        if (userId != null) {
            AdpPushClient.get().register(userId);
            return;
        }
        AdpPushClient.get().registerAsGuest(guestId);
    }

    private void setConfiguration(com.adpdigital.push.config.NZV config) {
        this.config = config;
    }

    public void login(String userId) {
        this.register(userId);
    }

    public void login(String userId, @Nullable Callback<String> loginCallback) {
        this.register(userId, loginCallback);
    }

    public void login(String userId, String[] tagsName) {
        this.login(userId, tagsName, null);
    }

    private void login(String userId, String[] tagsName, @Nullable Callback<String> loginCallback) {
        this.register(userId, new KTB(this, tagsName, loginCallback));
    }

    public void login(String userId, HashMap<String, Object> attributes) {
        this.login(userId, attributes, null);
    }

    private void login(String userId, HashMap<String, Object> attributes, @Nullable Callback<String> loginCallback) {
        this.register(userId, new IXL(this, attributes, loginCallback));
    }

    public void login(String userId, String eventName, JSONObject data) {
        this.login(userId, eventName, data, null);
    }

    private void login(String userId, String eventName, JSONObject data, @Nullable Callback<String> loginCallback) {
        this.register(userId, new WVK(this, eventName, data, loginCallback));
    }

    public void login(String userId, String userHash) {
        this.userHash = userHash;
        this.register(userId);
    }

    private void login(String userId, String userHash, @Nullable Callback loginCallback) {
        this.userHash = userHash;
        this.register(userId, new UIR(this, loginCallback));
    }

    public void logout() {
        this.logout(null);
    }

    private void logout(@Nullable Callback<String> logoutCallback) {
        this.registerAsGuest(logoutCallback);
    }

    static /* synthetic */ WeakReference access$002(AdpPushClient x0, WeakReference x1) {
        x0.currentActivity = x1;
        return x0.currentActivity;
    }

    static /* synthetic */ boolean access$100(AdpPushClient x0) {
        return x0.isFreshStart;
    }

    static /* synthetic */ void access$200(AdpPushClient x0) {
        x0.updateLaunchStats();
    }

    static /* synthetic */ XTU.OJW access$300(AdpPushClient x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$400(AdpPushClient x0) {
        return x0.isNewInstall;
    }

    static /* synthetic */ void access$500(AdpPushClient x0) {
        x0.doRegister();
    }

    static /* synthetic */ boolean access$102(AdpPushClient x0, boolean x1) {
        x0.isFreshStart = x1;
        return x0.isFreshStart;
    }

    static /* synthetic */ Context access$600(AdpPushClient x0) {
        return x0.getApplicationContext();
    }

    static /* synthetic */ void access$700(AdpPushClient x0) {
        x0.resetBackgroundTimer();
    }

    static /* synthetic */ void access$800(AdpPushClient x0) {
        x0.startBackgroundTimer();
    }

    static /* synthetic */ void access$900(AdpPushClient x0, JHA x1, String x2, String x3, JSONObject x4, boolean x5, boolean x6) {
        x0.emit(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ AdpPushClient access$1000(AdpPushClient x0, String x1, String[] x2, Callback x3) {
        return x0._register(x1, x2, x3);
    }

    static /* synthetic */ boolean access$1100(AdpPushClient x0) {
        return x0.registeredOnce;
    }

    static /* synthetic */ boolean access$1202(AdpPushClient x0, boolean x1) {
        x0.registering = x1;
        return x0.registering;
    }

    static /* synthetic */ ForegroundManager access$1300(AdpPushClient x0) {
        return x0.foreground;
    }

    static /* synthetic */ AdpPushClient access$1400(AdpPushClient x0, boolean x1) {
        return x0.updateRegistration(x1);
    }

    static /* synthetic */ Object access$1500(AdpPushClient x0) {
        return x0._tokenLock;
    }

    static /* synthetic */ void access$1600(AdpPushClient x0) {
        x0.retryGetTokenBackoff();
    }

    static /* synthetic */ void access$1700(AdpPushClient x0, RFF x1) {
        x0.updateDeviceToken(x1);
    }

    static /* synthetic */ boolean access$1800(AdpPushClient x0) {
        return x0.restartServiceState;
    }

    static /* synthetic */ void access$1900(AdpPushClient x0, MRR.NZV x1, boolean x2) {
        x0.saveInstallation(x1, x2);
    }

    static /* synthetic */ boolean access$1802(AdpPushClient x0, boolean x1) {
        x0.restartServiceState = x1;
        return x0.restartServiceState;
    }

    static /* synthetic */ Object access$2000(AdpPushClient x0) {
        return x0._installationLock;
    }

    static /* synthetic */ boolean access$1102(AdpPushClient x0, boolean x1) {
        x0.registeredOnce = x1;
        return x0.registeredOnce;
    }

    static /* synthetic */ int access$2102(int x0) {
        installationRetries = x0;
        return installationRetries;
    }

    static /* synthetic */ Callback access$2200(AdpPushClient x0) {
        return x0.registerCallback;
    }

    static /* synthetic */ String access$2300(AdpPushClient x0) {
        return x0.userId;
    }

    static /* synthetic */ Callback access$2202(AdpPushClient x0, Callback x1) {
        x0.registerCallback = x1;
        return x0.registerCallback;
    }

    static /* synthetic */ OnDeeplinkResponseListener access$2400(AdpPushClient x0) {
        return x0.onDeeplinkResponseListener;
    }

    static /* synthetic */ DeferredDataListener access$2500(AdpPushClient x0) {
        return x0.deferredDataListener;
    }

    static /* synthetic */ void access$2600(AdpPushClient x0) {
        x0.getDeferredDeepLink();
    }

    static /* synthetic */ boolean access$2702(AdpPushClient x0, boolean x1) {
        x0.isLoggedIn = x1;
        return x0.isLoggedIn;
    }

    static /* synthetic */ boolean access$402(AdpPushClient x0, boolean x1) {
        x0.isNewInstall = x1;
        return x0.isNewInstall;
    }

    static /* synthetic */ String access$2802(AdpPushClient x0, String x1) {
        x0.userHash = x1;
        return x0.userHash;
    }

    static /* synthetic */ boolean access$2902(AdpPushClient x0, boolean x1) {
        x0.isLaunched = x1;
        return x0.isLaunched;
    }

    static /* synthetic */ void access$3000(AdpPushClient x0) {
        x0.retryRegistrationBackoff();
    }

    static /* synthetic */ OJW.YCE access$3100(AdpPushClient x0) {
        return x0.beforeSend();
    }

    static /* synthetic */ boolean access$3200(AdpPushClient x0) {
        return x0.isGuestUser();
    }

    static /* synthetic */ long access$3300(AdpPushClient x0) {
        return x0.getRegisterTs();
    }

    static /* synthetic */ String access$3400(AdpPushClient x0) {
        return x0.getUniqueID();
    }

    static /* synthetic */ void access$3500(AdpPushClient x0, boolean x1) {
        x0.getToken(x1);
    }

    static /* synthetic */ void access$3600(AdpPushClient x0, HashMap x1) {
        x0.saveUserAttributes(x1);
    }

    static /* synthetic */ void access$3700(AdpPushClient x0) {
        x0.huaweiProtectedApps();
    }

    static /* synthetic */ Context access$3800() {
        return context;
    }

    static /* synthetic */ void access$3900(AdpPushClient x0, HashMap x1, Callback x2) {
        x0.setUserAttributes(x1, x2);
    }

    static /* synthetic */ void access$4000(AdpPushClient x0, String x1, JSONObject x2, Callback x3) {
        x0.track(x1, x2, x3);
    }

    static {
        FORCE_STICKY = false;
        installationRetries = 0;
        tokenRetries = 0;
        notifs = new EIW<String>(200);
        pushClientInstance = null;
        tokenWorker = Executors.newSingleThreadScheduledExecutor();
    }
}

