/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import com.adpdigital.push.LPP;
import org.json.JSONObject;

public class ChabokEvent {
    protected Double revenue;
    protected JSONObject data;
    protected String currency;

    public ChabokEvent(double revenue) {
        this.setRevenue(revenue);
    }

    public ChabokEvent(double revenue, String currency) {
        this.setRevenue(revenue, currency);
    }

    public void setRevenue(double revenue) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        this.revenue = revenue;
    }

    public void setRevenue(double revenue, String currency) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        if (!this.checkCurrency(currency)) {
            return;
        }
        this.revenue = revenue;
        this.currency = currency;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    private boolean checkRevenue(Double revenue) {
        if (revenue == null) {
            LPP.e(LPP.TAG, "Amount is null");
            return false;
        }
        if (revenue < 0.0) {
            LPP.e(LPP.TAG, "Invalid amount " + revenue);
            return false;
        }
        return true;
    }

    private boolean checkCurrency(String currency) {
        if (currency == null) {
            LPP.e(LPP.TAG, "Currency must be set with revenue");
            return false;
        }
        if (currency.equals("")) {
            LPP.e(LPP.TAG, "Currency is empty");
            return false;
        }
        return true;
    }
}

