/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import b.h;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GcmMessageHandler;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.R;
import com.adpdigital.push.a;
import com.adpdigital.push.aa;
import com.adpdigital.push.ac;
import com.adpdigital.push.ae;
import com.adpdigital.push.af;
import com.adpdigital.push.ag;
import com.adpdigital.push.ah;
import com.adpdigital.push.ai;
import com.adpdigital.push.al;
import com.adpdigital.push.am;
import com.adpdigital.push.ao;
import com.adpdigital.push.aq;
import com.adpdigital.push.b;
import com.adpdigital.push.c;
import com.adpdigital.push.d;
import com.adpdigital.push.e;
import com.adpdigital.push.f;
import com.adpdigital.push.g;
import com.adpdigital.push.i;
import com.adpdigital.push.j;
import com.adpdigital.push.k;
import com.adpdigital.push.l;
import com.adpdigital.push.m;
import com.adpdigital.push.n;
import com.adpdigital.push.p;
import com.adpdigital.push.q;
import com.adpdigital.push.s;
import com.adpdigital.push.service.RegistrationIntentService;
import com.adpdigital.push.t;
import com.adpdigital.push.u;
import com.adpdigital.push.v;
import com.adpdigital.push.w;
import com.adpdigital.push.x;
import com.adpdigital.push.y;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static final String SDK_VERSION = "2.9.1";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int failed_tries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private b.i adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private f.c eventBus = f.c.getDefault();
    private Context context;
    private Class activityClass;
    private Activity currentActivity;
    private String userId;
    private String senderId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = false;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;

    /*
     * WARNING - void declaration
     */
    private AdpPushClient(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        void var3_3;
        void var2_2;
        Log.i((String)TAG, (String)"Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate(context, (Class)var2_2, (String)var3_3, apiKey, username, password);
        this.eventBus.register(this);
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new a(this));
        try {
            void var1_1;
            ((Application)var1_1).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new m(this));
        }
        catch (Exception exception) {}
        this.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdpPushClient init(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            void var3_4;
            void var2_3;
            void var1_2;
            Context context2;
            if (pushClientInstance != null) return pushClientInstance;
            packageName = context.getPackageName();
            pushClientInstance = new AdpPushClient(context2, (Class)var1_2, (String)var2_3, (String)var3_4, username, password);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized yet, please first call AdpPushClient.get with parameters");
        }
        return pushClientInstance;
    }

    static boolean hasNotified(String id) {
        String string2;
        return notifs.contains(string2);
    }

    /*
     * WARNING - void declaration
     */
    private void initializeAdapter() {
        void var1_1;
        void var3_3;
        String string2;
        String restApi = "http://" + am.a + ":80/api/";
        String currentHost = am.a;
        String currentPortBroker = ":1880";
        if (this.useSecure) {
            String appSubDomain = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                appSubDomain = this.appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + am.a + ":443/api/";
            string2 = string2 + am.a;
            currentPortBroker = ":4443";
        }
        if (this.useDev) {
            restApi = "http://sandbox.push.adpdigital.com:80/api/";
            string2 = "sandbox.push.adpdigital.com";
            currentPortBroker = ":1880";
        }
        if (this.useDev && this.useSecure) {
            restApi = "https://sandbox.push.adpdigital.com:443/api/";
            string2 = "sandbox.push.adpdigital.com";
            currentPortBroker = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", string2).putString("port", (String)var3_3).putBoolean("useSecure", this.useSecure).putBoolean("useDev", this.useDev).apply();
        this.adapter = new b.i(this.getApplicationContext(), (String)var1_1);
        this.adapter.setAccessToken(this.apiKey);
    }

    /*
     * WARNING - void declaration
     */
    private void validateAndPopulate(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        Set cache;
        void var3_3;
        void var2_2;
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, PushClient needs your application context");
        }
        this.context = context;
        if (handlerActivity == null) {
            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
        }
        this.activityClass = var2_2;
        this.getSharedPreferences().edit().putString(ACTIVITY_KEY, this.getActivityClass().getName()).apply();
        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        this.getSharedPreferences().edit().putString("username", this.encrypt(username)).apply();
        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        this.getSharedPreferences().edit().putString("password", this.encrypt(password)).apply();
        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String[] tokens = var3_3.split("/");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Application ID should be in `app-name/number` format");
        }
        this.appId = tokens[0];
        this.apiKey = apiKey;
        this.senderId = tokens[1];
        this.getSharedPreferences().edit().putString("applicationId", this.encrypt(this.appId)).apply();
        this.getSharedPreferences().edit().putString("senderId", this.encrypt(this.senderId)).apply();
        Set storedChannels = this.getSharedPreferences().getStringSet("topics", new HashSet<String>(Arrays.asList(this.channels)));
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);
        String storedNotifSettings = this.getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                this.notificationSettings = new JSONObject(storedNotifSettings);
            }
            catch (JSONException jSONException) {
                jSONException.getMessage();
            }
        }
        if ((cache = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            void var1_1;
            notifs.addAll((Collection<String>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(aq gcmMessage) {
        void var1_1;
        void var2_2;
        Log.w((String)TAG, (String)("New GCM message (foreground:" + this.isForeground() + "): " + gcmMessage.getIntent().getExtras()));
        if (this.isForeground()) {
            Log.w((String)TAG, (String)"How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient that = this;
        this.isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"), new x(this, (AdpPushClient)var2_2, (aq)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void publish(PushMessage message, Callback clbk) {
        void var2_2;
        void var1_1;
        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new y(this, (PushMessage)var1_1, (Callback)var2_2), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(String channel, String text, Callback clbk) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (channel.contains("/")) {
            clbk.onFailure(new Throwable("Channel should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new aa(this, (String)var2_2, (String)var1_1, (Callback)var3_3), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(String user, String channel, String text, Callback clbk) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (channel.contains("/") || user.contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ac(this, (String)var3_3, (String)var2_2, (String)var1_1, clbk), 0);
    }

    /*
     * WARNING - void declaration
     */
    void publishMessageEvent(String subject, String messageId) {
        try {
            void var1_1;
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            this.emit((String)var1_1, messageId, obj, false, false);
            return;
        }
        catch (Exception e2) {
            void var3_4;
            void var2_2;
            Log.e((String)TAG, (String)("Couldnt publish message event " + (String)var2_2), (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data) {
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (JSONObject)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data, boolean live) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (JSONObject)var2_2, (boolean)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data, boolean live, boolean stateful) {
        void var3_3;
        void var2_2;
        void var1_1;
        try {
            if (data.optLong("createdAt", 0L) == 0L) {
                data.put("createdAt", System.currentTimeMillis());
            }
            data.put("id", (Object)UUID.randomUUID().toString());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            this.eventBus.register(new ae(this, event, data, live, stateful));
            return;
        }
        this.emit((String)var1_1, this.getInstallationId(), (JSONObject)var2_2, (boolean)var3_3, stateful);
    }

    /*
     * WARNING - void declaration
     */
    private void emit(String event, String subject, JSONObject data, boolean live, boolean stateful) {
        void var3_3;
        void var2_2;
        void var1_1;
        String dataStr = "";
        if (data != null) {
            dataStr = data.toString();
            new StringBuilder("emit: data: ").append(dataStr).append(" , subject: ").append(subject);
        }
        String payload = dataStr;
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new af(this, (String)var1_1, (String)var2_2, (String)var3_3, live, stateful), 0);
    }

    /*
     * WARNING - void declaration
     */
    private void isReceivedMessage(String messageId, Callback clbk) {
        void var1_1;
        void var2_2;
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ag(this, (Callback)var2_2, (String)var1_1), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void getStatus(Callback<ConnectionStatus> clbk) {
        void var1_1;
        if (!PushService.isRunning(this.getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new b(this, (Callback)var1_1), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(String channel, Callback clbk) {
        void var2_2;
        void var1_1;
        this.subscribe((String)var1_1, false, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(String channel, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!live) {
            HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
            allChannels.add(this.convertChannelName2OldConvention(channel));
            this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
            this.channels = allChannels.toArray(new String[allChannels.size()]);
            this.updateInstallation(new HashMap());
            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                RegistrationIntentService.subscribe(channel, this.getApplicationContext());
            }
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new c(this, (String)var1_1, (boolean)var2_2, (Callback)var3_3), 0);
    }

    /*
     * WARNING - void declaration
     */
    private String convertChannelName2OldConvention(String channel) {
        void var1_1;
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        if (channel.startsWith("public/")) {
            return channel;
        }
        return "public/" + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribe(String channel, Callback clbk) {
        void var2_2;
        void var1_1;
        void var3_3;
        HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
        allChannels.remove(this.convertChannelName2OldConvention(channel));
        this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
        this.channels = allChannels.toArray(new String[var3_3.size()]);
        this.updateInstallation(new HashMap());
        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            RegistrationIntentService.unsubscribe(channel, this.getApplicationContext());
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new d(this, (String)var1_1, (Callback)var2_2), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        this.notificationSettings.remove(topicName);
        try {
            void var1_1;
            void var3_3;
            topicSetting.put("sound", (Object)sound);
            topicSetting.put("alert", (boolean)var3_3);
            this.notificationSettings.put(topicName, (Object)topicSetting);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            HashMap<String, void> props = new HashMap<String, void>();
            HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
            if (notifSettings != null) {
                void var2_2;
                props.put("notificationSettings", var2_2);
            }
            this.updateInstallation((Map<String, ?>)var1_1);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.getMessage();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            void var1_1;
            this.eventBus.register(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            void var1_1;
            this.eventBus.post(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            void var1_1;
            this.eventBus.unregister(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient setPushListener(Object ctx) {
        void var1_1;
        return this.addListener(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient removePushListener(Object activity) {
        void var1_1;
        return this.removeListener(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient register(String userId) {
        void var1_1;
        return this._register((String)var1_1, new String[0], false);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient register(String userId, String[] channels) {
        void var2_2;
        void var1_1;
        return this._register((String)var1_1, (String[])var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient reRegister(String userId) {
        void var1_1;
        return this._register((String)var1_1, new String[0], true);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient reRegister(String userId, String[] channels) {
        void var2_2;
        void var1_1;
        return this._register((String)var1_1, (String[])var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient _register(String userId, String[] channels, boolean restartService) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId);
        }
        if (!this.isValid(userId)) {
            throw new IllegalArgumentException("User ID is not valid: " + userId);
        }
        if (this.registering) {
            Log.w((String)TAG, (String)"Already in registering...");
            return this;
        }
        this.registeredOnce = false;
        this.userId = userId;
        this.getSharedPreferences().edit().putString("userId", this.encrypt(this.userId)).apply();
        HashSet<String> allTopics = new HashSet<String>(Arrays.asList(this.channels));
        ArrayList<String> newChannels = new ArrayList<String>();
        boolean userHasNewTopic = false;
        for (void ch : var2_2) {
            String chName = this.convertChannelName2OldConvention((String)ch);
            newChannels.add(chName);
            if (allTopics.contains(chName)) continue;
            userHasNewTopic = true;
        }
        allTopics.addAll(newChannels);
        if (userHasNewTopic) {
            this.makeSubsDirty();
        }
        this.getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
        this.channels = allTopics.toArray(new String[var1_1.size()]);
        failed_tries = 0;
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        this.doRegister((boolean)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(String userId) {
        void var2_2;
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (userId.length() < 3 || userId.length() > 32) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !var1_1.matches((String)var2_2);
    }

    private void doRegister() {
        this.doRegister(false);
    }

    /*
     * WARNING - void declaration
     */
    private void doRegister(boolean restartService) {
        void var1_1;
        if (this.userId == null) {
            Log.e((String)TAG, (String)"userId not initialized yet");
            return;
        }
        if (this.registering) {
            new StringBuilder("Register already in progress for ").append(this.userId);
            return;
        }
        this.registering = true;
        this.initializeAdapter();
        worker.schedule(new e(this, (boolean)var1_1), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        return this.adapter != null && this.adapter.isConnected();
    }

    public void dismiss() {
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    /*
     * WARNING - void declaration
     */
    private boolean _checkPlayServices() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getApplicationContext());
        if (resultCode != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode) && this.currentActivity != null) {
                void var1_1;
                GooglePlayServicesUtil.getErrorDialog((int)var1_1, (Activity)this.currentActivity, (int)9000).show();
            } else {
                Log.w((String)"AdpPushLibrary", (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
        if (resultCode != 0 && resultCode != 2) {
            if (apiAvailability.isUserResolvableError(resultCode)) {
                void var2_2;
                void var1_1;
                var1_1.getErrorDialog(this.currentActivity, (int)var2_2, 9000).show();
            } else {
                Log.i((String)TAG, (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient updateRegistration(boolean restartService) {
        void var2_2;
        void var1_1;
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.restartServiceState = var1_1;
        this.registerInBackground((b.a)var2_2);
        return this;
    }

    private void registerInBackground(b.a installation) {
        installation.setDeviceToken("---");
        this.getApplicationContext().startService(new Intent(this.getApplicationContext(), RegistrationIntentService.class));
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(ao token) {
        void var1_1;
        void var2_2;
        b.a installation = this.getLocalInstallation();
        new f(this, (b.a)var2_2, (ao)var1_1).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    private void saveInstallation(b.a installation, boolean restartService) {
        void var2_2;
        void var3_3;
        void var1_1;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("launchCount", this.getAppLaunchCount());
        props.put("launchTime", this.getAppLaunchTime());
        props.put("deviceId", this.getDeviceId());
        props.put("connection", al.getNetworkClass(this.getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("clientVersion", this.getClientVersion());
        HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
        if (notifSettings != null) {
            props.put("notificationSettings", notifSettings);
        }
        if (!this.getUserInfo().isEmpty()) {
            props.put("userInfo", this.getUserInfo());
        }
        new g(this, (b.a)var1_1, (HashMap)var3_3, (boolean)var2_2).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            void var1_1;
            HashMap notifSettings = new HashMap();
            Iterator channelSettings = this.notificationSettings.keys();
            while (channelSettings.hasNext()) {
                void var3_3;
                String topic = (String)channelSettings.next();
                JSONObject channelSetting = this.notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<String, String>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(var3_3, setting);
            }
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void retryRegistrationBackoff() {
        if (++failed_tries <= 10) {
            void var2_2;
            void var1_1;
            i retryTask = new i(this);
            long nextTry = (long)Math.max(Math.pow(2.0, failed_tries), 32.0);
            worker.schedule((Runnable)var1_1, (long)var2_2, TimeUnit.SECONDS);
        }
    }

    private String getDeviceId() {
        return Build.SERIAL;
    }

    /*
     * WARNING - void declaration
     */
    public String getClientVersion() {
        void var1_1;
        String userClientVersion = this.decrypt(this.getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                userClientVersion = this.getApplicationContext().getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setClientVersion(String version) {
        void var1_1;
        this.getSharedPreferences().edit().putString("clientVersion", this.encrypt((String)var1_1)).apply();
    }

    /*
     * WARNING - void declaration
     */
    public void incBadge() {
        void var1_1;
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        int currentBadge = this.getSharedPreferences().getInt("androidBadge", 0);
        this.getSharedPreferences().edit().putInt("androidBadge", ++currentBadge).apply();
        this.eventBus.post(new BadgeUpdate(currentBadge));
        ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void updateLaunchStats() {
        void var1_1;
        int count = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        ++count;
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, (int)var1_1).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient setBadge(int badgeNumber) {
        void var1_1;
        this.getSharedPreferences().edit().putInt("androidBadge", badgeNumber).apply();
        this.eventBus.post(new BadgeUpdate(badgeNumber));
        ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient resetBadge() {
        void var1_1;
        ((NotificationManager)this.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        var1_1.apply();
        return this.setBadge(0);
    }

    public void unregister() {
        PushService.performAction(this.getApplicationContext(), "DISCONNECT");
        this.deleteInstallation(new j(this));
        this.getSharedPreferences().edit().remove("userId").apply();
        this.getSharedPreferences().edit().remove("installationId").apply();
        this.getSharedPreferences().edit().remove("topics").apply();
        this.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        this.getSharedPreferences().edit().remove("offlineCache").apply();
        this.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        this.getSharedPreferences().edit().remove("dataCache").apply();
    }

    /*
     * WARNING - void declaration
     */
    public String getInstallationId() {
        String idJson = this.decrypt(this.getSharedPreferences().getString("installationId", null));
        if (idJson != null) {
            try {
                return (String)new JSONArray(idJson).get(0);
            }
            catch (JSONException jSONException) {
                void var1_1;
                new StringBuilder("Cannot parse installation id '").append((String)var1_1).append("'");
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteInstallation(Callback clbk) {
        void var3_3;
        void var1_1;
        void var2_2;
        h<b.e> repository = this.adapter.createRepository("installation");
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        ((b.e)var2_2.createModel(d.a.getProperties(installation, false, false))).destroy(new k(this, (Callback)var1_1, (b.a)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(Map<String, ?> properties) {
        void var1_1;
        this.updateInstallation((Map<String, ?>)var1_1, new l(this));
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(Map<String, ?> properties, Callback<b.a> clbk) {
        void var2_2;
        void var1_1;
        void var3_3;
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.updateInstallation((b.a)var3_3, (Map<String, ?>)var1_1, (Callback<b.a>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private b.a getLocalInstallation() {
        void var1_1;
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(b.a installation, Map<String, ?> properties, Callback<b.a> clbk) {
        void var1_1;
        void var3_3;
        void var2_2;
        b.e model = this.adapter.createRepository("installation").createModel(d.a.getProperties(installation, false, false));
        model.putAll((Map<String, ? extends Object>)var2_2);
        new n(this, model, (Callback)var3_3, (b.a)var1_1).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    public void requestVerificationCode(String userId, String media, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        h<b.e> repository = this.adapter.createRepository("verification");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", var1_1);
        map.put("appId", this.appId);
        map.put("media", var2_2);
        repository.invokeStaticMethod("requestCode", map, new p(this, (Callback)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void requestCode(String userId, Callback clbk) {
        void var2_2;
        void var1_1;
        this.adapter.createRepository("verification").requestCode((String)var1_1, new q(this, (Callback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void requestVerificationCode(String userId, Callback clbk) {
        void var2_2;
        void var1_1;
        this.requestCode((String)var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUserCode(String userId, String code, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        h<b.e> repository = this.adapter.createRepository("verification");
        HashMap<String, void> map = new HashMap<String, void>();
        map.put("userId", var1_1);
        map.put("code", var2_2);
        repository.invokeStaticMethod("verifyCode", map, new s(this, (Callback)var3_3));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && this.getActivityClass().getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient addAppListener(AppListener listener) {
        void var1_1;
        this.getForegroundManager().addListener((AppListener)var1_1);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return this.activityClass;
    }

    private Context getApplicationContext() {
        return this.context;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getUserId() {
        return this.decrypt(this.getSharedPreferences().getString("userId", null));
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    /*
     * WARNING - void declaration
     */
    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                void var1_1;
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                return this.getApplicationContext().getPackageManager().getApplicationInfo((String)var1_1.packageName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotificationIcon(int notificationIcon) {
        void var1_1;
        this.notificationIcon = var1_1;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        void var1_1;
        this.notificationIconSilhouette = var1_1;
    }

    public HashMap<String, Object> getUserInfo() {
        return this.userInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserInfo(HashMap<String, Object> userInfo) {
        void var1_1;
        this.userInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient setDevelopment(boolean isDev) {
        void var1_1;
        this.useDev = var1_1;
        this.initializeAdapter();
        return this;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, Callback clbk) {
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, "+", false, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, "+", (boolean)var2_2, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, String installationId, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, (String)var2_2, false, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, String installationId, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new t(this, (String)var1_1, (String)var2_2, (boolean)var3_3, clbk), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeEvent(String eventName, Callback clbk) {
        void var2_2;
        void var1_1;
        this.unsubscribeEvent((String)var1_1, "+", (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeEvent(String eventName, String installationId, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new u(this, (String)var1_1, (String)var2_2, (Callback)var3_3), 0);
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient setSecure(boolean isSecure) {
        void var1_1;
        this.useSecure = var1_1;
        this.initializeAdapter();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getSubscriptions() {
        void var1_1;
        ArrayList<String> newChannels = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n2 = this.channels.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String ch = stringArray[i2];
            String chName = this.convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }
        return newChannels.toArray(new String[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private String convertChannelName2newConvention(String channel) {
        void var1_1;
        if (channel.startsWith("private/")) {
            return channel;
        }
        if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        return "private/" + (String)var1_1;
    }

    private SharedPreferences getSharedPreferences() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        void var1_1;
        this.currentActivity = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void notifyNewMessage(PushMessage message) {
        void var1_1;
        void var2_2;
        Class clazz = this.activityClass;
        if (AdpPushClient.hasNotified(message.getId())) {
            return;
        }
        for (NotificationHandler h2 : this.handlers) {
            ChabokNotification notif;
            Class theirs = h2.getActivityClass(notif = new ChabokNotification(message, 0));
            if (theirs == null) continue;
            clazz = theirs;
        }
        GcmMessageHandler.sendNotification(this.getApplicationContext(), (Class)var2_2, new ChabokNotification((PushMessage)var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    boolean addNotifiedMessage(String id) {
        void var1_2;
        boolean val = notifs.add(id);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        void var2_2;
        Class clazz = this.activityClass;
        for (NotificationHandler h2 : this.handlers) {
            ChabokNotification gcmNotif;
            Class theirs = h2.getActivityClass(gcmNotif = new ChabokNotification(data.getString("messageId"), data.getString("messageFrom"), data.getString("message"), Integer.valueOf(data.getString("androidBadge", "0")), data));
            if (theirs == null) continue;
            clazz = theirs;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        void var3_3;
        boolean showNotification = true;
        for (NotificationHandler h2 : this.handlers) {
            showNotification &= h2.buildNotification(notif, builder);
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void addNotificationHandler(NotificationHandler handler) {
        void var1_1;
        this.handlers.add((NotificationHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void ifHuaweiAlert(Activity ctx) {
        void var1_1;
        this.ifHuaweiAlert((Activity)var1_1, "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", this.getApplicationContext().getString(R.string.app_name)));
    }

    /*
     * WARNING - void declaration
     */
    public void ifHuaweiAlert(Activity ctx, String title, String message) {
        this.getApplicationContext();
        SharedPreferences settings = ctx.getSharedPreferences("ProtectedApps", 0);
        if (!settings.getBoolean("skipProtectedAppsMessage", false)) {
            SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                void var3_3;
                void var2_2;
                void var1_1;
                CheckBox dontShowAgain = new CheckBox(this.getApplicationContext());
                dontShowAgain.setTextColor(-16777216);
                dontShowAgain.setText((CharSequence)"\u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                dontShowAgain.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new v(this, editor));
                new AlertDialog.Builder((Context)var1_1).setIcon(17301543).setTitle((CharSequence)var2_2).setMessage((CharSequence)var3_3).setView((View)dontShowAgain).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new w(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            editor.putBoolean("skipProtectedAppsMessage", true);
            editor.apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCallable(Intent intent) {
        void var1_1;
        return this.getApplicationContext().getPackageManager().queryIntentActivities((Intent)var1_1, 65536).size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private void huaweiProtectedApps() {
        try {
            void var1_1;
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec((String)var1_1);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getUserSerial() {
        Object userManager = this.getApplicationContext().getSystemService("user");
        if (userManager == null) {
            return "";
        }
        try {
            void var2_2;
            Object myUserHandle = Process.class.getMethod("myUserHandle", null).invoke(Process.class, null);
            Long userSerial = (Long)userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass()).invoke(userManager, var2_2);
            if (userSerial != null) {
                void var1_1;
                return String.valueOf(var1_1);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    public String encrypt(String value) {
        try {
            void var3_4;
            byte[] bytes = value != null ? value.getBytes("UTF-8") : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)var3_4, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(ah.encode(pbeCipher.doFinal(bytes), 2), "UTF-8");
        }
        catch (Exception e2) {
            void var1_1;
            void var2_3;
            this.getClass().getName();
            new StringBuilder("Warning, could not encrypt the value.  It may be stored in plaintext.  ").append(var2_3.getMessage());
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String decrypt(String value) {
        if (value == null) {
            return value;
        }
        try {
            void var3_4;
            byte[] bytes = value != null ? ah.decode(value, 0) : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)var3_4, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(pbeCipher.doFinal(bytes), "UTF-8");
        }
        catch (Exception e2) {
            void var1_1;
            void var2_3;
            this.getClass().getName();
            new StringBuilder("Warning, could not decrypt the value.  It may be stored in plaintext.  ").append(var2_3.getMessage());
            return var1_1;
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !this.isGCMSupported();
    }

    public boolean isGCMSupported() {
        return !this.getSharedPreferences().getBoolean("noGCM", false);
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String tagName, Callback callback) {
        String msg;
        if (this.userId == null) {
            msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "addTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        try {
            this.getLocalInstallation().addTag(URLEncoder.encode(msg.trim(), "UTF-8"), callback);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var1_1;
            void var2_2;
            UnsupportedEncodingException e2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            var2_2.onFailure((Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTag(String tagName, Callback callback) {
        String msg;
        if (this.userId == null) {
            msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "removeTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        try {
            this.getLocalInstallation().removeTag(URLEncoder.encode(msg.trim(), "UTF-8"), callback);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var1_1;
            void var2_2;
            UnsupportedEncodingException e2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            var2_2.onFailure((Throwable)var1_1);
            return;
        }
    }

    static /* synthetic */ boolean access$000(AdpPushClient x0) {
        return x0.isFreshStart;
    }

    static /* synthetic */ void access$100(AdpPushClient x0) {
        x0.updateLaunchStats();
    }

    static /* synthetic */ f.c access$200(AdpPushClient x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$300(AdpPushClient x0) {
        x0.doRegister();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.isFreshStart = var1_1;
        return x0.isFreshStart;
    }

    static /* synthetic */ Context access$400(AdpPushClient x0) {
        return x0.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Activity access$502(AdpPushClient x0, Activity x1) {
        void var1_1;
        x0.currentActivity = var1_1;
        return x0.currentActivity;
    }

    static /* synthetic */ boolean access$600(AdpPushClient x0) {
        return x0.registeredOnce;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$702(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.registering = var1_1;
        return x0.registering;
    }

    static /* synthetic */ ForegroundManager access$800(AdpPushClient x0) {
        return x0.foreground;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ AdpPushClient access$900(AdpPushClient x0, boolean x1) {
        void var1_1;
        return x0.updateRegistration((boolean)var1_1);
    }

    static /* synthetic */ boolean access$1000(AdpPushClient x0) {
        return x0.restartServiceState;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(AdpPushClient x0, b.a x1, boolean x2) {
        void var2_2;
        void var1_1;
        x0.saveInstallation((b.a)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1002(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.restartServiceState = var1_1;
        return x0.restartServiceState;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$602(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.registeredOnce = var1_1;
        return x0.registeredOnce;
    }

    static /* synthetic */ int access$1202(int x0) {
        failed_tries = x0;
        return failed_tries;
    }

    static /* synthetic */ void access$1300(AdpPushClient x0) {
        x0.retryRegistrationBackoff();
    }

    static /* synthetic */ void access$1400(AdpPushClient x0) {
        x0.huaweiProtectedApps();
    }

    static {
        FORCE_STICKY = false;
        failed_tries = 0;
        notifs = new ai<String>(200);
        pushClientInstance = null;
    }
}

