package com.adpdigital.push;

/**
 * Created by behrad on 6/10/15.
 */

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.PowerManager;

/**
 * Called in response to a change in network connection - after losing a
 *  connection to the server, this allows us to wait until we have a usable
 *  data connection again
 **/
public class NetworkConnectionIntentReceiver extends BroadcastReceiver {

    private NetworkConnectionListener listener;
    private Context ctx;

    public NetworkConnectionIntentReceiver(Context ctx, NetworkConnectionListener listener) {
        this.listener = listener;
        this.ctx = ctx;

        ctx.registerReceiver( this, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
    }

    @Override
    public void onReceive(Context ctx, Intent intent)
    {
        // we protect against the phone switching off while we're doing this
        //  by requesting a wake lock - we request the minimum possible wake
        //  lock - just enough to keep the CPU running until we've finished
        PowerManager pm = (PowerManager)ctx.getSystemService(Context.POWER_SERVICE);
        PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "BROKER");
        wl.acquire();

        listener.onChange( ctx, intent );

        // we're finished - if the phone is switched off, it's okay for the CPU
        //  to sleep now
        wl.release();
    }

    public void unregister() {
        ctx.unregisterReceiver( this );
    }
}
