package com.adpdigital.push;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.util.Log;

/**
 * @author Rakesh.Jha
 * Date - 07/10/2013
 * Definition - Logger file use to keep Log info to external SD with the simple method
 */

public class Logger {

    public static final String TAG = Logger.class.getName();


    public static  FileHandler logger = null;

    private final static String pid = String.valueOf(android.os.Process.myPid());

    private static String filename = AdpPushClient.packageName + "_" + pid;
//    private static String filename = BuildConfig.APPLICATION_ID + "_" + pid;

    static boolean isExternalStorageAvailable = false;
    static boolean isExternalStorageWriteable = false;

    static String state = Environment.getExternalStorageState();

    public static boolean isLoggable(String tag, int level) {
        return true;
    }

    public static void d( String tag, String message ) {
        Log.d( tag, message );
        addRecordToLog( tag, message );
    }

    public static void i( String tag, String message ) {
        Log.i(tag, message);
        addRecordToLog( tag, message );
    }

    public static void v( String tag, String message ) {
        Log.v(tag, message);
        addRecordToLog( tag, message );
    }

    public static void w( String tag, String message ) {
        Log.w(tag, message);
        addRecordToLog( tag, message );
    }

    public static void e( String tag, String message ) {
        Log.e(tag, message);
        addRecordToLog( tag, "ERROR " + message );
    }

    public static void e( String tag, String message, Throwable t ) {
        Log.e(tag, message, t);
        addRecordToLog( tag, "ERROR " + message );
    }

    public static void addRecordToLog(String tag, String message) {

        if (Environment.MEDIA_MOUNTED.equals(state)) {
            // We can read and write the media
            isExternalStorageAvailable = isExternalStorageWriteable = true;
        } else if (Environment.MEDIA_MOUNTED_READ_ONLY.equals(state)) {
            // We can only read the media
            isExternalStorageAvailable = true;
            isExternalStorageWriteable = false;
        } else {
            // Something else is wrong. It may be one of many other states, but all we need
            //  to know is we can neither read nor write
            isExternalStorageAvailable = isExternalStorageWriteable = false;
        }


        File dir = new File(Environment.getExternalStorageDirectory() +"/.adp");

        if (Environment.MEDIA_MOUNTED.equals(state)) {
            if(!dir.exists()) {
                dir.mkdirs();
            }

            File logFile = new File(Environment.getExternalStorageDirectory() +"/.adp/"+filename+".log");

            if (!logFile.exists())  {
                try  {
                    logFile.createNewFile();
                } catch (IOException e) {
//                    Log.e(TAG, "Error creating file...", e);
                }
            }
            try {
                BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true));
                DateFormat sdf = SimpleDateFormat.getDateTimeInstance();
                buf.write(sdf.format( new Date() ) + " [" + tag + "]: " + message + "\r\n");
                buf.newLine();
                buf.flush();
                buf.close();
            } catch (Exception e) {
//                Log.e(TAG, "Error writing file...", e);
            }
        }
    }
}
