package com.adpdigital.push;

import android.os.Bundle;

/**
 * Created by behrad on 5/19/15.
 */
public class ChabokNotification {

    private String id;
    private String title;
    private String text;
    private PushMessage message;
    private Bundle extras;
    private int badge;
    private String sound;
    private boolean alert = true;
    private String topicName;


    public ChabokNotification(String id, String title, String text, int badge, Bundle extras) {
        this.id = id;
        this.title = title;
        this.badge = badge;
        this.text = text;
        this.extras = extras;
    }

    public ChabokNotification(PushMessage message, int badge) {
        this.message = message;
        this.id = message.getId();
        this.title = message.getAlertText();
        this.text = message.getBody();
        this.badge = badge;
    }

    public String getId() {
        return id;
    }

//    public String getTitle() {
//        return title;
//    }

    public String getText() {
        return text;
    }

    public int getBadge() {
        return badge;
    }

    public String getTitle() {
        return title;
    }

    public PushMessage getMessage() {
        return message;
    }

    public Bundle getExtras() {
        return extras;
    }

    public String getSound() {
        return sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean isAlert() {
        return alert;
    }

    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    public String getTopicName() {
        return topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}
