package com.adpdigital.push;


import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.adpdigital.push.service.RegistrationIntentService;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.strongloop.android.loopback.LocalInstallation;
import com.strongloop.android.loopback.Model;
import com.strongloop.android.loopback.ModelRepository;
import com.strongloop.android.loopback.RestAdapter;
import com.strongloop.android.remoting.BeanUtil;
import com.strongloop.android.remoting.adapters.Adapter;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

import de.greenrobot.event.EventBus;
import me.leolin.shortcutbadger.ShortcutBadger;

import static com.adpdigital.push.AppState.REGISTERED;
import static com.strongloop.android.loopback.LocalInstallation.PROPERTY_INSTALLATION_ID;


/**
 * Created by: Alireza
 * Date: 5/8/2015.
 */
public class AdpPushClient {

    public static final String TAG = AdpPushClient.class.getName();


    public static String packageName;

    private static boolean FORCE_STICKY = false;


    public static final String SDK_VERSION = BuildConfig.VERSION_NAME;

    // constants used to notify the Activity UI of received messages
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";

    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";

    public static final String PUSH_MSG_RECEIVED_TOPIC  = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG    = "com.adpdigital.push.client.MSGRECVD_MSGBODY";

    private boolean restartServiceState = false;

    // constants used by status bar notifications
    public static final int PUSH_NOTIFICATION_UPDATE  = 2;

    public static final String APPLICATION_LAUNCH = "AppLaunched";

    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";

    public static final String ACTIVITY_KEY = "MainActivityClassName";

//    private GoogleCloudMessaging gcm;

    private RestAdapter adapter;

    private boolean isFreshStart = false;

    private boolean registeredOnce = false;
    private boolean registering = false;

    private static int failed_tries = 0;

    private static final int TOTAL_RETRIES = 10;

    private EventBus eventBus = EventBus.getDefault();

    private Context context;

    private Class activityClass;

    private Activity currentActivity;


    /**
     * User's ID, this should be set from the acquired user phone number
     */
    private String userId;

    /**
     * Substitute you own sender ID here. This is the project number you got
     * from the API Console, as described in "Getting Started."
     */
    private String senderId;

    /**
     * Substitute your own application ID here. This is the id of the
     * application you registered in your LoopBack server by calling
     * Application.register().
     */
    private String appId;

    private String apiKey;

    private HashMap<String, Object> userInfo = new HashMap<>();

    Set<NotificationHandler> handlers = new HashSet<>();

    static private Collection<String> notifs = new BoundedQueue<>(200);

    /**
     * Channels name on which client subscribes to by default
     */
    private String[] topics = new String[]{
        Constants.DEFAULT_CHANNEL
    };

    private JSONObject notificationSettings;

    private ForegroundManager foreground;


    private boolean useSecure = true;
    private boolean useDev = false;


    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;

    private static final ScheduledExecutorService worker =
            Executors.newSingleThreadScheduledExecutor();


    private static AdpPushClient pushClientInstance = null;


    public static AdpPushClient init(Context context,
                                     Class handlerActivity,
                                     String appId,
                                     String apiKey,
                                     String username,
                                     String password) {
        if( pushClientInstance == null ) {
            synchronized ( AdpPushClient.class ) {
                if( pushClientInstance == null ) {
                    packageName = context.getPackageName();
                    pushClientInstance = new AdpPushClient(
                        context, handlerActivity, appId, apiKey, username, password
                    );
                }
            }
        }
        return pushClientInstance;
    }


    public synchronized static AdpPushClient get() {
        if( pushClientInstance == null ) {
            throw new IllegalStateException( "AdpPushClient not initialized yet, " +
                    "please first call AdpPushClient.get with parameters" );
        }
        return pushClientInstance;
    }


    private AdpPushClient(Context context, Class handlerActivity,
                          String appId, String apiKey, String username, String password) {
        Log.i(TAG, "Creating a new AdpPushClient instance");

        // https://groups.google.com/forum/#!msg/google-admob-ads-sdk/_x12qmjWI7M/8WkalST9hvUJ
        try {Class.forName("android.os.AsyncTask");} catch(Throwable ignore) {}

        isFreshStart = true;

        validateAndPopulate(context, handlerActivity, appId, apiKey, username, password);

        eventBus.register(this);

        this.foreground = ForegroundManager.get(getApplicationContext());

        this.foreground.addListener(new AppListener() {
            @Override
            public void onBecameForeground(Class activityClass) {
                if (isFreshStart) {
                    Logger.i(TAG, "Application Launch");

                    updateLaunchStats();
                    eventBus.post(AppState.LAUNCH);
                    doRegister();

                    isFreshStart = false;
                }

                resetBadge();

                PushService.performAction(getApplicationContext(), "START");
            }

            @Override
            public void onBecameBackground() {
//                resetBadge();
            }
        });

        try {
            ((Application) context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
                @Override
                public void onActivityCreated(Activity activity, Bundle bundle) {}

                @Override
                public void onActivityStarted(Activity activity) {}

                @Override
                public void onActivityResumed(Activity activity) {
                    currentActivity = activity;
                }

                @Override
                public void onActivityPaused(Activity activity) {}

                @Override
                public void onActivityStopped(Activity activity) {}

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {}

                @Override
                public void onActivityDestroyed(Activity activity) {}
            });
        } catch (Exception e) {

        }

        initializeAdapter();

    }


    private void initializeAdapter() {
        String restApi = "http://" + Constants.ADP_RESOLVED_HOST + Constants.ADP_SERVER_PORT + "/api/";
        String currentHost = Constants.ADP_RESOLVED_HOST;
        String currentPortBroker = Constants.BROKER_PORT;
        if( useSecure ) {
            String appSubDomain = "";
            if( !appId.equalsIgnoreCase("chabok-demo")
                    && !appId.equalsIgnoreCase("adp-nms-push")
                    && !appId.equalsIgnoreCase("chabok-demo")) {
                appSubDomain = appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + Constants.ADP_RESOLVED_HOST + Constants.ADP_SERVER_PORT_SSL + "/api/";
            currentHost = appSubDomain + Constants.ADP_RESOLVED_HOST;
            currentPortBroker = Constants.BROKER_PORT_SSL;
        }
        if( useDev ) {
            restApi = "http://" + Constants.ADP_SERVER_DEV + Constants.ADP_SERVER_PORT_DEV + "/api/";
            currentHost = Constants.ADP_SERVER_DEV;
            currentPortBroker = Constants.BROKER_PORT_DEV;
        }
        if( useDev && useSecure ) {
            restApi = "https://" + Constants.ADP_SERVER_DEV + Constants.ADP_SERVER_PORT_DEV_SSL + "/api/";
            currentHost = Constants.ADP_SERVER_DEV;
            currentPortBroker = Constants.BROKER_PORT_DEV_SSL;
        }
        getSharedPreferences().edit()
                .putString("host", currentHost)
                .putString("port", currentPortBroker)
                .putBoolean("useSecure", useSecure)
                .putBoolean("useDev", useDev).apply();

        adapter = new RestAdapter( getApplicationContext(), restApi );
        adapter.setAccessToken(apiKey);
    }


    private void validateAndPopulate(Context context, Class handlerActivity,
                                     String appId, String apiKey, String username, String password) {
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, PushClient needs your application context");
        }
        this.context = context;

        if (handlerActivity == null) {
            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
        }
        this.activityClass = handlerActivity;
        getSharedPreferences().edit().putString(ACTIVITY_KEY, getActivityClass().getName()).apply();

        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        getSharedPreferences().edit().putString("username", encrypt(username)).apply();

        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        getSharedPreferences().edit().putString("password", encrypt(password)).apply();

        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String[] tokens = appId.split("/");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Application ID should be in `app-name/number` format");
        }
        this.appId = tokens[0];
        this.apiKey = apiKey;
        this.senderId = tokens[1];
        getSharedPreferences().edit().putString("applicationId", encrypt(this.appId)).apply();
        getSharedPreferences().edit().putString("senderId", encrypt(this.senderId)).apply();

        Set<String> storedTopics = getSharedPreferences()
                .getStringSet("topics", new HashSet<>(Arrays.asList(this.topics)));
        this.topics = storedTopics.toArray(new String[storedTopics.size()]);


        String storedNotifSettings = getSharedPreferences().getString("notificationSettings", null);
        if( storedNotifSettings != null ) {
            try {
                notificationSettings = new JSONObject(storedNotifSettings);
            } catch (JSONException e) {
                Logger.e(TAG, e.getMessage(), e);
            }
        }

        Set<String> cache = getSharedPreferences().getStringSet("notifs", null);
        if (cache != null) {
            notifs.addAll( cache );
        }

    }


//    private void scheduleWatchDog() {
//        Intent intent = new Intent(getApplicationContext(), ChabokWatchDog.class);
//        final PendingIntent pIntent = PendingIntent.getBroadcast(getApplicationContext(), 0,
//                intent, PendingIntent.FLAG_UPDATE_CURRENT);
//        long firstMillis = System.currentTimeMillis();
//        AlarmManager alarm = (AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE);
//        alarm.setInexactRepeating(AlarmManager.RTC_WAKEUP, firstMillis, 24 * 60 * 60 * 1000, pIntent);
//    }


    public void onEvent(final GcmMessage gcmMessage) {
        Log.w(TAG, "New GCM message (foreground:" + isForeground() + "): " + gcmMessage.getIntent().getExtras());
        if (isForeground()) {
            Log.w(TAG, "How is this happening...!? we are in foreground, so ignore GCM message");
        } else {
            final AdpPushClient that = this;
            isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"),
                    new com.adpdigital.push.Callback() {
                        @Override
                        public void onSuccess(Object value) {
                            boolean isReceived = (boolean) value;
                            eventBus.post(new createNotificationEvent(
                                that,
                                gcmMessage.getIntent(),
                                /* TODO: revisit: we are in background, but ignore this GCM message also...
                                    since brokerService should receive it soon or later
                                */
                                true,
                                isReceived
                                /*toBeCanceledNotifs.contains(gcmMessage.getIntent().getExtras().getString("messageId"))*/
                            ));
                        }

                        @Override
                        public void onFailure(Throwable value) {
                        }
                    });
        }
    }


    public void publish(final PushMessage message, final com.adpdigital.push.Callback clbk) {
        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        try {
                            brokerService.publish(message, new Callback<Boolean>() {
                                public void onSuccess(Boolean v) {
                                    clbk.onSuccess(v);
                                }

                                public void onFailure(Throwable value) {
                                    clbk.onFailure(value);
                                }
                            });
                        } catch (Exception e) {
                            clbk.onFailure(e);
                        }
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                    }
                },
                0);
    }


    public void publish(
            final String channel,
            final String text,
            final com.adpdigital.push.Callback clbk
    ) {
        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        try {
                            PushMessage message = new PushMessage();
                            message.setId(UUID.randomUUID().toString());
                            message.setCreatedAt(System.currentTimeMillis());
                            message.setBody(text);
                            message.setTopicName(channel);
                            brokerService.publish(message, new Callback<Boolean>() {
                                public void onSuccess(Boolean v) {
                                    clbk.onSuccess(v);
                                }

                                public void onFailure(Throwable value) {
                                    clbk.onFailure(value);
                                }
                            });
                        } catch (Exception e) {
                            clbk.onFailure(e);
                        }
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                    }
                },
                0);
    }


    public void publish(
            final String channel,
            final String text,
            final JSONObject data,
            final com.adpdigital.push.Callback clbk
    ) {
        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        try {
                            PushMessage message = new PushMessage();
                            message.setId(UUID.randomUUID().toString());
                            message.setCreatedAt(System.currentTimeMillis());
                            message.setBody(text);
                            message.setTopicName(channel);
                            message.setData(data);
                            brokerService.publish(message, new Callback<Boolean>() {
                                public void onSuccess(Boolean v) {
                                    clbk.onSuccess(v);
                                }

                                public void onFailure(Throwable value) {
                                    clbk.onFailure(value);
                                }
                            });
                        } catch (Exception e) {
                            clbk.onFailure(e);
                        }
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                    }
                },
                0);
    }



    void publishMessageEvent(final String subject, final String messageId) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            emit(subject, messageId, obj);
        } catch (Exception e) {
            Log.e(TAG, "Couldnt publish message event " + messageId, e);
        }
    }

    public void publishEvent(final String event, final JSONObject data) {
        publishEvent(event, data, false, false);
    }

    public void publishEvent(final String event, final JSONObject data, final boolean stateful) {
        publishEvent(event, data, false, stateful);
    }

    public void publishEvent(final String event, final JSONObject data,
                                   final boolean live, final boolean stateful) {
        try {
            if (data.optLong("createdAt", 0) == 0) {
                data.put("createdAt", System.currentTimeMillis());
            }
            data.put("id", UUID.randomUUID().toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this.getInstallationId() == null) {
            eventBus.register(new Object(){
                public void onEvent(ConnectionStatus state) {
                    if (state == ConnectionStatus.CONNECTED) {
                        publishEvent(event, data, live, stateful);
                        eventBus.unregister(this);
                    }
                }
            });
            return;
        }

        Log.d(TAG, "publishEvent: sending data, event: " + event);
        emit(event, this.getInstallationId(), data, live, stateful);
    }

    private void emit(final String event, final String subject, final JSONObject data) {
        emit(event, subject, data, false, false);
    }

    private void emit(final String event, final String subject, final JSONObject data,
                      final boolean live, final boolean stateful) {

        String dataStr = "";
        if ( data != null ) {
            dataStr = data.toString();
            Log.d(TAG, "emit: data: " + dataStr + " , subject: " + subject);
        }
        final String payload = dataStr;

        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        brokerService.publishReliably(event, subject, payload, live, stateful);
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                    }
                },
                0);
    }

    private void isReceivedMessage(final String messageId, final com.adpdigital.push.Callback clbk ) {
        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        clbk.onSuccess(brokerService.hasReceivedMessage(messageId));
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                    }
                },
                0
        );
    }


    public void getStatus( final com.adpdigital.push.Callback<ConnectionStatus> clbk ) {
        if( !PushService.isRunning(getApplicationContext()) ) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        clbk.onSuccess(brokerService.getStatus());
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Log.e(TAG, "Error connecting to service " + name);
                        clbk.onSuccess(ConnectionStatus.DISCONNECTED);
                    }
                },
                0
        );
    }

    public void subscribe( final String channel,
                           final com.adpdigital.push.Callback clbk ) {

        subscribe(channel, false, clbk);
    }

    public void subscribe( final String channel,
                           final boolean live,
                           final com.adpdigital.push.Callback clbk ) {

        if( !live ) {
            Set<String> allTopics = new HashSet<>(Arrays.asList(topics));
            allTopics.add(channel);
//            boolean userHasPublicTopic = false;
//            for( String t : allTopics) {
//                if( t.contains("public/") && !t.equalsIgnoreCase(Constants.PUBLIC_CHANNEL) ) {
//                    userHasPublicTopic = true;
//                }
//            }
//            if( userHasPublicTopic ) {
//                allTopics.remove(Constants.PUBLIC_CHANNEL);
//            } else {
//                allTopics.add(Constants.PUBLIC_CHANNEL);
//            }
            getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
            topics = allTopics.toArray(new String[allTopics.size()]);
            updateInstallation(new HashMap<String, Object>());

            if (channel.startsWith("public/")) {
                RegistrationIntentService.subscribe(channel, getApplicationContext());
            }
        }

        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        brokerService.subscribe(channel, live, clbk);
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Log.e(TAG, "Error connecting to service " + name);
                        clbk.onFailure(new Exception("Push Disconnected"));
                    }
                },
                0
        );
    }


    public void unsubscribe( final String channel,
                             final com.adpdigital.push.Callback clbk ) {
        Set<String> allTopics = new HashSet<>(Arrays.asList(topics));
        allTopics.remove(channel);
        //TODO restore public topic if all public/ are ubsubed?
        getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
        topics = allTopics.toArray(new String[allTopics.size()]);

        updateInstallation(new HashMap<String, Object>());

        if (channel.startsWith("public/")) {
            RegistrationIntentService.unsubscribe(channel, getApplicationContext());
        }

        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        brokerService.unsubscribe(channel, clbk);
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Log.e(TAG, "Error connecting to service " + name);
                        clbk.onFailure(new Exception("Push Disconnected"));
                    }
                },
                0
        );
    }


    public void updateNotificationSettings( String topicName, String sound, boolean alert) {
        if( notificationSettings == null ) {
            notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        notificationSettings.remove(topicName);
        try {
            topicSetting.put("sound", sound);
            topicSetting.put("alert", alert);
            notificationSettings.put(topicName, topicSetting);
            getSharedPreferences()
                    .edit()
                    .putString("notificationSettings",notificationSettings.toString())
                    .apply();

            HashMap<String, Object> props = new HashMap();
            HashMap notifSettings = getNotificationSettings();
            if( notifSettings != null ) {
                props.put("notificationSettings", notifSettings );
            }
            updateInstallation(props);
        } catch (JSONException e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }


    public AdpPushClient addListener(Object object) {
        if( !eventBus.isRegistered(object) ) {
            eventBus.register(object);
        }
        return this;
    }


    public AdpPushClient notify(Object object) {
        if (eventBus != null) {
            eventBus.post(object);
        }
        return this;
    }


    public AdpPushClient removeListener(Object object) {
        if( eventBus.isRegistered(object) ) {
            eventBus.unregister(object);
        }
        return this;
    }


    //TODO check side effects of refactoring Context to Object
    public AdpPushClient setPushListener(Object ctx) {
//        this.clientContextInstance = ctx;
        return addListener(ctx);
    }


    public AdpPushClient removePushListener(Object activity) {
//        this.clientContextInstance = null;
        return removeListener(activity);
    }


    public AdpPushClient register(String userId) {
        return _register(userId, new String[]{}, false);
    }

    public AdpPushClient register(String userId, String[] channels) {
        return _register(userId, channels, false);
    }

    public AdpPushClient reRegister(String userId) {
        //TODO should we re-create deviceId so that we can track user change on server?
        return _register(userId, new String[]{}, true);
    }

    public AdpPushClient reRegister(String userId, String[] channels) {
        //TODO should we re-create deviceId so that we can track user change on server?
        return _register(userId, channels, true);
    }

    public AdpPushClient _register(String userId, String[] channels, boolean restartService) {
        if (userId == null || userId.trim().equals("") || userId.trim().equals( "null" )) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId);
        }

        if (registering) {
            Log.w(TAG, "Already in registering...");
            return this;
        }

        registeredOnce = false;

        this.userId = userId;

        getSharedPreferences().edit().putString("userId", encrypt(this.userId)).apply();

        Set<String> allTopics = new HashSet<>(Arrays.asList(this.topics));
        boolean userHasNewTopic = false;
        for (String ch : channels) {
            if (!allTopics.contains(ch)) {
                userHasNewTopic = true;
            }
        }
        allTopics.addAll(Arrays.asList(channels));
//        boolean userHasPublicTopic = false;
//        for( String t : allTopics) {
//            if( t.contains("public/") && !t.equalsIgnoreCase(Constants.PUBLIC_CHANNEL) ) {
//                userHasPublicTopic = true;
//            }
//        }
//        if( userHasPublicTopic ) {
//            allTopics.remove(Constants.PUBLIC_CHANNEL);
//        } else {
//            allTopics.add(Constants.PUBLIC_CHANNEL);
//        }
        if(userHasNewTopic) {
            makeSubsDirty();
        }
        getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
        this.topics = allTopics.toArray(new String[allTopics.size()]);

        failed_tries = 0;

        // Check device for Play Services APK.
        // If check succeeds, proceed with GCM registration.
        if (!checkPlayServices()) {
            getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w(TAG, "No valid Google Play Services found.");
        } else {
            getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }

        doRegister(restartService);
        return this;
    }


    private void doRegister() {
        doRegister(false);
    }


    private void doRegister(final boolean restartService) {
        if( userId == null ) {
            Log.e(TAG, "userId not initialized yet");
            return;
        }
        if( registering ) {
            Logger.d(TAG, "Register already in progress for " + userId);
            return;
        }

        registering = true;

        initializeAdapter();

        worker.schedule(new Runnable() {
            public void run() {
                if( registeredOnce ) {
                    Logger.w(TAG, "Already Registered Once!");
                    registering = false;
                    return;
                }
                if( !foreground.isForeground() ) {
                    Logger.w(TAG, "Don't register in non-foreground mode!");
                    registering = false;
                    return;
                }

                Logger.i(TAG, "Registering to Chabok, foreground:" + isForeground());
                updateRegistration(restartService);
            }
        }, 250, TimeUnit.MILLISECONDS);
    }


    public boolean isConnected() {
        return adapter!=null && adapter.isConnected();
    }


    public void dismiss() {
        Logger.i(TAG, "Dismiss AdpPushClient");
        eventBus.unregister(this);
        getForegroundManager().removeListeners();
    }


    private void cleanData() {
        getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    /**
     * Checks the device to make sure it has the Google Play Services APK. If
     * it doesn't, display a dialog that allows users to download the APK from
     * the Google Play Store or enable it in the device's system settings.
     */
    private boolean _checkPlayServices() {
        final int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable(getApplicationContext());
        if (resultCode != ConnectionResult.SUCCESS) {
            if (GooglePlayServicesUtil.isUserRecoverableError(resultCode) && currentActivity != null) {
                GooglePlayServicesUtil.getErrorDialog(
                        resultCode,
                        currentActivity,
                        Constants.PLAY_SERVICES_RESOLUTION_REQUEST
                ).show();
            } else {
                //TODO should we start Broker connection as a service !?
                Log.w(Constants.TAG, "This device is not supported.");
            }
            return false;
        }
        return true;
    }

    /**
     * Check the device to make sure it has the Google Play Services APK. If
     * it doesn't, display a dialog that allows users to download the APK from
     * the Google Play Store or enable it in the device's system settings.
     */
    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(getApplicationContext());
        if (resultCode != ConnectionResult.SUCCESS && resultCode != ConnectionResult.SERVICE_VERSION_UPDATE_REQUIRED) {
            if (apiAvailability.isUserResolvableError(resultCode)) {
                apiAvailability
                    .getErrorDialog(currentActivity, resultCode, Constants.PLAY_SERVICES_RESOLUTION_REQUEST)
                    .show();
            } else {
                Log.i(TAG, "This device is not supported.");
            }
            return false;
        }
        return true;
    }


    /**
     * Updates the registration for push notifications.
     */
    private AdpPushClient updateRegistration(boolean restartService) {

        // 2. Create LocalInstallation instance
        final LocalInstallation installation = new LocalInstallation(getApplicationContext(), adapter);

        //TODO Don't update unnecessary fields each time

        // 3. Update Installation properties that were not pre-filled
        // Enter the id of the LoopBack Application
        installation.setAppId(getAppId());

        installation.setAppVersion(SDK_VERSION);

        // Substitute a real id of the user logged in this application
        installation.setUserId(getUserId());

        installation.setSubscriptions(topics);

//        // 4. Check if we have a valid GCM registration id
//        if (installation.getDeviceToken() != null && !installation.getDeviceToken().equals("---")) {
//            // 5a. We have a valid GCM token, all we need to do now
//            //     is to save the installation to the server
//            saveInstallation(installation, restartService);
//        } else {
//            // 5b. We don't have a valid GCM token. Get one from GCM
//            // and save the installation afterwards.
//            registerInBackground(installation);
//        }

        restartServiceState = restartService;
        registerInBackground(installation);

        return this;
    }


    /**
     * Registers the application with GCM servers asynchronously.
     * <p/>
     * Stores the registration ID in the provided LocalInstallation
     */
    private void registerInBackground(final LocalInstallation installation) {
        installation.setDeviceToken("---");
        getApplicationContext().startService(
            new Intent(getApplicationContext(), RegistrationIntentService.class)
        );
    }


    public void onEvent( final DeviceToken token ) {
        final LocalInstallation installation = getLocalInstallation();
        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                Logger.i(TAG, "Got token, now registering installation");
                installation.setDeviceToken(token.getToken());
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
                if( registered ) {
                    saveInstallation(installation, restartServiceState);
                    restartServiceState = false;
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }


    /**
     * Saves the Installation to the LoopBack server and reports the result.
     *
     * @param installation
     */
    private void saveInstallation(final LocalInstallation installation, final boolean restartService) {
        final HashMap<String, Object> props = new HashMap<>();

        // fore this on each device save request
        props.put("launchCount", getAppLaunchCount());
        props.put("launchTime", getAppLaunchTime());
        props.put("deviceId", getDeviceId());

        // we can omit this until a change is happening!
        props.put("connection", Connectivity.getNetworkClass(getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("clientVersion", getClientVersion());

        HashMap notifSettings = getNotificationSettings();
        if( notifSettings != null ) {
            props.put("notificationSettings", notifSettings );
        }
        if (!getUserInfo().isEmpty()) {
            props.put("userInfo", getUserInfo());
        }

        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                Logger.i(TAG, "Saving installation " + installation.getId());
                installation.save(props, new Model.Callback() {
                    @Override
                    public void onSuccess() {
                        registering = false;
                        registeredOnce = true;
                        failed_tries = 0;
                        final Object id = installation.getId();
                        Logger.i(Constants.TAG, "Device saved: " + id);
                        eventBus.post(REGISTERED);

                        if (restartService) {
                            AdpPushClient.get().makeSubsDirty();
                            PushService.performAction(getApplicationContext(), "RESTART");
                        } else {
                            PushService.performAction(getApplicationContext(), "START");
                        }
                    }

                    @Override
                    public void onError(final Throwable t) {
                        registering = false;
                        registeredOnce = false;
                        final String msg = "Cannot save device, Reason: " + t.getMessage();
                        Log.e(TAG, msg, t);
                        eventBus.post(ConnectionStatus.DISCONNECTED);
                        retryRegistrationBackoff();
                    }
                });
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    HashMap<String,HashMap> getNotificationSettings() {
        if( notificationSettings != null ) {
            HashMap<String,HashMap> notifSettings = new HashMap<>();
            Iterator<String> channelSettings = notificationSettings.keys();
            while( channelSettings.hasNext() ) {
                String topic = channelSettings.next();
                JSONObject channelSetting = notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<>();
                setting.put( "alert", channelSetting.optString("alert", null));
                setting.put( "sound", channelSetting.optString("sound", null));
                notifSettings.put(topic, setting);
            }
            return notifSettings;
        }
        return null;
    }


    private void retryRegistrationBackoff() {
        if (++failed_tries <= TOTAL_RETRIES) {
            Runnable retryTask = new Runnable() {
                public void run() {
                    doRegister();
                }
            };
            long nextTry = (long)Math.max(Math.pow(2,failed_tries), 32);
            worker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    private String getDeviceId() {
        return android.os.Build.SERIAL;
    }

    public String getClientVersion() {
        String userClientVersion = decrypt(getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                PackageInfo packageInfo = getApplicationContext().getPackageManager()
                        .getPackageInfo(context.getPackageName(), 0);
                userClientVersion = packageInfo.versionName;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return userClientVersion;
    }

    public void setClientVersion(String version) {
        getSharedPreferences().edit().putString("clientVersion", encrypt(version)).apply();
    }


    private AdpPushClient setBadge(int badgeNumber) {
        getSharedPreferences()
            .edit()
            .putInt("androidBadge", badgeNumber)
            .apply();
        eventBus.post(new BadgeUpdate(badgeNumber));
        ShortcutBadger.applyCount(getApplicationContext(), badgeNumber);
        return this;
    }

    public void incBadge() {
        if( AdpPushClient.get().isForeground() ) {
            return;
        }

        int currentBadge = getSharedPreferences().getInt("androidBadge", 0);
        getSharedPreferences().edit().putInt("androidBadge", ++currentBadge).apply();
        eventBus.post(new BadgeUpdate(currentBadge));
        ShortcutBadger.applyCount(getApplicationContext(), currentBadge);
    }


    private void updateLaunchStats() {
        int count = getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++count).apply();
        getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
    }


    public int getAppLaunchCount() {
        return getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }


    public long getAppLaunchTime() {
        return getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }


    public int getBadge() {
        return getSharedPreferences().getInt("androidBadge", 0);
    }


    public AdpPushClient resetBadge() {
        // Cancel All notifications...
        NotificationManager mNotificationManager = (NotificationManager)
                getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.cancelAll();
        SharedPreferences.Editor editor = getSharedPreferences().edit();
//        for (String key : getSharedPreferences().getAll().keySet()) {
//            if (key.startsWith("gcm_notif_to_uuid_")) {
//                editor.remove(key);
//            }
//        }
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return setBadge(0);
    }


    public void unregister() {
//        context.stopService(new Intent(context, PushService.class));
        PushService.performAction(getApplicationContext(), "DISCONNECT");

        deleteInstallation(new com.adpdigital.push.Callback<LocalInstallation>() {
            @Override
            public void onSuccess(LocalInstallation device) {
                Log.w(TAG, "Deleted " + device.getId() + ": " + device);
            }

            @Override
            public void onFailure(Throwable value) {
                Log.e(TAG, "Delete Error " + value);
            }
        });
        getSharedPreferences().edit().remove("userId").apply();
        getSharedPreferences().edit().remove(PROPERTY_INSTALLATION_ID).apply();
        getSharedPreferences().edit().remove("topics").apply();
        getSharedPreferences().edit().remove("subscriptionDirty").apply();
        getSharedPreferences().edit().remove("offlineCache").apply();
        getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        getSharedPreferences().edit().remove("dataCache").apply();
    }


    public String getInstallationId() {
        String idJson = decrypt(getSharedPreferences().getString(PROPERTY_INSTALLATION_ID, null));
        if(idJson != null) {
            try {
                return (String)(new JSONArray(idJson)).get(0);
            } catch (JSONException var5) {
                String currentVersionCode = "Cannot parse installation id \'" + idJson + "\'";
                Logger.e(TAG, currentVersionCode, var5);
            }
        }
        return null;
    }


    private void deleteInstallation(final com.adpdigital.push.Callback clbk) {
        ModelRepository<Model> repository = adapter.createRepository("installation");
        final LocalInstallation installation = new LocalInstallation(
                getApplicationContext(),
                adapter
        );
        final Model model = repository.createModel(BeanUtil.getProperties(installation, false, false));
        model.destroy(new Model.Callback() {
            @Override
            public void onSuccess() {
                clbk.onSuccess(installation);
            }

            @Override
            public void onError(Throwable t) {
                clbk.onFailure(t);
            }
        });
    }


    private void updateInstallation( Map<String,?> properties) {
        updateInstallation(properties, new com.adpdigital.push.Callback<LocalInstallation>() {
            @Override
            public void onSuccess(LocalInstallation value) {
            }

            @Override
            public void onFailure(Throwable value) {
            }
        });
    }


    private void updateInstallation( Map<String,?> properties,
                                     final com.adpdigital.push.Callback<LocalInstallation> clbk ) {

        final LocalInstallation installation = new LocalInstallation(
                getApplicationContext(),
                adapter
        );
        installation.setAppId(getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(getUserId());
        installation.setSubscriptions(topics);
        updateInstallation(installation, properties, clbk);
    }


    private LocalInstallation getLocalInstallation() {
        final LocalInstallation installation = new LocalInstallation(
                getApplicationContext(),
                adapter
        );
        installation.setAppId(getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(getUserId());
        installation.setSubscriptions(topics);
        return installation;
    }


    private void updateInstallation(final LocalInstallation installation,
                                    Map<String, ?> properties,
                                    final com.adpdigital.push.Callback<LocalInstallation> clbk) {
        final ModelRepository<Model> repository = adapter.createRepository("installation");
        final Model model = repository.createModel(BeanUtil.getProperties(installation, false, false));
        model.putAll(properties);
        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                model.save(new Model.Callback() {
                    @Override
                    public void onSuccess() {
                        clbk.onSuccess(installation);
                    }

                    @Override
                    public void onError(Throwable t) {
                        clbk.onFailure(t);
                    }
                });
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }


    public void requestVerificationCode(String userId, String media, final com.adpdigital.push.Callback clbk) {
        ModelRepository<Model> repository = adapter.createRepository("verification");
        Map<String, Object> map = new HashMap<>();
        map.put("userId", userId);
        map.put("appId", appId);
        map.put("media", media);
        repository.invokeStaticMethod("requestCode", map, new Adapter.Callback() {
            @Override
            public void onSuccess(String s) {
                clbk.onSuccess(s);
            }

            @Override
            public void onError(Throwable throwable) {
                clbk.onFailure(throwable);
            }
        });
    }


    public void requestVerificationCode( String userId, final com.adpdigital.push.Callback clbk ) {
        requestVerificationCode(userId, "sms", clbk);
    }


    public void verifyUserCode( String userId, String code, final com.adpdigital.push.Callback clbk ) {
        ModelRepository<Model> repository = adapter.createRepository("verification");
        Map<String, Object> map = new HashMap<>();
        map.put("userId", userId);
        map.put("appId", appId);
        map.put("code", code);
        repository.invokeStaticMethod("verify", map, new Adapter.Callback() {
            @Override
            public void onSuccess(String s) {
                clbk.onSuccess(s);
            }

            @Override
            public void onError(Throwable throwable) {
                clbk.onFailure(throwable);
            }
        });
    }


    boolean isFreshStart() {
        return isFreshStart;
    }


    public boolean isForeground() {
        return getForegroundManager().isForeground();
    }


    public boolean isFocused() {
        return
            isForeground()
                &&
            getActivityClass().getName().equals(getForegroundManager().getActiveActivityClassName());
    }


    public boolean isBackground() {
        return getForegroundManager().isBackground();
    }


    public AdpPushClient addAppListener(AppListener listener) {
        getForegroundManager().addListener(listener);
        return this;
    }


    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }


    public Class getActivityClass() {
        return this.activityClass;
    }


    private Context getApplicationContext() {
        return this.context;
    }


    public String getSenderId() {
        return this.senderId;
    }


    public String getUserId() {
        return decrypt(getSharedPreferences().getString("userId", null));
//        return this.userId;
    }

    public boolean isRegistered() {
        return getSharedPreferences().getString(PROPERTY_INSTALLATION_ID, null) != null;
    }

    public String getAppId() {
        return this.appId;
    }


    public int getNotificationIcon() {
        if( notificationIcon == -1 ) {
            try {
                PackageInfo packageInfo = getApplicationContext()
                        .getPackageManager()
                        .getPackageInfo(getApplicationContext().getPackageName(), 0);
                ApplicationInfo appInfo = getApplicationContext()
                        .getPackageManager()
                        .getApplicationInfo(packageInfo.packageName, 0);
                return appInfo.icon;
            } catch (PackageManager.NameNotFoundException e) {
                return -1;
            }
        }
        return notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public int getNotificationIconSilhouette() {
        if( notificationIconSilhouette == -1 ) {
            return getNotificationIcon();
        }
        return notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        this.notificationIconSilhouette = notificationIconSilhouette;
    }

    public HashMap<String, Object> getUserInfo() {
        return userInfo;
    }


    public void setUserInfo(HashMap<String, Object> userInfo) {
        this.userInfo = userInfo;
    }


    public AdpPushClient setDevelopment( boolean isDev ) {
        useDev = isDev;
        initializeAdapter();
        return this;
    }


    public AdpPushClient setSticky( boolean sticky ) {
        FORCE_STICKY = sticky;
        return this;
    }

    public void enableEventDelivery(String eventName) {
        enableEventDelivery(eventName, false, false);
    }

    public void enableEventDelivery(String eventName, boolean live) {
        enableEventDelivery(eventName, false, live);
    }

    public void enableEventDelivery(final String eventName, final boolean forPublic, final boolean live) {
        final Callback clbk = new Callback() {
            @Override
            public void onSuccess(Object value) {
                Log.d(TAG, "Subscribed on event " + eventName + ": " + value);
            }

            @Override
            public void onFailure(Throwable value) {
                Log.e(TAG, "Error subscribing on event " + eventName + ": ", value);
            }
        };

        getApplicationContext().bindService(
                new Intent(getApplicationContext(), PushService.class),
                new ServiceConnection() {
                    @SuppressWarnings("unchecked")
                    @Override
                    public void onServiceConnected(ComponentName className, final IBinder service) {
                        PushService brokerService = ((PushService.LocalBinder<PushService>) service).getService();
                        brokerService.subscribeEvent(eventName, forPublic, live, clbk);
                        getApplicationContext().unbindService(this);
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Log.e(TAG, "Error connecting to service " + name);
                        clbk.onFailure(new Exception("Push Disconnected"));
                    }
                },
                0
        );
    }

    public AdpPushClient enableDeliveryTopic() {
        getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }


    private AdpPushClient setSecure( boolean isSecure ) {
        useSecure = isSecure;
        initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        return this.topics;
    }


    private SharedPreferences getSharedPreferences() {
        return getApplicationContext().getSharedPreferences(
                LocalInstallation.SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE
        );
    }


    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        this.currentActivity = currentActivity;
        return this;
    }


    void notifyNewMessage(PushMessage message) {
        //TODO this hook should be put inside sendNotification to be called for GCM notifs!
        Class clazz = this.activityClass;

        if(hasNotified(message.getId())){
           return;
        }

        for( NotificationHandler h : handlers ) {
            ChabokNotification notif = new ChabokNotification(message, 0);
            Class theirs = h.getActivityClass(notif);
            if( theirs != null ) {
                clazz = theirs;
            }
        }
        GcmMessageHandler.sendNotification(
                this.getApplicationContext(),
                clazz,
                new ChabokNotification(message, 0)
        );
    }

    static boolean hasNotified(String id) {
        return notifs.contains(id);
    }


    boolean addNotifiedMessage(String id) {
        boolean val = notifs.add(id);
        getSharedPreferences().edit().putStringSet(
            "notifs",
            new HashSet<>(Arrays.asList(notifs.toArray(new String[notifs.size()])))
        ).apply();
        return val;
    }

    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        Class clazz = activityClass;
        for( NotificationHandler h : handlers ) {
            ChabokNotification gcmNotif = new ChabokNotification(
                data.getString("messageId"),
                data.getString("messageFrom"),
                data.getString("message"),
                Integer.valueOf(data.getString("androidBadge", "0")),
                data
            );
            Class theirs = h.getActivityClass( gcmNotif );
            if( theirs != null ) {
                clazz = theirs;
            }
        }
        return clazz;
    }

    boolean prepareNotification( ChabokNotification notif, NotificationCompat.Builder builder ) {
        boolean showNotification = true;
        for( NotificationHandler h : handlers ) {
            showNotification &= h.buildNotification( notif, builder );
        }
        return showNotification;
    }


    public void addNotificationHandler( NotificationHandler handler ) {
        handlers.add( handler );
    }


    public void ifHuaweiAlert(Activity ctx) {
        ifHuaweiAlert(
                ctx,
                "برنامه‌های محافظت شده",
                String.format("برنامه %s برای کارکرد درست می‌بایست در لیست برنامه‌های محافظت شده فعال شود.%n",
                        getApplicationContext().getString(R.string.app_name))
        );
    }


    public void ifHuaweiAlert(Activity ctx, String title, String message) {
        final SharedPreferences settings = ctx
                .getSharedPreferences("ProtectedApps", getApplicationContext().MODE_PRIVATE);
        final String saveIfSkip = "skipProtectedAppsMessage";
        boolean skipMessage = settings.getBoolean(saveIfSkip, false);
        if (!skipMessage) {
            final SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (isCallable(intent)) {
                final CheckBox dontShowAgain = new CheckBox(getApplicationContext());
                dontShowAgain.setTextColor(Color.BLACK);
                dontShowAgain.setText("دیگر این پیام را نشان نده");
                dontShowAgain.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        editor.putBoolean(saveIfSkip, isChecked);
                        editor.apply();
                    }
                });

                new AlertDialog.Builder(ctx)
                        .setIcon(android.R.drawable.ic_dialog_alert)
                        .setTitle(title)
                        .setMessage(message)
                        .setView(dontShowAgain)
                        .setPositiveButton("برو به برنامه‌های محافظت شده", new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int which) {
                                huaweiProtectedApps();
                            }
                        })
                        .setNegativeButton("لغو", null)
                        .show();
            } else {
                editor.putBoolean(saveIfSkip, true);
                editor.apply();
            }
        }
    }

    private boolean isCallable(Intent intent) {
        List<ResolveInfo> list = getApplicationContext()
                .getPackageManager()
                .queryIntentActivities(
                        intent,
                        PackageManager.MATCH_DEFAULT_ONLY
                );
        return list.size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                cmd += " --user " + getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
        } catch (IOException ignored) {
        }
    }

    private String getUserSerial() {
        //noinspection ResourceType
        Object userManager = getApplicationContext().getSystemService("user");
        if (null == userManager) return "";

        try {
            Method myUserHandleMethod = android.os.Process.class.getMethod("myUserHandle", (Class<?>[]) null);
            Object myUserHandle = myUserHandleMethod.invoke(android.os.Process.class, (Object[]) null);
            Method getSerialNumberForUser = userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass());
            Long userSerial = (Long) getSerialNumberForUser.invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            } else {
                return "";
            }
        } catch (NoSuchMethodException | IllegalArgumentException | InvocationTargetException | IllegalAccessException ignored) {
        }
        return "";
    }


    public String encrypt( String value ) {

        try {
            final byte[] bytes = value!=null ? value.getBytes("UTF-8") : new byte[0];
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(Cipher.ENCRYPT_MODE, key, new PBEParameterSpec(Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID).getBytes("UTF-8"), 20));
            return new String(Base64Support.encode(pbeCipher.doFinal(bytes), Base64Support.NO_WRAP),"UTF-8");
        } catch( Exception e ) {
            Logger.e(this.getClass().getName(), "Warning, could not encrypt the value.  It may be stored in plaintext.  "+e.getMessage(), e);
            return value;
        }

    }

    public String decrypt(String value){
        if (value == null) {
            return value;
        }

        try {
            final byte[] bytes = value!=null ? Base64Support.decode(value, Base64Support.DEFAULT) : new byte[0];
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(Cipher.DECRYPT_MODE, key, new PBEParameterSpec(
                Settings.Secure.getString(
                    context.getContentResolver(),
                    Settings.Secure.ANDROID_ID).getBytes("UTF-8"),
                20));
            return new String(pbeCipher.doFinal(bytes),"UTF-8");
        } catch( Exception e) {
            Logger.e(this.getClass().getName(), "Warning, could not decrypt the value.  It may be stored in plaintext.  "+e.getMessage(), e);
            return value;
        }
    }


    boolean shouldBeSticky() {
        if( FORCE_STICKY ) {
            return true;
        }
        if( appId != null ) {
//            if(appId.contains("ansar-")) {
//                return true;
//            }
        }
        return !isGCMSupported();
    }

    public boolean isGCMSupported() {
        return !getSharedPreferences().getBoolean("noGCM", false);
    }
}