/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.am;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ForegroundManager
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = ForegroundManager.class.getName();
    private static String currentActivity = null;
    private static final long CHECK_DELAY = 500L;
    private static ForegroundManager instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler();
    private List<AppListener> listeners = new CopyOnWriteArrayList<AppListener>();
    private Runnable check;

    public static ForegroundManager init(Application application) {
        if (instance == null) {
            instance = new ForegroundManager();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        return instance;
    }

    public static ForegroundManager get(Application application) {
        if (instance == null) {
            ForegroundManager.init(application);
        }
        return instance;
    }

    public static ForegroundManager get(Context context) {
        if (instance == null) {
            if ((context = context.getApplicationContext()) instanceof Application) {
                return ForegroundManager.init((Application)context);
            }
            throw new IllegalStateException("ForegroundManager is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static ForegroundManager get() {
        if (instance == null) {
            throw new IllegalStateException("ForegroundManager is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void addListener(AppListener appListener) {
        this.listeners.add(appListener);
    }

    public void removeListener(AppListener appListener) {
        this.listeners.remove(appListener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public String getActiveActivityClassName() {
        return currentActivity;
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean bl = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (bl) {
            Log.d((String)TAG, (String)"app foreground");
            for (AppListener appListener : this.listeners) {
                try {
                    appListener.onBecameForeground(activity.getClass());
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"AppListener threw exception!", (Throwable)exception);
                }
            }
        } else {
            Log.d((String)TAG, (String)"still foreground");
        }
        currentActivity = activity.getClass().getName();
    }

    public void onActivityPaused(Activity activity) {
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = new am(this);
        this.handler.postDelayed(this.check, 500L);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static /* synthetic */ boolean access$000(ForegroundManager foregroundManager) {
        return foregroundManager.foreground;
    }

    static /* synthetic */ boolean access$100(ForegroundManager foregroundManager) {
        return foregroundManager.paused;
    }

    static /* synthetic */ boolean access$002(ForegroundManager foregroundManager, boolean bl) {
        foregroundManager.foreground = bl;
        return foregroundManager.foreground;
    }

    static /* synthetic */ String access$200() {
        return TAG;
    }

    static /* synthetic */ List access$300(ForegroundManager foregroundManager) {
        return foregroundManager.listeners;
    }
}

