/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.ODB;
import com.adpdigital.push.OWQ;
import com.adpdigital.push.TUY;
import com.adpdigital.push.WAW;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            new StringBuilder("Couldn't start service in foreground (").append(AdpPushClient.get().isForeground()).append(") with action ").append(action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        WAW wAW = WAW.getInstance((Context)this);
        wAW.NZV();
        wAW.VMB = (WifiManager)wAW.KEM.getSystemService("wifi");
        wAW.AOP = (AlarmManager)wAW.KEM.getSystemService("alarm");
        WAW wAW2 = wAW;
        wAW2.HUI();
        wAW2.cancelReconnect();
        Set set = wAW.AOP().getStringSet("dataCache", null);
        if (set != null) {
            WAW.NZV.addAll(set);
        }
        wAW.YCE.register(wAW);
        wAW.DYH = new WAW.MRR<WAW>(wAW, wAW);
        if (wAW.OJW == null) {
            wAW.OJW = new NetworkConnectionIntentReceiver(wAW.KEM, new TUY(wAW));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        wAW.HUI = new OWQ(wAW);
        if (wAW.KEM != null) {
            try {
                wAW.KEM.getApplicationContext().registerReceiver(wAW.HUI, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    wAW.KEM.registerReceiver(wAW.HUI, intentFilter);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (WAW.MRR == null) {
            WAW.MRR = new WAW.OJW(wAW);
        }
        wAW.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        new StringBuilder("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand ").append(flags).append(", ").append(startId);
        if (intent == null || intent.getAction() == null) {
            WAW.getInstance((Context)this).OJW();
        } else {
            new StringBuilder("PushService action ").append(intent.getAction()).append(", foreground:").append(AdpPushClient.get().isForeground()).append(", screenOn:").append(WAW.MRR());
            switch (intent.getAction()) {
                case "START": {
                    WAW.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    WAW wAW = WAW.getInstance((Context)this);
                    if (AdpPushClient.get().isDisabledRealtime() || !ODB.isConnected(wAW.KEM)) break;
                    if (WAW.MRR != null && (WAW.MRR.isConnecting() || WAW.MRR.isConnected())) {
                        WAW.MRR.disconnectExistingClient();
                    }
                    new WAW.NZV(wAW).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    WAW wAW = WAW.getInstance((Context)this);
                    if (!WAW.MRR.isConnected()) break;
                    new WAW.HUI(wAW).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "RECONNECT": {
                    WAW.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    WAW.getInstance((Context)this).cancelReconnect();
                    WAW.getInstance((Context)this).HUI();
                    if (WAW.MRR == null) break;
                    WAW.MRR.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    WAW.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    new StringBuilder("Unrecognized action ").append(intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            return 1;
        }
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        new StringBuilder("PushService removed: ").append(rootIntent.getAction()).append(rootIntent);
        WAW.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        WAW.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        WAW.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

