/*
 * Decompiled with CFR 0.152.
 */
package KEM;

import AOP.VLN;
import KEM.MRR;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class NZV {
    private static final String NZV = NZV.class.getName();
    public static final String SSLPROTOCOL = "com.ibm.ssl.protocol";
    public static final String JSSEPROVIDER = "com.ibm.ssl.contextProvider";
    public static final String KEYSTORE = "com.ibm.ssl.keyStore";
    public static final String KEYSTOREPWD = "com.ibm.ssl.keyStorePassword";
    public static final String KEYSTORETYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEYSTOREPROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEYSTOREMGR = "com.ibm.ssl.keyManager";
    public static final String TRUSTSTORE = "com.ibm.ssl.trustStore";
    public static final String TRUSTSTOREPWD = "com.ibm.ssl.trustStorePassword";
    public static final String TRUSTSTORETYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUSTSTOREPROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUSTSTOREMGR = "com.ibm.ssl.trustManager";
    public static final String CIPHERSUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENTAUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SYSKEYSTORE = "javax.net.ssl.keyStore";
    public static final String SYSKEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String SYSKEYSTOREPWD = "javax.net.ssl.keyStorePassword";
    public static final String SYSTRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String SYSTRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    public static final String SYSTRUSTSTOREPWD = "javax.net.ssl.trustStorePassword";
    public static final String SYSKEYMGRALGO = "ssl.KeyManagerFactory.algorithm";
    public static final String SYSTRUSTMGRALGO = "ssl.TrustManagerFactory.algorithm";
    public static final String DEFAULT_PROTOCOL = "TLS";
    private static final String[] MRR = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.contextProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyManager", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustManager", "com.ibm.ssl.enabledCipherSuites", "com.ibm.ssl.clientAuthentication"};
    private Hashtable OJW = new Hashtable();
    private Properties HUI;
    private static final byte[] YCE = new byte[]{-99, -89, -39, -128, 5, -72, -119, -100};
    private HXH.MRR XTU = null;

    public static boolean isSupportedOnJVM() throws LinkageError, ExceptionInInitializerError {
        String requiredClassname = "javax.net.ssl.SSLServerSocketFactory";
        try {
            Class.forName(requiredClassname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public NZV() {
    }

    public NZV(HXH.MRR logger) {
        this();
        this.XTU = logger;
    }

    private static void NZV(Properties properties) throws IllegalArgumentException {
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            int n;
            String k;
            String string = k = (String)i.next();
            for (n = 0; n < 14 && !MRR[n].equals(string); ++n) {
            }
            if (n < 14) continue;
            throw new IllegalArgumentException(k + " is not a valid IBM SSL property key.");
        }
    }

    public static char[] toChar(byte[] b) {
        if (b == null) {
            return null;
        }
        char[] c = new char[b.length / 2];
        int i = 0;
        int j = 0;
        while (i < b.length) {
            c[j++] = (char)((b[i++] & 0xFF) + ((b[i++] & 0xFF) << 8));
        }
        return c;
    }

    public static byte[] toByte(char[] c) {
        if (c == null) {
            return null;
        }
        byte[] b = new byte[c.length * 2];
        int i = 0;
        int j = 0;
        while (j < c.length) {
            b[i++] = (byte)(c[j] & 0xFF);
            b[i++] = (byte)(c[j++] >> 8 & 0xFF);
        }
        return b;
    }

    public static String obfuscate(char[] password) {
        if (password == null) {
            return null;
        }
        byte[] bytes = KEM.NZV.toByte(password);
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((bytes[i] ^ YCE[i % 8]) & 0xFF);
        }
        return "{xor}" + new String(KEM.MRR.encode(bytes));
    }

    public static char[] deObfuscate(String ePassword) {
        byte[] bytes;
        if (ePassword == null) {
            return null;
        }
        try {
            bytes = KEM.MRR.decode(ePassword.substring(5));
        }
        catch (Exception exception) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((bytes[i] ^ YCE[i % 8]) & 0xFF);
        }
        return KEM.NZV.toChar(bytes);
    }

    public static String packCipherSuites(String[] ciphers) {
        String cipherSet = null;
        if (ciphers != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < ciphers.length; ++i) {
                buf.append(ciphers[i]);
                if (i >= ciphers.length - 1) continue;
                buf.append(',');
            }
            cipherSet = buf.toString();
        }
        return cipherSet;
    }

    public static String[] unpackCipherSuites(String ciphers) {
        if (ciphers == null) {
            return null;
        }
        Vector<String> c = new Vector<String>();
        int i = ciphers.indexOf(44);
        int j = 0;
        while (i >= 0) {
            c.add(ciphers.substring(j, i));
            j = i + 1;
            i = ciphers.indexOf(44, j);
        }
        c.add(ciphers.substring(j));
        String[] s = new String[c.size()];
        c.toArray(s);
        return s;
    }

    private static void MRR(Properties p) {
        String epw;
        String pw = p.getProperty(KEYSTOREPWD);
        if (pw != null && !pw.startsWith("{xor}")) {
            epw = KEM.NZV.obfuscate(pw.toCharArray());
            p.put(KEYSTOREPWD, epw);
        }
        if ((pw = p.getProperty(TRUSTSTOREPWD)) != null && !pw.startsWith("{xor}")) {
            epw = KEM.NZV.obfuscate(pw.toCharArray());
            p.put(TRUSTSTOREPWD, epw);
        }
    }

    public void initialize(Properties props, String configID) throws IllegalArgumentException {
        KEM.NZV.NZV(props);
        Properties p = new Properties();
        p.putAll((Map<?, ?>)props);
        KEM.NZV.MRR(p);
        if (configID != null) {
            this.OJW.put(configID, p);
            return;
        }
        this.HUI = p;
    }

    public void merge(Properties props, String configID) throws IllegalArgumentException {
        KEM.NZV.NZV(props);
        Properties p = this.HUI;
        if (configID != null) {
            p = (Properties)this.OJW.get(configID);
        }
        if (p == null) {
            p = new Properties();
        }
        KEM.NZV.MRR(props);
        p.putAll((Map<?, ?>)props);
        if (configID != null) {
            this.OJW.put(configID, p);
            return;
        }
        this.HUI = p;
    }

    public boolean remove(String configID) {
        boolean res = false;
        if (configID != null) {
            res = this.OJW.remove(configID) != null;
        } else if (this.HUI != null) {
            res = true;
            this.HUI = null;
        }
        return res;
    }

    public Properties getConfiguration(String configID) {
        return configID == null ? this.HUI : this.OJW.get(configID);
    }

    private String NZV(String configID, String ibmKey, String sysProperty) {
        String res = this.NZV(configID, ibmKey);
        if (res != null) {
            return res;
        }
        if (sysProperty != null) {
            res = System.getProperty(sysProperty);
        }
        return res;
    }

    private String NZV(String configID, String ibmKey) {
        String res = null;
        Properties p = null;
        if (configID != null) {
            p = (Properties)this.OJW.get(configID);
        }
        if (p != null && (res = p.getProperty(ibmKey)) != null) {
            return res;
        }
        p = this.HUI;
        if (p != null && (res = p.getProperty(ibmKey)) != null) {
            return res;
        }
        return res;
    }

    public String getSSLProtocol(String configID) {
        return this.NZV(configID, SSLPROTOCOL, null);
    }

    public String getJSSEProvider(String configID) {
        return this.NZV(configID, JSSEPROVIDER, null);
    }

    public String getKeyStore(String configID) {
        String ibmKey = KEYSTORE;
        String sysProperty = SYSKEYSTORE;
        String res = this.NZV(configID, ibmKey);
        if (res != null) {
            return res;
        }
        return System.getProperty(sysProperty);
    }

    public char[] getKeyStorePassword(String configID) {
        String pw = this.NZV(configID, KEYSTOREPWD, SYSKEYSTOREPWD);
        char[] r = null;
        if (pw != null) {
            r = pw.startsWith("{xor}") ? KEM.NZV.deObfuscate(pw) : pw.toCharArray();
        }
        return r;
    }

    public String getKeyStoreType(String configID) {
        return this.NZV(configID, KEYSTORETYPE, SYSKEYSTORETYPE);
    }

    public String getKeyStoreProvider(String configID) {
        return this.NZV(configID, KEYSTOREPROVIDER, null);
    }

    public String getKeyManager(String configID) {
        return this.NZV(configID, KEYSTOREMGR, SYSKEYMGRALGO);
    }

    public String getTrustStore(String configID) {
        return this.NZV(configID, TRUSTSTORE, SYSTRUSTSTORE);
    }

    public char[] getTrustStorePassword(String configID) {
        String pw = this.NZV(configID, TRUSTSTOREPWD, SYSTRUSTSTOREPWD);
        char[] r = null;
        if (pw != null) {
            r = pw.startsWith("{xor}") ? KEM.NZV.deObfuscate(pw) : pw.toCharArray();
        }
        return r;
    }

    public String getTrustStoreType(String configID) {
        return this.NZV(configID, TRUSTSTORETYPE, null);
    }

    public String getTrustStoreProvider(String configID) {
        return this.NZV(configID, TRUSTSTOREPROVIDER, null);
    }

    public String getTrustManager(String configID) {
        return this.NZV(configID, TRUSTSTOREMGR, SYSTRUSTMGRALGO);
    }

    public String[] getEnabledCipherSuites(String configID) {
        return KEM.NZV.unpackCipherSuites(this.NZV(configID, CIPHERSUITES, null));
    }

    public boolean getClientAuthentication(String configID) {
        String auth = this.NZV(configID, CLIENTAUTH, null);
        boolean res = false;
        if (auth != null) {
            res = Boolean.valueOf(auth);
        }
        return res;
    }

    private SSLContext NZV(String configID) throws VLN {
        SSLContext ctx;
        String protocol = this.getSSLProtocol(configID);
        if (protocol == null) {
            protocol = DEFAULT_PROTOCOL;
        }
        if (this.XTU != null) {
            this.XTU.fine(NZV, "getSSLContext", "12000", new Object[]{configID != null ? configID : "null (broker defaults)", protocol});
        }
        String provider = this.getJSSEProvider(configID);
        try {
            String trustStoreType;
            String keyStoreType;
            ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12001", new Object[]{configID != null ? configID : "null (broker defaults)", ctx.getProvider().getName()});
            }
            String keyStoreName = this.NZV(configID, KEYSTORE, null);
            KeyManager[] keyMgr = null;
            if (keyStoreName == null) {
                keyStoreName = this.NZV(configID, KEYSTORE, SYSKEYSTORE);
            }
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12004", new Object[]{configID != null ? configID : "null (broker defaults)", keyStoreName != null ? keyStoreName : "null"});
            }
            char[] keyStorePwd = this.getKeyStorePassword(configID);
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12005", new Object[]{configID != null ? configID : "null (broker defaults)", keyStorePwd != null ? KEM.NZV.obfuscate(keyStorePwd) : "null"});
            }
            if ((keyStoreType = this.getKeyStoreType(configID)) == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12006", new Object[]{configID != null ? configID : "null (broker defaults)", keyStoreType != null ? keyStoreType : "null"});
            }
            String keyMgrAlgo = KeyManagerFactory.getDefaultAlgorithm();
            String keyMgrProvider = this.getKeyStoreProvider(configID);
            String keyManager = this.getKeyManager(configID);
            if (keyManager != null) {
                keyMgrAlgo = keyManager;
            }
            if (keyStoreName != null && keyStoreType != null && keyMgrAlgo != null) {
                try {
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    keyStore.load(new FileInputStream(keyStoreName), keyStorePwd);
                    KeyManagerFactory keyMgrFact = keyMgrProvider != null ? KeyManagerFactory.getInstance(keyMgrAlgo, keyMgrProvider) : KeyManagerFactory.getInstance(keyMgrAlgo);
                    if (this.XTU != null) {
                        this.XTU.fine(NZV, "getSSLContext", "12010", new Object[]{configID != null ? configID : "null (broker defaults)", keyMgrAlgo != null ? keyMgrAlgo : "null"});
                        this.XTU.fine(NZV, "getSSLContext", "12009", new Object[]{configID != null ? configID : "null (broker defaults)", keyMgrFact.getProvider().getName()});
                    }
                    keyMgrFact.init(keyStore, keyStorePwd);
                    keyMgr = keyMgrFact.getKeyManagers();
                }
                catch (KeyStoreException e) {
                    throw new VLN(e);
                }
                catch (CertificateException e) {
                    throw new VLN(e);
                }
                catch (FileNotFoundException e) {
                    throw new VLN(e);
                }
                catch (IOException e) {
                    throw new VLN(e);
                }
                catch (UnrecoverableKeyException e) {
                    throw new VLN(e);
                }
            }
            String trustStoreName = this.getTrustStore(configID);
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12011", new Object[]{configID != null ? configID : "null (broker defaults)", trustStoreName != null ? trustStoreName : "null"});
            }
            TrustManager[] trustMgr = null;
            char[] trustStorePwd = this.getTrustStorePassword(configID);
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12012", new Object[]{configID != null ? configID : "null (broker defaults)", trustStorePwd != null ? KEM.NZV.obfuscate(trustStorePwd) : "null"});
            }
            if ((trustStoreType = this.getTrustStoreType(configID)) == null) {
                trustStoreType = KeyStore.getDefaultType();
            }
            if (this.XTU != null) {
                this.XTU.fine(NZV, "getSSLContext", "12013", new Object[]{configID != null ? configID : "null (broker defaults)", trustStoreType != null ? trustStoreType : "null"});
            }
            String trustMgrAlgo = TrustManagerFactory.getDefaultAlgorithm();
            String trustMgrProvider = this.getTrustStoreProvider(configID);
            String trustManager = this.getTrustManager(configID);
            if (trustManager != null) {
                trustMgrAlgo = trustManager;
            }
            if (trustStoreName != null && trustStoreType != null && trustMgrAlgo != null) {
                try {
                    KeyStore trustStore = KeyStore.getInstance(trustStoreType);
                    trustStore.load(new FileInputStream(trustStoreName), trustStorePwd);
                    TrustManagerFactory trustMgrFact = trustMgrProvider != null ? TrustManagerFactory.getInstance(trustMgrAlgo, trustMgrProvider) : TrustManagerFactory.getInstance(trustMgrAlgo);
                    if (this.XTU != null) {
                        this.XTU.fine(NZV, "getSSLContext", "12017", new Object[]{configID != null ? configID : "null (broker defaults)", trustMgrAlgo != null ? trustMgrAlgo : "null"});
                        this.XTU.fine(NZV, "getSSLContext", "12016", new Object[]{configID != null ? configID : "null (broker defaults)", trustMgrFact.getProvider().getName()});
                    }
                    trustMgrFact.init(trustStore);
                    trustMgr = trustMgrFact.getTrustManagers();
                }
                catch (KeyStoreException e) {
                    throw new VLN(e);
                }
                catch (CertificateException e) {
                    throw new VLN(e);
                }
                catch (FileNotFoundException e) {
                    throw new VLN(e);
                }
                catch (IOException e) {
                    throw new VLN(e);
                }
            }
            ctx.init(keyMgr, trustMgr, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VLN(e);
        }
        catch (NoSuchProviderException e) {
            throw new VLN(e);
        }
        catch (KeyManagementException e) {
            throw new VLN(e);
        }
        return ctx;
    }

    public SSLSocketFactory createSocketFactory(String configID) throws VLN {
        SSLContext ctx = this.NZV(configID);
        if (this.XTU != null) {
            this.XTU.fine(NZV, "createSocketFactory", "12020", new Object[]{configID != null ? configID : "null (broker defaults)", this.getEnabledCipherSuites(configID) != null ? this.NZV(configID, CIPHERSUITES, null) : "null (using platform-enabled cipher suites)"});
        }
        return ctx.getSocketFactory();
    }
}

