/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.GTE;
import com.adpdigital.push.IMV;
import com.adpdigital.push.KPZ;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.WAW;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            new StringBuilder("Couldn't start service in foreground (").append(AdpPushClient.get().isForeground()).append(") with action ").append(action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        IMV iMV = IMV.getInstance((Context)this);
        iMV.NZV();
        iMV.VMB = (WifiManager)iMV.KEM.getSystemService("wifi");
        iMV.AOP = (AlarmManager)iMV.KEM.getSystemService("alarm");
        IMV iMV2 = iMV;
        iMV2.HUI();
        iMV2.cancelReconnect();
        Set set = iMV.AOP().getStringSet("dataCache", null);
        if (set != null) {
            IMV.NZV.addAll(set);
        }
        iMV.YCE.register(iMV);
        iMV.DYH = new IMV.MRR<IMV>(iMV, iMV);
        if (iMV.OJW == null) {
            iMV.OJW = new NetworkConnectionIntentReceiver(iMV.KEM, new WAW(iMV));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        iMV.HUI = new KPZ(iMV);
        iMV.KEM.registerReceiver(iMV.HUI, intentFilter);
        if (IMV.MRR == null) {
            IMV.MRR = new IMV.OJW(iMV);
        }
        iMV.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        new StringBuilder("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand ").append(flags).append(", ").append(startId);
        if (intent == null || intent.getAction() == null) {
            IMV.getInstance((Context)this).OJW();
        } else {
            new StringBuilder("PushService action ").append(intent.getAction()).append(", foreground:").append(AdpPushClient.get().isForeground()).append(", screenOn:").append(IMV.MRR());
            switch (intent.getAction()) {
                case "START": {
                    IMV.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    IMV iMV = IMV.getInstance((Context)this);
                    if (!GTE.isConnected(iMV.KEM)) break;
                    if (IMV.MRR != null && (IMV.MRR.isConnecting() || IMV.MRR.isConnected())) {
                        IMV.MRR.disconnectExistingClient();
                    }
                    new IMV.NZV(iMV).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    IMV iMV = IMV.getInstance((Context)this);
                    if (!IMV.MRR.isConnected()) break;
                    new IMV.HUI(iMV).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "RECONNECT": {
                    IMV.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    IMV.getInstance((Context)this).cancelReconnect();
                    IMV.getInstance((Context)this).HUI();
                    if (IMV.MRR == null) break;
                    IMV.MRR.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    IMV.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    new StringBuilder("Unrecognized action ").append(intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            return 1;
        }
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        new StringBuilder("PushService removed: ").append(rootIntent.getAction()).append(rootIntent);
        IMV.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        IMV.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        IMV.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

