/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.adpdigital.push.AOP;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.AppState;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.CVA;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokEvent;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.DYH;
import com.adpdigital.push.EIW;
import com.adpdigital.push.ELX;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GKV;
import com.adpdigital.push.GMT;
import com.adpdigital.push.GTE;
import com.adpdigital.push.GcmMessageHandler;
import com.adpdigital.push.HUI;
import com.adpdigital.push.HWU;
import com.adpdigital.push.HXH;
import com.adpdigital.push.IMV;
import com.adpdigital.push.IRK;
import com.adpdigital.push.IXL;
import com.adpdigital.push.IZX;
import com.adpdigital.push.JAZ;
import com.adpdigital.push.JMY;
import com.adpdigital.push.JZR;
import com.adpdigital.push.KEM;
import com.adpdigital.push.KTB;
import com.adpdigital.push.LMH;
import com.adpdigital.push.LOX;
import com.adpdigital.push.MRR;
import com.adpdigital.push.NZV;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.ODB;
import com.adpdigital.push.OJW;
import com.adpdigital.push.OLN;
import com.adpdigital.push.OnDeeplinkResponseListener;
import com.adpdigital.push.PWW;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.QHG;
import com.adpdigital.push.QHM;
import com.adpdigital.push.RFF;
import com.adpdigital.push.RGI;
import com.adpdigital.push.RPN;
import com.adpdigital.push.SUU;
import com.adpdigital.push.TUY;
import com.adpdigital.push.UFF;
import com.adpdigital.push.UIR;
import com.adpdigital.push.VIN;
import com.adpdigital.push.VLN;
import com.adpdigital.push.VMB;
import com.adpdigital.push.WFM;
import com.adpdigital.push.WGR;
import com.adpdigital.push.XXU;
import com.adpdigital.push.YCE;
import com.adpdigital.push.ZTV;
import com.adpdigital.push.ZWK;
import com.adpdigital.push.service.RegistrationIntentService;
import com.google.android.gms.common.GoogleApiAvailability;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static final String SDK_VERSION = "2.17.1";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final String USE_BADGE_COUNT = "com.adpdigital.push.client.BadgeCount";
    public static final String ADVERTISING_ID_ENABLED = "com.adpdigital.push.client.ADVERTISING_ID_ENABLED";
    public static final String SHOW_ONLY_CHABOK_NOTIFICATIONS = "com.adpdigital.push.client.SHOW_ONLY_CHABOK_NOTIFICATIONS";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    public static final String PURCHASE_EVENT_NAME = "purchase";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int failed_tries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private MRR.UFF adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long lastLaunchTime;
    private long installDate;
    private boolean isLaunched = false;
    private XTU.OJW eventBus = XTU.OJW.getDefault();
    private Context context;
    private Class activityClass;
    private Activity currentActivity;
    private ChabokNotificationAction lastNotificationAction;
    private OnDeeplinkResponseListener onDeeplinkResponseListener;
    private String defaultTracker;
    private String userId;
    private String senderId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private ZTV communicateFallbackMachine = ZTV.getInstance();
    private static final String GUEST_TAG = "CHABOK_GUEST";

    private AdpPushClient(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        Log.i((String)TAG, (String)"Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate(context, handlerActivity, appId, apiKey, username, password);
        this.eventBus.register(this);
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        if (this.shouldBeSticky() && this.hasProtectedAppSupport()) {
            this.eventBus.post((Object)AppState.PROTECTED_GRANT_NEEDED);
        }
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new NZV(this));
        try {
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new UFF(this));
        }
        catch (Exception exception) {}
        this.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdpPushClient init(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            if (pushClientInstance != null) return pushClientInstance;
            packageName = context.getPackageName();
            pushClientInstance = new AdpPushClient(context, handlerActivity, appId, apiKey, username, password);
            XTU.OJW.getDefault().post((Object)AppState.INITIALIZED);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to call AdpPushClient.init in your Application class onCreate(). Please see https://goo.gl/8vnu2k");
        }
        return pushClientInstance;
    }

    static boolean hasNotified(String id) {
        return notifs.contains(id);
    }

    private void initializeAdapter() {
        String restApi = "http://" + ODB.NZV + ":80/api/";
        String currentHost = ODB.NZV;
        String currentPortBroker = ":1880";
        this.useDev = this.getSharedPreferences().getBoolean("useDev", true);
        if (this.useSecure) {
            String appSubDomain = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                appSubDomain = this.appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + ODB.NZV + ":443/api/";
            currentHost = appSubDomain + ODB.NZV;
            currentPortBroker = ":4443";
        }
        if (this.useDev) {
            restApi = "http://sandbox.push.adpdigital.com:80/api/";
            currentHost = "sandbox.push.adpdigital.com";
            currentPortBroker = ":1880";
        }
        if (this.useDev && this.useSecure) {
            restApi = "https://sandbox.push.adpdigital.com:443/api/";
            currentHost = "sandbox.push.adpdigital.com";
            currentPortBroker = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", currentHost).putString("port", currentPortBroker).putBoolean("useSecure", this.useSecure).apply();
        this.adapter = new MRR.UFF(this.getApplicationContext(), restApi);
        this.adapter.setAccessToken(this.apiKey);
    }

    private void validateAndPopulate(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        Set cache;
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, PushClient needs your application context");
        }
        this.context = context;
        if (handlerActivity == null) {
            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
        }
        this.activityClass = handlerActivity;
        this.getSharedPreferences().edit().putString(ACTIVITY_KEY, this.getActivityClass().getName()).apply();
        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        this.getSharedPreferences().edit().putString("username", this.encrypt(username)).apply();
        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        this.getSharedPreferences().edit().putString("password", this.encrypt(password)).apply();
        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String[] tokens = appId.split("/");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Application ID should be in `app-name/number` format");
        }
        this.appId = tokens[0];
        this.apiKey = apiKey;
        this.senderId = tokens[1];
        this.getSharedPreferences().edit().putString("applicationId", this.encrypt(this.appId)).apply();
        this.getSharedPreferences().edit().putString("senderId", this.encrypt(this.senderId)).apply();
        Set storedChannels = this.getSharedPreferences().getStringSet("topics", new HashSet<String>(Arrays.asList(this.channels)));
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);
        String storedNotifSettings = this.getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                this.notificationSettings = new JSONObject(storedNotifSettings);
            }
            catch (JSONException jSONException) {
                jSONException.getMessage();
            }
        }
        if ((cache = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            notifs.addAll(cache);
        }
        this.isNewInstall = !this.getSharedPreferences().getBoolean("chabokInstallation", false);
        this.installDate = this.getSharedPreferences().getLong("installDate", -1L);
        if (this.installDate == -1L) {
            long unixTime = System.currentTimeMillis();
            this.getSharedPreferences().edit().putLong("installDate", unixTime).apply();
            this.installDate = unixTime;
        }
    }

    private void resetBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        alarm.cancel(this.getBackgroundIntent());
    }

    private void startBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        PendingIntent backgroundIntent = this.getBackgroundIntent();
        if (Build.VERSION.SDK_INT < 19) {
            alarm.set(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
            return;
        }
        alarm.setExact(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
    }

    private PendingIntent getBackgroundIntent() {
        Intent background = new Intent();
        background.setClass(this.getApplicationContext(), PushService.class);
        background.setAction("BackgroundTimeExceeded");
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)background, (int)0);
    }

    public void onEvent(PWW gcmMessage) {
        Log.w((String)TAG, (String)("New GCM message (foreground:" + this.isForeground() + "): " + gcmMessage.getIntent().getExtras()));
        if (this.isForeground()) {
            Log.w((String)TAG, (String)"How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient that = this;
        this.isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"), new VIN(this, that, gcmMessage));
    }

    public void publish(PushMessage message, Callback clbk) {
        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            return;
        }
        IMV.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    public void publish(String channel, String text, Callback clbk) {
        if (channel.contains("/")) {
            clbk.onFailure(new Throwable("Channel should not contain slashes"));
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        IMV.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    public void publish(String user, String channel, String text, Callback clbk) {
        if (channel.contains("/") || user.contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        message.setUser(user);
        IMV.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    void publishMessageEvent(String subject, String messageId) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            this.emit(HWU.event, subject, messageId, obj, true, false);
            return;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Couldnt publish message event " + messageId), (Throwable)e);
            return;
        }
    }

    public void publishEvent(String event, JSONObject data) {
        this.publishEvent(event, data, true, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live) {
        this.publishEvent(event, data, live, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live, boolean stateful) {
        JSONObject eventData = new JSONObject();
        try {
            boolean isMatchFeedback;
            boolean bl = isMatchFeedback = event.contentEquals("matchUserFeedback") && (AdpPushClient.get().getAppId().contentEquals("90-dev") || AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                data.put("id", (Object)UUID.randomUUID().toString());
                data.put("createdAt", System.currentTimeMillis());
                eventData = data;
            } else {
                eventData.put("id", (Object)UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                if (data != null) {
                    eventData.put("data", (Object)data);
                }
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = eventData;
            this.eventBus.register(new GMT(this, event, finalEventData, live, stateful));
            return;
        }
        this.emit(HWU.event, event, this.getInstallationId(), eventData, live, stateful);
    }

    public void publishBackground(String event, JSONObject data) {
        if (event == null || event.isEmpty()) {
            throw new IllegalArgumentException("eventName parameter is null. Please, provide an eventName");
        }
        if (data == null) {
            throw new IllegalArgumentException("data parameter is null. Please, provide a data");
        }
        JSONObject json = new JSONObject();
        JSONObject eventData = new JSONObject();
        try {
            if (event.equals("geo")) {
                eventData = data;
            } else {
                eventData.put("data", (Object)data);
            }
            eventData.put("eventName", (Object)event);
            eventData.put("id", (Object)UUID.randomUUID().toString());
            eventData.put("createdAt", System.currentTimeMillis());
            json.put("type", 3);
            json.put("data", (Object)eventData);
            UIR communicateEvent = new UIR(json, XXU.PublishInBackground);
            this.eventBus.post(communicateEvent);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private void emit(HWU type, String event, String subject, JSONObject data, boolean live, boolean stateful) {
        String string;
        String payload;
        String dataStr = "";
        if (data != null) {
            dataStr = data.toString();
            new StringBuilder("emit: data: ").append(dataStr).append(" , subject: ").append(subject);
        }
        String string2 = payload = dataStr;
        String string3 = subject;
        String string4 = event;
        HWU hWU = type;
        IMV iMV = IMV.getInstance(this.getApplicationContext());
        switch (hWU) {
            case event: {
                string = iMV.NZV(string4, string3);
                break;
            }
            case track: {
                String string5 = string3;
                String string6 = string4;
                IMV iMV2 = iMV;
                string = "app/" + iMV2.XTU + "/track/" + string6 + "/" + string5;
                break;
            }
            default: {
                string = iMV.NZV(string4, string3);
            }
        }
        iMV.MRR(string, string2, live, stateful, new RFF(iMV));
    }

    private void isReceivedMessage(String messageId, Callback clbk) {
        IMV.getInstance(this.getApplicationContext());
        clbk.onSuccess(IMV.NZV(messageId));
    }

    public void getStatus(Callback<ConnectionStatus> clbk) {
        if (!PushService.isRunning(this.getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        clbk.onSuccess(IMV.getInstance(this.getApplicationContext()).getStatus());
    }

    public void subscribe(String channel, Callback clbk) {
        this.subscribe(channel, false, clbk);
    }

    public void subscribe(String channel, boolean live, Callback clbk) {
        if (!live) {
            HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
            allChannels.add(this.convertChannelName2OldConvention(channel));
            this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
            this.channels = allChannels.toArray(new String[allChannels.size()]);
            this.updateInstallation(new HashMap<String, Object>());
            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                RegistrationIntentService.subscribe(channel, this.getApplicationContext());
            }
        }
        if (Build.VERSION.SDK_INT >= 24 && !this.hasNotificationChannel(channel)) {
            String channelName = GcmMessageHandler.NZV(channel);
            this.createNotificationChannel(channel, channelName, 3);
        }
        IMV.getInstance(this.getApplicationContext()).NZV(channel, live, clbk);
    }

    private String convertChannelName2OldConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        if (channel.startsWith("public/")) {
            return channel;
        }
        return "public/" + channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String channel, Callback clbk) {
        HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
        allChannels.remove(this.convertChannelName2OldConvention(channel));
        this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
        this.channels = allChannels.toArray(new String[allChannels.size()]);
        this.updateInstallation(new HashMap<String, Object>());
        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            RegistrationIntentService.unsubscribe(channel, this.getApplicationContext());
        }
        if (this.hasNotificationChannel(channel)) {
            this.deleteNotificationChannel(channel);
        }
        Callback callback = clbk;
        String string = channel;
        IMV iMV = IMV.getInstance(this.getApplicationContext());
        Class<IMV> clazz = IMV.class;
        synchronized (IMV.class) {
            if (!iMV.isConnected()) {
                callback.onFailure(new Exception("Not Connected"));
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            String string2 = iMV.MRR(string);
            new ZWK(iMV, string2, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        this.notificationSettings.remove(topicName);
        try {
            topicSetting.put("sound", (Object)sound);
            topicSetting.put("alert", alert);
            this.notificationSettings.put(topicName, (Object)topicSetting);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            HashMap<String, Object> props = new HashMap<String, Object>();
            HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
            if (notifSettings != null) {
                props.put("notificationSettings", notifSettings);
            }
            this.updateInstallation(props);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.getMessage();
            return;
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            this.eventBus.register(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            this.eventBus.post(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            this.eventBus.unregister(object);
        }
        return this;
    }

    public AdpPushClient setPushListener(Object ctx) {
        return this.addListener(ctx);
    }

    public AdpPushClient removePushListener(Object activity) {
        return this.removeListener(activity);
    }

    public AdpPushClient register(String userId) {
        return this.register(userId, new String[0]);
    }

    public AdpPushClient register(String userId, String[] channels) {
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId);
        }
        if (!this.isValid(userId)) {
            throw new IllegalArgumentException("User ID is not valid: " + userId);
        }
        if (userId != this.getGuestUserId()) {
            this.setGuestUserId(null);
        }
        return this._register(userId, channels);
    }

    public AdpPushClient registerAsGuest() {
        String userId = this.getGuestUserId();
        if (userId == null) {
            userId = UUID.randomUUID().toString().replace("-", "");
            this.setGuestUserId(userId);
        }
        return this._register(userId, new String[0]);
    }

    private AdpPushClient reRegister(String userId) {
        return this.reRegister(userId, new String[0]);
    }

    private AdpPushClient reRegister(String userId, String[] channels) {
        this.getSharedPreferences().edit().putString("reregisteredFrom", this.encrypt(this.userId)).apply();
        this.unregister(true);
        this._register(userId, channels);
        return this;
    }

    private AdpPushClient _register(String userId, String[] channels) {
        String currentUserId;
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId);
        }
        if (!this.isValid(userId)) {
            throw new IllegalArgumentException("User ID is not valid: " + userId);
        }
        if (this.registering) {
            Log.w((String)TAG, (String)"Already in registering...");
            return this;
        }
        if (this.hasNotificationChannel(this.getInstallationId())) {
            this.deleteNotificationChannel(this.getInstallationId());
        }
        if ((currentUserId = this.getUserId()) != null && !userId.equalsIgnoreCase(currentUserId)) {
            return this.reRegister(userId, channels);
        }
        this.registeredOnce = false;
        this.userId = userId;
        this.getSharedPreferences().edit().putString("userId", this.encrypt(this.userId)).apply();
        HashSet<String> allTopics = new HashSet<String>(Arrays.asList(this.channels));
        ArrayList<String> newChannels = new ArrayList<String>();
        boolean userHasNewTopic = false;
        String[] stringArray = channels;
        int n = channels.length;
        for (int i = 0; i < n; ++i) {
            String ch = stringArray[i];
            String chName = this.convertChannelName2OldConvention(ch);
            newChannels.add(chName);
            if (allTopics.contains(chName)) continue;
            userHasNewTopic = true;
        }
        allTopics.addAll(newChannels);
        if (userHasNewTopic) {
            this.makeSubsDirty();
        }
        this.getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
        this.channels = allTopics.toArray(new String[allTopics.size()]);
        failed_tries = 0;
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        this.getApplicationInstallReferrer();
        this.doRegister();
        return this;
    }

    private boolean isValid(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (userId.length() < 3 || userId.length() > 64) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !userId.matches(REGEX);
    }

    private void doRegister() {
        this.doRegister(false);
    }

    private void doRegister(boolean restartService) {
        if (this.userId == null) {
            Log.e((String)TAG, (String)"userId not initialized yet");
            return;
        }
        if (this.registering) {
            new StringBuilder("Register already in progress for ").append(this.userId);
            return;
        }
        this.registering = true;
        this.eventBus.post((Object)AppState.REGISTERING);
        this.initializeAdapter();
        worker.schedule(new WFM(this, restartService), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        return this.adapter != null && this.adapter.isConnected();
    }

    public void dismiss() {
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
        if (resultCode != 0 && resultCode != 2) {
            if (apiAvailability.isUserResolvableError(resultCode) && this.currentActivity != null) {
                apiAvailability.getErrorDialog(this.currentActivity, resultCode, 9000).show();
            }
            Log.i((String)TAG, (String)"This device is not supported.");
            return false;
        }
        return true;
    }

    private AdpPushClient updateRegistration(boolean restartService) {
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.restartServiceState = restartService;
        this.registerInBackground(installation);
        return this;
    }

    private void fetchAndSetAdId(MRR.NZV installation) {
        if (this.isAdvertisingIdEnabled() && Boolean.valueOf(this.checkPlayServices()).booleanValue()) {
            new StringBuilder("\n\n ==================================== \n\nStart getting AdvertisingId at ").append(System.currentTimeMillis()).append("\n\n ==================================== \n\n");
            try {
                String adId = this.getPlayAdId(this.context);
                if (adId != null) {
                    installation.setAdId(adId);
                }
                Boolean trackingEnabled = this.isPlayTrackingEnabled(this.context);
                installation.setAdIdEnabled(trackingEnabled);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Exception happen for get advertisingId doInBackground: -----> ", (Throwable)ex);
                ex.printStackTrace();
            }
            new StringBuilder("\n\n ==================================== \n\nGet AdvertisingId = ").append(installation.getAdId()).append(" at ").append(System.currentTimeMillis()).append("\n\n ==================================== \n\n");
        }
    }

    private void registerInBackground(MRR.NZV installation) {
        installation.setDeviceToken("---");
        this.fetchAndSetAdId(installation);
        this.getApplicationContext().startService(new Intent(this.getApplicationContext(), RegistrationIntentService.class));
    }

    public void onEvent(EIW token) {
        MRR.NZV installation = this.getLocalInstallation();
        new ELX(this, installation, token).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private void saveInstallation(MRR.NZV installation, boolean restartService) {
        String isReregistered;
        HashMap<String, HashMap> notifSettings;
        JSONArray cachedData;
        String installReferrer;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("launchCount", this.getAppLaunchCount());
        props.put("launchTime", this.getAppLaunchTime());
        if (this.getLastAppLaunchTime() > 0L) {
            props.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if (this.hasInstallReferrerData() && (installReferrer = this.getInstallReferrer()) != null) {
            props.put("referrer", installReferrer);
            props.put("refClickTs", this.getInstallReferrerClickTs());
            props.put("refBeginTs", this.getInstallReferrerInstallBeginTs());
        }
        if (this.getRawInstallReferrer() != null) {
            props.put("rawReferrer", this.getRawInstallReferrer());
            props.put("rawRefClickTs", this.getRawInstallReferrerClickTs());
        }
        if (this.defaultTracker != null && !this.defaultTracker.trim().isEmpty()) {
            props.put("defaultTracker", this.defaultTracker);
        }
        if ((cachedData = this.communicateFallbackMachine.getReadyToSendEventData()) != null) {
            props.put("eventData", cachedData);
        }
        props.put("deviceId", this.getDeviceId());
        String uniqueId = this.getUniqueID();
        if (uniqueId != null && uniqueId.trim() != "") {
            props.put("uniqueId", uniqueId);
        }
        if (!Boolean.valueOf(this.checkPlayServices()).booleanValue()) {
            props.put("gpsVersionFound", -1);
        } else {
            try {
                if (this.context != null && this.context.getPackageManager() != null) {
                    int installedPlayServices = this.context.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode;
                    props.put("gpsVersionFound", installedPlayServices);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int appRequiredPlayServices = GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        props.put("gpsVersionRequired", appRequiredPlayServices);
        props.put("connection", GTE.getNetworkClass(this.getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("osBuild", Build.ID);
        props.put("locale", Locale.getDefault());
        props.put("clientVersion", this.getClientVersion());
        props.put("launched", this.isLaunched);
        props.put("newInstall", this.isNewInstall);
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            props.put("userInfo", this.userInfo);
        }
        if ((notifSettings = this.getNotificationSettings()) != null) {
            props.put("notificationSettings", notifSettings);
        }
        props.put("installSource", this.getInstallSource());
        props.put("installDate", this.installDate);
        String screenRes = this.getDeviceScreenResolution();
        if (screenRes != null) {
            props.put("screenResolution", screenRes);
        }
        if ((isReregistered = this.getReregisteredFrom()) != null) {
            props.put("reregisteredFrom", isReregistered);
        }
        if (this.context != null && this.context.getPackageName() != null) {
            props.put("appBundleId", this.context.getPackageName());
        }
        try {
            if (NotificationManagerCompat.from((Context)this.context).areNotificationsEnabled()) {
                props.put("tokenStatus", "ALLOWED");
            } else {
                props.put("tokenStatus", "DENIED");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        props.put("isProduction", true);
        new QHG(this, installation, props, restartService).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private OJW.YCE beforeSend() {
        return new WGR(this);
    }

    private String getPlayAdId(Context context) {
        String playAdId = null;
        for (int i = 0; i < 3; ++i) {
            try {
                playAdId = OLN.getGooglePlayServicesInfo(context).getGpsAdid();
                if (playAdId != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((playAdId = GKV.NZV(context)) != null) break;
        }
        return playAdId;
    }

    private boolean isPlayTrackingEnabled(Context context) {
        Boolean isTrackingEnabled = null;
        for (int i = 0; i < 3; ++i) {
            try {
                isTrackingEnabled = OLN.getGooglePlayServicesInfo(context).isTrackingEnabled();
                if (isTrackingEnabled != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((isTrackingEnabled = GKV.MRR(context)) != null) break;
        }
        if (isTrackingEnabled == null) {
            return false;
        }
        return isTrackingEnabled;
    }

    private String getInstallSource() {
        try {
            if (this.context != null && this.context.getPackageManager() != null) {
                String installationSource;
                PackageManager pm = this.context.getPackageManager();
                if (this.context.getPackageName() != null && (installationSource = pm.getInstallerPackageName(this.context.getPackageName())) != null) {
                    return installationSource;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "notSet";
    }

    @Nullable
    private String getDeviceScreenResolution() {
        if (this.currentActivity == null) {
            return null;
        }
        Display display = this.currentActivity.getWindowManager().getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {}
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception exception) {}
        }
        return mWidthPixels + "x" + mHeightPixels;
    }

    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            HashMap<String, HashMap> notifSettings = new HashMap<String, HashMap>();
            Iterator channelSettings = this.notificationSettings.keys();
            while (channelSettings.hasNext()) {
                String topic = (String)channelSettings.next();
                JSONObject channelSetting = this.notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<String, String>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(topic, setting);
            }
            return notifSettings;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++failed_tries <= 10) {
            JAZ retryTask = new JAZ(this);
            long nextTry = (long)Math.max(Math.pow(2.0, failed_tries), 32.0);
            worker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    @Deprecated
    private String getDeviceId() {
        return Build.SERIAL;
    }

    private String getUniqueID() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    public String getClientVersion() {
        String userClientVersion = this.decrypt(this.getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                userClientVersion = this.getApplicationContext().getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return userClientVersion;
    }

    public void setClientVersion(String version) {
        this.getSharedPreferences().edit().putString("clientVersion", this.encrypt(version)).apply();
    }

    public void incBadge() {
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        int currentBadge = this.getSharedPreferences().getInt("androidBadge", 0);
        this.setBadge(++currentBadge);
    }

    boolean isBadgeEnabled() {
        try {
            if (this.context != null) {
                String badgeStatus;
                Bundle bundle = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
                if (bundle != null && (badgeStatus = bundle.getString(USE_BADGE_COUNT)) != null && badgeStatus.toLowerCase().equals("disable")) {
                    return false;
                }
                if (!ShortcutBadger.isBadgeCounterSupported((Context)this.context)) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"isBadgeEnabled: NameNotFoundException -->", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"isBadgeEnabled: NullPointerException -->", (Throwable)e);
        }
        return true;
    }

    boolean preventShowNonChabokNotifications() {
        try {
            String showOnlyChabokNotif;
            Bundle bundle;
            if (this.context != null && (bundle = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData) != null && (showOnlyChabokNotif = bundle.getString(SHOW_ONLY_CHABOK_NOTIFICATIONS)) != null && showOnlyChabokNotif.toLowerCase().equals("enable")) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"isBadgeEnabled: NameNotFoundException -->", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"isBadgeEnabled: NullPointerException -->", (Throwable)e);
        }
        return false;
    }

    boolean isAdvertisingIdEnabled() {
        try {
            String advertisingIdStatus;
            Bundle bundle;
            if (this.context != null && (bundle = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData) != null && (advertisingIdStatus = bundle.getString(ADVERTISING_ID_ENABLED)) != null && advertisingIdStatus.toLowerCase().equals("disable")) {
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"isAdvertisingIdEnabled: NameNotFoundException -->", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"isAdvertisingIdEnabled: NullPointerException -->", (Throwable)e);
        }
        return true;
    }

    private void updateLaunchStats() {
        this.lastLaunchTime = this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, -1L);
        int count = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++count).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
        this.isLaunched = true;
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public long getLastAppLaunchTime() {
        return this.lastLaunchTime;
    }

    public String getReregisteredFrom() {
        String reregisteredFrom = this.decrypt(this.getSharedPreferences().getString("reregisteredFrom", null));
        this.getSharedPreferences().edit().remove("reregisteredFrom").apply();
        return reregisteredFrom;
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    AdpPushClient setBadge(int badgeNumber) {
        this.getSharedPreferences().edit().putInt("androidBadge", badgeNumber).apply();
        this.eventBus.post(new BadgeUpdate(badgeNumber));
        if (this.isBadgeEnabled()) {
            ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)badgeNumber);
        }
        return this;
    }

    public AdpPushClient resetBadge() {
        ((NotificationManager)this.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return this.setBadge(0);
    }

    public void unregister() {
        this.unregister(false);
    }

    private void unregister(boolean isReregister) {
        PushService.performAction(this.getApplicationContext(), "DISCONNECT");
        if (!isReregister) {
            this.deleteInstallation(new MRR(this));
        }
        this.getSharedPreferences().edit().remove("userId").apply();
        this.getSharedPreferences().edit().remove("CHK_GUI").apply();
        this.getSharedPreferences().edit().remove("installationId").apply();
        this.getSharedPreferences().edit().remove("topics").apply();
        this.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        this.getSharedPreferences().edit().remove("offlineCache").apply();
        this.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        this.getSharedPreferences().edit().remove("dataCache").apply();
        this.channels = new String[]{"default"};
    }

    public String getInstallationId() {
        String idJson = this.decrypt(this.getSharedPreferences().getString("installationId", null));
        if (idJson != null) {
            try {
                return (String)new JSONArray(idJson).get(0);
            }
            catch (JSONException jSONException) {
                new StringBuilder("Cannot parse installation id '").append(idJson).append("'");
            }
        }
        return null;
    }

    private void deleteInstallation(Callback clbk) {
        MRR.NZV installation;
        MRR.HXH<MRR.DYH> repository = this.adapter.createRepository("installation");
        MRR.DYH model = repository.createModel(HUI.NZV.getProperties(installation = new MRR.NZV(this.getApplicationContext(), this.adapter), false, false));
        if (model.getId() == null) {
            return;
        }
        model.destroy(new OJW(this, clbk, installation));
    }

    private void updateInstallation(Map<String, Object> properties) {
        this.updateInstallation(properties, new HUI(this));
    }

    private void updateInstallation(Map<String, Object> properties, Callback<MRR.NZV> clbk) {
        JSONArray cachedData;
        String uniqueId;
        this.eventBus.post((Object)XXU.UpdatingInstallation);
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        properties.put("launched", this.isLaunched);
        properties.put("newInstall", this.isNewInstall);
        properties.put("launchTime", this.getAppLaunchTime());
        if (this.getLastAppLaunchTime() > 0L) {
            properties.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if ((uniqueId = this.getUniqueID()) != null && !uniqueId.isEmpty()) {
            properties.put("uniqueId", this.getUniqueID());
        }
        if ((cachedData = this.communicateFallbackMachine.getReadyToSendEventData()) != null) {
            properties.put("eventData", cachedData);
        }
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            properties.put("userInfo", this.userInfo);
        }
        this.updateInstallation(installation, properties, clbk);
    }

    private MRR.NZV getLocalInstallation() {
        MRR.NZV installation = new MRR.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        return installation;
    }

    private void updateInstallation(MRR.NZV installation, Map<String, ?> properties, Callback<MRR.NZV> clbk) {
        MRR.DYH model = this.adapter.createRepository("installation").createModel(HUI.NZV.getProperties(installation, false, false));
        model.putAll(properties);
        new YCE(this, model, clbk, installation).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    public void requestVerificationCode(String userId, String media, Callback clbk) {
        MRR.HXH<MRR.DYH> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("appId", this.appId);
        map.put("media", media);
        repository.invokeStaticMethod("requestCode", map, new VMB(this, clbk));
    }

    private void requestCode(String userId, Callback clbk) {
        this.adapter.createRepository("verification").requestCode(userId, new AOP(this, clbk));
    }

    public void requestVerificationCode(String userId, Callback clbk) {
        this.requestCode(userId, clbk);
    }

    public void verifyUserCode(String userId, String code, Callback clbk) {
        MRR.HXH<MRR.DYH> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("code", code);
        repository.invokeStaticMethod("verifyCode", map, new DYH(this, clbk));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && this.getActivityClass().getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener listener) {
        this.getForegroundManager().addListener(listener);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return this.activityClass;
    }

    private Context getApplicationContext() {
        return this.context;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getUserId() {
        return this.decrypt(this.getSharedPreferences().getString("userId", null));
    }

    public void setAutoResetBadge(boolean autoResetBadge) {
        this.getSharedPreferences().edit().putBoolean("CHK_AUTO_RESET_BADGE", autoResetBadge).apply();
    }

    public boolean isAutoResetBadge() {
        return this.getSharedPreferences().getBoolean("CHK_AUTO_RESET_BADGE", true);
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                return this.getApplicationContext().getPackageManager().getApplicationInfo((String)packageInfo.packageName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        this.notificationIconSilhouette = notificationIconSilhouette;
    }

    private boolean isGuestUser() {
        return this.getGuestUserId() != null;
    }

    private void setGuestUserId(String guestUserId) {
        if (guestUserId == null) {
            this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            return;
        }
        this.getSharedPreferences().edit().putString("CHK_GUI", this.encrypt(guestUserId)).apply();
    }

    private String getGuestUserId() {
        String guestUserId = this.getSharedPreferences().getString("CHK_GUI", null);
        if (guestUserId != null) {
            return this.decrypt(guestUserId);
        }
        return null;
    }

    @Deprecated
    public HashMap<String, Object> getUserInfo() {
        return this.getUserAttributes();
    }

    public HashMap<String, Object> getUserAttributes() {
        try {
            return this.loadMap("CHK_USER_INFO");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public void setUserInfo(HashMap<String, Object> userInfo) {
        this.setUserAttributes(userInfo);
    }

    public void setUserAttributes(HashMap<String, Object> attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute parameter should has a value. To removing attribute data, provide an empty HashMap");
        }
        this.userInfo = attribute;
        try {
            JSONObject json = new JSONObject(this.userInfo);
            this.getSharedPreferences().edit().putString("CHK_USER_INFO", this.encrypt(json.toString())).apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isRegistered()) {
            this.getLocalInstallation().userInfo(this.getInstallationId(), this.userInfo, new KEM(this));
        }
    }

    public void incrementUserAttribute(String attributeName) {
        this.incrementUserAttribute(attributeName, 1.0);
    }

    public void incrementUserAttribute(String attributeName, double value) {
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null. Please provide an attributeName");
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put(attributeName, value);
        this.incrementUserAttribute(attributesArray);
    }

    public void incrementUserAttribute(ArrayList<String> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null. Please provide an attribute");
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        for (String attribute : attributes) {
            attributesArray.put(attribute, 1.0);
        }
        this.incrementUserAttribute(attributesArray);
    }

    public void incrementUserAttribute(HashMap<String, Double> attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes parameter is null. please, provide an attribute");
        }
        JSONArray attributesArray = new JSONArray();
        for (Map.Entry<String, Double> me : attributes.entrySet()) {
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", (Object)me.getKey());
                attribute.put("value", (Object)me.getValue());
                attributesArray.put((Object)attribute);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (this.isRegistered()) {
            this.getLocalInstallation().incrementAttribute(this.getInstallationId(), attributesArray, new IZX(this, attributes));
            return;
        }
        new StringBuilder("User not registered yet, try to increment attributes (").append(attributes.toString()).append(") after send successfully installation request");
        this.eventBus.register(new HXH(this, attributes));
    }

    private HashMap<String, Object> loadMap(String key) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            String jsonStringEnc = this.getSharedPreferences().getString(key, null);
            if (jsonStringEnc != null) {
                JSONObject jsonObject = new JSONObject(this.decrypt(jsonStringEnc));
                Iterator keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String k = (String)keysItr.next();
                    Object v = jsonObject.get(k);
                    outputMap.put(k, v);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return outputMap;
    }

    public void setDefaultTracker(String defaultTracker) {
        this.defaultTracker = defaultTracker;
    }

    public AdpPushClient setDevelopment(boolean isDev) {
        this.useDev = isDev;
        this.getSharedPreferences().edit().putBoolean("useDev", this.useDev).apply();
        this.initializeAdapter();
        return this;
    }

    public void setDefaultNotificationChannel(String channelName) {
        String defaultChannelId = "default";
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel(defaultChannelId, channelName, 4);
        }
    }

    void createNotificationChannel(String channelId, String channelName, int importanceLevel) {
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel defaultNotificationChannel = new NotificationChannel(channelId, (CharSequence)(channelName.substring(0, 1).toUpperCase() + channelName.substring(1)), importanceLevel);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(defaultNotificationChannel);
            }
        }
    }

    void deleteNotificationChannel(String channelId) {
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && notificationManager != null) {
            notificationManager.deleteNotificationChannel(channelId);
        }
    }

    boolean hasNotificationChannel(String channelId) {
        if (channelId == null) {
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && notificationManager != null) {
            return notificationManager.getNotificationChannel(channelId) != null;
        }
        return false;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    public void subscribeEvent(String eventName, Callback clbk) {
        this.subscribeEvent(eventName, "+", false, clbk);
    }

    public void subscribeEvent(String eventName, boolean live, Callback clbk) {
        this.subscribeEvent(eventName, "+", live, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, Callback clbk) {
        this.subscribeEvent(eventName, installationId, false, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, boolean live, Callback clbk) {
        IMV.getInstance(this.getApplicationContext()).NZV(eventName, installationId, live, clbk);
    }

    public void unsubscribeEvent(String eventName, Callback clbk) {
        this.unsubscribeEvent(eventName, "+", clbk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(String eventName, String installationId, Callback clbk) {
        Callback callback = clbk;
        String string = installationId;
        String string2 = eventName;
        IMV iMV = IMV.getInstance(this.getApplicationContext());
        Class<IMV> clazz = IMV.class;
        synchronized (IMV.class) {
            if (!iMV.isConnected()) {
                callback.onFailure(new Exception("Not Connected"));
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return;
            }
            String string3 = iMV.NZV(string2, string);
            new TUY(iMV, string3, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public void track(String eventName, JSONObject data) {
        if (eventName == null) {
            throw new IllegalArgumentException("eventName is null, please provide an eventName.");
        }
        if (eventName.contentEquals("")) {
            throw new IllegalArgumentException("eventName is empty, please provide an eventName.");
        }
        JSONObject trackData = new JSONObject();
        try {
            JSONObject influenceData;
            trackData.put("id", (Object)UUID.randomUUID().toString());
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                trackData.put("data", (Object)data);
            }
            if ((influenceData = LOX.YCE()) != null) {
                if (LOX.VMB()) {
                    influenceData.put("direct", LOX.VMB());
                }
                trackData.put("influence", (Object)influenceData);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalTrackData = trackData;
            this.eventBus.register(new LMH(this, eventName, finalTrackData));
            return;
        }
        this.emit(HWU.track, eventName, this.getInstallationId(), trackData, true, false);
    }

    public void trackPurchase(String eventName, ChabokEvent chabokEvent) {
        if (eventName == null) {
            throw new IllegalArgumentException("eventName is null, please provide an eventName.");
        }
        if (eventName.contentEquals("")) {
            throw new IllegalArgumentException("eventName is empty, please provide an eventName.");
        }
        if (chabokEvent == null) {
            return;
        }
        if (chabokEvent.revenue >= 0.0) {
            JSONObject trackData = new JSONObject();
            try {
                trackData.put("id", (Object)UUID.randomUUID().toString());
                trackData.put("createdAt", System.currentTimeMillis());
                JSONObject influenceData = LOX.YCE();
                if (influenceData != null) {
                    if (LOX.VMB()) {
                        influenceData.put("direct", LOX.VMB());
                    }
                    trackData.put("influence", (Object)influenceData);
                }
                JSONObject data = new JSONObject();
                if (chabokEvent.data != null) {
                    data = chabokEvent.data;
                }
                data.put("isRevenue", true);
                data.put("value", (Object)chabokEvent.revenue);
                if (chabokEvent.currency != null) {
                    data.put("currency", (Object)chabokEvent.currency);
                }
                trackData.put("data", (Object)data);
                if (this.getInstallationId() == null) {
                    JSONObject finalTrackData = trackData;
                    this.eventBus.register(new SUU(this, eventName, finalTrackData));
                    return;
                }
                this.emit(HWU.track, eventName, this.getInstallationId(), trackData, true, false);
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    void publishClientEvents(String id, JSONArray data) {
        JSONObject trackData = new JSONObject();
        try {
            trackData.put("id", (Object)id);
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                trackData.put("eventData", (Object)data);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = trackData;
            this.eventBus.register(new QHM(this, finalEventData));
            return;
        }
        new StringBuilder("-- Publish cached data ").append(data);
        this.emit(HWU.event, "clientEvent", this.getInstallationId(), trackData, true, false);
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    private AdpPushClient setSecure(boolean isSecure) {
        this.useSecure = isSecure;
        this.initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        ArrayList<String> newChannels = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n = this.channels.length;
        for (int i = 0; i < n; ++i) {
            String ch = stringArray[i];
            String chName = this.convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }
        return newChannels.toArray(new String[newChannels.size()]);
    }

    private String convertChannelName2newConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel;
        }
        if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        return "private/" + channel;
    }

    SharedPreferences getSharedPreferences() {
        return this.getApplicationContext().getSharedPreferences(MRR.NZV.SHARED_PREFERENCES_NAME, 0);
    }

    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        this.currentActivity = currentActivity;
        return this;
    }

    void notifyNewMessage(PushMessage message) {
        Class clazz = this.activityClass;
        if (AdpPushClient.hasNotified(message.getId())) {
            return;
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification notif;
            Class theirs = h.getActivityClass(notif = new ChabokNotification(message, 0));
            if (theirs == null) continue;
            clazz = theirs;
        }
        Class finalClazz = clazz;
        PushMessage finalMessage = message;
        new VLN(this, finalClazz, finalMessage).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    boolean addNotifiedMessage(String id) {
        boolean val = notifs.add(id);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return val;
    }

    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        Class clazz = this.activityClass;
        String title = data.getString("title");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification gcmNotif;
            Class theirs = h.getActivityClass(gcmNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), Integer.valueOf(data.getString("androidBadge", "0")), data));
            if (theirs == null) continue;
            clazz = theirs;
        }
        return clazz;
    }

    boolean notificationOpened(Bundle data, ChabokNotificationAction notificationAction) {
        this.lastNotificationAction = notificationAction;
        String title = data.getString("title");
        boolean shouldLaunchActivity = true;
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification chabokNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), Integer.valueOf(data.getString("androidBadge", "0")), data);
            shouldLaunchActivity = h.notificationOpened(chabokNotif, notificationAction);
        }
        return shouldLaunchActivity;
    }

    public ChabokNotificationAction getLastNotificationAction() {
        return this.lastNotificationAction;
    }

    boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        boolean showNotification = true;
        for (NotificationHandler h : this.handlers) {
            showNotification &= h.buildNotification(notif, builder);
        }
        return showNotification;
    }

    public void addNotificationHandler(NotificationHandler handler) {
        this.handlers.add(handler);
    }

    void launchSingleTaskUri(String uri, String logMessage) {
        try {
            String url = uri;
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            Intent i = new Intent("android.intent.action.VIEW");
            i.addFlags(0x10020000);
            i.setData(Uri.parse((String)url));
            new StringBuilder().append(logMessage).append(" ").append(url);
            this.context.startActivity(i);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener deeplinkResponseListener) {
        this.onDeeplinkResponseListener = deeplinkResponseListener;
    }

    private void getDeferredDeepLink() {
        this.getLocalInstallation().deferredDeepLink(this.getInstallationId(), new IRK(this));
    }

    public void appWillOpenUrl(Uri url) {
        if (url == null || url.toString().trim().isEmpty()) {
            return;
        }
        long clickTime = System.currentTimeMillis();
        JSONObject json = new JSONObject();
        try {
            json.put("type", 0);
            json.put("deepLinkClickTs", clickTime);
            json.put("deepLinkUrl", (Object)url.toString());
            UIR communicateEvent = new UIR(json, XXU.GotDeepLink);
            this.eventBus.post(communicateEvent);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean hasProtectedAppSupport() {
        String deviceManufacturer = this.getDeviceManufacturer().toLowerCase();
        return !TextUtils.isEmpty((CharSequence)deviceManufacturer) && (deviceManufacturer.contains("huawei") || deviceManufacturer.contains("xiaomi"));
    }

    private String getDeviceManufacturer() {
        String deviceMan = Build.MANUFACTURER;
        Log.d((String)"deviceMan", (String)deviceMan);
        return deviceMan;
    }

    public void showProtectedAppSettings(Activity ctx, String app_name, String title, String msg) {
        title = title != null && !title.isEmpty() ? title : "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647";
        msg = msg != null && !msg.isEmpty() ? msg : String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", app_name);
        this.showGuide(ctx, title, msg);
    }

    private void showGuide(Activity ctx, String title, String message) {
        this.getApplicationContext();
        SharedPreferences settings = ctx.getSharedPreferences("ProtectedApps", 0);
        if (!settings.getBoolean("skipProtectedAppsMessage", false)) {
            SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                CheckBox dontShowAgain = new CheckBox(this.getApplicationContext());
                dontShowAgain.setTextColor(-16777216);
                dontShowAgain.setText((CharSequence)"     \u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                dontShowAgain.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new RGI(this, editor));
                new AlertDialog.Builder((Context)ctx).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setView((View)dontShowAgain).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new RPN(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            editor.putBoolean("skipProtectedAppsMessage", true);
            editor.apply();
        }
    }

    private boolean isCallable(Intent intent) {
        return this.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String getUserSerial() {
        Object userManager = this.getApplicationContext().getSystemService("user");
        if (userManager == null) {
            return "";
        }
        try {
            Object myUserHandle = Process.class.getMethod("myUserHandle", null).invoke(Process.class, null);
            Long userSerial = (Long)userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass()).invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    public String encrypt(String value) {
        try {
            byte[] bytes = value != null ? value.getBytes("UTF-8") : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)key, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(KTB.encode(pbeCipher.doFinal(bytes), 2), "UTF-8");
        }
        catch (Exception e) {
            this.getClass().getName();
            new StringBuilder("Warning, could not encrypt the value.  It may be stored in plaintext.  ").append(e.getMessage());
            return value;
        }
    }

    public String decrypt(String value) {
        if (value == null) {
            return value;
        }
        try {
            byte[] bytes = value != null ? KTB.decode(value, 0) : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)key, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(pbeCipher.doFinal(bytes), "UTF-8");
        }
        catch (Exception e) {
            this.getClass().getName();
            new StringBuilder("Warning, could not decrypt the value.  It may be stored in plaintext.  ").append(e.getMessage());
            return value;
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !this.isGCMSupported();
    }

    public boolean isGCMSupported() {
        return !this.getSharedPreferences().getBoolean("noGCM", false);
    }

    public void addTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "addTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        this.addTag(tagsName, callback);
    }

    public void addTag(String[] tagsName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] msg = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)msg[i])) continue;
            String msg2 = "addTags: tag is empty";
            Log.e((String)TAG, (String)msg2);
            callback.onFailure(new Throwable(msg2));
            return;
        }
        this.getLocalInstallation().addTag(tagsName, callback);
    }

    public void removeTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "removeTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        this.removeTag(tagsName, callback);
    }

    public void removeTag(String[] tagsName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] msg = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)msg[i])) continue;
            String msg2 = "removeTag: tag is empty";
            Log.e((String)TAG, (String)msg2);
            callback.onFailure(new Throwable(msg2));
            return;
        }
        this.getLocalInstallation().removeTag(tagsName, callback);
    }

    void sendEventData(JSONArray datas, Callback callback) {
        if (datas == null) {
            String msg = "Please provide a data parameter";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to send fallback event...";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        long ts = System.currentTimeMillis();
        String userId = AdpPushClient.get().getUserId();
        String installationId = AdpPushClient.get().getInstallationId();
        body.put("createdAt", ts);
        body.put("userId", userId);
        body.put("installationId", installationId);
        body.put("deviceType", "android");
        body.put("eventData", datas);
        try {
            Integer l = String.valueOf(HUI.MRR.toJson(body)).replaceAll("(\\\\.)", "/").length();
            String type = body.get("deviceType").toString();
            String manId = AdpPushClient.get().getManufacturerId(userId, installationId, type, ts, l);
            if (manId != null) {
                body.put("sessionId", manId);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getLocalInstallation().events(body, callback);
    }

    boolean hasInstallReferrerData() {
        return this.getSharedPreferences().contains("CHK_INSTALL_REFERRER") && this.getSharedPreferences().contains("CHK_INSTALL_REF_CLICK_TS") && this.getSharedPreferences().contains("CHK_INSTALL_REF_BEGIN_TS");
    }

    String getInstallReferrer() {
        String encryptInstallReferrer = this.getSharedPreferences().getString("CHK_INSTALL_REFERRER", null);
        if (encryptInstallReferrer == null) {
            return null;
        }
        return this.decrypt(encryptInstallReferrer);
    }

    long getInstallReferrerClickTs() {
        String encryptReferrerClickTimestampSeconds = this.getSharedPreferences().getString("CHK_INSTALL_REF_CLICK_TS", null);
        if (encryptReferrerClickTimestampSeconds == null) {
            return 0L;
        }
        return Long.valueOf(this.decrypt(encryptReferrerClickTimestampSeconds));
    }

    long getInstallReferrerInstallBeginTs() {
        String encryptInstallBeginTimestampSeconds = this.getSharedPreferences().getString("CHK_INSTALL_REF_BEGIN_TS", null);
        if (encryptInstallBeginTimestampSeconds == null) {
            return 0L;
        }
        return Long.valueOf(this.decrypt(encryptInstallBeginTimestampSeconds));
    }

    void getApplicationInstallReferrer() {
        new JZR(this.context, new CVA(this));
    }

    void sendInstallReferrer(String rawReferrer, Context context) {
        long clickTime = System.currentTimeMillis();
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        this.context = context;
        this.getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REFERRER", this.encrypt(rawReferrer)).apply();
        this.getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REF_CLICK_TS", this.encrypt(Long.toString(clickTime))).apply();
    }

    private String getRawInstallReferrer() {
        String encryptRawInstallReferrer = this.getSharedPreferences().getString("CHK_RAW_INSTALL_REFERRER", null);
        if (encryptRawInstallReferrer == null) {
            return encryptRawInstallReferrer;
        }
        return this.decrypt(encryptRawInstallReferrer);
    }

    private long getRawInstallReferrerClickTs() {
        String encryptRawInstallRefClickTs = this.getSharedPreferences().getString("CHK_RAW_INSTALL_REF_CLICK_TS", null);
        if (encryptRawInstallRefClickTs == null) {
            return 0L;
        }
        return Long.valueOf(this.decrypt(encryptRawInstallRefClickTs));
    }

    private Map<String, String> getRawInstallReferrerParams() {
        String referrer = this.getRawInstallReferrer();
        try {
            referrer = URLDecoder.decode(referrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
            new StringBuilder("Referrer decoding failed due to UnsupportedEncodingException. Message: (").append(e.getMessage()).append(")");
        }
        catch (IllegalArgumentException e) {
            referrer = "malformed";
            new StringBuilder("Referrer decoding failed due to IllegalArgumentException. Message: (").append(e.getMessage()).append(")");
        }
        catch (Exception e) {
            referrer = "malformed";
            new StringBuilder("Referrer decoding failed. Message: (").append(e.getMessage()).append(")");
        }
        new StringBuilder("Referrer to parse (").append(referrer).append(")");
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        for (UrlQuerySanitizer.ParameterValuePair params : querySanitizer.getParameterList()) {
            extraParameters.put(params.mParameter, params.mValue);
        }
        return extraParameters;
    }

    String getManufacturerId(String userId, String uid, String type, long launchTs, Integer len) {
        try {
            String string;
            int n;
            Object object;
            Object[] objectArray;
            int n2;
            long l;
            block8: {
                new JMY();
                String string2 = type;
                int n3 = 2;
                if (string2.length() > 2) {
                    n3 = string2.charAt(2);
                }
                l = Long.parseLong(Long.toString(launchTs));
                n2 = n3;
                objectArray = Long.toString(l);
                object = objectArray.toCharArray();
                for (int i = ((char[])object).length - 1; i >= 0; --i) {
                    if (Character.toString(object[i]).contains("0")) continue;
                    n = Integer.parseInt(Character.toString(object[i]));
                    break block8;
                }
                n = 9;
            }
            int n4 = n2 % n;
            int n5 = Integer.parseInt(Character.toString(objectArray.charAt(objectArray.length() - 3)));
            char[] cArray = Long.valueOf(l).toString().toCharArray();
            long[] lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = Character.getNumericValue(cArray[i]);
            }
            long[] lArray2 = lArray;
            List<Long> list = JMY.NZV(Arrays.copyOfRange(lArray, 0, n5));
            List<Long> list2 = JMY.NZV(Arrays.copyOfRange(lArray2, n5, objectArray.length()));
            list.add(Long.valueOf(n4));
            list.addAll(list2);
            List<Long> list3 = list;
            object = new StringBuilder();
            for (long l2 : list3) {
                ((StringBuilder)object).append(Long.toString(l2));
            }
            String sugar = ((StringBuilder)object).toString();
            sugar = new StringBuilder(sugar).insert(sugar.length() / 2, len).toString();
            String string3 = Long.toString(launchTs);
            String string4 = uid;
            String string5 = userId;
            if (string5 == null || string4 == null || string3 == null) {
                string = "";
            } else {
                objectArray = new String[]{string5, string4, string3};
                string = TextUtils.join((CharSequence)JMY.NZV(), (Object[])objectArray);
            }
            String ManufacturerId = string;
            return JMY.NZV(ManufacturerId + sugar);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ boolean access$000(AdpPushClient x0) {
        return x0.isFreshStart;
    }

    static /* synthetic */ void access$100(AdpPushClient x0) {
        x0.updateLaunchStats();
    }

    static /* synthetic */ XTU.OJW access$200(AdpPushClient x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$300(AdpPushClient x0) {
        return x0.isNewInstall;
    }

    static /* synthetic */ void access$400(AdpPushClient x0) {
        x0.doRegister();
    }

    static /* synthetic */ boolean access$002(AdpPushClient x0, boolean x1) {
        x0.isFreshStart = x1;
        return x0.isFreshStart;
    }

    static /* synthetic */ Context access$500(AdpPushClient x0) {
        return x0.getApplicationContext();
    }

    static /* synthetic */ void access$600(AdpPushClient x0) {
        x0.resetBackgroundTimer();
    }

    static /* synthetic */ void access$700(AdpPushClient x0) {
        x0.startBackgroundTimer();
    }

    static /* synthetic */ Activity access$802(AdpPushClient x0, Activity x1) {
        x0.currentActivity = x1;
        return x0.currentActivity;
    }

    static /* synthetic */ void access$900(AdpPushClient x0, HWU x1, String x2, String x3, JSONObject x4, boolean x5, boolean x6) {
        x0.emit(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ boolean access$1000(AdpPushClient x0) {
        return x0.registeredOnce;
    }

    static /* synthetic */ boolean access$1102(AdpPushClient x0, boolean x1) {
        x0.registering = x1;
        return x0.registering;
    }

    static /* synthetic */ ForegroundManager access$1200(AdpPushClient x0) {
        return x0.foreground;
    }

    static /* synthetic */ AdpPushClient access$1300(AdpPushClient x0, boolean x1) {
        return x0.updateRegistration(x1);
    }

    static /* synthetic */ boolean access$1400(AdpPushClient x0) {
        return x0.restartServiceState;
    }

    static /* synthetic */ void access$1500(AdpPushClient x0, MRR.NZV x1, boolean x2) {
        x0.saveInstallation(x1, x2);
    }

    static /* synthetic */ boolean access$1402(AdpPushClient x0, boolean x1) {
        x0.restartServiceState = x1;
        return x0.restartServiceState;
    }

    static /* synthetic */ boolean access$1002(AdpPushClient x0, boolean x1) {
        x0.registeredOnce = x1;
        return x0.registeredOnce;
    }

    static /* synthetic */ int access$1602(int x0) {
        failed_tries = x0;
        return failed_tries;
    }

    static /* synthetic */ OnDeeplinkResponseListener access$1700(AdpPushClient x0) {
        return x0.onDeeplinkResponseListener;
    }

    static /* synthetic */ void access$1800(AdpPushClient x0) {
        x0.getDeferredDeepLink();
    }

    static /* synthetic */ boolean access$302(AdpPushClient x0, boolean x1) {
        x0.isNewInstall = x1;
        return x0.isNewInstall;
    }

    static /* synthetic */ boolean access$1902(AdpPushClient x0, boolean x1) {
        x0.isLaunched = x1;
        return x0.isLaunched;
    }

    static /* synthetic */ void access$2000(AdpPushClient x0) {
        x0.retryRegistrationBackoff();
    }

    static /* synthetic */ OJW.YCE access$2100(AdpPushClient x0) {
        return x0.beforeSend();
    }

    static /* synthetic */ boolean access$2200(AdpPushClient x0) {
        return x0.isGuestUser();
    }

    static /* synthetic */ String access$2300(AdpPushClient x0) {
        return x0.getUniqueID();
    }

    static /* synthetic */ void access$2400(AdpPushClient x0) {
        x0.huaweiProtectedApps();
    }

    static {
        FORCE_STICKY = false;
        failed_tries = 0;
        notifs = new IXL<String>(200);
        pushClientInstance = null;
    }
}

