/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.webkit.MimeTypeMap;
import b.a;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.ad;
import com.adpdigital.push.ag;
import com.adpdigital.push.ap;
import com.adpdigital.push.ax;
import com.adpdigital.push.bs;
import com.adpdigital.push.service.ChabokNotificationOpenedReceiver;
import com.google.android.gms.gcm.GcmListenerService;
import f.c;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GcmMessageHandler
extends GcmListenerService {
    public static final String TAG = GcmMessageHandler.class.getName();
    private static int a = 0;
    private c b = f.c.getDefault();
    private static final ScheduledExecutorService c = Executors.newSingleThreadScheduledExecutor();

    public GcmMessageHandler() {
        this.b.register((Object)this);
    }

    public void onMessageReceived(String from, Bundle data) {
        String currentDeviceId;
        new StringBuilder("@@@@@@@@@@@@@@@@@ Received FCM Notification for ").append(from).append(": ").append(data);
        String deviceId = data.getString("deviceId");
        if (deviceId != null && !deviceId.equalsIgnoreCase(currentDeviceId = AdpPushClient.get().getInstallationId())) {
            new StringBuilder("Ignoring FCM, unmatched deviceId ").append(deviceId).append(" != ").append(currentDeviceId);
            return;
        }
        String alertText = data.getString("message");
        String title = data.getString("title");
        if ((alertText == null || alertText.equalsIgnoreCase("")) && (title == null || title.equalsIgnoreCase(""))) {
            return;
        }
        String messageId = data.getString("messageId");
        if (messageId != null && ax.a(messageId)) {
            return;
        }
        String pushPayload = data.getString("push");
        String topicName = "app/" + AdpPushClient.get().getAppId() + "/user/" + AdpPushClient.get().getUserId() + "/" + data.getString("collapse_key");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        ChabokNotification notification = new ChabokNotification(messageId, title, alertText, Integer.valueOf(data.getString("androidBadge", "0")) + this.a(), data);
        String trackId = data.getString("trackId");
        if (trackId != null) {
            notification.setTrackId(trackId);
        }
        notification.setTopicName(data.getString("collapse_key"));
        try {
            try {
                if (messageId != null && (ax.a(messageId) || AdpPushClient.hasNotified(messageId))) {
                    Log.w((String)TAG, (String)"Don't notify, messageId already delivered!");
                    return;
                }
                Class activityToOpen = AdpPushClient.get().getNotifActivityClass(data);
                GcmMessageHandler ctx = this;
                ap notifTask = new ap(this, pushPayload, topicName, (Context)ctx, activityToOpen, notification);
                c.schedule(notifTask, 0L, TimeUnit.SECONDS);
                return;
            }
            catch (ClassNotFoundException e2) {
                Log.e((String)TAG, (String)"cannot send notification when no subscriber for Intents", (Throwable)e2);
                return;
            }
        }
        catch (Exception e3) {
            Log.e((String)TAG, (String)"Error handling GCM ", (Throwable)e3);
            GcmMessageHandler.sendNotification((Context)this, null, notification);
            return;
        }
    }

    public void onEvent(bs event) {
        Log.w((String)TAG, (String)("Should? Notify GCM message (canNotify,isCanceled): " + event.isCanNofity() + "," + event.isCanceled()));
        if (!event.isCanceled()) {
            bs bs2 = event;
            GcmMessageHandler gcmMessageHandler = this;
            String string = bs2.getIntent().getExtras().getString("title");
            if (string == null) {
                string = bs2.getIntent().getExtras().getString("messageFrom");
            }
            ChabokNotification chabokNotification = new ChabokNotification(bs2.getIntent().getExtras().getString("messageId"), string, bs2.getIntent().getExtras().getString("message"), Integer.valueOf(bs2.getIntent().getExtras().getString("androidBadge", "0")) + gcmMessageHandler.a(), bs2.getIntent().getExtras());
            GcmMessageHandler.sendNotification((Context)gcmMessageHandler, bs2.getClient().getActivityClass(), chabokNotification);
        }
    }

    @TargetApi(value=16)
    public static void sendNotification(Context ctx, Class viewClass, ChabokNotification msg) {
        try {
            HashMap<String, HashMap> settings;
            PackageInfo packageInfo = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            ApplicationInfo appInfo = ctx.getPackageManager().getApplicationInfo(packageInfo.packageName, 0);
            CharSequence title = appInfo.nonLocalizedLabel;
            String body = null;
            String channelName = "CHABOK_CHANNEL";
            Intent intent = new Intent(ctx, ChabokNotificationOpenedReceiver.class);
            intent.setFlags(0x4000000);
            intent.putExtra("CHABOK_NOTIFICATION", true);
            if (viewClass != null) {
                intent.putExtra("CHABOK_NOTIFICATION_HANDLER", viewClass.getName());
            }
            String msgId = msg.getId();
            String trackId = msg.getTrackId();
            if (msg.getExtras() != null) {
                Log.i((String)TAG, (String)("Notification Extras " + msg.getExtras()));
                intent.putExtras(msg.getExtras());
                if (msg.getExtras().getString("messageId") != null) {
                    msgId = msg.getExtras().getString("messageId");
                }
                if (msg.getExtras().getString("trackId") != null) {
                    trackId = msg.getExtras().getString("trackId");
                }
                if (msg.getExtras().getString("title") != null) {
                    title = msg.getExtras().getString("title");
                }
                if (msg.getExtras().getString("body") != null) {
                    body = msg.getExtras().getString("body");
                }
            }
            if (msg != null && msg.getTopicName() != null) {
                channelName = GcmMessageHandler.a(msg.getTopicName());
            }
            if (msg.getMessage() != null) {
                channelName = GcmMessageHandler.a(msg.getMessage().getChannel());
                msg.setTopicName(msg.getMessage().getChannel());
                intent.putExtra("collapse_key", msg.getMessage().getChannel());
                intent.putExtra("messageId", msg.getMessage().getId());
                intent.putExtra("trackId", msg.getMessage().getTrackId());
                if (msg.getMessage().getData() != null) {
                    intent.putExtra("data", msg.getMessage().getData().toString());
                }
                intent.putExtra("live", msg.getMessage().isLive());
                intent.putExtra("stateful", msg.getMessage().isStateful());
                intent.putExtra("inapp", msg.getMessage().isInApp());
                intent.putExtra("topicName", msg.getMessage().getChannel());
                intent.putExtra("expireAt", msg.getMessage().getExpireAt());
                intent.putExtra("receivedAt", msg.getMessage().getReceivedAt());
                if (msg.getMessage() instanceof PushMessage) {
                    intent.putExtra("title", msg.getMessage().getAlertTitle());
                    intent.putExtra("body", msg.getMessage().getAlertText());
                    body = msg.getMessage().getAlertText();
                }
                title = msg.getMessage().getAlertTitle();
            }
            if (msgId != null) {
                AdpPushClient.get().addNotifiedMessage(msgId);
            }
            NotificationManager notificationManager = (NotificationManager)ctx.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel mChannel = new NotificationChannel(channelName.toString(), (CharSequence)channelName, 4);
                notificationManager.createNotificationChannel(mChannel);
            }
            JSONObject notificationObject = null;
            if (msg.getMessage() != null) {
                notificationObject = msg.getMessage().getNotification();
            } else if (msg.getExtras() != null) {
                String json = GcmMessageHandler.a(msg.getExtras());
                notificationObject = new JSONObject(json);
            }
            if (notificationObject != null && notificationObject.has("clickUrl")) {
                intent.putExtra("clickUrl", notificationObject.getString("clickUrl"));
            }
            int uniqueInt = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
            PendingIntent contentIntent = PendingIntent.getBroadcast((Context)ctx, (int)uniqueInt, (Intent)intent, (int)0x8000000);
            String string = trackId;
            String string2 = msgId;
            Context context = ctx;
            Intent intent2 = new Intent(context, ChabokNotificationOpenedReceiver.class);
            intent2.putExtra("CHABOK_DISMISS_NOTIFICATION", true);
            intent2.putExtra("messageId", string2);
            intent2.putExtra("trackId", string);
            int n2 = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
            PendingIntent dismissPendingIntent = PendingIntent.getBroadcast((Context)context, (int)n2, (Intent)intent2, (int)0x8000000);
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(ctx, channelName.toString()).setAutoCancel(true).setPriority(1).setTicker((CharSequence)msg.getText()).setContentTitle(title).setContentText((CharSequence)msg.getText()).setContentIntent(contentIntent).setDeleteIntent(dismissPendingIntent);
            if (body != null && body.toString().trim() != "") {
                mBuilder.setContentText((CharSequence)body);
            }
            mBuilder.setSmallIcon(Build.VERSION.SDK_INT >= 21 ? AdpPushClient.get().getNotificationIconSilhouette() : AdpPushClient.get().getNotificationIcon());
            Bitmap bm2 = BitmapFactory.decodeResource((Resources)ctx.getResources(), (int)appInfo.icon);
            mBuilder.setLargeIcon(bm2);
            int badge = -1;
            if (notificationObject != null) {
                Bitmap largeIconBitmap;
                String largeIcon;
                String colorHex;
                Bitmap bigPictureBitmap;
                String mediaUrl;
                String ledColorHex;
                int icon;
                String smallIcon;
                if (notificationObject.has("androidBadge")) {
                    badge = notificationObject.getInt("androidBadge");
                }
                if (notificationObject.has("smallIcon") && (smallIcon = notificationObject.getString("smallIcon")) != null && smallIcon.trim() != "" && (icon = GcmMessageHandler.a(smallIcon, ctx)) != 0) {
                    mBuilder.setSmallIcon(icon);
                }
                if (notificationObject.has("ledColor") && (ledColorHex = notificationObject.getString("ledColor")) != null && ledColorHex.trim() != "") {
                    String sharpSign = "#";
                    if (ledColorHex.startsWith("#")) {
                        sharpSign = "";
                    }
                    if (GcmMessageHandler.b(ledColorHex = sharpSign + ledColorHex)) {
                        mBuilder.setLights(Color.parseColor((String)ledColorHex), 300, 3000);
                    }
                }
                if (notificationObject.has("actions")) {
                    JSONArray actions;
                    if (notificationObject.get("actions").getClass() == String.class) {
                        String jsonActions = notificationObject.getString("actions");
                        actions = new JSONArray(jsonActions);
                    } else {
                        actions = notificationObject.getJSONArray("actions");
                    }
                    if (actions != null) {
                        GcmMessageHandler.a(mBuilder, actions, ctx, msgId, trackId);
                    }
                }
                if (notificationObject.has("mediaUrl") && (mediaUrl = notificationObject.getString("mediaUrl")) != null && mediaUrl.trim() != "" && (bigPictureBitmap = GcmMessageHandler.c(mediaUrl)) != null) {
                    mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureBitmap));
                    if (notificationObject.has("useAsLargeIcon") && notificationObject.getBoolean("useAsLargeIcon")) {
                        mBuilder.setLargeIcon(bigPictureBitmap);
                    }
                }
                if (notificationObject.has("color") && (colorHex = notificationObject.getString("color")) != null && colorHex.trim() != "") {
                    String sharpSign = "#";
                    if (colorHex.startsWith("#")) {
                        sharpSign = "";
                    }
                    if (GcmMessageHandler.b(colorHex = sharpSign + colorHex)) {
                        mBuilder.setColor(Color.parseColor((String)colorHex));
                    }
                }
                if (notificationObject.has("largeIcon") && (largeIcon = notificationObject.getString("largeIcon")) != null && largeIcon.trim() != "" && (largeIconBitmap = GcmMessageHandler.c(largeIcon)) != null) {
                    mBuilder.setLargeIcon(largeIconBitmap);
                }
            }
            if ((settings = AdpPushClient.get().getNotificationSettings()) != null && settings.containsKey(msg.getTopicName())) {
                msg.setAlert(Boolean.getBoolean(settings.get(msg.getTopicName()).get("alert").toString()));
                if (settings.get(msg.getTopicName()).get("sound") != null) {
                    msg.setSound((String)settings.get(msg.getTopicName()).get("sound"));
                }
            } else if (settings != null) {
                new StringBuilder("No Notification settings? ").append(Arrays.toString(settings.keySet().toArray())).append(", ").append(msg.getTopicName());
            } else {
                new StringBuilder("No Notification settings = null ").append(msg.getTopicName());
            }
            if (msg.isAlert()) {
                String soundName = msg.getSound();
                if (soundName != null && !soundName.isEmpty()) {
                    String extension = MimeTypeMap.getFileExtensionFromUrl((String)msg.getSound());
                    if (extension != null && extension != "") {
                        soundName = soundName.replace("." + extension, "");
                    }
                    mBuilder.setSound(Uri.parse((String)("android.resource://" + ctx.getPackageName() + "/raw/" + soundName)));
                } else {
                    mBuilder.setSound(RingtoneManager.getActualDefaultRingtoneUri((Context)ctx, (int)2));
                }
            }
            if (Build.VERSION.SDK_INT >= 21) {
                mBuilder.setVisibility(1);
            }
            if (AdpPushClient.get().prepareNotification(msg, mBuilder)) {
                Notification notif = mBuilder.build();
                if (badge >= 0) {
                    AdpPushClient.get().setBadge(badge);
                    if (AdpPushClient.get().isBadgeEnabled()) {
                        ShortcutBadger.applyNotification((Context)ctx, (Notification)notif, (int)AdpPushClient.get().getBadge());
                    }
                } else if (AdpPushClient.get().isBackground()) {
                    AdpPushClient.get().incBadge();
                }
                notificationManager.notify(++a, notif);
            }
            return;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)"Error notifying user ", (Throwable)e2);
            return;
        }
    }

    private static String a(String topic) {
        if (topic == null) {
            return "UNKNOWN";
        }
        String[] channels = topic.split("/");
        String deviceId = AdpPushClient.get().getInstallationId();
        String userId = AdpPushClient.get().getUserId();
        if (channels.length > 1) {
            if (channels[0].contentEquals("public")) {
                return channels[1];
            }
            if (deviceId != null && channels[1].contentEquals(deviceId)) {
                return "This Device";
            }
            if (channels[0].contentEquals("private") || userId != null && channels[0].contentEquals(userId)) {
                return "Personal " + channels[1] + " (private)";
            }
        }
        return channels[0];
    }

    private static boolean b(String color) {
        if (color == null) {
            return false;
        }
        return Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$").matcher(color).matches();
    }

    private static String a(Bundle bundle) {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException jSONException) {}
        }
        return json.toString();
    }

    private static Bitmap c(String strURL) {
        try {
            String string = strURL;
            if (!Pattern.compile("^((https?|ftp)://|(www|ftp)\\.)?[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].*)?$").matcher(string).find()) {
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)new URL(strURL).openConnection();
            connection.setDoInput(true);
            connection.connect();
            return BitmapFactory.decodeStream((InputStream)connection.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void a(NotificationCompat.Builder mBuilder, JSONArray actions, Context ctx, String msgId, String trackId) throws JSONException {
        if (actions != null) {
            for (int i2 = 0; i2 < actions.length(); ++i2) {
                JSONObject action = actions.getJSONObject(i2);
                String id = "";
                String title = "";
                String iconName = "";
                if (action.has("id")) {
                    id = action.getString("id");
                }
                if (action.has("title")) {
                    title = action.getString("title");
                }
                if (action.has("icon")) {
                    iconName = action.getString("icon");
                }
                if (title.trim() == "" || id.trim() == "") continue;
                int icon = GcmMessageHandler.a(iconName, ctx);
                Intent actionReceive = new Intent(ctx, ChabokNotificationOpenedReceiver.class);
                actionReceive.putExtra("CHABOK_ACTION_BUTTON", true);
                actionReceive.putExtra("CHABOK_ACTION_ID", id);
                actionReceive.putExtra("CHABOK_ACTION_TITLE", title);
                if (action.has("url")) {
                    String url = action.getString("url");
                    actionReceive.putExtra("CHABOK_ACTION_URL", url);
                }
                if (msgId != null) {
                    actionReceive.putExtra("messageId", msgId);
                }
                if (trackId != null) {
                    actionReceive.putExtra("trackId", trackId);
                }
                actionReceive.setAction(id);
                PendingIntent pendingIntentAction = PendingIntent.getBroadcast((Context)ctx, (int)i2, (Intent)actionReceive, (int)0x8000000);
                mBuilder.addAction(icon, (CharSequence)title, pendingIntentAction);
            }
        }
    }

    private static int a(String iconName, Context ctx) {
        String string;
        String trimmedIconName;
        if (iconName == null) {
            return 0;
        }
        String string2 = trimmedIconName = iconName.trim();
        if (!(trimmedIconName != null && !string2.matches("^[0-9]"))) {
            return 0;
        }
        Context context = ctx;
        string2 = trimmedIconName;
        Resources resources = context.getResources();
        int notificationIcon = resources != null && (string = context.getPackageName()) != null ? resources.getIdentifier(string2, "drawable", string) : 0;
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 0;
    }

    private int a() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0).getInt("androidUnseenBadge", 0);
    }

    private static boolean a(Intent intent) {
        return intent != null && intent.getBooleanExtra("CHABOK_ACTION_BUTTON", false);
    }

    private static boolean b(Intent intent) {
        return intent != null && intent.getBooleanExtra("CHABOK_DISMISS_NOTIFICATION", false);
    }

    public static void handleClickNotification(Context context, Intent intent) {
        Intent intent2;
        long clickTime = System.currentTimeMillis();
        if (!(GcmMessageHandler.b(intent) || GcmMessageHandler.a(intent) || (intent2 = intent) != null && intent2.hasExtra("CHABOK_NOTIFICATION"))) {
            new StringBuilder("----> It's not chabok intent :/ = ").append(intent);
            return;
        }
        intent2 = intent;
        ChabokNotificationAction chabokNotificationAction = new ChabokNotificationAction();
        if (GcmMessageHandler.b(intent2)) {
            chabokNotificationAction.type = ChabokNotificationAction.a.Dismissed;
            new StringBuilder("----> Notification dismissed ").append(intent2.getExtras());
        } else if (GcmMessageHandler.a(intent2)) {
            chabokNotificationAction.type = ChabokNotificationAction.a.ActionTaken;
            chabokNotificationAction.actionID = intent2.getStringExtra("CHABOK_ACTION_ID");
            if (intent2.hasExtra("CHABOK_ACTION_URL")) {
                chabokNotificationAction.actionUrl = intent2.getStringExtra("CHABOK_ACTION_URL");
            }
            new StringBuilder("----> User tapped on ('").append(intent2.getStringExtra("CHABOK_ACTION_TITLE")).append("') action with id = ").append(chabokNotificationAction.actionID).append(" from the notification");
        } else {
            chabokNotificationAction.type = ChabokNotificationAction.a.Opened;
            if (intent2.hasExtra("clickUrl")) {
                chabokNotificationAction.actionUrl = intent2.getStringExtra("clickUrl");
            }
        }
        ChabokNotificationAction notificationAction = chabokNotificationAction;
        JSONObject notifActionJson = GcmMessageHandler.a(intent, clickTime, notificationAction);
        ad communicateEvent = new ad(notifActionJson, ag.ClickedNotification);
        if (notificationAction.type == ChabokNotificationAction.a.Dismissed) {
            communicateEvent.status = ag.DismissedNotification;
        }
        f.c.getDefault().post(communicateEvent);
        boolean preventStartActivity = AdpPushClient.get().notificationOpened(intent.getExtras(), notificationAction);
        if (preventStartActivity || GcmMessageHandler.b(intent)) {
            new StringBuilder("-- prevent start activity = ").append(preventStartActivity).append(" , isDismissed = ").append(GcmMessageHandler.b(intent));
            return;
        }
        if (notificationAction.type == ChabokNotificationAction.a.ActionTaken) {
            ChabokNotificationAction chabokNotificationAction2 = notificationAction;
            chabokNotificationAction = intent;
            intent2 = context;
            Intent intent3 = new Intent();
            intent3.setAction(chabokNotificationAction2.actionID);
            intent3.replaceExtras((Intent)chabokNotificationAction);
            intent2.sendBroadcast(intent3);
            if (intent.hasExtra("CHABOK_ACTION_URL")) {
                GcmMessageHandler.a(context, intent, "CHABOK_ACTION_URL", "----> Start launch action url = ");
            }
            return;
        }
        if (notificationAction.type == ChabokNotificationAction.a.Opened && intent.hasExtra("clickUrl")) {
            GcmMessageHandler.a(context, intent, "clickUrl", "----> Start launch click url = ");
            return;
        }
        chabokNotificationAction = intent;
        intent2 = context;
        try {
            Class clazz = AdpPushClient.get().getNotifActivityClass(chabokNotificationAction.getExtras());
            Intent intent4 = new Intent((Context)intent2, clazz);
            intent4.setFlags(0x10020000);
            new StringBuilder("----> Start launching activity = ").append(clazz);
            intent2.startActivity(intent4);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @NonNull
    private static JSONObject a(Intent intent, long clickTime, ChabokNotificationAction notificationAction) {
        JSONObject notifActionJson = new JSONObject();
        try {
            String actionId;
            String trackId;
            notifActionJson.put("type", 1);
            String messageId = intent.getExtras().getString("messageId");
            if (messageId != null) {
                notifActionJson.put("msgId", (Object)messageId);
            }
            if ((trackId = intent.getExtras().getString("trackId")) != null) {
                notifActionJson.put("trackId", (Object)trackId);
            }
            if ((actionId = notificationAction.actionID) != null) {
                notifActionJson.put("actionId", (Object)actionId);
            }
            notifActionJson.put("actionTs", clickTime);
            if (notificationAction.type == ChabokNotificationAction.a.Opened) {
                notifActionJson.put("actionType", (Object)"OPENED");
            } else if (notificationAction.type == ChabokNotificationAction.a.Dismissed) {
                notifActionJson.put("actionType", (Object)"DISMISSED");
            } else if (notificationAction.type == ChabokNotificationAction.a.ActionTaken) {
                notifActionJson.put("actionType", (Object)"ACTION_TAKEN");
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return notifActionJson;
    }

    private static void a(Context context, Intent intent, String actionUrl, String logMessage) {
        try {
            String url = intent.getStringExtra(actionUrl);
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            Intent i2 = new Intent("android.intent.action.VIEW");
            i2.addFlags(0x58080000);
            i2.setData(Uri.parse((String)url));
            new StringBuilder().append(logMessage).append(url);
            context.startActivity(i2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void onDestroy() {
        this.b.unregister((Object)this);
        super.onDestroy();
    }

    static /* synthetic */ SharedPreferences a(GcmMessageHandler x0) {
        return x0.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }
}

