/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Log;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokMessage;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.DeliveryMessage;
import com.adpdigital.push.EventMessage;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.ai;
import com.adpdigital.push.ak;
import com.adpdigital.push.am;
import com.adpdigital.push.at;
import com.adpdigital.push.aw;
import com.adpdigital.push.ax;
import com.adpdigital.push.ay;
import com.adpdigital.push.ba;
import com.adpdigital.push.bc;
import com.adpdigital.push.bd;
import com.adpdigital.push.be;
import com.adpdigital.push.bf;
import com.adpdigital.push.bg;
import com.adpdigital.push.bh;
import com.adpdigital.push.bi;
import com.adpdigital.push.bj;
import com.adpdigital.push.bk;
import h.g;
import h.h;
import h.j;
import h.m;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PushService
extends Service {
    private static final String a = PushService.class.getSimpleName();
    private static final ScheduledExecutorService b = Executors.newSingleThreadScheduledExecutor();
    private static boolean c = true;
    private static boolean d = false;
    private static Collection<String> e = new ai<String>(200);
    private static c f;
    private NetworkConnectionIntentReceiver g;
    private BroadcastReceiver h;
    private f.c i = f.c.getDefault();
    private Collection<String> j = new ai<String>(400);
    private String k;
    private String l;
    private String m;
    private String n;
    private String o;
    private boolean p;
    private String q;
    private String r;
    private WifiManager s;
    private AlarmManager t;
    private WifiManager.WifiLock u;
    private long v = 2000L;
    private boolean w = false;
    private b<PushService> x;

    public static void performAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        context.startService(actionIntent);
    }

    static boolean a(String id) {
        return e.contains(id);
    }

    static boolean a() {
        return c;
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        new StringBuilder("Creating ADP PushService for ").append(this.k);
        this.w = false;
        this.s = (WifiManager)this.getApplicationContext().getSystemService("wifi");
        this.t = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        PushService pushService = this;
        pushService.f();
        pushService.cancelReconnect();
        this.j();
        Set cache = this.l().getStringSet("dataCache", null);
        if (cache != null) {
            e.addAll(cache);
        }
        this.i.register((Object)this);
        this.x = new b<PushService>(this);
        if (this.g == null) {
            this.g = new NetworkConnectionIntentReceiver((Context)this, new at(this));
        }
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.h = new bc(this);
        this.registerReceiver(this.h, filter);
        if (f == null) {
            f = new c();
        }
        this.i();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        new StringBuilder("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand ").append(flags).append(", ").append(startId);
        if (intent == null || intent.getAction() == null) {
            this.e();
        } else {
            new StringBuilder("PushService action ").append(intent.getAction()).append(", foreground:").append(AdpPushClient.get().isForeground()).append(", screenOn:").append(c);
            switch (intent.getAction()) {
                case "START": {
                    this.e();
                    break;
                }
                case "RESTART": {
                    PushService pushService = this;
                    if (!ak.isConnected((Context)pushService)) break;
                    if (f != null && (f.isConnecting() || f.isConnected())) {
                        f.disconnectExistingClient();
                    }
                    pushService.new a().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    PushService pushService = this;
                    if (!f.isConnected()) break;
                    pushService.new d().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "RECONNECT": {
                    this.g();
                    break;
                }
                case "DISCONNECT": {
                    this.cancelReconnect();
                    this.f();
                    if (f == null) break;
                    f.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    this.h();
                    break;
                }
                default: {
                    new StringBuilder("Unrecognized action ").append(intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            return 1;
        }
        return 2;
    }

    private void e() {
        if (!ak.isConnected((Context)this)) {
            return;
        }
        if (f != null) {
            if (f.isConnecting() || f.isConnected()) {
                f.isConnected();
                return;
            }
            if (PushService.f.b != null) {
                PushService.f.b.isConnected();
            }
        }
        new a().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
    }

    public boolean isConnected() {
        return f != null && f.isConnected();
    }

    private PendingIntent c(String action) {
        Intent keepAlive = new Intent();
        keepAlive.setClass((Context)this, PushService.class);
        keepAlive.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAlive, (int)0);
    }

    private void f() {
        this.t.cancel(this.c("KEEP_ALIVE"));
        PushService pushService = this;
        if (pushService.u != null) {
            try {
                pushService.u.release();
            }
            catch (Exception exception) {}
            pushService.u = null;
        }
    }

    public void scheduleReconnect() {
        if (this.v >= 120000L) {
            this.v = 2000L;
        }
        this.v = Math.min(this.v * 2L, 120000L);
        new StringBuilder("Scheduling reconnect timer in ").append(this.v).append("ms.");
        PendingIntent reconnectIntent = this.c("RECONNECT");
        this.t.cancel(reconnectIntent);
        this.t.set(0, System.currentTimeMillis() + this.v, reconnectIntent);
    }

    public void cancelReconnect() {
        this.t.cancel(this.c("RECONNECT"));
    }

    private void g() {
        if (!ak.isConnected((Context)this)) {
            return;
        }
        if (f != null && (f.isConnected() || f.isConnecting())) {
            String state = f.isConnected() ? "Connected" : "Connecting";
            new StringBuilder("We are ").append(state).append(", don't reconnect");
            return;
        }
        new a().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
    }

    public void onTaskRemoved(Intent rootIntent) {
        new StringBuilder("push service removed: ").append(rootIntent.getAction()).append(rootIntent);
        this.h();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        this.h();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        this.h();
        super.onDestroy();
    }

    private void h() {
        this.w = true;
        if (f != null) {
            f.disconnectExistingClient();
        }
        PushService pushService = this;
        pushService.cancelReconnect();
        pushService.f();
        if (AdpPushClient.get().shouldBeSticky()) {
            PushService pushService2 = pushService;
            Intent intent = new Intent(pushService2.getApplicationContext(), ((Object)((Object)pushService2)).getClass());
            intent.setPackage(pushService2.getPackageName());
            PendingIntent pendingIntent = PendingIntent.getService((Context)pushService2.getApplicationContext(), (int)1, (Intent)intent, (int)0x40000000);
            pushService2.t.set(3, SystemClock.elapsedRealtime() + 10000L, pendingIntent);
        }
        pushService.stopSelf();
        if (this.g != null) {
            this.g.unregister();
            this.g = null;
        }
        if (this.h != null) {
            this.unregisterReceiver(this.h);
            this.h = null;
        }
        if (this.x != null) {
            this.x.close();
            this.x = null;
        }
        this.i.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStatus getStatus() {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (f == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ConnectionStatus.NOT_INITIALIZED;
            }
            if (f.isConnected()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ConnectionStatus.CONNECTED;
            }
            if (f.isConnecting()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ConnectionStatus.CONNECTING;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ConnectionStatus.DISCONNECTED;
        }
    }

    public void onEvent(String event) {
    }

    public void onEvent(am event) {
        switch (event) {
            case DeviceIdChange: {
                b.schedule(new bd(this), 1L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(bk cmd) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            new StringBuilder("Got service ").append((Object)cmd).append(" in state ").append((Object)this.getStatus());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void i() {
        Set inAppMsgs = this.l().getStringSet("pendingInAppMsgs", null);
        if (inAppMsgs != null) {
            new StringBuilder("Delivering in-app messages: ").append(inAppMsgs.size());
            for (String item : inAppMsgs) {
                try {
                    String[] tokens = item.split("_BAHDRPA_");
                    this.a(PushService.b(tokens[0], tokens[1]), tokens[1]);
                }
                catch (Exception exception) {}
            }
            this.j = new ai<String>(400);
            this.l().edit().putStringSet("pendingInAppMsgs", new HashSet<String>(Arrays.asList(this.j.toArray(new String[this.j.size()])))).commit();
        }
    }

    private void j() {
        AdpPushClient adpClient = AdpPushClient.get();
        this.m = adpClient.getInstallationId();
        this.k = adpClient.decrypt(this.l().getString("userId", null));
        this.l = adpClient.decrypt(this.l().getString("applicationId", null));
        this.q = adpClient.decrypt(this.l().getString("username", null));
        this.r = adpClient.decrypt(this.l().getString("password", null));
        this.n = this.l().getString("host", null);
        this.o = this.l().getString("port", null);
        this.p = this.l().getBoolean("useSecure", true);
        d = this.l().getBoolean("energySaverMode", false);
        this.k();
    }

    private short k() {
        short kaStored;
        short KEEP_ALIVE = ak.isConnectedMobile(this.getApplicationContext()) ? ((kaStored = (short)this.l().getInt("ka-data", 0)) == 0 ? (short)180 : (short)kaStored) : ((kaStored = (short)this.l().getInt("ka-wifi", 0)) == 0 ? (short)300 : (short)kaStored);
        return KEEP_ALIVE;
    }

    private static ChabokMessage b(String topic, String payload) {
        ChabokMessage message;
        if (topic.contains("/delivery/")) {
            message = new DeliveryMessage(PushService.e(topic), payload);
            message.setChannel(topic);
            new StringBuilder("Delivery message ").append(PushService.e(topic)).append(", ").append(payload);
        } else if (topic.contains("/event/")) {
            message = new EventMessage(topic.split("/")[3], PushService.e(topic), payload);
            message.setChannel(topic);
            new StringBuilder("Event message ").append(PushService.e(topic)).append(", ").append(payload);
        } else {
            try {
                message = PushMessage.fromJson(payload, PushService.f(topic));
            }
            catch (Throwable throwable) {
                Throwable e2 = throwable;
                throwable.getMessage();
                String newText = "error: " + e2.getMessage() + " on received data " + payload;
                message = new PushMessage();
                message.setChannel(PushService.f(topic));
                message.setId("fixMockUUID");
                ((PushMessage)message).setBody(newText);
                ((PushMessage)message).setCreatedAt(System.currentTimeMillis());
            }
        }
        return message;
    }

    private void a(ChabokMessage message, String payload) {
        if (message instanceof PushMessage) {
            if (((PushMessage)message).isNotify()) {
                AdpPushClient.get().notifyNewMessage((PushMessage)message);
            }
            String string = payload;
            ChabokMessage chabokMessage = message;
            PushService pushService = this;
            Intent intent = new Intent();
            intent.setAction(chabokMessage.getIntentType());
            intent.addCategory(pushService.getApplicationContext().getPackageName());
            intent.putExtra("com.adpdigital.push.client.MSGRECVD_TOPIC", chabokMessage.getChannel());
            intent.putExtra("com.adpdigital.push.client.MSGRECVD_MSGBODY", string);
            pushService.sendBroadcast(intent);
        }
        if (this.i.hasSubscriberForEvent(message.getClass())) {
            this.i.post(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(String channel, boolean isLive, Callback<String> clbk) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (!this.isConnected()) {
                this.i.register(new bg(this, channel, isLive, clbk));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            String channelName = this.b(channel);
            new bh(this, channelName, isLive, clbk).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(String event, String installationId, boolean isLive, Callback<String> clbk) {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (!this.isConnected()) {
                this.i.register(new bi(this, event, installationId, isLive, clbk));
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            String topicName = this.a(event, installationId);
            new bj(this, topicName, isLive, clbk).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    final String b(String channel) {
        String[] parts = channel.split("/");
        if (parts.length == 1) {
            return this.c("public", channel);
        }
        if (parts.length == 2) {
            if (channel.contains("private/")) {
                return this.c(this.k, parts[1]);
            }
            return this.c("public", parts[1]);
        }
        throw new IllegalArgumentException("Invalid Channel Name " + channel);
    }

    private String c(String user, String channel) {
        return "app/" + this.l + "/user/" + user + "/" + channel;
    }

    private String d(String channel) {
        String[] parts = channel.split("/");
        if (parts.length == 2) {
            return "app/" + this.l + "/user/" + channel;
        }
        if (parts.length == 1) {
            String string = this.k;
            String string2 = channel;
            PushService pushService = this;
            return "app/" + pushService.l + "/user/" + string + "/" + string2;
        }
        throw new IllegalArgumentException("Invalid Channel Name " + channel);
    }

    final String a(String event, String subject) {
        return "app/" + this.l + "/event/" + event + "/" + subject;
    }

    private static String e(String topicName) {
        return topicName.split("/")[4];
    }

    private static String f(String topicName) {
        String[] parts = topicName.split("/");
        return parts[3] + "/" + parts[4];
    }

    public void publish(PushMessage message, Callback<Boolean> callback) throws Exception {
        PushMessage pushMessage = message;
        PushService pushService = this;
        String string = !pushMessage.getUser().equals("*") ? pushMessage.getUser() : "public";
        this.b("app/" + pushService.l + "/publish/" + string + "/" + pushMessage.getChannel(), message.toJson(), false, false, callback);
    }

    final void a(String topic, String payload, boolean live, boolean stateful, Callback<Boolean> callback) throws Exception {
        if (!this.isConnected()) {
            this.i.register(new ax(this, topic, payload, live, stateful, callback));
            return;
        }
        new ay(this, topic, payload, live, stateful, callback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    final void b(String topic, String payload, boolean live, boolean stateful, Callback<Boolean> callback) {
        try {
            this.a(topic, payload, live, stateful, new ba(this, callback, live, topic, payload, stateful));
            return;
        }
        catch (Exception e2) {
            callback.onFailure(e2);
            return;
        }
    }

    private SharedPreferences l() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }

    public IBinder onBind(Intent intent) {
        return this.x;
    }

    static /* synthetic */ boolean a(PushService x0) {
        return ak.isConnected((Context)x0);
    }

    static /* synthetic */ void b(PushService x0) {
        PushService pushService = x0;
        if (c) {
            pushService.g();
        }
    }

    static /* synthetic */ void c(PushService x0) {
        x0.cancelReconnect();
    }

    static /* synthetic */ boolean a(boolean x0) {
        c = x0;
        return c;
    }

    static /* synthetic */ void d(PushService x0) {
        x0.cancelReconnect();
    }

    static /* synthetic */ void c() {
    }

    static /* synthetic */ Object[] e(PushService x0) {
        PushService pushService = x0;
        Set set = pushService.l().getStringSet("topics", new HashSet());
        String[] stringArray = set.toArray(new String[set.size()]);
        if (!pushService.l().getBoolean("subscriptionDirty", true)) {
            return new Object[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Object[] objectArray = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String object = objectArray[i2];
            arrayList.add(pushService.d(object));
            arrayList2.add(1);
        }
        arrayList.add(pushService.d(pushService.m));
        arrayList2.add(1);
        if (AdpPushClient.get().deliveryTopicEnabled()) {
            PushService pushService2 = pushService;
            arrayList.add("app/" + pushService2.l + "/delivery/" + pushService2.k + "/#");
            arrayList2.add(1);
        }
        objectArray = new int[arrayList2.size()];
        n2 = 0;
        for (Integer n3 : arrayList2) {
            objectArray[n2++] = (String)((Object)n3);
        }
        return new Object[]{arrayList.toArray(new String[arrayList.size()]), objectArray};
    }

    static /* synthetic */ void f(PushService x0) {
        x0.l().edit().putBoolean("subscriptionDirty", false).apply();
    }

    static /* synthetic */ void a(PushService x0, String x1, String x2, boolean x4) {
        boolean bl2 = x4;
        String string = x2;
        String string2 = x1;
        PushService pushService = x0;
        new StringBuilder("Storing offline message ").append(string2).append(": ").append(string);
        HashSet<String> hashSet = new HashSet<String>(50);
        Set set = pushService.l().getStringSet("offlineCache", null);
        if (set != null) {
            hashSet.addAll(set);
        }
        hashSet.add(string2 + "_:_" + string + "_:_1_:_" + bl2);
        pushService.l().edit().putStringSet("offlineCache", new HashSet<String>(Arrays.asList(hashSet.toArray(new String[hashSet.size()])))).apply();
    }

    static /* synthetic */ String i(PushService x0) {
        PushService pushService = x0;
        if (pushService.l == null) {
            throw new IllegalStateException("appId not set");
        }
        if (pushService.k == null) {
            throw new IllegalStateException("userId not set");
        }
        if (pushService.m == null) {
            throw new IllegalStateException("installationId not set");
        }
        return pushService.l + "/" + pushService.k + "/" + pushService.m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void j(PushService x0) {
        PushService pushService = x0;
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (!pushService.isConnected()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            new bf(pushService).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static /* synthetic */ void k(PushService x0) {
        PushService pushService;
        PushService pushService2 = pushService = x0;
        Object object = new HashSet(50);
        Object object2 = pushService2.l().getStringSet("offlineCache", null);
        if (object2 != null) {
            object.addAll(object2);
        }
        pushService2.l().edit().putStringSet("offlineCache", new HashSet()).apply();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = ((String)iterator.next()).split("_:_");
            if (objectArray.length == 4) {
                try {
                    object2 = objectArray[1];
                    object = objectArray[0];
                    pushService2 = pushService;
                    aw aw2 = new aw(pushService2);
                    pushService2.a((String)object, (String)object2, false, false, aw2);
                }
                catch (Exception exception) {
                    new StringBuilder("Error publishing offline msg ").append((String)objectArray[1]);
                }
                continue;
            }
            new StringBuilder("Error in parsing offline message ").append(Arrays.toString(objectArray));
        }
    }

    static /* synthetic */ void l(PushService x0) {
        PushService pushService = x0;
        long l2 = pushService.k() * 1000;
        new StringBuilder("Scheduling keepalive timer in ").append(l2).append("ms.");
        PendingIntent pendingIntent = pushService.c("KEEP_ALIVE");
        pushService.t.cancel(pendingIntent);
        if (Build.VERSION.SDK_INT < 19) {
            pushService.t.set(2, SystemClock.elapsedRealtime() + l2, pendingIntent);
        } else {
            pushService.t.setExact(2, SystemClock.elapsedRealtime() + l2, pendingIntent);
        }
        PushService pushService2 = pushService;
        if (pushService2.u == null) {
            pushService2.u = pushService2.s.createWifiLock(1, "PushService");
            pushService2.u.acquire();
        }
    }

    static /* synthetic */ String m(PushService x0) {
        PushService pushService = x0;
        String string = "tcp://";
        if (pushService.p) {
            string = "ssl://";
        }
        new StringBuilder("Broker Host ").append(string).append(pushService.n).append(pushService.o);
        return string + pushService.n + pushService.o;
    }

    static /* synthetic */ long r(PushService x0) {
        x0.v = 2000L;
        return 2000L;
    }

    static /* synthetic */ void a(PushService x0, String x1, String x2) {
        String string = x2;
        String string2 = x1;
        PushService pushService = x0;
        ChabokMessage chabokMessage = PushService.b(string2, string);
        try {
            if (chabokMessage.getId() != null) {
                boolean bl2;
                Object object = chabokMessage.getId();
                PushService pushService2 = pushService;
                if (e.contains(object)) {
                    bl2 = false;
                } else {
                    boolean bl3 = e.add((String)object);
                    pushService2.l().edit().putStringSet("dataCache", new HashSet<String>(Arrays.asList(e.toArray(new String[e.size()])))).apply();
                    bl2 = bl3;
                }
                if (bl2) {
                    if (chabokMessage instanceof PushMessage) {
                        PushMessage pushMessage = (PushMessage)chabokMessage;
                        if (pushMessage.getData() != null && pushMessage.getData().optString("chabokCmd", null) != null) {
                            object = pushMessage;
                            pushService2 = pushService;
                            String[] stringArray = ((PushMessage)object).getData().optString("chabokCmd", "").split(" ");
                            String string3 = stringArray[0];
                            new StringBuilder("Push Command ").append(string3).append(": ").append(((PushMessage)object).getData());
                            switch (string3.toLowerCase()) {
                                case "behrad": {
                                    String string4 = "Please enter a text";
                                    String string5 = pushService2.k;
                                    if (stringArray.length == 3) {
                                        string5 = stringArray[1];
                                        string4 = stringArray[2];
                                    }
                                    try {
                                        PushMessage pushMessage2 = new PushMessage();
                                        pushMessage2.setId("push-command-" + System.currentTimeMillis());
                                        pushMessage2.setCreatedAt(System.currentTimeMillis());
                                        pushMessage2.setBody(string4);
                                        pushMessage2.setChannel(string5 + "/default");
                                        pushService2.publish(pushMessage2, new be(pushService2));
                                        return;
                                    }
                                    catch (Exception exception) {
                                        Log.e((String)a, (String)"Error in echo command ", (Throwable)exception);
                                        return;
                                    }
                                }
                                case "set-ka-data": {
                                    if (stringArray.length <= 1) break;
                                    short s2 = Short.valueOf(stringArray[1]);
                                    if (s2 > 0) {
                                        pushService2.l().edit().putInt("ka-data", (int)s2).commit();
                                        return;
                                    }
                                    pushService2.l().edit().remove("ka-data").commit();
                                    return;
                                }
                                case "set-ka-wifi": {
                                    if (stringArray.length <= 1) break;
                                    short s3 = Short.valueOf(stringArray[1]);
                                    if (s3 > 0) {
                                        pushService2.l().edit().putInt("ka-wifi", (int)s3).commit();
                                        return;
                                    }
                                    pushService2.l().edit().remove("ka-wifi").commit();
                                    return;
                                }
                            }
                            return;
                        }
                        if (pushMessage.getExpireAt() > 0L && pushMessage.getExpireAt() < System.currentTimeMillis()) {
                            return;
                        }
                        if (pushMessage.getBody().startsWith("BIBB")) {
                            return;
                        }
                        if (pushMessage.isInApp() && AdpPushClient.get().isFreshStart()) {
                            String string6 = string;
                            object = string2;
                            pushService2 = pushService;
                            pushService2.j.add((String)object + "_BAHDRPA_" + string6);
                            pushService2.l().edit().putStringSet("pendingInAppMsgs", new HashSet<String>(Arrays.asList(pushService2.j.toArray(new String[pushService2.j.size()])))).commit();
                            return;
                        }
                    }
                    pushService.a(chabokMessage, string);
                    return;
                }
            }
            new StringBuilder("Ignore duplicate message(").append(string2).append(", ").append(string).append(")");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final class c
    implements g {
        boolean a;
        private boolean d;
        h.c b;

        public c() {
            try {
                this.d = ak.isConnectedMobile(PushService.this.getApplicationContext());
                a;
                this.b = new h(PushService.m(PushService.this), PushService.i(PushService.this), null);
                return;
            }
            catch (Exception exc) {
                a;
                new StringBuilder("Connection initialization error: ").append(exc.toString());
                return;
            }
        }

        public final void disconnectExistingClient() {
            if (this.b == null) {
                a;
                return;
            }
            if (this.b.isConnected()) {
                try {
                    a;
                    this.b.disconnect(5000L);
                    PushService.this.i.post((Object)ConnectionStatus.DISCONNECTED);
                    a;
                }
                catch (Exception exception) {
                    a;
                }
            }
            try {
                this.b.close();
                a;
                return;
            }
            catch (Exception exception) {
                a;
                return;
            }
        }

        public final void connect() throws Exception {
            a;
            PushService.this.f();
            PushService.this.cancelReconnect();
            if (this.b != null) {
                a;
                new StringBuilder("We already have an initialized client ").append(this.b.isConnected());
            }
            this.b = new h(PushService.m(PushService.this), PushService.i(PushService.this), null);
            this.b.setCallback(this);
            j options = new j();
            options.setBrokerVersion(4);
            options.setUserName(PushService.this.q);
            options.setPassword(PushService.this.r.toCharArray());
            options.setCleanSession(false);
            options.setKeepAliveInterval(PushService.this.k());
            options.setConnectionTimeout(30);
            a;
            this.b.connect(options);
            PushService.l(PushService.this);
            PushService.r(PushService.this);
        }

        public final boolean isConnected() {
            if (this.b == null) {
                return false;
            }
            return this.b.isConnected();
        }

        public final boolean isConnecting() {
            return this.a;
        }

        public final void setConnecting(boolean value) {
            this.a = value;
        }

        @Override
        public final void connectionLost(Throwable cause) {
            a;
            new StringBuilder("connection lost(ScreenOn=").append(PushService.a()).append(", isCleanUp=").append(PushService.this.w).append("): ").append(cause);
            this.a = false;
            PushService.this.i.post((Object)ConnectionStatus.DISCONNECTED);
            PushService.this.f();
            if (PushService.a(PushService.this) && PushService.a() && !PushService.this.w) {
                PushService.this.g();
            }
        }

        @Override
        public final void messageArrived(String topic, m message) throws Exception {
            a;
            new StringBuilder("Got message on ").append(topic).append(": ").append(new String(message.getPayload())).append(" length=").append(message.getPayload().length);
            PushService.l(PushService.this);
            PushService.a(PushService.this, topic, new String(message.getPayload()));
        }

        @Override
        public final void deliveryComplete(h.d token) {
            PushService.l(PushService.this);
            a;
            new StringBuilder("Publish delivered to server on topic ").append(Arrays.toString(token.getTopics())).append(": ").append(token.getMessageId());
        }
    }

    public final class b<S>
    extends Binder {
        private WeakReference<S> b;

        public b(S service) {
            this.b = new WeakReference<S>(service);
        }

        public final S getService() {
            return (S)this.b.get();
        }

        public final void close() {
            this.b = null;
        }
    }

    public final class d
    extends AsyncTask<Integer, String, Integer> {
        protected final Integer doInBackground(Integer ... Parameter2) {
            if (f.b == null) {
                a;
                return 0;
            }
            a;
            f.b.sendKeepAlive();
            a;
            PushService.l(PushService.this);
            return 0;
        }
    }

    public final class a
    extends AsyncTask<Integer, String, Integer> {
        public a() {
            if (f != null) {
                if (f.a) {
                    a;
                    return;
                }
                PushService.this.i.post((Object)ConnectionStatus.CONNECTING);
                f.setConnecting(true);
                return;
            }
            a;
        }

        protected final Integer doInBackground(Integer ... Parameter2) {
            block2: {
                a;
                try {
                    PushService.this.j();
                    f.connect();
                    a;
                    new StringBuilder("Connected to ADP Chabok ").append(PushService.i(PushService.this));
                    PushService.this.i.post((Object)ConnectionStatus.CONNECTED);
                    PushService.j(PushService.this);
                    PushService.k(PushService.this);
                }
                catch (Exception e2) {
                    a;
                    new StringBuilder("Connect Exception: ").append(e2.toString());
                    if (!PushService.a(PushService.this) || e2 instanceof IllegalStateException) break block2;
                    PushService.this.scheduleReconnect();
                }
            }
            f.setConnecting(false);
            return 0;
        }
    }
}

