/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import b.h;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.AppState;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GcmMessageHandler;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.a;
import com.adpdigital.push.aa;
import com.adpdigital.push.ac;
import com.adpdigital.push.ae;
import com.adpdigital.push.af;
import com.adpdigital.push.ag;
import com.adpdigital.push.ah;
import com.adpdigital.push.ai;
import com.adpdigital.push.ak;
import com.adpdigital.push.al;
import com.adpdigital.push.an;
import com.adpdigital.push.ap;
import com.adpdigital.push.b;
import com.adpdigital.push.c;
import com.adpdigital.push.d;
import com.adpdigital.push.e;
import com.adpdigital.push.f;
import com.adpdigital.push.g;
import com.adpdigital.push.i;
import com.adpdigital.push.j;
import com.adpdigital.push.k;
import com.adpdigital.push.l;
import com.adpdigital.push.m;
import com.adpdigital.push.n;
import com.adpdigital.push.p;
import com.adpdigital.push.q;
import com.adpdigital.push.s;
import com.adpdigital.push.service.RegistrationIntentService;
import com.adpdigital.push.t;
import com.adpdigital.push.u;
import com.adpdigital.push.v;
import com.adpdigital.push.w;
import com.adpdigital.push.x;
import com.adpdigital.push.y;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static final String SDK_VERSION = "2.12.1";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int failed_tries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private b.i adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long installDate;
    private boolean isLaunched = false;
    private f.c eventBus = f.c.getDefault();
    private Context context;
    private Class activityClass;
    private Activity currentActivity;
    private String userId;
    private String senderId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;

    private AdpPushClient(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        Log.i((String)TAG, (String)"Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate(context, handlerActivity, appId, apiKey, username, password);
        this.eventBus.register(this);
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        if (this.shouldBeSticky() && this.hasProtectedAppSupport()) {
            this.eventBus.post((Object)AppState.PROTECTED_GRANT_NEEDED);
        }
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new a(this));
        try {
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new m(this));
        }
        catch (Exception exception) {}
        this.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdpPushClient init(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            if (pushClientInstance != null) return pushClientInstance;
            packageName = context.getPackageName();
            pushClientInstance = new AdpPushClient(context, handlerActivity, appId, apiKey, username, password);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized yet, please first call AdpPushClient.get with parameters");
        }
        return pushClientInstance;
    }

    static boolean hasNotified(String id) {
        return notifs.contains(id);
    }

    private void initializeAdapter() {
        String restApi = "http://" + al.a + ":80/api/";
        String currentHost = al.a;
        String currentPortBroker = ":1880";
        this.useDev = this.getSharedPreferences().getBoolean("useDev", true);
        if (this.useSecure) {
            String appSubDomain = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                appSubDomain = this.appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + al.a + ":443/api/";
            currentHost = appSubDomain + al.a;
            currentPortBroker = ":4443";
        }
        if (this.useDev) {
            restApi = "http://sandbox.push.adpdigital.com:80/api/";
            currentHost = "sandbox.push.adpdigital.com";
            currentPortBroker = ":1880";
        }
        if (this.useDev && this.useSecure) {
            restApi = "https://sandbox.push.adpdigital.com:443/api/";
            currentHost = "sandbox.push.adpdigital.com";
            currentPortBroker = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", currentHost).putString("port", currentPortBroker).putBoolean("useSecure", this.useSecure).apply();
        this.adapter = new b.i(this.getApplicationContext(), restApi);
        this.adapter.setAccessToken(this.apiKey);
    }

    private void validateAndPopulate(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        Set cache;
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, PushClient needs your application context");
        }
        this.context = context;
        if (handlerActivity == null) {
            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
        }
        this.activityClass = handlerActivity;
        this.getSharedPreferences().edit().putString(ACTIVITY_KEY, this.getActivityClass().getName()).apply();
        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        this.getSharedPreferences().edit().putString("username", this.encrypt(username)).apply();
        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        this.getSharedPreferences().edit().putString("password", this.encrypt(password)).apply();
        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String[] tokens = appId.split("/");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Application ID should be in `app-name/number` format");
        }
        this.appId = tokens[0];
        this.apiKey = apiKey;
        this.senderId = tokens[1];
        this.getSharedPreferences().edit().putString("applicationId", this.encrypt(this.appId)).apply();
        this.getSharedPreferences().edit().putString("senderId", this.encrypt(this.senderId)).apply();
        Set storedChannels = this.getSharedPreferences().getStringSet("topics", new HashSet<String>(Arrays.asList(this.channels)));
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);
        String storedNotifSettings = this.getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                this.notificationSettings = new JSONObject(storedNotifSettings);
            }
            catch (JSONException jSONException) {
                jSONException.getMessage();
            }
        }
        if ((cache = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            notifs.addAll(cache);
        }
        this.isNewInstall = !this.getSharedPreferences().getBoolean("chabokInstallation", false);
        this.installDate = this.getSharedPreferences().getLong("installDate", -1L);
        if (this.installDate == -1L) {
            long unixTime = System.currentTimeMillis();
            this.getSharedPreferences().edit().putLong("installDate", unixTime).apply();
            this.installDate = unixTime;
        }
    }

    private void resetBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        alarm.cancel(this.getBackgroundIntent());
    }

    private void startBackgroundTimer() {
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        PendingIntent backgroundIntent = this.getBackgroundIntent();
        if (Build.VERSION.SDK_INT < 19) {
            alarm.set(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
            return;
        }
        alarm.setExact(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
    }

    private PendingIntent getBackgroundIntent() {
        Intent background = new Intent();
        background.setClass(this.getApplicationContext(), PushService.class);
        background.setAction("BackgroundTimeExceeded");
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)background, (int)0);
    }

    public void onEvent(ap gcmMessage) {
        Log.w((String)TAG, (String)("New GCM message (foreground:" + this.isForeground() + "): " + gcmMessage.getIntent().getExtras()));
        if (this.isForeground()) {
            Log.w((String)TAG, (String)"How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient that = this;
        this.isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"), new x(this, that, gcmMessage));
    }

    public void publish(PushMessage message, Callback clbk) {
        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new y(this, message, clbk), 0);
    }

    public void publish(String channel, String text, Callback clbk) {
        if (channel.contains("/")) {
            clbk.onFailure(new Throwable("Channel should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new aa(this, text, channel, clbk), 0);
    }

    public void publish(String user, String channel, String text, Callback clbk) {
        if (channel.contains("/") || user.contains("/")) {
            clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ac(this, text, channel, user, clbk), 0);
    }

    void publishMessageEvent(String subject, String messageId) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            this.emit(subject, messageId, obj, false, false);
            return;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)("Couldnt publish message event " + messageId), (Throwable)e2);
            return;
        }
    }

    public void publishEvent(String event, JSONObject data) {
        this.publishEvent(event, data, false, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live) {
        this.publishEvent(event, data, live, false);
    }

    public void publishEvent(String event, JSONObject data, boolean live, boolean stateful) {
        try {
            if (data.optLong("createdAt", 0L) == 0L) {
                data.put("createdAt", System.currentTimeMillis());
            }
            data.put("id", (Object)UUID.randomUUID().toString());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            this.eventBus.register(new ae(this, event, data, live, stateful));
            return;
        }
        this.emit(event, this.getInstallationId(), data, live, stateful);
    }

    private void emit(String event, String subject, JSONObject data, boolean live, boolean stateful) {
        String dataStr = "";
        if (data != null) {
            dataStr = data.toString();
            new StringBuilder("emit: data: ").append(dataStr).append(" , subject: ").append(subject);
        }
        String payload = dataStr;
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new af(this, event, subject, payload, live, stateful), 0);
    }

    private void isReceivedMessage(String messageId, Callback clbk) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new ag(this, clbk, messageId), 0);
    }

    public void getStatus(Callback<ConnectionStatus> clbk) {
        if (!PushService.isRunning(this.getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new b(this, clbk), 0);
    }

    public void subscribe(String channel, Callback clbk) {
        this.subscribe(channel, false, clbk);
    }

    public void subscribe(String channel, boolean live, Callback clbk) {
        if (!live) {
            HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
            allChannels.add(this.convertChannelName2OldConvention(channel));
            this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
            this.channels = allChannels.toArray(new String[allChannels.size()]);
            this.updateInstallation(new HashMap<String, Object>());
            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                RegistrationIntentService.subscribe(channel, this.getApplicationContext());
            }
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new c(this, channel, live, clbk), 0);
    }

    private String convertChannelName2OldConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        if (channel.startsWith("public/")) {
            return channel;
        }
        return "public/" + channel;
    }

    public void unsubscribe(String channel, Callback clbk) {
        HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
        allChannels.remove(this.convertChannelName2OldConvention(channel));
        this.getSharedPreferences().edit().putStringSet("topics", allChannels).apply();
        this.channels = allChannels.toArray(new String[allChannels.size()]);
        this.updateInstallation(new HashMap<String, Object>());
        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            RegistrationIntentService.unsubscribe(channel, this.getApplicationContext());
        }
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new d(this, channel, clbk), 0);
    }

    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        this.notificationSettings.remove(topicName);
        try {
            topicSetting.put("sound", (Object)sound);
            topicSetting.put("alert", alert);
            this.notificationSettings.put(topicName, (Object)topicSetting);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            HashMap<String, Object> props = new HashMap<String, Object>();
            HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
            if (notifSettings != null) {
                props.put("notificationSettings", notifSettings);
            }
            this.updateInstallation(props);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.getMessage();
            return;
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            this.eventBus.register(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            this.eventBus.post(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            this.eventBus.unregister(object);
        }
        return this;
    }

    public AdpPushClient setPushListener(Object ctx) {
        return this.addListener(ctx);
    }

    public AdpPushClient removePushListener(Object activity) {
        return this.removeListener(activity);
    }

    public AdpPushClient register(String userId) {
        return this._register(userId, new String[0]);
    }

    public AdpPushClient register(String userId, String[] channels) {
        return this._register(userId, channels);
    }

    private AdpPushClient reRegister(String userId) {
        return this.reRegister(userId, new String[0]);
    }

    private AdpPushClient reRegister(String userId, String[] channels) {
        this.unregister();
        this.register(userId, channels);
        return this;
    }

    private AdpPushClient _register(String userId, String[] channels) {
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            throw new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId);
        }
        if (!this.isValid(userId)) {
            throw new IllegalArgumentException("User ID is not valid: " + userId);
        }
        if (this.registering) {
            Log.w((String)TAG, (String)"Already in registering...");
            return this;
        }
        String currentUserId = this.getUserId();
        if (currentUserId != null && !userId.equalsIgnoreCase(currentUserId)) {
            return this.reRegister(userId, channels);
        }
        this.registeredOnce = false;
        this.userId = userId;
        this.getSharedPreferences().edit().putString("userId", this.encrypt(this.userId)).apply();
        HashSet<String> allTopics = new HashSet<String>(Arrays.asList(this.channels));
        ArrayList<String> newChannels = new ArrayList<String>();
        boolean userHasNewTopic = false;
        String[] stringArray = channels;
        int n2 = channels.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String ch = stringArray[i2];
            String chName = this.convertChannelName2OldConvention(ch);
            newChannels.add(chName);
            if (allTopics.contains(chName)) continue;
            userHasNewTopic = true;
        }
        allTopics.addAll(newChannels);
        if (userHasNewTopic) {
            this.makeSubsDirty();
        }
        this.getSharedPreferences().edit().putStringSet("topics", allTopics).apply();
        this.channels = allTopics.toArray(new String[allTopics.size()]);
        failed_tries = 0;
        if (!this.checkPlayServices()) {
            this.getSharedPreferences().edit().putBoolean("noGCM", true).apply();
            Log.w((String)TAG, (String)"No valid Google Play Services found.");
        } else {
            this.getSharedPreferences().edit().putBoolean("noGCM", false).apply();
        }
        this.doRegister();
        return this;
    }

    private boolean isValid(String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (userId.length() < 3 || userId.length() > 32) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !userId.matches(REGEX);
    }

    private void doRegister() {
        this.doRegister(false);
    }

    private void doRegister(boolean restartService) {
        if (this.userId == null) {
            Log.e((String)TAG, (String)"userId not initialized yet");
            return;
        }
        if (this.registering) {
            new StringBuilder("Register already in progress for ").append(this.userId);
            return;
        }
        this.registering = true;
        this.initializeAdapter();
        worker.schedule(new e(this, restartService), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        return this.adapter != null && this.adapter.isConnected();
    }

    public void dismiss() {
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    private boolean _checkPlayServices() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getApplicationContext());
        if (resultCode != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode) && this.currentActivity != null) {
                GooglePlayServicesUtil.getErrorDialog((int)resultCode, (Activity)this.currentActivity, (int)9000).show();
            } else {
                Log.w((String)"AdpPushLibrary", (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
        if (resultCode != 0 && resultCode != 2) {
            if (apiAvailability.isUserResolvableError(resultCode)) {
                apiAvailability.getErrorDialog(this.currentActivity, resultCode, 9000).show();
            } else {
                Log.i((String)TAG, (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private AdpPushClient updateRegistration(boolean restartService) {
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.restartServiceState = restartService;
        this.registerInBackground(installation);
        return this;
    }

    private void registerInBackground(b.a installation) {
        installation.setDeviceToken("---");
        this.getApplicationContext().startService(new Intent(this.getApplicationContext(), RegistrationIntentService.class));
    }

    public void onEvent(an token) {
        b.a installation = this.getLocalInstallation();
        new f(this, installation, token).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private void saveInstallation(b.a installation, boolean restartService) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("launchCount", this.getAppLaunchCount());
        props.put("launchTime", this.getAppLaunchTime());
        props.put("deviceId", this.getDeviceId());
        String uniqueId = this.getUniqueID();
        if (uniqueId != null && uniqueId.trim() != "") {
            props.put("uniqueId", uniqueId);
        }
        props.put("connection", ak.getNetworkClass(this.getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("clientVersion", this.getClientVersion());
        props.put("launched", this.isLaunched);
        props.put("newInstall", this.isNewInstall);
        HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
        if (notifSettings != null) {
            props.put("notificationSettings", notifSettings);
        }
        if (!this.getUserInfo().isEmpty()) {
            props.put("userInfo", this.getUserInfo());
        }
        props.put("installSource", this.getInstallSource());
        props.put("installDate", this.installDate);
        props.put("screenResolution", this.getDeviceScreenResolution());
        if (this.context != null && this.context.getPackageName() != null) {
            props.put("appBundleId", this.context.getPackageName());
        }
        try {
            if (NotificationManagerCompat.from((Context)this.context).areNotificationsEnabled()) {
                props.put("tokenStatus", "ALLOWED");
            } else {
                props.put("tokenStatus", "DENIED");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new g(this, installation, props, restartService).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private String getInstallSource() {
        try {
            if (this.context != null && this.context.getPackageManager() != null) {
                String installationSource;
                PackageManager pm = this.context.getPackageManager();
                if (this.context.getPackageName() != null && (installationSource = pm.getInstallerPackageName(this.context.getPackageName())) != null) {
                    return installationSource;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "notSet";
    }

    private String getDeviceScreenResolution() {
        Display display = this.currentActivity.getWindowManager().getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {}
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception exception) {}
        }
        return mWidthPixels + "x" + mHeightPixels;
    }

    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            HashMap<String, HashMap> notifSettings = new HashMap<String, HashMap>();
            Iterator channelSettings = this.notificationSettings.keys();
            while (channelSettings.hasNext()) {
                String topic = (String)channelSettings.next();
                JSONObject channelSetting = this.notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<String, String>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(topic, setting);
            }
            return notifSettings;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++failed_tries <= 10) {
            i retryTask = new i(this);
            long nextTry = (long)Math.max(Math.pow(2.0, failed_tries), 32.0);
            worker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    @Deprecated
    private String getDeviceId() {
        return Build.SERIAL;
    }

    private String getUniqueID() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    public String getClientVersion() {
        String userClientVersion = this.decrypt(this.getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                userClientVersion = this.getApplicationContext().getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return userClientVersion;
    }

    public void setClientVersion(String version) {
        this.getSharedPreferences().edit().putString("clientVersion", this.encrypt(version)).apply();
    }

    public void incBadge() {
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        int currentBadge = this.getSharedPreferences().getInt("androidBadge", 0);
        this.getSharedPreferences().edit().putInt("androidBadge", ++currentBadge).apply();
        this.eventBus.post(new BadgeUpdate(currentBadge));
        ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)currentBadge);
    }

    private void updateLaunchStats() {
        int count = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++count).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
        this.isLaunched = true;
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    private AdpPushClient setBadge(int badgeNumber) {
        this.getSharedPreferences().edit().putInt("androidBadge", badgeNumber).apply();
        this.eventBus.post(new BadgeUpdate(badgeNumber));
        ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)badgeNumber);
        return this;
    }

    public AdpPushClient resetBadge() {
        ((NotificationManager)this.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return this.setBadge(0);
    }

    public void unregister() {
        PushService.performAction(this.getApplicationContext(), "DISCONNECT");
        this.deleteInstallation(new j(this));
        this.getSharedPreferences().edit().remove("userId").apply();
        this.getSharedPreferences().edit().remove("installationId").apply();
        this.getSharedPreferences().edit().remove("topics").apply();
        this.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        this.getSharedPreferences().edit().remove("offlineCache").apply();
        this.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        this.getSharedPreferences().edit().remove("dataCache").apply();
        this.channels = new String[]{"default"};
    }

    public String getInstallationId() {
        String idJson = this.decrypt(this.getSharedPreferences().getString("installationId", null));
        if (idJson != null) {
            try {
                return (String)new JSONArray(idJson).get(0);
            }
            catch (JSONException jSONException) {
                new StringBuilder("Cannot parse installation id '").append(idJson).append("'");
            }
        }
        return null;
    }

    private void deleteInstallation(Callback clbk) {
        b.a installation;
        h<b.e> repository = this.adapter.createRepository("installation");
        b.e model = repository.createModel(d.a.getProperties(installation = new b.a(this.getApplicationContext(), this.adapter), false, false));
        if (model.getId() == null) {
            return;
        }
        model.destroy(new k(this, clbk, installation));
    }

    private void updateInstallation(Map<String, Object> properties) {
        this.updateInstallation(properties, new l(this));
    }

    private void updateInstallation(Map<String, Object> properties, Callback<b.a> clbk) {
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        properties.put("launched", this.isLaunched);
        properties.put("newInstall", this.isNewInstall);
        this.updateInstallation(installation, properties, clbk);
    }

    private b.a getLocalInstallation() {
        b.a installation = new b.a(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        return installation;
    }

    private void updateInstallation(b.a installation, Map<String, ?> properties, Callback<b.a> clbk) {
        b.e model = this.adapter.createRepository("installation").createModel(d.a.getProperties(installation, false, false));
        model.putAll(properties);
        new n(this, model, clbk, installation).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    public void requestVerificationCode(String userId, String media, Callback clbk) {
        h<b.e> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("appId", this.appId);
        map.put("media", media);
        repository.invokeStaticMethod("requestCode", map, new p(this, clbk));
    }

    private void requestCode(String userId, Callback clbk) {
        this.adapter.createRepository("verification").requestCode(userId, new q(this, clbk));
    }

    public void requestVerificationCode(String userId, Callback clbk) {
        this.requestCode(userId, clbk);
    }

    public void verifyUserCode(String userId, String code, Callback clbk) {
        h<b.e> repository = this.adapter.createRepository("verification");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("code", code);
        repository.invokeStaticMethod("verifyCode", map, new s(this, clbk));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && this.getActivityClass().getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener listener) {
        this.getForegroundManager().addListener(listener);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return this.activityClass;
    }

    private Context getApplicationContext() {
        return this.context;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getUserId() {
        return this.decrypt(this.getSharedPreferences().getString("userId", null));
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                return this.getApplicationContext().getPackageManager().getApplicationInfo((String)packageInfo.packageName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        this.notificationIconSilhouette = notificationIconSilhouette;
    }

    public HashMap<String, Object> getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(HashMap<String, Object> userInfo) {
        this.userInfo = userInfo;
    }

    public AdpPushClient setDevelopment(boolean isDev) {
        this.useDev = isDev;
        this.getSharedPreferences().edit().putBoolean("useDev", this.useDev).apply();
        this.initializeAdapter();
        return this;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    public void subscribeEvent(String eventName, Callback clbk) {
        this.subscribeEvent(eventName, "+", false, clbk);
    }

    public void subscribeEvent(String eventName, boolean live, Callback clbk) {
        this.subscribeEvent(eventName, "+", live, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, Callback clbk) {
        this.subscribeEvent(eventName, installationId, false, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, boolean live, Callback clbk) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new t(this, eventName, installationId, live, clbk), 0);
    }

    public void unsubscribeEvent(String eventName, Callback clbk) {
        this.unsubscribeEvent(eventName, "+", clbk);
    }

    public void unsubscribeEvent(String eventName, String installationId, Callback clbk) {
        this.getApplicationContext().bindService(new Intent(this.getApplicationContext(), PushService.class), (ServiceConnection)new u(this, eventName, installationId, clbk), 0);
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    private AdpPushClient setSecure(boolean isSecure) {
        this.useSecure = isSecure;
        this.initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        ArrayList<String> newChannels = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n2 = this.channels.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String ch = stringArray[i2];
            String chName = this.convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }
        return newChannels.toArray(new String[newChannels.size()]);
    }

    private String convertChannelName2newConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel;
        }
        if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        return "private/" + channel;
    }

    private SharedPreferences getSharedPreferences() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }

    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        this.currentActivity = currentActivity;
        return this;
    }

    void notifyNewMessage(PushMessage message) {
        Class clazz = this.activityClass;
        if (AdpPushClient.hasNotified(message.getId())) {
            return;
        }
        for (NotificationHandler h2 : this.handlers) {
            ChabokNotification notif;
            Class theirs = h2.getActivityClass(notif = new ChabokNotification(message, 0));
            if (theirs == null) continue;
            clazz = theirs;
        }
        GcmMessageHandler.sendNotification(this.getApplicationContext(), clazz, new ChabokNotification(message, 0));
    }

    boolean addNotifiedMessage(String id) {
        boolean val = notifs.add(id);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return val;
    }

    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        Class clazz = this.activityClass;
        String title = data.getString("title");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h2 : this.handlers) {
            ChabokNotification gcmNotif;
            Class theirs = h2.getActivityClass(gcmNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), Integer.valueOf(data.getString("androidBadge", "0")), data));
            if (theirs == null) continue;
            clazz = theirs;
        }
        return clazz;
    }

    boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        boolean showNotification = true;
        for (NotificationHandler h2 : this.handlers) {
            showNotification &= h2.buildNotification(notif, builder);
        }
        return showNotification;
    }

    public void addNotificationHandler(NotificationHandler handler) {
        this.handlers.add(handler);
    }

    public boolean hasProtectedAppSupport() {
        String deviceManufacturer = this.getDeviceManufacturer().toLowerCase();
        return !TextUtils.isEmpty((CharSequence)deviceManufacturer) && (deviceManufacturer.contains("huawei") || deviceManufacturer.contains("xiaomi"));
    }

    private String getDeviceManufacturer() {
        String deviceMan = Build.MANUFACTURER;
        Log.d((String)"deviceMan", (String)deviceMan);
        return deviceMan;
    }

    public void showProtectedAppSettings(Activity ctx, String app_name, String title, String msg) {
        title = title != null && !title.isEmpty() ? title : "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647";
        msg = msg != null && !msg.isEmpty() ? msg : String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", app_name);
        this.showGuide(ctx, title, msg);
    }

    private void showGuide(Activity ctx, String title, String message) {
        this.getApplicationContext();
        SharedPreferences settings = ctx.getSharedPreferences("ProtectedApps", 0);
        if (!settings.getBoolean("skipProtectedAppsMessage", false)) {
            SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                CheckBox dontShowAgain = new CheckBox(this.getApplicationContext());
                dontShowAgain.setTextColor(-16777216);
                dontShowAgain.setText((CharSequence)"     \u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                dontShowAgain.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new v(this, editor));
                new AlertDialog.Builder((Context)ctx).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setView((View)dontShowAgain).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new w(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            editor.putBoolean("skipProtectedAppsMessage", true);
            editor.apply();
        }
    }

    private boolean isCallable(Intent intent) {
        return this.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String getUserSerial() {
        Object userManager = this.getApplicationContext().getSystemService("user");
        if (userManager == null) {
            return "";
        }
        try {
            Object myUserHandle = Process.class.getMethod("myUserHandle", null).invoke(Process.class, null);
            Long userSerial = (Long)userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass()).invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    public String encrypt(String value) {
        try {
            byte[] bytes = value != null ? value.getBytes("UTF-8") : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(1, (Key)key, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(ah.encode(pbeCipher.doFinal(bytes), 2), "UTF-8");
        }
        catch (Exception e2) {
            this.getClass().getName();
            new StringBuilder("Warning, could not encrypt the value.  It may be stored in plaintext.  ").append(e2.getMessage());
            return value;
        }
    }

    public String decrypt(String value) {
        if (value == null) {
            return value;
        }
        try {
            byte[] bytes = value != null ? ah.decode(value, 0) : new byte[]{};
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(new PBEKeySpec("BEHRAD".toCharArray()));
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(2, (Key)key, new PBEParameterSpec(Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id").getBytes("UTF-8"), 20));
            return new String(pbeCipher.doFinal(bytes), "UTF-8");
        }
        catch (Exception e2) {
            this.getClass().getName();
            new StringBuilder("Warning, could not decrypt the value.  It may be stored in plaintext.  ").append(e2.getMessage());
            return value;
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !this.isGCMSupported();
    }

    public boolean isGCMSupported() {
        return !this.getSharedPreferences().getBoolean("noGCM", false);
    }

    public void addTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "addTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        try {
            this.getLocalInstallation().addTag(URLEncoder.encode(tagName.trim(), "UTF-8"), callback);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException e2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            callback.onFailure(e2);
            return;
        }
    }

    public void removeTag(String tagName, Callback callback) {
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tagName)) {
            String msg = "removeTag: tag is empty";
            Log.e((String)TAG, (String)msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        try {
            this.getLocalInstallation().removeTag(URLEncoder.encode(tagName.trim(), "UTF-8"), callback);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException e2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            callback.onFailure(e2);
            return;
        }
    }

    static /* synthetic */ boolean access$000(AdpPushClient x0) {
        return x0.isFreshStart;
    }

    static /* synthetic */ void access$100(AdpPushClient x0) {
        x0.updateLaunchStats();
    }

    static /* synthetic */ f.c access$200(AdpPushClient x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$300(AdpPushClient x0) {
        return x0.isNewInstall;
    }

    static /* synthetic */ void access$400(AdpPushClient x0) {
        x0.doRegister();
    }

    static /* synthetic */ boolean access$002(AdpPushClient x0, boolean x1) {
        x0.isFreshStart = x1;
        return x0.isFreshStart;
    }

    static /* synthetic */ Context access$500(AdpPushClient x0) {
        return x0.getApplicationContext();
    }

    static /* synthetic */ void access$600(AdpPushClient x0) {
        x0.resetBackgroundTimer();
    }

    static /* synthetic */ void access$700(AdpPushClient x0) {
        x0.startBackgroundTimer();
    }

    static /* synthetic */ Activity access$802(AdpPushClient x0, Activity x1) {
        x0.currentActivity = x1;
        return x0.currentActivity;
    }

    static /* synthetic */ boolean access$900(AdpPushClient x0) {
        return x0.registeredOnce;
    }

    static /* synthetic */ boolean access$1002(AdpPushClient x0, boolean x1) {
        x0.registering = x1;
        return x0.registering;
    }

    static /* synthetic */ ForegroundManager access$1100(AdpPushClient x0) {
        return x0.foreground;
    }

    static /* synthetic */ AdpPushClient access$1200(AdpPushClient x0, boolean x1) {
        return x0.updateRegistration(x1);
    }

    static /* synthetic */ boolean access$1300(AdpPushClient x0) {
        return x0.restartServiceState;
    }

    static /* synthetic */ void access$1400(AdpPushClient x0, b.a x1, boolean x2) {
        x0.saveInstallation(x1, x2);
    }

    static /* synthetic */ boolean access$1302(AdpPushClient x0, boolean x1) {
        x0.restartServiceState = x1;
        return x0.restartServiceState;
    }

    static /* synthetic */ boolean access$902(AdpPushClient x0, boolean x1) {
        x0.registeredOnce = x1;
        return x0.registeredOnce;
    }

    static /* synthetic */ int access$1502(int x0) {
        failed_tries = x0;
        return failed_tries;
    }

    static /* synthetic */ boolean access$302(AdpPushClient x0, boolean x1) {
        x0.isNewInstall = x1;
        return x0.isNewInstall;
    }

    static /* synthetic */ SharedPreferences access$1600(AdpPushClient x0) {
        return x0.getSharedPreferences();
    }

    static /* synthetic */ boolean access$1702(AdpPushClient x0, boolean x1) {
        x0.isLaunched = x1;
        return x0.isLaunched;
    }

    static /* synthetic */ void access$1800(AdpPushClient x0) {
        x0.retryRegistrationBackoff();
    }

    static /* synthetic */ void access$1900(AdpPushClient x0) {
        x0.huaweiProtectedApps();
    }

    static {
        FORCE_STICKY = false;
        failed_tries = 0;
        notifs = new ai<String>(200);
        pushClientInstance = null;
    }
}

