/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ak;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessage
extends ak {
    private long createdAt;
    private boolean inApp = false;
    private boolean live = false;
    private boolean stateful = false;
    private long expireAt;
    protected String body;
    private JSONObject data;
    private JSONObject notification;
    private String senderId;
    private String sentId;
    private boolean notify = true;
    private boolean useAsAlert = false;
    private String alertText;
    private String alertTitle;
    private String sound;

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isInApp() {
        return this.inApp;
    }

    public void setInApp(boolean inApp) {
        this.inApp = inApp;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(long expireAt) {
        this.expireAt = expireAt;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public JSONObject getNotification() {
        return this.notification;
    }

    public void setNotification(JSONObject notification) {
        this.notification = notification;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getSentId() {
        return this.sentId;
    }

    public void setSentId(String sentId) {
        this.sentId = sentId;
    }

    public boolean isUseAsAlert() {
        return this.useAsAlert;
    }

    public void setUseAsAlert(boolean useAsAlert) {
        this.useAsAlert = useAsAlert;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public String getAlertTitle() {
        return this.alertTitle;
    }

    public void setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public static PushMessage fromJson(String jsonString, String channel) {
        PushMessage push = new PushMessage();
        try {
            JSONObject notif;
            String[] tokens;
            JSONObject jsonMessage = new JSONObject(jsonString);
            push.setChannel(channel);
            push.setId(jsonMessage.getString("id"));
            push.setCreatedAt(jsonMessage.getLong("createdAt"));
            push.setReceivedAt(System.currentTimeMillis());
            push.setBody(jsonMessage.optString("content"));
            push.setData(jsonMessage.optJSONObject("data"));
            long ttl = jsonMessage.optLong("ttl", 0L);
            if (ttl > 0L) {
                push.setExpireAt(push.getCreatedAt() + ttl * 1000L);
            }
            push.setInApp(jsonMessage.optBoolean("inApp"));
            push.setLive(jsonMessage.optBoolean("live"));
            push.setNotify(!jsonMessage.optBoolean("silent", false));
            push.setStateful(jsonMessage.optBoolean("stateful"));
            String publishId = jsonMessage.optString("publishId");
            if (publishId != null && (tokens = publishId.split("/")).length == 3) {
                push.setSenderId(tokens[0]);
                push.setSentId(tokens[2]);
            }
            if ((notif = jsonMessage.optJSONObject("notification")) != null) {
                push.setNotification(notif);
                push.setAlertTitle(notif.optString("title"));
                push.setAlertText(notif.optString("text"));
                push.setAlertText(notif.optString("body"));
                push.setSound(notif.optString("sound"));
            }
            return push;
        }
        catch (JSONException e2) {
            throw new IllegalArgumentException("Invalid Json " + e2.getMessage());
        }
    }

    public String toJson() {
        try {
            JSONObject jsonMessage = new JSONObject();
            jsonMessage.put("id", (Object)this.id);
            jsonMessage.put("createdAt", this.createdAt);
            if (this.body != null) {
                jsonMessage.put("content", (Object)this.body);
            }
            if (this.expireAt > 0L) {
                long ttl = (this.getExpireAt() - this.getCreatedAt()) / 1000L;
                jsonMessage.put("ttl", ttl);
            }
            if (this.inApp) {
                jsonMessage.put("inApp", true);
            }
            if (!this.notify) {
                jsonMessage.put("silent", true);
            }
            if (this.stateful) {
                jsonMessage.put("stateful", true);
            }
            if (this.useAsAlert) {
                jsonMessage.put("useAsAlert", true);
            }
            if (this.alertText != null) {
                jsonMessage.put("alertText", (Object)this.alertText);
            }
            if (this.alertTitle != null) {
                JSONObject obj = new JSONObject();
                obj.put("title", (Object)this.alertTitle);
                jsonMessage.put("notification", (Object)obj);
            }
            if (this.data != null) {
                jsonMessage.put("data", (Object)this.data);
            }
            return jsonMessage.toString();
        }
        catch (JSONException e2) {
            throw new IllegalArgumentException("Invalid Json " + e2.getMessage());
        }
    }

    public String toString() {
        return "PushMessage{id='" + this.id + '\'' + ", createdAt=" + this.createdAt + ", channel='" + this.channel + '\'' + ", inapp='" + this.inApp + '\'' + ", stateful='" + this.stateful + '\'' + ", data='" + (this.data != null ? this.data.toString() : "null") + '\'' + '}';
    }

    @Override
    public String getIntentType() {
        return "com.adpdigital.push.client.MSGRECEIVE";
    }

    public void markAsRead() {
        PushMessage.markAsRead(this.id);
    }

    public static void markAsRead(String messageId) {
        AdpPushClient.get().publishMessageEvent("seen", messageId);
    }

    public void dismiss() {
        PushMessage.messageDismissed(this.id);
    }

    public static void messageDismissed(String messageId) {
        AdpPushClient.get().publishMessageEvent("dismiss", messageId);
    }
}

