/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import b.a;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.PushService;
import com.adpdigital.push.ar;
import com.adpdigital.push.bm;
import com.google.android.gms.gcm.GcmListenerService;
import f.c;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.leolin.shortcutbadger.ShortcutBadger;

public class GcmMessageHandler
extends GcmListenerService {
    public static final String TAG = GcmMessageHandler.class.getName();
    private static int a = 0;
    private c b = f.c.getDefault();
    private static final ScheduledExecutorService c = Executors.newSingleThreadScheduledExecutor();

    public GcmMessageHandler() {
        this.b.register((Object)this);
    }

    public void onMessageReceived(String from, Bundle data) {
        String currentDeviceId;
        new StringBuilder("@@@@@@@@@@@@@@@@@ FCM Notification on ").append(from).append(": ").append(data);
        String deviceId = data.getString("deviceId");
        if (deviceId != null && !deviceId.equalsIgnoreCase(currentDeviceId = AdpPushClient.get().getInstallationId())) {
            new StringBuilder("Ignoring FCM, unmatched deviceId ").append(deviceId).append(" != ").append(currentDeviceId);
            return;
        }
        String alertText = data.getString("message");
        if (alertText == null || alertText.equalsIgnoreCase("")) {
            return;
        }
        String messageId = data.getString("messageId");
        if (messageId != null && PushService.a(messageId)) {
            return;
        }
        String pushPayload = data.getString("push");
        String topicName = "app/" + AdpPushClient.get().getAppId() + "/user/" + AdpPushClient.get().getUserId() + "/" + data.getString("collapse_key");
        ChabokNotification notification = new ChabokNotification(messageId, data.getString("messageFrom"), alertText, Integer.valueOf(data.getString("androidBadge", "0")) + this.a(), data);
        notification.setTopicName(data.getString("collapse_key"));
        try {
            if (AdpPushClient.get().isForeground()) {
                Log.w((String)TAG, (String)"Don't notify GCM when app is foreground!");
                return;
            }
            try {
                if (messageId != null && (PushService.a(messageId) || AdpPushClient.hasNotified(messageId))) {
                    return;
                }
                Class activityToOpen = AdpPushClient.get().getNotifActivityClass(data);
                GcmMessageHandler ctx = this;
                ar notifTask = new ar(this, pushPayload, topicName, (Context)ctx, activityToOpen, notification);
                c.schedule(notifTask, 0L, TimeUnit.SECONDS);
                return;
            }
            catch (ClassNotFoundException e2) {
                Log.e((String)TAG, (String)"cannot send notification when no subscriber for Intents", (Throwable)e2);
                return;
            }
        }
        catch (Exception exception) {
            GcmMessageHandler.sendNotification((Context)this, null, notification);
            return;
        }
    }

    public void onEvent(bm event) {
        Log.w((String)TAG, (String)("Should? Notify GCM message (canNotify,isCanceled): " + event.isCanNofity() + "," + event.isCanceled()));
        if (!event.isCanceled()) {
            bm bm2 = event;
            GcmMessageHandler gcmMessageHandler = this;
            ChabokNotification chabokNotification = new ChabokNotification(bm2.getIntent().getExtras().getString("messageId"), bm2.getIntent().getExtras().getString("messageFrom"), bm2.getIntent().getExtras().getString("message"), Integer.valueOf(bm2.getIntent().getExtras().getString("androidBadge", "0")) + gcmMessageHandler.a(), bm2.getIntent().getExtras());
            GcmMessageHandler.sendNotification((Context)gcmMessageHandler, bm2.getClient().getActivityClass(), chabokNotification);
        }
    }

    @TargetApi(value=16)
    public static void sendNotification(Context ctx, Class viewClass, ChabokNotification msg) {
        try {
            PackageInfo packageInfo = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            ApplicationInfo appInfo = ctx.getPackageManager().getApplicationInfo(packageInfo.packageName, 0);
            NotificationManagerCompat mNotificationManager = NotificationManagerCompat.from((Context)ctx);
            Intent intent = viewClass != null ? new Intent(ctx, viewClass) : new Intent();
            intent.setFlags(0x4000000);
            intent.putExtra("CHABOK_NOTIFICATION", true);
            if (viewClass != null) {
                intent.putExtra("CHABOK_NOTIFICATION_HANDLER", viewClass.getName());
            }
            String msgId = msg.getId();
            if (msg.getExtras() != null) {
                Log.i((String)TAG, (String)("Notification Extras " + msg.getExtras()));
                intent.putExtras(msg.getExtras());
                if (msg.getExtras().getString("messageId") != null) {
                    msgId = msg.getExtras().getString("messageId");
                }
            }
            if (msg.getMessage() != null) {
                msg.setTopicName(msg.getMessage().getChannel());
                intent.putExtra("collapse_key", msg.getMessage().getChannel());
                intent.putExtra("messageId", msg.getMessage().getId());
                if (msg.getMessage().getData() != null) {
                    intent.putExtra("data", msg.getMessage().getData().toString());
                }
                intent.putExtra("live", msg.getMessage().isLive());
                intent.putExtra("stateful", msg.getMessage().isStateful());
                intent.putExtra("inapp", msg.getMessage().isInApp());
                intent.putExtra("topicName", msg.getMessage().getChannel());
                intent.putExtra("expireAt", msg.getMessage().getExpireAt());
                intent.putExtra("receivedAt", msg.getMessage().getReceivedAt());
            }
            if (msgId != null) {
                AdpPushClient.get().addNotifiedMessage(msgId);
            }
            int uniqueInt = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)ctx, (int)uniqueInt, (Intent)intent, (int)0x8000000);
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(ctx).setAutoCancel(true).setPriority(1).setContentTitle(appInfo.nonLocalizedLabel).setTicker((CharSequence)msg.getText()).setContentText((CharSequence)msg.getText()).setContentIntent(contentIntent);
            mBuilder.setSmallIcon(Build.VERSION.SDK_INT >= 21 ? AdpPushClient.get().getNotificationIconSilhouette() : AdpPushClient.get().getNotificationIcon());
            Bitmap bm2 = BitmapFactory.decodeResource((Resources)ctx.getResources(), (int)appInfo.icon);
            mBuilder.setLargeIcon(bm2);
            HashMap<String, HashMap> settings = AdpPushClient.get().getNotificationSettings();
            if (settings != null && settings.containsKey(msg.getTopicName())) {
                msg.setAlert(Boolean.getBoolean(settings.get(msg.getTopicName()).get("alert").toString()));
                if (settings.get(msg.getTopicName()).get("sound") != null) {
                    msg.setSound((String)settings.get(msg.getTopicName()).get("sound"));
                }
            } else if (settings != null) {
                new StringBuilder("No Notification settings? ").append(Arrays.toString(settings.keySet().toArray())).append(", ").append(msg.getTopicName());
            } else {
                new StringBuilder("No Notification settings = null ").append(msg.getTopicName());
            }
            if (msg.isAlert()) {
                if (msg.getSound() != null) {
                    mBuilder.setSound(Uri.parse((String)("android.resource://" + ctx.getPackageName() + "/" + msg.getSound())));
                } else {
                    mBuilder.setSound(RingtoneManager.getActualDefaultRingtoneUri((Context)ctx, (int)2));
                }
            }
            if (Build.VERSION.SDK_INT >= 21) {
                mBuilder.setVisibility(1);
            }
            Notification notif = mBuilder.build();
            AdpPushClient.get().incBadge();
            ShortcutBadger.applyNotification((Context)ctx, (Notification)notif, (int)AdpPushClient.get().getBadge());
            if (AdpPushClient.get().prepareNotification(msg, mBuilder)) {
                mNotificationManager.notify(++a, notif);
            }
            return;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)"Error notifying user ", (Throwable)e2);
            return;
        }
    }

    private int a() {
        return this.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0).getInt("androidUnseenBadge", 0);
    }

    public void onDestroy() {
        this.b.unregister((Object)this);
        super.onDestroy();
    }

    static /* synthetic */ SharedPreferences a(GcmMessageHandler x0) {
        return x0.getApplicationContext().getSharedPreferences(b.a.SHARED_PREFERENCES_NAME, 0);
    }
}

