/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import com.adpdigital.push.location.LocationAccuracy;

public final class LocationParams {
    public static final LocationParams NAVIGATION = new Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(500L).build();
    public static final LocationParams BEST_EFFORT = new Builder().setAccuracy(LocationAccuracy.MEDIUM).setDistance(150.0f).setInterval(2500L).build();
    public static final LocationParams LAZY = new Builder().setAccuracy(LocationAccuracy.LOW).setDistance(500.0f).setInterval(5000L).build();
    private long NZV;
    private float MRR;
    private LocationAccuracy OJW;

    /*
     * WARNING - void declaration
     */
    LocationParams(LocationAccuracy accuracy, long interval, float distance) {
        void var1_1;
        void var2_2;
        this.NZV = var2_2;
        this.MRR = distance;
        this.OJW = var1_1;
    }

    public final long getInterval() {
        return this.NZV;
    }

    public final float getDistance() {
        return this.MRR;
    }

    public final LocationAccuracy getAccuracy() {
        return this.OJW;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationParams)) {
            return false;
        }
        LocationParams that = (LocationParams)o;
        return Float.compare(that.MRR, this.MRR) == 0 && this.NZV == that.NZV && this.OJW == var1_1.OJW;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = (int)(this.NZV ^ this.NZV >>> 32);
        result = result * 31 + (this.MRR != 0.0f ? Float.floatToIntBits(this.MRR) : 0);
        var1_1 = var1_1 * 31 + this.OJW.hashCode();
        return (int)var1_1;
    }

    public static class Builder {
        private LocationAccuracy accuracy = LocationAccuracy.MEDIUM;
        private long interval = 2500L;
        private float distance = 150.0f;

        /*
         * WARNING - void declaration
         */
        public Builder setAccuracy(LocationAccuracy accuracy) {
            void var1_1;
            this.accuracy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInterval(long interval) {
            void var1_1;
            this.interval = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDistance(float distance) {
            void var1_1;
            this.distance = var1_1;
            return this;
        }

        public LocationParams build() {
            return new LocationParams(this.accuracy, this.interval, this.distance);
        }
    }
}

