/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.HGC;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.location.AOP;
import com.adpdigital.push.location.DYH;
import com.adpdigital.push.location.GeofenceParams;
import com.adpdigital.push.location.HXH;
import com.adpdigital.push.location.KEM;
import com.adpdigital.push.location.LocationAccuracy;
import com.adpdigital.push.location.LocationEvent;
import com.adpdigital.push.location.LocationMode;
import com.adpdigital.push.location.LocationParams;
import com.adpdigital.push.location.LocationService;
import com.adpdigital.push.location.OJW;
import com.adpdigital.push.location.OnLocationUpdateListener;
import com.adpdigital.push.location.VMB;
import com.adpdigital.push.location.XTU;
import com.adpdigital.push.location.YCE;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static final String LOCATION_KEY = "location-key";
    private static LocationManager NZV;
    private GoogleApiClient MRR;
    private LocationRequest OJW;
    private OnLocationUpdateListener HUI;
    private Context YCE;
    private Location XTU;
    private LocationAccuracy VMB;
    private boolean AOP = false;
    private long DYH = 1000L;
    private long KEM;
    private float IZX;
    private SharedPreferences HXH;
    private boolean UFF = false;
    private Intent LMH;
    private NZV SUU;

    /*
     * WARNING - void declaration
     */
    public void setWaitDurationBeforePublish(long waitDuration) {
        void var1_1;
        this.DYH = var1_1 * 1000L;
    }

    public static LocationManager init(Context context) {
        HGC.d("LocationManager", "Called init in LocationManager.");
        if (NZV == null) {
            Context context2;
            NZV = new LocationManager(context2);
        }
        return NZV;
    }

    /*
     * WARNING - void declaration
     */
    private LocationManager(Context context) {
        void var1_1;
        this.YCE = context;
        this.HXH = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.MRR = new GoogleApiClient.Builder((Context)var1_1).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.MRR.connect();
        AdpPushClient.get().addListener(this);
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(PushMessage message) {
        HGC.d("LocationManager", "Got a push, is it a geofence?");
        if (message.getData() != null && message.getData().has("geofence")) {
            HGC.d("LocationManager", "Yes it is a geofence push");
            try {
                void var2_2;
                JSONObject geofence = message.getData().getJSONObject("geofence");
                JSONArray center = geofence.has("center") ? geofence.getJSONArray("center") : null;
                if (center == null) {
                    if (geofence.has("id")) {
                        void var1_1;
                        HGC.d("LocationManager", "removeGeofenceById " + geofence.getString("id"));
                        this.removeGeofenceById(var1_1.getString("id"));
                    }
                    return;
                }
                long expireTime = geofence.has("expire") && geofence.get("expire") != null ? geofence.getLong("expire") : Calendar.getInstance().getTime().getTime() + 3600000L;
                HGC.d("LocationManager", "setUpGeofence " + geofence);
                this.setUpGeofence(new GeofenceParams.Builder().setCenter(geofence.getString("id"), center.optDouble(0), var2_2.optDouble(1)).setExpire(expireTime).setRadius(geofence.getInt("r")).build(), geofence.has("enter") ? geofence.getString("enter") : "entering", geofence.has("exit") ? geofence.getString("exit") : "exiting", geofence.getInt("count"));
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUpGeofence(GeofenceParams params, String enterMessage, String exitMessage, int count) {
        HGC.d("LocationManager", "setUpGeofence: called");
        long now = Calendar.getInstance().getTime().getTime();
        if (params.getExpire() - now > 0L) {
            long duration = params.getExpire() - now;
            Geofence geofence = new Geofence.Builder().setRequestId(params.getId()).setCircularRegion(params.getLatitude(), params.getLongitude(), params.getRadius()).setTransitionTypes(3).setExpirationDuration(duration).build();
            if (!TextUtils.isEmpty((CharSequence)enterMessage)) {
                void var2_2;
                this.HXH.edit().putString("enter_message" + params.getId(), (String)var2_2).apply();
            }
            if (!TextUtils.isEmpty((CharSequence)exitMessage)) {
                void var3_3;
                this.HXH.edit().putString("exit_message" + params.getId(), (String)var3_3).apply();
            }
            if (count > 0) {
                void var1_1;
                this.HXH.edit().putInt("key_count" + var1_1.getId(), count).apply();
            }
            if (this.MRR.isConnected()) {
                this.NZV(geofence);
                return;
            }
            AdpPushClient.get().addListener(new OJW(this, geofence));
            this.MRR.connect();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeGeofenceById(String geofenceId) {
        void var2_2;
        void var1_1;
        ArrayList<void> geofenceIds = new ArrayList<void>();
        geofenceIds.add(var1_1);
        this.removeGeofencesByIds((List<String>)var2_2);
    }

    public void removeGeofencesByIds(List<String> geofenceIds) {
        if (this.MRR != null && this.MRR.isConnected()) {
            PendingResult pendingResult;
            pendingResult = LocationServices.GeofencingApi.removeGeofences(this.MRR, (List)pendingResult);
            pendingResult.setResultCallback((ResultCallback)new YCE(this));
        }
    }

    private void NZV(Geofence geofence) {
        GeofencingRequest.Builder builder;
        PendingResult pendingResult;
        ArrayList<void> mGeofenceList = new ArrayList<void>();
        mGeofenceList.add((void)pendingResult);
        pendingResult = builder;
        builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences((List)pendingResult);
        pendingResult = LocationServices.GeofencingApi.addGeofences(this.MRR, builder.build(), this.HUI());
        pendingResult.setResultCallback((ResultCallback)new XTU(this));
    }

    /*
     * WARNING - void declaration
     */
    public void startTrackingMe(long duration, long interval, float distance) {
        void var3_2;
        void var1_1;
        HGC.d("LocationManager", "startTrackingMe: called, duration: " + duration + " ,interval: " + interval);
        this.HXH.edit().putString("location_mode", "Tracking").apply();
        this.enableBackgroundMode();
        this.HXH.edit().putLong("duration", (long)var1_1).apply();
        this.HXH.edit().putFloat("distance", distance).apply();
        this.HXH.edit().putLong("interval", (long)var3_2).apply();
        this.HXH.edit().putLong("start_time", Calendar.getInstance().getTimeInMillis()).apply();
        this.XTU = null;
        this.NZV();
    }

    /*
     * WARNING - void declaration
     */
    private void NZV() {
        void var1_1;
        LocationParams initialParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(0L).build();
        this.startLocationUpdates((LocationParams)var1_1);
    }

    public void startLocationUpdates(LocationParams params) {
        LocationManager locationManager;
        HGC.d("LocationManager", "startLocationUpdates: called");
        void var2_2 = locationManager;
        locationManager = this;
        this.KEM = var2_2.getInterval();
        locationManager.IZX = var2_2.getDistance();
        locationManager.VMB = var2_2.getAccuracy();
        locationManager = LocationRequest.create().setFastestInterval(locationManager.KEM).setInterval(locationManager.KEM).setSmallestDisplacement(locationManager.IZX);
        switch (var2_2.getAccuracy()) {
            case HIGH: {
                locationManager.setPriority(100);
                break;
            }
            case MEDIUM: {
                locationManager.setPriority(102);
                break;
            }
            case LOW: {
                locationManager.setPriority(104);
                break;
            }
            case LOWEST: {
                locationManager.setPriority(105);
            }
        }
        this.OJW = locationManager;
        if (this.MRR.isConnected()) {
            this.OJW();
            return;
        }
        this.SUU = new VMB(this);
        this.MRR.connect();
    }

    public void requestSingleLocation(LocationListener listener) {
        if (this.XTU()) {
            HGC.d("LocationManager", "requestSingleLocation is ignored when in tracking mode!");
            return;
        }
        HGC.d("LocationManager", "requestSingleLocation: called");
        this.HXH.edit().putString("location_mode", "Single").apply();
        this.enableBackgroundMode();
        this.XTU = null;
        this.NZV();
    }

    private void MRR() {
        this.HXH.edit().putLong("listening_start_time", Calendar.getInstance().getTimeInMillis()).apply();
    }

    public void connect() {
        HGC.d("LocationManager", "connect: ");
        if (this.MRR != null && !this.MRR.isConnected()) {
            this.MRR.connect();
        }
    }

    public void resume() {
        HGC.d("LocationManager", "resume Connected=" + this.MRR.isConnected());
        if (this.MRR.isConnected()) {
            this.OJW();
            return;
        }
        this.MRR.connect();
    }

    /*
     * WARNING - void declaration
     */
    public void stop() {
        HGC.d("LocationManager", "stop");
        if (this.MRR != null && this.MRR.isConnected()) {
            AOP callback = new AOP(this);
            com.adpdigital.push.location.NZV handler = new com.adpdigital.push.location.NZV(1, callback);
            if (!this.AOP) {
                void var1_1;
                LocationManager locationManager = this;
                HGC.d("LocationManager", "stopService: called");
                PendingIntent pendingIntent = locationManager.HUI();
                PendingResult result1 = LocationServices.FusedLocationApi.removeLocationUpdates(locationManager.MRR, pendingIntent);
                var1_1.check((PendingResult<Status>)locationManager);
            }
        }
    }

    public boolean isConnected() {
        return this.MRR.isConnected();
    }

    private void OJW() {
        HGC.d("LocationManager", "start: called, backgoundMode: " + this.AOP);
        if (ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            HGC.w("LocationManager", "Permission check failed. Please handle it in your app before setting up location");
            return;
        }
        LocationManager locationManager = this;
        HGC.d("LocationManager", "startService: Creating location service request");
        PendingIntent pendingIntent = locationManager.HUI();
        LocationServices.FusedLocationApi.requestLocationUpdates(locationManager.MRR, locationManager.OJW, pendingIntent);
    }

    /*
     * WARNING - void declaration
     */
    private PendingIntent HUI() {
        void var1_1;
        Intent intent = new Intent(this.YCE, LocationService.class);
        return PendingIntent.getService((Context)this.YCE, (int)1, (Intent)var1_1, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public Location getLastLocation() {
        if (this.XTU != null) {
            return this.XTU;
        }
        if (this.MRR != null && this.MRR.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                HGC.e("LocationManager", "No permission available to get last location");
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.MRR);
            if (location != null) {
                void var1_1;
                return var1_1;
            }
            HGC.e("LocationManager", "No location from fused getLastLocation");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void onConnected(@Nullable Bundle bundle) {
        HGC.d("LocationManager", "onConnected: called");
        AdpPushClient.get().notify((Object)LocationEvent.CONNECTED);
        if (this.SUU != null) {
            this.SUU.onConnect();
            this.SUU = null;
        }
        if (this.HUI != null) {
            void var1_1;
            this.HUI.onConnected((Bundle)var1_1);
        }
    }

    public void onConnectionSuspended(int i) {
        if (this.HUI != null) {
            this.HUI.onSuspended();
        }
        HGC.d("LocationManager", "onConnectionSuspended: ");
    }

    /*
     * WARNING - void declaration
     */
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        if (this.HUI != null) {
            void var1_1;
            this.HUI.onConnectionFailed((ConnectionResult)var1_1);
        }
        HGC.d("LocationManager", "onConnectionFailed: ");
    }

    private void YCE() {
        LocationManager locationManager;
        HGC.d("LocationManager", "updateStateAndSendLocation: called");
        if (this.LMH == null) {
            this.LMH = this.VMB();
        }
        if (this.LMH != null) {
            locationManager = this;
            try {
                HGC.d("LocationManager", "sendPendingIntent: called");
                Bundle bundle = new Bundle();
                bundle.putParcelable(LOCATION_KEY, (Parcelable)locationManager.XTU);
                locationManager.LMH.putExtras(bundle);
                locationManager = PendingIntent.getService((Context)locationManager.YCE, (int)0, (Intent)locationManager.LMH, (int)0);
                locationManager.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                PendingIntent.CanceledException canceledException2 = canceledException;
                canceledException.printStackTrace();
            }
        }
        AdpPushClient.get().notify(this.XTU);
        this.publishLocation(this.XTU);
        this.MRR();
        if (this.HUI != null) {
            this.HUI.onLocationUpdated(this.XTU);
        }
        if (this.XTU()) {
            HGC.d("LocationManager", "updateStateAndSendLocation: isInTrackingMode");
            if ("Tracking".equalsIgnoreCase(this.HXH.getString("location_mode", ""))) {
                this.disableBackgroundMode();
                this.stop();
                locationManager = new Handler();
                locationManager.postDelayed(new KEM(this), 500L);
                return;
            }
        } else if ("Single".equalsIgnoreCase(this.HXH.getString("location_mode", "")) || this.HXH.getLong("duration", 0L) != 0L) {
            HGC.d("LocationManager", "updateStateAndSendLocation: time elapsed, provider: " + this.XTU.getProvider() + " ," + this.XTU);
            this.HXH.edit().putString("location_mode", "").apply();
            this.disableBackgroundMode();
            this.stop();
            AdpPushClient.get().notify((Object)LocationMode.TRACKING_STOPPED);
            if (this.HXH.getLong("duration", 0L) != 0L) {
                this.HXH.edit().putLong("duration", 0L).apply();
                HGC.d("LocationManager", "updateStateAndSendLocation, tracking stopped");
            }
            if (AdpPushClient.get().isBackground()) {
                PushService.performAction(this.YCE, "DISCONNECT");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean XTU() {
        void var1_1;
        void var3_2;
        long duration = this.HXH.getLong("duration", 0L);
        long start = this.HXH.getLong("start_time", 0L);
        return duration > 0L && Calendar.getInstance().getTimeInMillis() - var3_2 < var1_1 * 1000L;
    }

    public void enableLocationOnLaunch() {
        if (this.XTU()) {
            HGC.d("LocationManager", "enableLocationOnLaunch is ignored when in tracking mode!");
            return;
        }
        this.requestSingleLocation(new HXH(this));
    }

    /*
     * WARNING - void declaration
     */
    public void publishLocation(Location location) {
        try {
            void var1_1;
            JSONObject data = new JSONObject();
            data.put("lat", location.getLatitude());
            data.put("lng", location.getLongitude());
            data.put("ts", var1_1.getTime());
            AdpPushClient.get().publishEvent("geo", data);
            return;
        }
        catch (JSONException e) {
            void var2_3;
            HGC.e("LocationManager", "Cant publish geo location event ", (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(OnLocationUpdateListener listener) {
        void var1_1;
        this.HUI = var1_1;
    }

    public void removeListener() {
        this.HUI = null;
    }

    public long getIntervel() {
        return this.KEM;
    }

    public float getDistance() {
        return this.IZX;
    }

    public LocationAccuracy getAccuracy() {
        return this.VMB;
    }

    public void enableBackgroundMode() {
        this.AOP = true;
    }

    public void disableBackgroundMode() {
        HGC.d("LocationManager", "disableBackgroundMode: called");
        this.AOP = false;
    }

    public boolean isBackgoundModeEnabled() {
        return this.AOP;
    }

    /*
     * WARNING - void declaration
     */
    public void onEnteredGeofences(String[] geofenceIds, Location location) {
        void var1_1;
        HGC.d("LocationManager", "onEnteredGeofences: called");
        for (void id2 : var1_1) {
            int count = this.HXH.getInt("key_count" + (String)id2, 0);
            if (count > 0) {
                HGC.d("LocationManager", "onEnteredGeofences: count: " + count + "location = " + location);
                String message = this.HXH.getString("enter_message" + (String)id2, "");
                this.NZV((String)id2 + count, (String)id2, message);
                this.HXH.edit().putInt("key_count" + (String)id2, count - 1).apply();
                continue;
            }
            this.HXH.edit().remove("key_count" + (String)id2).apply();
            this.HXH.edit().remove("enter_message" + (String)id2).apply();
            this.removeGeofenceById((String)id2);
        }
    }

    public void onExitedGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n = geofenceIds.length;
        for (int i = 0; i < n; ++i) {
            String id2 = stringArray[i];
            int count = this.HXH.getInt("key_count" + id2, 0);
            if (count > 0) {
                HGC.d("LocationManager", "onExitedGeofences: count: " + count);
                String message = this.HXH.getString("exit_message" + id2, "");
                this.NZV(id2 + count, id2, message);
                this.HXH.edit().putInt("key_count" + id2, count - 1).apply();
                continue;
            }
            this.HXH.edit().remove("key_count" + id2).apply();
            this.HXH.edit().remove("exit_message" + id2).apply();
            this.removeGeofenceById(id2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void NZV(String id2, String title, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        Exception bm22;
        Class activityClass = AdpPushClient.get().getActivityClass();
        Intent intent = new Intent(this.YCE, activityClass);
        intent.setFlags(0x24000000);
        int uniqueInt = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.YCE, (int)uniqueInt, (Intent)intent, (int)0);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.YCE, "default");
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)message).setContentIntent(pendingIntent).setAutoCancel(true);
        try {
            builder.setSound(RingtoneManager.getActualDefaultRingtoneUri((Context)this.YCE, (int)2));
            if (Build.VERSION.SDK_INT >= 21) {
                builder.setVisibility(1);
            }
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message).setBigContentTitle((CharSequence)title));
            if (Build.VERSION.SDK_INT >= 16) {
                builder.setPriority(2);
            }
            PackageInfo packageInfo = this.YCE.getPackageManager().getPackageInfo(this.YCE.getPackageName(), 0);
            ApplicationInfo appInfo = this.YCE.getPackageManager().getApplicationInfo(packageInfo.packageName, 0);
            bm22 = BitmapFactory.decodeResource((Resources)this.YCE.getResources(), (int)appInfo.icon);
            builder.setLargeIcon((Bitmap)bm22);
            boolean bm22 = Build.VERSION.SDK_INT >= 21;
            builder.setSmallIcon(bm22 ? AdpPushClient.get().getNotificationIconSilhouette() : AdpPushClient.get().getNotificationIcon());
        }
        catch (Exception exception) {
            bm22 = exception;
            exception.printStackTrace();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.YCE.getSystemService("notification");
        ChabokNotification notification = new ChabokNotification((String)var1_1, (String)var2_2, (String)var3_3, 0);
        if (mNotificationManager != null && AdpPushClient.get().prepareNotification(notification, builder)) {
            mNotificationManager.notify(0, builder.build());
        }
    }

    public void addCallbackIntent(Intent callbackIntent) {
        LocationManager locationManager;
        this.LMH = callbackIntent;
        String string = locationManager.toUri(0);
        locationManager = this;
        locationManager.HXH.edit().putString("host_intent_uri_key", string).apply();
    }

    public void removeCallbackIntent() {
        this.LMH = null;
        this.HXH.edit().remove("host_intent_uri_key").apply();
    }

    @Nullable
    private Intent VMB() {
        String uri = this.HXH.getString("host_intent_uri_key", "");
        HGC.d("LocationManager", "restoreIntent: uri: " + uri);
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            URISyntaxException uRISyntaxException;
            try {
                return Intent.parseUri((String)((Object)uRISyntaxException), (int)0);
            }
            catch (URISyntaxException uRISyntaxException2) {
                uRISyntaxException = uRISyntaxException2;
                uRISyntaxException2.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void NZV(LocationManager x0, Geofence x1) {
        void var1_1;
        x0.NZV((Geofence)var1_1);
    }

    static /* synthetic */ OnLocationUpdateListener NZV(LocationManager x0) {
        return x0.HUI;
    }

    static /* synthetic */ void MRR(LocationManager x0) {
        x0.OJW();
    }

    static /* synthetic */ GoogleApiClient OJW(LocationManager x0) {
        return x0.MRR;
    }

    static /* synthetic */ boolean HUI(LocationManager x0) {
        return x0.UFF;
    }

    static /* synthetic */ Location YCE(LocationManager x0) {
        return x0.XTU;
    }

    static /* synthetic */ void XTU(LocationManager x0) {
        x0.YCE();
    }

    static /* synthetic */ SharedPreferences VMB(LocationManager x0) {
        return x0.HXH;
    }

    static /* synthetic */ void AOP(LocationManager x0) {
        LocationManager locationManager = x0;
        float f = locationManager.HXH.getFloat("distance", 0.0f);
        long l = locationManager.HXH.getLong("interval", 0L);
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(f).setInterval(l * 1000L).build();
        locationManager.enableBackgroundMode();
        locationManager.startLocationUpdates(locationParams);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ void NZV(LocationManager x0, Location x1) {
        block10: {
            block11: {
                block9: {
                    var0 = x0;
                    HGC.d("LocationManager", "handleLocation, provider: " + var1_1.getProvider() + " ," + var1_1);
                    if (var0.XTU == null) {
                        var0.MRR();
                        var0.UFF = false;
                        var4_2 /* !! */  = new Handler();
                        var4_2 /* !! */ .postDelayed((Runnable)new DYH(var0), var0.DYH + 500L);
                    }
                    var4_2 /* !! */  = var0.XTU;
                    var3_4 = var1_1;
                    var2_6 = var0;
                    if (var4_2 /* !! */  != null) break block9;
                    v0 = true;
                    break block10;
                }
                var11_8 = var3_4.getTime() - var4_2 /* !! */ .getTime();
                var2_7 = var11_8 > 120000L ? 1 : 0;
                var5_9 = var11_8 < -120000L;
                v1 = var6_10 = var11_8 > 0L;
                if (var2_7 == 0) break block11;
                v0 = true;
                break block10;
            }
            if (var5_9) ** GOTO lbl-1000
            var2_7 = (int)(var3_4.getAccuracy() - var4_2 /* !! */ .getAccuracy());
            var5_9 = var2_7 > 0;
            var7_12 = var2_7 < 0;
            var2_7 = var2_7 > 200 ? 1 : 0;
            var4_2 /* !! */  = var4_2 /* !! */ .getProvider();
            v2 = (var3_4 = var3_4.getProvider()) == null ? var4_2 /* !! */  == null : (var3_5 = var3_4.equals(var4_2 /* !! */ ));
            if (var7_12) {
                v0 = true;
            } else if (var6_10 && !var5_9) {
                v0 = true;
            } else if (var6_10 && var2_7 == 0 && var3_5) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            var0.XTU = var1_1;
        }
        var2_6 = var0;
        var4_3 = var2_6.HXH.getLong("listening_start_time", 0L);
        var6_11 = Calendar.getInstance().getTimeInMillis() - var4_3;
        if (var0.XTU != null && var4_3 != 0L && var6_11 > var0.DYH) {
            var0.UFF = true;
            var0.YCE();
        }
    }

    static interface NZV {
        public void onConnect();
    }
}

