/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.GKV;
import com.adpdigital.push.HGC;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    /*
     * WARNING - void declaration
     */
    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        HGC.d(NZV, "PushService action " + action);
        try {
            void var2_3;
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService((Intent)var2_3);
            return;
        }
        catch (Exception exc) {
            void var0_1;
            void var1_2;
            HGC.w(NZV, "Couldn't start service in foreground (" + AdpPushClient.get().isForeground() + ") with action " + (String)var1_2);
            var0_1.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isRunning(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : activityManager.getRunningServices(Integer.MAX_VALUE)) {
            void var1_1;
            if (!PushService.class.getName().equals(var1_1.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        HGC.d(NZV, "Creating Chabok PushService");
        GKV.getInstance((Context)this).NZV();
    }

    /*
     * WARNING - void declaration
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        int n;
        void var2_2;
        HGC.i(NZV, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + (int)var2_2 + ", " + n);
        if (intent == null || intent.getAction() == null) {
            HGC.i(NZV, "Start PushService with empty action");
            GKV.getInstance((Context)this).OJW();
        } else {
            HGC.i(NZV, "PushService action " + intent.getAction() + ", foreground:" + AdpPushClient.get().isForeground() + ", screenOn:" + GKV.MRR());
            switch (intent.getAction()) {
                case "START": {
                    GKV.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    GKV.getInstance((Context)this).HUI();
                    break;
                }
                case "KEEP_ALIVE": {
                    GKV.getInstance((Context)this).YCE();
                    break;
                }
                case "RECONNECT": {
                    GKV.getInstance((Context)this).VMB();
                    break;
                }
                case "DISCONNECT": {
                    GKV.getInstance((Context)this).cancelReconnect();
                    GKV.getInstance((Context)this).XTU();
                    if (GKV.NZV == null) break;
                    GKV.NZV.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    GKV.getInstance((Context)this).AOP();
                    break;
                }
                default: {
                    void var1_1;
                    HGC.w(NZV, "Unrecognized action " + var1_1.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            HGC.d(NZV, "service is sticky");
            return 1;
        }
        HGC.d(NZV, "service is not sticky");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public void onTaskRemoved(Intent rootIntent) {
        void var1_1;
        HGC.w(NZV, "PushService removed: " + rootIntent.getAction() + rootIntent);
        GKV.getInstance((Context)this).AOP();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved((Intent)var1_1);
    }

    public void onLowMemory() {
        HGC.w(NZV, "push service low memory...");
        GKV.getInstance((Context)this).AOP();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    /*
     * WARNING - void declaration
     */
    public void onTrimMemory(int level) {
        void var1_1;
        HGC.w(NZV, "push service trim memory " + level);
        super.onTrimMemory((int)var1_1);
    }

    public void onDestroy() {
        HGC.i(NZV, "destroying push service");
        GKV.getInstance((Context)this).AOP();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

