/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.IntentService;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;

public abstract class GeoEventsIntentService
extends IntentService {
    public GeoEventsIntentService() {
        super("GeoEventsIntentService");
    }

    /*
     * WARNING - void declaration
     */
    public GeoEventsIntentService(String name) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void onHandleIntent(@Nullable Intent intent) {
        Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: called");
        GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
        if (event == null) return;
        if (event.hasError()) {
            this.onError(event.getErrorCode());
            return;
        }
        int transition = event.getGeofenceTransition();
        if (transition != 1 && transition != 4 && transition != 2) {
            Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: transition invalid");
            return;
        }
        Location location = event.getTriggeringLocation();
        String[] geofenceIds = new String[event.getTriggeringGeofences().size()];
        for (int index = 0; index < event.getTriggeringGeofences().size(); ++index) {
            geofenceIds[index] = ((Geofence)event.getTriggeringGeofences().get(index)).getRequestId();
        }
        if (transition != 1 && transition != 4) {
            void var3_3;
            void var2_2;
            if (var2_2 != 2) return;
            this.onExitedGeofences(geofenceIds, (Location)var3_3);
            return;
        }
        this.onEnteredGeofences(geofenceIds, location);
    }

    protected abstract void onEnteredGeofences(String[] var1, Location var2);

    protected abstract void onExitedGeofences(String[] var1, Location var2);

    protected abstract void onError(int var1);
}

