/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.adpdigital.push.AGP;
import com.adpdigital.push.AOP;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.AppState;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.CVA;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokEvent;
import com.adpdigital.push.ChabokFirebaseMessaging;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.DYH;
import com.adpdigital.push.Datetime;
import com.adpdigital.push.DeferredDataListener;
import com.adpdigital.push.EIW;
import com.adpdigital.push.ELX;
import com.adpdigital.push.FOL;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GKV;
import com.adpdigital.push.GMT;
import com.adpdigital.push.GTE;
import com.adpdigital.push.HCZ;
import com.adpdigital.push.HGC;
import com.adpdigital.push.HUI;
import com.adpdigital.push.IRK;
import com.adpdigital.push.IXL;
import com.adpdigital.push.IZX;
import com.adpdigital.push.JAZ;
import com.adpdigital.push.JMY;
import com.adpdigital.push.JYK;
import com.adpdigital.push.JZR;
import com.adpdigital.push.KEM;
import com.adpdigital.push.KTB;
import com.adpdigital.push.LMH;
import com.adpdigital.push.LOX;
import com.adpdigital.push.LPP;
import com.adpdigital.push.LogLevel;
import com.adpdigital.push.MRR;
import com.adpdigital.push.NHW;
import com.adpdigital.push.NZV;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.OJW;
import com.adpdigital.push.OWQ;
import com.adpdigital.push.OnDeeplinkResponseListener;
import com.adpdigital.push.PCS;
import com.adpdigital.push.PWW;
import com.adpdigital.push.PZH;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.QHG;
import com.adpdigital.push.QHM;
import com.adpdigital.push.RFF;
import com.adpdigital.push.RGI;
import com.adpdigital.push.RPN;
import com.adpdigital.push.RTB;
import com.adpdigital.push.SUU;
import com.adpdigital.push.TUY;
import com.adpdigital.push.UFF;
import com.adpdigital.push.UIR;
import com.adpdigital.push.VIN;
import com.adpdigital.push.VLN;
import com.adpdigital.push.VMB;
import com.adpdigital.push.WAW;
import com.adpdigital.push.WFM;
import com.adpdigital.push.WGR;
import com.adpdigital.push.WVK;
import com.adpdigital.push.XTU;
import com.adpdigital.push.XXU;
import com.adpdigital.push.YCE;
import com.adpdigital.push.ZTV;
import com.adpdigital.push.ZWK;
import com.adpdigital.push.config.Environment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = AdpPushClient.class.getName();
    public static final String SDK_VERSION = "3.4.0";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final String USE_BADGE_COUNT = "com.adpdigital.push.client.BadgeCount";
    public static final String ADVERTISING_ID_ENABLED = "com.adpdigital.push.client.ADVERTISING_ID_ENABLED";
    public static final String FB_DEFAULT_NOTIFICATION_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String CHABOK_DEFAULT_NOTIFICATION_ICON = "com.adpdigital.push.client.default_notification_icon";
    public static final String FB_DEFAULT_NOTIFICATION_COLOR = "com.google.firebase.messaging.default_notification_color";
    public static final String CHABOK_DEFAULT_NOTIFICATION_COLOR = "com.adpdigital.push.client.default_notification_color";
    public static final String SHOW_ONLY_CHABOK_NOTIFICATIONS = "com.adpdigital.push.client.SHOW_ONLY_CHABOK_NOTIFICATIONS";
    public static final String DISABLE_REALTIME = "com.adpdigital.push.client.DISABLE_REALTIME";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    public static final String PURCHASE_EVENT_NAME = "purchase";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int installationRetries;
    private static int tokenRetries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    private static boolean disableSdk;
    private static Environment chabokEnvironment;
    private Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private com.MRR.NZV.NZV.LMH adapter;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long lastLaunchTime;
    private long installDate;
    private boolean isLaunched = false;
    private NZV.NZV.NZV.OJW eventBus = NZV.NZV.NZV.OJW.getDefault();
    private static Context context;
    private static Class activityClass;
    private WeakReference<Activity> currentActivity;
    private ChabokNotificationAction lastNotificationAction;
    private ChabokNotification lastNotificationData;
    private OnDeeplinkResponseListener onDeeplinkResponseListener;
    private DeferredDataListener deferredDataListener;
    private com.adpdigital.push.config.NZV config;
    private String userHash;
    private boolean _isLoggedInNow = false;
    private static Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    private final Object _installationLock = new Object();
    private final Object _tokenLock = new Object();
    private static final ScheduledExecutorService tokenWorker;
    private static String defaultTracker;
    private String userId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private HCZ communicateFallbackMachine = HCZ.getInstance();
    private static final String GUEST_TAG = "CHABOK_GUEST";
    private static final String META_DATA = "__meta";
    private Callback<String> registerCallback;

    public static void setLogLevel(LogLevel logLevel) {
        HGC.setLogLevel(logLevel);
    }

    public static void setApplicationContext(Context context) {
        HGC.d(TAG, "setApplicationContext is called with context = " + context);
        AdpPushClient.context = context.getApplicationContext() == null ? context : context.getApplicationContext();
        if (AdpPushClient.context instanceof Application) {
            Context context2;
            AdpPushClient.registerOnActivityLifeCycle((Application)context2);
        }
        activityClass = AdpPushClient.getActivityClass(AdpPushClient.context);
    }

    /*
     * WARNING - void declaration
     */
    private static void registerOnActivityLifeCycle(Application context) {
        try {
            if (lifecycleCallbacks == null) {
                lifecycleCallbacks = new NZV();
                context.registerActivityLifecycleCallbacks(lifecycleCallbacks);
            }
            return;
        }
        catch (Exception ignored) {
            void var0_1;
            HGC.e(TAG, "can not register activity life cycle listener", (Throwable)var0_1);
            return;
        }
    }

    static Class getActivityClass(Context context) {
        Object object;
        try {
            object = context.getPackageManager().getLaunchIntentForPackage(object.getPackageName()).getComponent().getClassName();
            return Class.forName((String)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            HGC.w(TAG, "Could not find main activity class. Please before calling Chabok init method call AdpPushClient.setActivityClass(MainActivity.getClass())");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient(String appId, String apiKey, String username, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        HGC.i(TAG, "Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        this.isFreshStart = true;
        this.validateAndPopulate((String)var1_1, (String)var2_2, (String)var3_3, password);
        this.eventBus.register(this);
        if (!this.checkPlayServices()) {
            HUI.setIsSupportPlayServices(this.getApplicationContext(), true);
            HGC.w(TAG, "No valid Google Play Services found.");
        } else {
            HUI.setIsSupportPlayServices(this.getApplicationContext(), false);
        }
        if (this.shouldBeSticky() && this.hasProtectedAppSupport()) {
            this.eventBus.post((Object)AppState.PROTECTED_GRANT_NEEDED);
        }
        this.foreground = ForegroundManager.get(this.getApplicationContext());
        this.foreground.addListener(new LMH(this));
        this.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static AdpPushClient init(Context context, Class handlerActivity, String appId, String apiKey, String username, String password) {
        if (pushClientInstance != null) return pushClientInstance;
        Object object = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            void var3_4;
            void var2_3;
            if (pushClientInstance != null) return pushClientInstance;
            packageName = AdpPushClient.context.getPackageName();
            pushClientInstance = new AdpPushClient((String)var2_3, (String)var3_4, username, password);
            NZV.NZV.NZV.OJW.getDefault().post((Object)AppState.INITIALIZED);
            // ** MonitorExit[var0 /* !! */ ] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AdpPushClient init(String appId, String apiKey, String username, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return AdpPushClient.init(context, activityClass, string, (String)var1_1, (String)var2_2, (String)var3_3);
    }

    public static void setDisableSdk(boolean disableSdk) {
        boolean bl;
        AdpPushClient.disableSdk = disableSdk;
        if (bl) {
            HGC.w(TAG, "Chabok has been disabled.");
        }
    }

    public static boolean isDisabledSdk() {
        if (disableSdk) {
            HGC.w(TAG, "Chabok has been disabled by calling setDisableSdk(boolean) method.");
            return true;
        }
        return false;
    }

    public static synchronized AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to call AdpPushClient.configureEnvironment(Environment) in onCreate() method of your Application class. Please see http://bit.ly/32x1Tsn");
        }
        return pushClientInstance;
    }

    public static Context getContext() {
        return context;
    }

    static boolean hasNotified(String id) {
        String string;
        return notifs.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    private void initializeAdapter() {
        void var1_1;
        void var3_3;
        String string;
        String restApi = "http://" + ZWK.NZV + ":80/api/";
        String currentHost = ZWK.NZV;
        String currentPortBroker = ":1880";
        this.useDev = this.getSharedPreferences().getBoolean("useDev", true);
        if (this.useSecure) {
            String appSubDomain = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                appSubDomain = this.appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + ZWK.NZV + ":443/api/";
            string = string + ZWK.NZV;
            currentPortBroker = ":4443";
        }
        if (this.useDev) {
            restApi = "http://sandbox.push.adpdigital.com:80/api/";
            string = "sandbox.push.adpdigital.com";
            currentPortBroker = ":1880";
        }
        if (this.useDev && this.useSecure) {
            if (chabokEnvironment == null) {
                restApi = "https://dev.push.adpdigital.com:443/api/";
                string = "dev.push.adpdigital.com";
            } else {
                restApi = "https://sandbox.push.adpdigital.com:443/api/";
                string = "sandbox.push.adpdigital.com";
            }
            currentPortBroker = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", string).putString("port", (String)var3_3).putBoolean("useSecure", this.useSecure).apply();
        this.adapter = new com.MRR.NZV.NZV.LMH(this.getApplicationContext(), (String)var1_1);
        this.adapter.setAccessToken(this.apiKey);
    }

    /*
     * WARNING - void declaration
     */
    private void validateAndPopulate(String appId, String apiKey, String username, String password) {
        Set cache;
        void var3_4;
        void var2_3;
        if (context == null) {
            throw new IllegalArgumentException("No Context passed, Please call AdpPushClient.setApplicationContext(getApplicationContext()) method before Chabok init method.");
        }
        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        HUI.setUsername(this.getApplicationContext(), username);
        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        HUI.setPassword(this.getApplicationContext(), password);
        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }
        String applicationId = appId;
        String[] token = appId.split("/");
        if (token.length > 1) {
            applicationId = token[0];
            if (token.length == 2) {
                HGC.i(HGC.TAG, "SenderId is removed from Chabok SDK v3.0.0. Remove it from appId.");
            }
        }
        this.apiKey = var2_3;
        this.appId = var3_4;
        HUI.setAppId(this.getApplicationContext(), this.appId);
        Set<String> storedChannels = HUI.getTopics(this.getApplicationContext(), new HashSet<String>(Arrays.asList(this.channels)));
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);
        String storedNotifSettings = this.getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                this.notificationSettings = new JSONObject(storedNotifSettings);
            }
            catch (JSONException e) {
                HGC.e(TAG, e.getMessage(), e);
            }
        }
        if ((cache = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
            void var1_1;
            notifs.addAll((Collection<String>)var1_1);
        }
        this.isNewInstall = !this.getSharedPreferences().getBoolean("chabokInstallation", false);
        this.installDate = this.getSharedPreferences().getLong("installDate", -1L);
        if (this.installDate == -1L) {
            long unixTime = System.currentTimeMillis();
            this.getSharedPreferences().edit().putLong("installDate", unixTime).apply();
            this.installDate = unixTime;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resetBackgroundTimer() {
        void var1_1;
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        var1_1.cancel(this.getBackgroundIntent());
    }

    /*
     * WARNING - void declaration
     */
    private void startBackgroundTimer() {
        void var2_2;
        void var1_1;
        AlarmManager alarm = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarm == null) {
            return;
        }
        PendingIntent backgroundIntent = this.getBackgroundIntent();
        if (Build.VERSION.SDK_INT < 19) {
            alarm.set(2, SystemClock.elapsedRealtime() + 170000L, backgroundIntent);
            return;
        }
        var1_1.setExact(2, SystemClock.elapsedRealtime() + 170000L, (PendingIntent)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private PendingIntent getBackgroundIntent() {
        void var1_1;
        Intent background = new Intent();
        background.setClass(this.getApplicationContext(), PushService.class);
        background.setAction("BackgroundTimeExceeded");
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)var1_1, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(RFF gcmMessage) {
        void var1_1;
        void var2_2;
        HGC.w(TAG, "New GCM message (foreground:" + this.isForeground() + "): " + gcmMessage.getIntent().getExtras());
        if (this.isForeground()) {
            HGC.w(TAG, "How is this happening...!? we are in foreground, so ignore GCM message");
            return;
        }
        AdpPushClient that = this;
        this.isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"), new ELX(this, (AdpPushClient)var2_2, (RFF)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void publish(PushMessage message, Callback clbk) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }
        GKV.getInstance(this.getApplicationContext()).publish((PushMessage)var1_1, (Callback<Boolean>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(String channel, String text, Callback clbk) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (channel.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel should not contain slashes"));
            }
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody((String)var2_2);
        message.setChannel((String)var1_1);
        GKV.getInstance(this.getApplicationContext()).publish(message, (Callback<Boolean>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void publish(String user, String channel, String text, Callback clbk) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (channel.contains("/") || user.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }
        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody((String)var3_3);
        message.setChannel((String)var2_2);
        message.setUser((String)var1_1);
        GKV.getInstance(this.getApplicationContext()).publish(message, clbk);
    }

    /*
     * WARNING - void declaration
     */
    void publishMessageEvent(String subject, String messageId) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        try {
            void var1_1;
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            this.emit(PZH.event, (String)var1_1, messageId, obj, true, false);
            return;
        }
        catch (Exception e) {
            void var3_4;
            void var2_2;
            HGC.e(TAG, "Couldnt publish message event " + (String)var2_2, (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data) {
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (JSONObject)var2_2, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data, boolean live) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (JSONObject)var2_2, (boolean)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, JSONObject data, boolean live, boolean stateful) {
        void var3_3;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            HGC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            HGC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject eventData = new JSONObject();
        try {
            boolean isMatchFeedback;
            boolean bl = isMatchFeedback = event.contentEquals("matchUserFeedback") && (AdpPushClient.get().getAppId().contentEquals("90-dev") || AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                data.put("id", (Object)UUID.randomUUID().toString());
                data.put("createdAt", System.currentTimeMillis());
                eventData = data;
            } else {
                void var2_2;
                eventData.put("id", (Object)UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", (Object)var2_2);
            }
        }
        catch (JSONException jSONException) {
            JSONException isMatchFeedback = jSONException;
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = eventData;
            this.eventBus.register(new ZTV(this, event, finalEventData, live, stateful));
            return;
        }
        HGC.d(TAG, "publishEvent: sending data, event: " + event);
        this.emit(PZH.event, (String)var1_1, this.getInstallationId(), eventData, (boolean)var3_3, stateful);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, Bundle data) {
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (Bundle)var2_2, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, Bundle data, boolean live) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.publishEvent((String)var1_1, (Bundle)var2_2, (boolean)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public void publishEvent(String event, Bundle data, boolean live, boolean stateful) {
        void var3_3;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            HGC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            HGC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        JSONObject convertedData = HUI.MRR(data);
        JSONObject eventData = new JSONObject();
        try {
            boolean isMatchFeedback;
            boolean bl = isMatchFeedback = event.contentEquals("matchUserFeedback") && (AdpPushClient.get().getAppId().contentEquals("90-dev") || AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                convertedData.put("id", (Object)UUID.randomUUID().toString());
                convertedData.put("createdAt", System.currentTimeMillis());
                if (metadata != null) {
                    convertedData.put(META_DATA, (Object)metadata);
                }
                eventData = convertedData;
            } else {
                void var2_2;
                eventData.put("id", (Object)UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", (Object)var2_2);
                if (metadata != null) {
                    eventData.put(META_DATA, (Object)metadata);
                }
            }
        }
        catch (JSONException jSONException) {
            JSONException isMatchFeedback = jSONException;
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            JSONObject finalEventData = eventData;
            this.eventBus.register(new AGP(this, event, finalEventData, live, stateful));
            return;
        }
        HGC.d(TAG, "publishEvent: sending data, event: " + event);
        this.emit(PZH.event, (String)var1_1, this.getInstallationId(), eventData, (boolean)var3_3, stateful);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void publishBackground(String event, JSONObject data) {
        JSONException jSONException;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (event == null || event.isEmpty()) {
            HGC.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            HGC.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }
        JSONObject json = new JSONObject();
        JSONObject eventData = new JSONObject();
        try {
            void var3_3;
            if (event.equals("geo")) {
                eventData = data;
            } else {
                void var2_2;
                eventData.put("data", (Object)var2_2);
            }
            eventData.put("eventName", (Object)event);
            eventData.put("id", (Object)UUID.randomUUID().toString());
            eventData.put("createdAt", System.currentTimeMillis());
            json.put("type", 3);
            json.put("data", (Object)eventData);
            PWW communicateEvent = new PWW((JSONObject)var3_3, JZR.PublishInBackground);
            this.eventBus.post((Object)jSONException);
            return;
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            jSONException2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void emit(PZH type, String event, String subject, JSONObject data, boolean live, boolean stateful) {
        void var3_3;
        void var2_2;
        void var1_1;
        String dataStr = "";
        if (data != null) {
            dataStr = data.toString();
            HGC.d(TAG, "emit: data: " + dataStr + " , subject: " + subject);
        }
        String payload = dataStr;
        GKV.getInstance(this.getApplicationContext()).NZV((PZH)var1_1, (String)var2_2, (String)var3_3, payload, live, stateful);
    }

    /*
     * WARNING - void declaration
     */
    private void isReceivedMessage(String messageId, Callback clbk) {
        void var1_1;
        GKV.getInstance(this.getApplicationContext());
        clbk.onSuccess(GKV.NZV((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void getStatus(Callback<ConnectionStatus> clbk) {
        void var1_1;
        if (!PushService.isRunning(this.getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        var1_1.onSuccess(GKV.getInstance(this.getApplicationContext()).getStatus());
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableAlertForNotSupportingGcm(boolean supportGCMDialog) {
        void var1_1;
        this.getSharedPreferences().edit().putBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", (boolean)var1_1).apply();
    }

    private boolean isEnabledAlertForNotSupportingGcm() {
        return this.getSharedPreferences().getBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", true);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(String channel, Callback clbk) {
        void var2_2;
        void var1_1;
        this.subscribe((String)var1_1, false, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribe(String channel, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (!live) {
            HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
            allChannels.add(this.convertChannelName2OldConvention(channel));
            HUI.setTopics(this.getApplicationContext(), allChannels);
            this.channels = allChannels.toArray(new String[allChannels.size()]);
            this.updateInstallation(new HashMap<String, Object>());
            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                ChabokFirebaseMessaging.subscribe(channel);
            }
        }
        String channelName = ChabokFirebaseMessaging.NZV(channel);
        this.createOrUpdateNotificationChannel(channel, channelName);
        GKV.getInstance(this.getApplicationContext()).NZV((String)var1_1, (boolean)var2_2, (Callback<String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private String convertChannelName2OldConvention(String channel) {
        void var1_1;
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        if (channel.startsWith("public/")) {
            return channel;
        }
        return "public/" + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribe(String channel, Callback clbk) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        HashSet<String> allChannels = new HashSet<String>(Arrays.asList(this.channels));
        allChannels.remove(this.convertChannelName2OldConvention(channel));
        HUI.setTopics(this.getApplicationContext(), allChannels);
        this.channels = allChannels.toArray(new String[var3_3.size()]);
        this.updateInstallation(new HashMap<String, Object>());
        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            ChabokFirebaseMessaging.unsubscribe(channel);
        }
        if (this.hasNotificationChannel(channel)) {
            this.deleteNotificationChannel(channel);
        }
        GKV.getInstance(this.getApplicationContext()).NZV((String)var1_1, (Callback<Boolean>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (this.notificationSettings == null) {
            this.notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        this.notificationSettings.remove(topicName);
        try {
            void var3_4;
            topicSetting.put("sound", (Object)sound);
            topicSetting.put("alert", (boolean)var3_4);
            this.notificationSettings.put(topicName, (Object)topicSetting);
            this.getSharedPreferences().edit().putString("notificationSettings", this.notificationSettings.toString()).apply();
            HashMap<String, Object> props = new HashMap<String, Object>();
            HashMap<String, HashMap> notifSettings = this.getNotificationSettings();
            if (notifSettings != null) {
                void var2_3;
                props.put("notificationSettings", var2_3);
            }
            this.updateInstallation(props);
            return;
        }
        catch (JSONException e) {
            void var1_2;
            HGC.e(TAG, e.getMessage(), (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.isRegistered(object)) {
            void var1_1;
            this.eventBus.register(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient notify(Object object) {
        if (this.eventBus != null) {
            void var1_1;
            this.eventBus.post(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.isRegistered(object)) {
            void var1_1;
            this.eventBus.unregister(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient setPushListener(Object ctx) {
        void var1_1;
        return this.addListener(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient removePushListener(Object activity) {
        void var1_1;
        return this.removeListener(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient register(String userId) {
        void var1_1;
        return this.register((String)var1_1, new String[0], null);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient register(String userId, Callback<String> registrationCallback) {
        void var2_2;
        void var1_1;
        return this.register((String)var1_1, new String[0], (Callback<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient register(String userId, String[] channels, Callback<String> registrationCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            HGC.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }
        if (!this.isValid(userId)) {
            HGC.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }
        String guid = this.getGuestUserId();
        if (guid != null && !userId.contentEquals(guid)) {
            this._isLoggedInNow = true;
            this.setGuestUserId(null);
        }
        return this._register((String)var1_1, (String[])var2_2, (Callback<String>)var3_3);
    }

    private AdpPushClient registerAsGuest() {
        return this._registerAsGuest(null, null);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient registerAsGuest(Callback<String> registrationCallback) {
        void var1_1;
        return this._registerAsGuest(null, (Callback<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient registerAsGuest(String guestId) {
        void var1_1;
        return this._registerAsGuest((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient registerAsGuest(String guestId, Callback<String> registrationCallback) {
        void var2_2;
        void var1_1;
        return this._registerAsGuest((String)var1_1, (Callback<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient _registerAsGuest(String guestId, Callback<String> registrationCallback) {
        void var2_2;
        void var3_3;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        String userId = this.getGuestUserId();
        if (guestId != null && userId == null || guestId != null && !guestId.contentEquals(userId)) {
            void var1_1;
            userId = var1_1;
            this.setGuestUserId(userId);
        }
        if (userId == null) {
            userId = UUID.randomUUID().toString().replace("-", "");
            this.setGuestUserId(userId);
        }
        this._isLoggedInNow = false;
        this.userHash = "";
        return this._register((String)var3_3, new String[0], (Callback<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient reRegister(String userId) {
        void var1_1;
        return this.reRegister((String)var1_1, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient reRegister(String userId, String[] channels) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        HUI.setReregisteredFrom(this.getApplicationContext(), this.userId);
        this.unregister(true);
        this._register((String)var1_1, (String[])var2_2, this.registerCallback);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient _register(String userId, String[] channels, Callback<String> registrationCallback) {
        void var1_1;
        void var3_3;
        void var2_2;
        String currentUserId;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            HGC.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }
        if (!this.isValid(userId)) {
            HGC.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }
        if (this.registering) {
            HGC.w(TAG, "Already in registering...");
            this.eventBus.register(new XXU(this, userId, channels, registrationCallback));
            return this;
        }
        this.registerCallback = registrationCallback;
        if (this.hasNotificationChannel(this.getInstallationId())) {
            this.deleteNotificationChannel(this.getInstallationId());
        }
        if (!userId.equalsIgnoreCase(currentUserId = this.getUserId())) {
            this.setRegisterTs(System.currentTimeMillis());
        }
        if (currentUserId != null && !userId.equalsIgnoreCase(currentUserId)) {
            return this.reRegister(userId, channels);
        }
        this.registeredOnce = false;
        this.userId = userId;
        HUI.setUserId(context, this.userId);
        HashSet<String> allTopics = new HashSet<String>(Arrays.asList(this.channels));
        ArrayList<String> newChannels = new ArrayList<String>();
        boolean userHasNewTopic = false;
        for (void ch : var2_2) {
            String chName = this.convertChannelName2OldConvention((String)ch);
            newChannels.add(chName);
            if (allTopics.contains(chName)) continue;
            userHasNewTopic = true;
        }
        allTopics.addAll((Collection<String>)var3_3);
        if (userHasNewTopic) {
            this.makeSubsDirty();
        }
        HUI.setTopics(this.getApplicationContext(), allTopics);
        this.channels = allTopics.toArray(new String[var1_1.size()]);
        installationRetries = 0;
        if (!this.checkPlayServices()) {
            HUI.setIsSupportPlayServices(this.getApplicationContext(), true);
            HGC.w(TAG, "No valid Google Play Services found.");
        } else {
            HUI.setIsSupportPlayServices(this.getApplicationContext(), false);
        }
        this.getApplicationInstallReferrer();
        this.doRegister();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(String userId) {
        void var2_2;
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        if (userId.length() <= 0 || userId.length() > 64) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !var1_1.matches((String)var2_2);
    }

    private void doRegister() {
        this.doRegister(false);
    }

    /*
     * WARNING - void declaration
     */
    private void doRegister(boolean restartService) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            HGC.e(TAG, "userId not initialized yet");
            return;
        }
        if (this.registering) {
            HGC.d(TAG, "Register already in progress for " + this.userId);
            return;
        }
        this.registering = true;
        HGC.d(TAG, "-- Post Event REGISTERING");
        this.eventBus.post((Object)AppState.REGISTERING);
        this.initializeAdapter();
        worker.schedule(new LOX(this, (boolean)var1_1), 250L, TimeUnit.MILLISECONDS);
    }

    public boolean isConnected() {
        if (AdpPushClient.isDisabledSdk()) {
            return false;
        }
        return this.adapter != null && this.adapter.isConnected();
    }

    @Deprecated
    public void dismiss() {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        HGC.i(TAG, "Dismiss AdpPushClient");
        this.eventBus.unregister(this);
        this.getForegroundManager().removeListeners();
        this.deferredDataListener = null;
        this.onDeeplinkResponseListener = null;
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPlayServices() {
        try {
            GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = apiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
            if (resultCode != 0 && resultCode != 2) {
                if (apiAvailability.isUserResolvableError(resultCode) && this.currentActivity != null && this.currentActivity.get() != null) {
                    Exception exception;
                    try {
                        if (this.isEnabledAlertForNotSupportingGcm() && !AdpPushClient.isDisabledSdk()) {
                            void var2_2;
                            exception.getErrorDialog((Activity)this.currentActivity.get(), (int)var2_2, 9000).show();
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        exception2.printStackTrace();
                    }
                }
                HGC.i(TAG, "This device is not supported, but google api is available");
                return false;
            }
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            HGC.i(TAG, "This device is not supported and google api is not available");
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient updateRegistration(boolean restartService) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        com.MRR.NZV.NZV.NZV installation = new com.MRR.NZV.NZV.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        this.restartServiceState = var1_1;
        this.registerInBackground((com.MRR.NZV.NZV.NZV)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void fetchAndSetAdId(com.MRR.NZV.NZV.NZV installation) {
        Boolean bl;
        if (this.isAdvertisingIdEnabled() && (bl = Boolean.valueOf(this.checkPlayServices())).booleanValue()) {
            void var1_1;
            HGC.d(HGC.TAG, "\n\n ==================================== \n\nStart getting AdvertisingId at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
            try {
                String adId = this.getPlayAdId(context);
                if (adId != null) {
                    installation.setAdId(adId);
                }
                Boolean trackingEnabled = this.isPlayTrackingEnabled(context);
                installation.setAdIdEnabled(trackingEnabled);
            }
            catch (Exception ex) {
                void var2_3;
                HGC.e(TAG, "Exception happen for get advertisingId doInBackground: -----> ", ex);
                var2_3.printStackTrace();
            }
            HGC.d(HGC.TAG, "\n\n ==================================== \n\nGet AdvertisingId = " + var1_1.getAdId() + " at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void registerInBackground(com.MRR.NZV.NZV.NZV installation) {
        HGC.d(TAG, String.format(Locale.getDefault(), "registerInBackground called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        this.fetchAndSetAdId(installation);
        if (!this.isEnabledPushNotification()) {
            void var1_1;
            LPP deviceToken = new LPP("disabled");
            deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
            NZV.NZV.NZV.OJW.getDefault().post(var1_1);
            return;
        }
        HGC.d(TAG, "registerInBackground...");
        this.getToken(true);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void getToken(boolean installationRequired) {
        void var1_1;
        HGC.d(TAG, String.format(Locale.getDefault(), "getToken called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new GTE(this, installationRequired)).addOnCanceledListener((OnCanceledListener)new JMY(this, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(LPP token) {
        void var2_2;
        void var1_1;
        HGC.d(TAG, String.format(Locale.getDefault(), "DeviceToken onEvent called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
        com.MRR.NZV.NZV.NZV installation = this.getLocalInstallation();
        HGC.d(TAG, "on event DeviceToken " + token.getToken() + " ?== " + installation.getDeviceToken());
        new MRR(this, (LPP)var1_1, (com.MRR.NZV.NZV.NZV)var2_2).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    private void saveInstallation(com.MRR.NZV.NZV.NZV installation, boolean restartService) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object isReregistered2;
        HashMap<String, HashMap> notifSettings;
        Object appSignature2;
        JSONArray cachedData;
        String installReferrer;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("launchCount", this.getAppLaunchCount());
        props.put("launchTime", this.getAppLaunchTime());
        props.put("realtime", this.isEnabledRealtime());
        if (this.getLastAppLaunchTime() > 0L) {
            props.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if (this.hasInstallReferrerData() && (installReferrer = this.getInstallReferrer()) != null) {
            props.put("referrer", installReferrer);
            props.put("refClickTs", this.getInstallReferrerClickTs());
            props.put("refBeginTs", this.getInstallReferrerInstallBeginTs());
        }
        if (this.getRawInstallReferrer() != null) {
            props.put("rawReferrer", this.getRawInstallReferrer());
            props.put("rawRefClickTs", this.getRawInstallReferrerClickTs());
        }
        if (defaultTracker != null && !defaultTracker.trim().isEmpty()) {
            props.put("defaultTracker", defaultTracker);
        }
        if ((cachedData = this.communicateFallbackMachine.getReadyToSendEventData()) != null) {
            props.put("eventData", cachedData);
        }
        props.put("deviceId", this.getDeviceId());
        String uniqueId = this.getUniqueID();
        if (uniqueId != null && uniqueId.trim() != "") {
            props.put("uniqueId", uniqueId);
        }
        try {
            appSignature2 = DYH.getAppSignature(context);
            if (appSignature2 != null) {
                props.put("appSessionId", appSignature2);
            } else {
                props.put("appSessionId", "INVALID");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            appSignature2 = nameNotFoundException;
            nameNotFoundException.printStackTrace();
        }
        props.put("appTokenId", DYH.base64CreateFingerprint(context));
        props.put("mobileOperator", DYH.getMobileOperator(context));
        boolean appSignature2 = this.checkPlayServices();
        if (!appSignature2) {
            props.put("gpsVersionFound", -1);
        } else {
            try {
                if (context != null && context.getPackageManager() != null) {
                    int installedPlayServices = AdpPushClient.context.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode;
                    props.put("gpsVersionFound", installedPlayServices);
                }
            }
            catch (Exception exception) {
                Exception installedPlayServices = exception;
                exception.printStackTrace();
            }
        }
        int appRequiredPlayServices = GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        props.put("gpsVersionRequired", appRequiredPlayServices);
        props.put("connection", YCE.getNetworkClass(this.getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("osBuild", Build.ID);
        props.put("locale", Locale.getDefault());
        props.put("clientVersion", this.getClientVersion());
        props.put("launched", this.isLaunched);
        props.put("newInstall", this.isNewInstall);
        if (this._isLoggedInNow) {
            props.put("isLoggedIn", this._isLoggedInNow);
        }
        if (this.userHash != null && !this.userHash.isEmpty()) {
            props.put("userHash", this.userHash);
        }
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            props.put("userInfo", this.userInfo);
        }
        if ((notifSettings = this.getNotificationSettings()) != null) {
            props.put("notificationSettings", notifSettings);
        }
        props.put("installSource", this.getInstallSource());
        props.put("installDate", this.installDate);
        String screenRes = this.getDeviceScreenResolution();
        if (screenRes != null) {
            props.put("screenResolution", screenRes);
        }
        if ((isReregistered2 = this.getReregisteredFrom()) != null) {
            props.put("reregisteredFrom", isReregistered2);
        }
        if (context != null && context.getPackageName() != null) {
            props.put("appBundleId", context.getPackageName());
        }
        if (installation.getTokenStatus() == null) {
            try {
                boolean isReregistered2 = NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
                if (isReregistered2) {
                    installation.setTokenStatus("ALLOWED");
                } else {
                    installation.setTokenStatus("DENIED");
                }
            }
            catch (Exception exception) {
                isReregistered2 = exception;
                exception.printStackTrace();
            }
        }
        props.put("isProduction", true);
        AdpPushClient finalThis = this;
        new OJW(this, (com.MRR.NZV.NZV.NZV)var1_1, (HashMap)var3_3, finalThis, (boolean)var2_2).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private com.MRR.NZV.NZV.NZV.YCE beforeSend() {
        return new YCE(this);
    }

    /*
     * WARNING - void declaration
     */
    private String getPlayAdId(Context context) {
        void var2_2;
        Object playAdId = null;
        for (int i = 0; i < 3; ++i) {
            try {
                playAdId = HUI.getGooglePlayServicesInfo(context);
                playAdId = ((PCS)playAdId).getGpsAdid();
                if (playAdId != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((playAdId = HUI.NZV(context)) != null) break;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPlayTrackingEnabled(Context context) {
        void var2_2;
        Object isTrackingEnabled = null;
        for (int i = 0; i < 3; ++i) {
            try {
                isTrackingEnabled = HUI.getGooglePlayServicesInfo(context);
                isTrackingEnabled = ((PCS)isTrackingEnabled).isTrackingEnabled();
                if (isTrackingEnabled != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((isTrackingEnabled = HUI.MRR(context)) != null) break;
        }
        if (isTrackingEnabled == null) {
            return false;
        }
        return var2_2.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    private String getInstallSource() {
        try {
            if (context != null && context.getPackageManager() != null) {
                String installationSource;
                PackageManager pm = context.getPackageManager();
                if (context.getPackageName() != null && (installationSource = pm.getInstallerPackageName(context.getPackageName())) != null) {
                    void var1_1;
                    return var1_1;
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return "notSet";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String getDeviceScreenResolution() {
        void var2_3;
        void var3_4;
        if (this.currentActivity == null || this.currentActivity.get() == null) {
            return null;
        }
        WindowManager windowManager = ((Activity)this.currentActivity.get()).getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {}
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)windowManager, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception exception) {}
        }
        return (int)var3_4 + "x" + (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            void var1_1;
            HashMap notifSettings = new HashMap();
            Iterator channelSettings = this.notificationSettings.keys();
            while (channelSettings.hasNext()) {
                void var3_3;
                String topic = (String)channelSettings.next();
                JSONObject channelSetting = this.notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<String, String>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(var3_3, setting);
            }
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void retryRegistrationBackoff() {
        if (++installationRetries <= 10) {
            void var2_2;
            void var1_1;
            XTU retryTask = new XTU(this);
            long nextTry = (long)Math.max(Math.pow(2.0, installationRetries), 32.0);
            HGC.d(TAG, String.format(Locale.getDefault(), "retryRegistration with `%d` seconds Backoff", nextTry));
            worker.schedule((Runnable)var1_1, (long)var2_2, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void retryGetTokenBackoff() {
        if (++tokenRetries <= 5) {
            void var2_2;
            void var1_1;
            VMB retryTask = new VMB(this);
            long nextTry = (long)Math.max(Math.pow(2.0, tokenRetries), 10.0);
            HGC.d(TAG, String.format(Locale.getDefault(), "retryGetToken with `%d` seconds Backoff", nextTry));
            tokenWorker.schedule((Runnable)var1_1, (long)var2_2, TimeUnit.SECONDS);
        }
    }

    @Deprecated
    private String getDeviceId() {
        return Build.SERIAL;
    }

    private String getUniqueID() {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getClientVersion() {
        void var1_1;
        String userClientVersion = RTB.decrypt(context, this.getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(context.getPackageName(), 0);
                userClientVersion = packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
                nameNotFoundException.printStackTrace();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setClientVersion(String version) {
        void var1_1;
        this.getSharedPreferences().edit().putString("clientVersion", RTB.encrypt(context, (String)var1_1)).apply();
    }

    /*
     * WARNING - void declaration
     */
    public void incBadge() {
        void var1_1;
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        int currentBadge = this.getSharedPreferences().getInt("androidBadge", 0);
        ++currentBadge;
        this.setBadge((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean isBadgeEnabled() {
        try {
            if (context != null) {
                String badgeStatus;
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && (badgeStatus = bundle.getString(USE_BADGE_COUNT)) != null && badgeStatus.toLowerCase().equals("disable")) {
                    return false;
                }
                if (!ShortcutBadger.isBadgeCounterSupported((Context)context)) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HGC.e(TAG, "isBadgeEnabled: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            void var1_3;
            HGC.e(TAG, "isBadgeEnabled: NullPointerException -->", (Throwable)var1_3);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    boolean isEnabledRealtime() {
        block9: {
            if (this.config == null) break block9;
            if (!this.config.realtime()) {
                HGC.i(TAG, String.format(Locale.getDefault(), "Chabok realtime is disabled. To enable set realtime in Chabok.%s.json file to true.", this.config.environment()));
                return false;
            }
            return true;
        }
        try {
            if (this.getSharedPreferences().contains("CHK_DISABLE_REALTIME")) {
                return !this.getSharedPreferences().getBoolean("CHK_DISABLE_REALTIME", true);
            }
            if (context != null) {
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && bundle.containsKey(DISABLE_REALTIME)) {
                    HGC.i(HGC.TAG, "com.adpdigital.push.client.DISABLE_REALTIME meta-data does not support anymore.");
                    if (this.config != null) {
                        HGC.i(HGC.TAG, String.format(Locale.getDefault(), "For config realtime change it from Chabok.%s.json file.", this.config.environment()));
                    }
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HGC.e(TAG, "isEnabledRealtime: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            void var1_3;
            HGC.e(TAG, "isEnabledRealtime: NullPointerException -->", (Throwable)var1_3);
        }
        return true;
    }

    boolean isEnabledPushNotification() {
        if (this.config == null || this.config.pushNotification()) {
            return true;
        }
        HGC.w(TAG, "Chabok push notification has been disabled in configuration.");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setEnableRealtime(boolean enableRealtime) {
        void var1_1;
        this.getSharedPreferences().edit().putBoolean("CHK_DISABLE_REALTIME", var1_1 == false).apply();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isChabokPushNotification(Bundle data) {
        void var1_1;
        return data != null && var1_1.containsKey("fromChabok");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isChabokPushNotification(Map<String, String> data) {
        void var1_1;
        return data != null && var1_1.containsKey("fromChabok");
    }

    /*
     * WARNING - void declaration
     */
    boolean isAdvertisingIdEnabled() {
        try {
            if (context != null) {
                String advertisingIdStatus;
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && (advertisingIdStatus = bundle.getString(ADVERTISING_ID_ENABLED)) != null && advertisingIdStatus.toLowerCase().equals("disable")) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HGC.e(TAG, "isAdvertisingIdEnabled: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            void var1_3;
            HGC.e(TAG, "isAdvertisingIdEnabled: NullPointerException -->", (Throwable)var1_3);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    int getDefaultNotificationIconIdFromMetadata() {
        try {
            if (context != null) {
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null) {
                    void var2_4;
                    int defaultIcon = -1;
                    if (bundle.containsKey(FB_DEFAULT_NOTIFICATION_ICON) && (defaultIcon = bundle.getInt(FB_DEFAULT_NOTIFICATION_ICON)) >= 0) {
                        return defaultIcon;
                    }
                    if (bundle.containsKey(CHABOK_DEFAULT_NOTIFICATION_ICON)) {
                        defaultIcon = bundle.getInt(CHABOK_DEFAULT_NOTIFICATION_ICON);
                    }
                    return (int)var2_4;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HGC.e(TAG, "getDefaultNotificationIconFromMetadata: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            void var1_3;
            HGC.e(TAG, "getDefaultNotificationIconFromMetadata: NullPointerException -->", (Throwable)var1_3);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    int getDefaultNotificationColorFromMetadata() {
        try {
            if (context != null) {
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null) {
                    void var2_5;
                    int color = -1;
                    if (bundle.containsKey(FB_DEFAULT_NOTIFICATION_COLOR) && (color = bundle.getInt(FB_DEFAULT_NOTIFICATION_COLOR)) >= 0) {
                        return context.getResources().getColor(color);
                    }
                    if (bundle.containsKey(CHABOK_DEFAULT_NOTIFICATION_COLOR)) {
                        color = bundle.getInt(CHABOK_DEFAULT_NOTIFICATION_COLOR);
                    }
                    return context.getResources().getColor((int)var2_5);
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            HGC.e(TAG, "getDefaultNotificationColorFromMetadata: NameNotFoundException -->", e);
        }
        catch (NullPointerException e) {
            HGC.e(TAG, "getDefaultNotificationColorFromMetadata: NullPointerException -->", e);
        }
        catch (Exception e) {
            void var1_4;
            HGC.e(TAG, "getDefaultNotificationColorFromMetadata: Exception -->", (Throwable)var1_4);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void updateLaunchStats() {
        void var1_1;
        this.lastLaunchTime = this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, -1L);
        int count = this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        ++count;
        this.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, (int)var1_1).apply();
        this.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
        this.isLaunched = true;
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public long getLastAppLaunchTime() {
        return this.lastLaunchTime;
    }

    public String getReregisteredFrom() {
        return HUI.getReregisteredFrom(this.getApplicationContext());
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    /*
     * WARNING - void declaration
     */
    AdpPushClient setBadge(int badgeNumber) {
        boolean bl;
        this.getSharedPreferences().edit().putInt("androidBadge", badgeNumber).apply();
        this.eventBus.post(new BadgeUpdate(badgeNumber));
        if (this.isBadgeEnabled() && !(bl = ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)badgeNumber))) {
            void var1_1;
            HGC.i(TAG, "Could not apply the badge " + (int)var1_1);
        }
        return this;
    }

    public AdpPushClient resetBadge() {
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        notificationManager.cancelAll();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        notificationManager.apply();
        return this.setBadge(0);
    }

    /*
     * WARNING - void declaration
     */
    private void unregister(boolean isReregister) {
        void var1_1;
        if (!isReregister) {
            this.deleteInstallation(new AOP(this));
        }
        HUI.removeUserId(context);
        try {
            if (this.getGuestUserId() == null || this.userId == null || this.userId.equalsIgnoreCase(this.getGuestUserId())) {
                this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        if (var1_1 == false) {
            this.getSharedPreferences().edit().remove("deviceToken").apply();
            this.getSharedPreferences().edit().remove("installationId").apply();
        }
        HUI.removeTopicsFromStorage(this.getApplicationContext());
        this.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        this.getSharedPreferences().edit().remove("offlineCache").apply();
        this.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        this.getSharedPreferences().edit().remove("dataCache").apply();
        this.channels = new String[]{"default"};
        PushService.performAction(this.getApplicationContext(), "DISCONNECT");
    }

    /*
     * WARNING - void declaration
     */
    public String getInstallationId() {
        String idJson = RTB.decrypt(context, this.getSharedPreferences().getString("installationId", null));
        if (idJson != null) {
            try {
                return (String)new JSONArray(idJson).get(0);
            }
            catch (JSONException var5) {
                void var2_2;
                void var1_1;
                String currentVersionCode = "Cannot parse installation id '" + idJson + "'";
                HGC.e(TAG, (String)var1_1, (Throwable)var2_2);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteInstallation(Callback clbk) {
        void var3_3;
        void var1_1;
        void var2_2;
        com.MRR.NZV.NZV.UFF<com.MRR.NZV.NZV.KEM> repository = this.adapter.createRepository("installation");
        com.MRR.NZV.NZV.NZV installation = new com.MRR.NZV.NZV.NZV(this.getApplicationContext(), this.adapter);
        com.MRR.NZV.NZV.KEM model = repository.createModel(PCS.getProperties(installation, false, false));
        model.putAll(installation.getRequireParams());
        if (model.getId() == null) {
            HGC.w(TAG, "------ Warning : Device was unregistered before!! -------");
            return;
        }
        var2_2.destroy(new DYH(this, (Callback)var1_1, (com.MRR.NZV.NZV.NZV)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(Map<String, Object> properties) {
        void var1_1;
        this.updateInstallation((Map<String, Object>)var1_1, new KEM(this));
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(Map<String, Object> properties, Callback<com.MRR.NZV.NZV.NZV> clbk) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object appSignature;
        String uniqueId;
        this.eventBus.post((Object)JZR.UpdatingInstallation);
        com.MRR.NZV.NZV.NZV installation = new com.MRR.NZV.NZV.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        properties.put("launched", this.isLaunched);
        properties.put("newInstall", this.isNewInstall);
        properties.put("launchTime", this.getAppLaunchTime());
        properties.put("realtime", this.isEnabledRealtime());
        if (this.getLastAppLaunchTime() > 0L) {
            properties.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if ((uniqueId = this.getUniqueID()) != null && !uniqueId.isEmpty()) {
            properties.put("uniqueId", uniqueId);
        }
        try {
            appSignature = DYH.getAppSignature(context);
            if (appSignature != null) {
                properties.put("appSessionId", appSignature);
            } else {
                properties.put("appSessionId", "INVALID");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            appSignature = nameNotFoundException;
            nameNotFoundException.printStackTrace();
        }
        properties.put("appTokenId", DYH.base64CreateFingerprint(context));
        properties.put("mobileOperator", DYH.getMobileOperator(context));
        JSONArray cachedData = this.communicateFallbackMachine.getReadyToSendEventData();
        if (cachedData != null) {
            properties.put("eventData", cachedData);
        }
        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            properties.put("userInfo", this.userInfo);
        }
        this.updateInstallation((com.MRR.NZV.NZV.NZV)var3_3, (Map<String, ?>)var1_1, (Callback<com.MRR.NZV.NZV.NZV>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private com.MRR.NZV.NZV.NZV getLocalInstallation() {
        void var1_1;
        com.MRR.NZV.NZV.NZV installation = new com.MRR.NZV.NZV.NZV(this.getApplicationContext(), this.adapter);
        installation.setAppId(this.getAppId());
        installation.setAppVersion(SDK_VERSION);
        installation.setUserId(this.getUserId());
        installation.setSubscriptions(this.channels);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void updateInstallation(com.MRR.NZV.NZV.NZV installation, Map<String, ?> properties, Callback<com.MRR.NZV.NZV.NZV> clbk) {
        void var1_1;
        void var3_3;
        void var2_2;
        com.MRR.NZV.NZV.UFF<com.MRR.NZV.NZV.KEM> uFF = this.adapter.createRepository("installation");
        com.MRR.NZV.NZV.KEM model = uFF.createModel(PCS.getProperties(installation, false, false));
        model.putAll(installation.getRequireParams());
        model.putAll((Map<String, ? extends Object>)var2_2);
        new IZX(this, model, (Callback)var3_3, (com.MRR.NZV.NZV.NZV)var1_1).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    public void requestVerificationCode(String userId, String media, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        com.MRR.NZV.NZV.UFF<com.MRR.NZV.NZV.KEM> repository = this.adapter.createRepository("verification");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", var1_1);
        map.put("appId", this.appId);
        map.put("media", var2_2);
        repository.invokeStaticMethod("requestCode", map, new UFF(this, (Callback)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private void requestCode(String userId, Callback clbk) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        com.MRR.NZV.NZV.UFF<com.MRR.NZV.NZV.KEM> uFF = this.adapter.createRepository("verification");
        uFF.requestCode((String)var1_1, new SUU(this, (Callback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void requestVerificationCode(String userId, Callback clbk) {
        void var2_2;
        void var1_1;
        this.requestCode((String)var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUserCode(String userId, String code, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        com.MRR.NZV.NZV.UFF<com.MRR.NZV.NZV.KEM> repository = this.adapter.createRepository("verification");
        HashMap<String, void> map = new HashMap<String, void>();
        map.put("userId", var1_1);
        map.put("code", var2_2);
        repository.invokeStaticMethod("verifyCode", map, new QHM(this, (Callback)var3_3));
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && AdpPushClient.getActivityClass(this.getApplicationContext()).getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient addAppListener(AppListener listener) {
        void var1_1;
        this.getForegroundManager().addListener((AppListener)var1_1);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return activityClass;
    }

    private Context getApplicationContext() {
        return context;
    }

    public String getUserId() {
        return HUI.getUserId(this.getApplicationContext());
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoResetBadge(boolean autoResetBadge) {
        void var1_1;
        this.getSharedPreferences().edit().putBoolean("CHK_AUTO_RESET_BADGE", (boolean)var1_1).apply();
    }

    public boolean isAutoResetBadge() {
        return this.getSharedPreferences().getBoolean("CHK_AUTO_RESET_BADGE", true);
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (this.notificationIcon == -1) {
            try {
                ApplicationInfo applicationInfo;
                int appIcon = this.getDefaultNotificationIconIdFromMetadata();
                if (appIcon >= 0) {
                    return appIcon;
                }
                PackageInfo packageInfo = this.getApplicationContext().getPackageManager().getPackageInfo(this.getApplicationContext().getPackageName(), 0);
                applicationInfo = this.getApplicationContext().getPackageManager().getApplicationInfo(applicationInfo.packageName, 0);
                return applicationInfo.icon;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return -1;
            }
        }
        return this.notificationIcon;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotificationIcon(int notificationIcon) {
        void var1_1;
        this.notificationIcon = var1_1;
    }

    public int getNotificationIconSilhouette() {
        if (this.notificationIconSilhouette == -1) {
            return this.getNotificationIcon();
        }
        return this.notificationIconSilhouette;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        void var1_1;
        this.notificationIconSilhouette = var1_1;
    }

    private long getRegisterTs() {
        return this.getSharedPreferences().getLong("CHK_REGISTER_TS", 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void setRegisterTs(long registerTs) {
        void var1_1;
        this.getSharedPreferences().edit().putLong("CHK_REGISTER_TS", (long)var1_1).apply();
    }

    private boolean isGuestUser() {
        return this.getGuestUserId() != null;
    }

    public boolean isLoggedIn() {
        return !this.isGuestUser();
    }

    /*
     * WARNING - void declaration
     */
    private void setGuestUserId(String guestUserId) {
        void var1_1;
        if (guestUserId == null) {
            this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            return;
        }
        this.getSharedPreferences().edit().putString("CHK_GUI", RTB.encrypt(context, (String)var1_1)).apply();
    }

    /*
     * WARNING - void declaration
     */
    private String getGuestUserId() {
        String guestUserId = this.getSharedPreferences().getString("CHK_GUI", null);
        if (guestUserId != null) {
            void var1_1;
            return RTB.decrypt(context, (String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void unsetUserAttribute(String attributeKey) {
        void var1_1;
        this.unsetUserAttributes(new String[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public void unsetUserAttributes(String[] attributeKeys) {
        void var2_2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKeys == null || attributeKeys.length == 0) {
            HGC.e(TAG, "attribute keys parameter should has a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            void var3_3;
            void var1_1;
            JSONObject keys = new JSONObject();
            for (void key : var1_1) {
                keys.put((String)key, (Object)new JSONObject().put("operation", (Object)"unset"));
            }
            metadata.put("keys", (Object)var3_3);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), (JSONObject)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void addToUserAttributeArray(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        this.addToUserAttributeArrayInternal((String)var1_1, new String[]{var2_2}, null);
    }

    /*
     * WARNING - void declaration
     */
    public void addToUserAttributeArray(String attributeKey, String[] attributeValues) {
        void var2_2;
        void var1_1;
        this.addToUserAttributeArrayInternal((String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void addToUserAttributeArray(String attributeKey, Integer attributeValue) {
        void var2_2;
        void var1_1;
        this.addToUserAttributeArrayInternal((String)var1_1, new Integer[]{var2_2}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void addToUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        void var2_2;
        void var1_1;
        this.addToUserAttributeArrayInternal((String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFromUserAttributeArray(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        this.removeFromUserAttributeArrayInternal((String)var1_1, new String[]{var2_2}, null);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFromUserAttributeArray(String attributeKey, String[] attributeValues) {
        void var2_2;
        void var1_1;
        this.removeFromUserAttributeArrayInternal((String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromUserAttributeArray(String attributeKey, Integer attributeValue) {
        void var2_2;
        void var1_1;
        this.removeFromUserAttributeArrayInternal((String)var1_1, new Integer[]{var2_2}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        void var2_2;
        void var1_1;
        this.removeFromUserAttributeArrayInternal((String)var1_1, (Object[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void addToUserAttributeArrayInternal(String attributeKey, Object[] attributeValues, Callback callback) {
        void var3_3;
        JSONException jSONException;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKey == null || attributeKey.isEmpty()) {
            HGC.e(TAG, "attribute key parameter should has a value.");
            return;
        }
        if (attributeValues == null || attributeValues.length <= 0) {
            HGC.e(TAG, "attribute values parameter should have a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            void var2_2;
            metadata.put("keys", (Object)new JSONObject().put((String)((Object)jSONException), (Object)new JSONObject().put("operation", (Object)"addToArray").put("type", (Object)"array").put("value", (Object)HUI.MRR(var2_2))));
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            jSONException2.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), metadata, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromUserAttributeArrayInternal(String attributeKey, Object[] attributeValues, Callback callback) {
        void var3_3;
        JSONException jSONException;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeKey == null || attributeKey.isEmpty()) {
            HGC.e(TAG, "attribute key parameter should has a value.");
            return;
        }
        if (attributeValues == null || attributeValues.length <= 0) {
            HGC.e(TAG, "attribute values parameter should have a value.");
            return;
        }
        JSONObject metadata = new JSONObject();
        try {
            void var2_2;
            metadata.put("keys", (Object)new JSONObject().put((String)((Object)jSONException), (Object)new JSONObject().put("operation", (Object)"removeFromArray").put("type", (Object)"array").put("value", (Object)HUI.MRR(var2_2))));
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            jSONException2.printStackTrace();
        }
        this.setUserAttributesInternal(new HashMap<String, Object>(), metadata, (Callback)var3_3);
    }

    public HashMap<String, Object> getUserAttributes() {
        try {
            try {
                String jsonStringEnc = this.getSharedPreferences().getString("CHK_USER_INFO", null);
                if (jsonStringEnc != null) {
                    JSONObject jSONObject;
                    jSONObject = new JSONObject(RTB.decrypt(context, (String)jSONObject));
                    return (HashMap)HUI.OJW(jSONObject);
                }
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
            return null;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setUserAttributesInternal(HashMap<String, Object> attributes, JSONObject metadata, Callback callback) {
        if (this.isRegistered()) {
            void var3_3;
            void var2_2;
            void var1_1;
            com.MRR.NZV.NZV.NZV nZV = this.getLocalInstallation();
            nZV.userInfo(this.getInstallationId(), (Map<String, Object>)var1_1, (JSONObject)var2_2, new VLN(this, (Callback)var3_3));
        }
    }

    private void saveUserAttributes(HashMap<String, Object> attributes) {
        Exception exception;
        if (attributes == null) {
            return;
        }
        this.userInfo = attributes;
        try {
            JSONObject json = new JSONObject(this.userInfo);
            this.getSharedPreferences().edit().putString("CHK_USER_INFO", RTB.encrypt(context, exception.toString())).apply();
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUserAttributes(Bundle attributes) {
        void var1_1;
        this.setUserAttributes((Bundle)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void setUserAttributes(Bundle attributes, Callback callback) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            HGC.e(TAG, "attributes parameter should have a value. To removing attributes data, provide an empty Bundle");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter should have a value. To removing attributes data, provide an empty Bundle"));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(attributes);
        HashMap userInfoMap = (HashMap)HUI.NZV(attributes);
        if (userInfoMap == null) {
            HGC.e(TAG, "cannot convert attributes parameter to map.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("cannot convert attributes parameter to map."));
            }
            return;
        }
        this.saveUserAttributes(userInfoMap);
        this.setUserAttributesInternal((HashMap<String, Object>)var1_1, (JSONObject)var3_3, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserAttributes(HashMap<String, Object> attribute) {
        void var1_1;
        this.setUserAttributes((HashMap<String, Object>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void setUserAttributes(HashMap<String, Object> attribute, Callback callback) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attribute == null) {
            HGC.e(TAG, "attribute parameter should has a value. To removing attribute data, provide an empty HashMap");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attribute parameter should has a value. To removing attribute data, provide an empty HashMap"));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(attribute);
        this.saveUserAttributes(attribute);
        this.setUserAttributesInternal((HashMap<String, Object>)var1_1, (JSONObject)var3_3, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void incrementUserAttribute(String attributeName) {
        void var1_1;
        this.incrementUserAttribute((String)var1_1, 1.0, null);
    }

    /*
     * WARNING - void declaration
     */
    private void incrementUserAttribute(String attributeName, Callback callback) {
        void var2_2;
        void var1_1;
        this.incrementUserAttribute((String)var1_1, 1.0, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void incrementUserAttribute(String attributeName, double value) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            HGC.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put((String)var1_1, (double)var2_2);
        this.incrementUserAttribute(attributesArray, null);
    }

    /*
     * WARNING - void declaration
     */
    private void incrementUserAttribute(String attributeName, double value, Callback callback) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            HGC.e(TAG, "attributeName is null. Please provide an attributeName");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributeName is null. Please provide an attributeName"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put((String)var1_1, (double)var2_2);
        this.incrementUserAttribute(attributesArray, callback);
    }

    /*
     * WARNING - void declaration
     */
    public void incrementUserAttribute(ArrayList<String> attributes) {
        void var1_1;
        this.incrementUserAttribute((ArrayList<String>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void incrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        void var2_2;
        void var3_3;
        Iterator iterator;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            HGC.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            attributesArray.put(attribute, 1.0);
        }
        this.incrementUserAttribute((HashMap<String, Double>)var3_3, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void incrementUserAttribute(HashMap<String, Double> attributes) {
        void var1_1;
        this.incrementUserAttribute((HashMap<String, Double>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void incrementUserAttribute(HashMap<String, Double> attributes, Callback callback) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            HGC.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }
        JSONArray attributesArray = new JSONArray();
        Object object = attributes.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry me = (Map.Entry)object.next();
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", me.getKey());
                attribute.put("value", me.getValue());
                attributesArray.put((Object)attribute);
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        if (this.isRegistered()) {
            void var2_2;
            void var3_3;
            object = this.getLocalInstallation();
            ((com.MRR.NZV.NZV.NZV)object).incrementAttribute(this.getInstallationId(), (JSONArray)var3_3, new IRK(this, attributes, (Callback)var2_2));
            return;
        }
        HGC.d(TAG, "User not registered yet, try to increment attributes (" + attributes.toString() + ") after send successfully installation request");
        this.eventBus.register(new RGI(this, (HashMap)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void decrementUserAttribute(String attributeName) {
        void var1_1;
        this.incrementUserAttribute((String)var1_1, -1.0, null);
    }

    /*
     * WARNING - void declaration
     */
    public void decrementUserAttribute(String attributeName, double value) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributeName == null) {
            HGC.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        attributesArray.put((String)var1_1, (double)(-var2_2));
        this.incrementUserAttribute(attributesArray, null);
    }

    /*
     * WARNING - void declaration
     */
    public void decrementUserAttribute(ArrayList<String> attributes) {
        void var1_1;
        this.decrementUserAttribute((ArrayList<String>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void decrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        void var2_2;
        void var3_3;
        Iterator iterator;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            HGC.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }
        HashMap<String, Double> attributesArray = new HashMap<String, Double>();
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            attributesArray.put(attribute, -1.0);
        }
        this.incrementUserAttribute((HashMap<String, Double>)var3_3, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void decrementUserAttribute(HashMap<String, Double> attributes) {
        void var1_1;
        this.decrementUserAttribute((HashMap<String, Double>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void decrementUserAttribute(HashMap<String, Double> attributes, Callback callback) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (attributes == null) {
            HGC.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }
        JSONArray attributesArray = new JSONArray();
        Object object = attributes.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry me = (Map.Entry)object.next();
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", me.getKey());
                attribute.put("value", -((Double)me.getValue()).doubleValue());
                attributesArray.put((Object)attribute);
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        if (this.isRegistered()) {
            void var2_2;
            void var3_3;
            object = this.getLocalInstallation();
            ((com.MRR.NZV.NZV.NZV)object).incrementAttribute(this.getInstallationId(), (JSONArray)var3_3, new RPN(this, attributes, (Callback)var2_2));
            return;
        }
        HGC.d(TAG, "User not registered yet, try to increment attributes (" + attributes.toString() + ") after send successfully installation request");
        this.eventBus.register(new CVA(this, (HashMap)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> loadMap(String key) {
        void var2_2;
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            String jsonStringEnc = this.getSharedPreferences().getString(key, null);
            if (jsonStringEnc != null) {
                JSONObject jsonObject = new JSONObject(RTB.decrypt(context, jsonStringEnc));
                Iterator keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String k = (String)keysItr.next();
                    Object v = jsonObject.get(k);
                    outputMap.put(k, v);
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject prepareMetaData(JSONObject data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            Iterator it = data.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
                data.put(key, ((Datetime)data.get(key)).getTime());
            }
            if (dateParams.length() > 0) {
                void var2_2;
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)var2_2);
                return metaData;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject prepareMetaData(HashMap<String, Object> data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            Object object = data.keySet();
            object = object.iterator();
            while (object.hasNext()) {
                String key = (String)object.next();
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
                data.put(key, ((Datetime)data.get(key)).getTime());
            }
            if (dateParams.length() > 0) {
                void var2_2;
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)var2_2);
                return object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject prepareMetaData(Bundle data) {
        if (data == null) {
            return null;
        }
        try {
            JSONObject dateParams = new JSONObject();
            Object object = data.keySet();
            object = object.iterator();
            while (object.hasNext()) {
                String key = (String)object.next();
                if (!(data.get(key) instanceof Datetime)) continue;
                dateParams.put(key, (Object)new JSONObject().put("type", (Object)"date"));
            }
            if (dateParams.length() > 0) {
                void var2_2;
                JSONObject metaData = new JSONObject();
                metaData.put("keys", (Object)var2_2);
                return object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return null;
    }

    public static void setDefaultTracker(String defaultTracker) {
        AdpPushClient.defaultTracker = defaultTracker;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public AdpPushClient setDevelopment(boolean isDev) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        this.useDev = var1_1;
        this.getSharedPreferences().edit().putBoolean("useDev", this.useDev).apply();
        this.initializeAdapter();
        return this;
    }

    public static void setEnvironment(Environment environment) {
        chabokEnvironment = environment;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultNotificationChannel(String channelName) {
        String defaultChannelId = "default";
        if (Build.VERSION.SDK_INT >= 26) {
            void var1_1;
            void var2_2;
            this.createOrUpdateNotificationChannel((String)var2_2, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void createOrUpdateNotificationChannel(String channelId, String channelName) {
        if (Build.VERSION.SDK_INT >= 26) {
            void var2_2;
            void var1_1;
            new TUY((String)var1_1, this.getApplicationContext()).setChannelName((String)var2_2).build();
        }
    }

    /*
     * WARNING - void declaration
     */
    void deleteNotificationChannel(String channelId) {
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            if (notificationManager != null) {
                void var1_1;
                void var2_2;
                var2_2.deleteNotificationChannel((String)var1_1);
                return;
            }
        } else {
            HGC.d(TAG, "Couldn't delete notification channel, because is require api level 26");
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean hasNotificationChannel(String channelId) {
        if (channelId == null) {
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && notificationManager != null) {
            void var1_1;
            void var2_2;
            return var2_2.getNotificationChannel((String)var1_1) != null;
        }
        return false;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, Callback clbk) {
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, "+", false, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, "+", (boolean)var2_2, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, String installationId, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.subscribeEvent((String)var1_1, (String)var2_2, false, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeEvent(String eventName, String installationId, boolean live, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        GKV.getInstance(this.getApplicationContext()).NZV((String)var1_1, (String)var2_2, (boolean)var3_3, clbk);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeEvent(String eventName, Callback clbk) {
        void var2_2;
        void var1_1;
        this.unsubscribeEvent((String)var1_1, "+", (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeEvent(String eventName, String installationId, Callback clbk) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        GKV.getInstance(this.getApplicationContext()).NZV((String)var1_1, (String)var2_2, (Callback<String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void track(String eventName) {
        void var1_1;
        this.track((String)var1_1, (Bundle)null);
    }

    /*
     * WARNING - void declaration
     */
    public void track(String eventName, Bundle data) {
        void var2_2;
        void var1_1;
        this.track((String)var1_1, (Bundle)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void track(String eventName, Bundle data, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (eventName == null) {
            HGC.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            HGC.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        JSONObject convertedData = HUI.MRR(data);
        this.trackInternal((String)var1_1, (JSONObject)var2_2, (JSONObject)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void track(String eventName, JSONObject data) {
        void var2_2;
        void var1_1;
        this.track((String)var1_1, (JSONObject)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void track(String eventName, JSONObject data, Callback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (eventName == null) {
            HGC.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            HGC.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        JSONObject metadata = this.prepareMetaData(data);
        this.trackInternal((String)var1_1, (JSONObject)var2_2, (JSONObject)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void trackInternal(String eventName, JSONObject data, JSONObject metadata) {
        void var1_1;
        JSONException influenceData;
        JSONObject trackData = new JSONObject();
        try {
            trackData.put("id", (Object)UUID.randomUUID().toString());
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                if (metadata != null) {
                    void var3_3;
                    trackData.put(META_DATA, (Object)var3_3);
                }
                trackData.put("data", (Object)data);
            }
            if ((influenceData = JYK.YCE()) != null) {
                if (JYK.XTU()) {
                    influenceData.put("direct", JYK.XTU());
                }
                trackData.put("influence", (Object)influenceData);
            }
        }
        catch (JSONException jSONException) {
            influenceData = jSONException;
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            void var2_2;
            JSONObject finalTrackData = trackData;
            this.eventBus.register(new VIN(this, eventName, (JSONObject)var2_2));
            return;
        }
        HGC.d(TAG, "Track event: " + eventName);
        this.emit(PZH.track, (String)var1_1, this.getInstallationId(), trackData, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void trackPurchase(String eventName, ChabokEvent chabokEvent) {
        if (chabokEvent == null) {
            HGC.e(TAG, "chabokEvent is null, please provide a revenue");
            return;
        }
        if (chabokEvent.revenue < 0.0) {
            HGC.e(TAG, "Could not track event, Invalid amount");
        }
        new JSONObject();
        try {
            void var2_2;
            void var3_3;
            void var1_1;
            JSONObject data = new JSONObject();
            if (chabokEvent.data != null) {
                data = chabokEvent.data;
            }
            data.put("isRevenue", true);
            data.put("value", (Object)chabokEvent.revenue);
            if (chabokEvent.currency != null) {
                data.put("currency", (Object)chabokEvent.currency);
            }
            JSONObject metadata = this.prepareMetaData(data);
            this.trackInternal((String)var1_1, (JSONObject)var3_3, (JSONObject)var2_2);
            return;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void trackRevenue(double revenue) {
        void var1_1;
        this.trackPurchase("Purchase", new ChabokEvent((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    void publishClientEvents(String id2, JSONArray data) {
        void var3_3;
        void var2_2;
        JSONObject trackData = new JSONObject();
        try {
            trackData.put("id", id2);
            trackData.put("createdAt", System.currentTimeMillis());
            if (data != null) {
                trackData.put("eventData", (Object)data);
            }
        }
        catch (JSONException jSONException) {
            id2 = jSONException;
            jSONException.printStackTrace();
        }
        if (this.getInstallationId() == null) {
            void var1_1;
            JSONObject finalEventData = trackData;
            this.eventBus.register(new GMT(this, (JSONObject)var1_1));
            return;
        }
        HGC.d(TAG, "-- Publish cached data " + var2_2);
        this.emit(PZH.event, "clientEvent", this.getInstallationId(), (JSONObject)var3_3, true, false);
    }

    public AdpPushClient enableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        this.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    /*
     * WARNING - void declaration
     */
    private AdpPushClient setSecure(boolean isSecure) {
        void var1_1;
        this.useSecure = var1_1;
        this.initializeAdapter();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getSubscriptions() {
        void var1_1;
        ArrayList<String> newChannels = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n = this.channels.length;
        for (int i = 0; i < n; ++i) {
            String ch = stringArray[i];
            String chName = this.convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }
        return newChannels.toArray(new String[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private String convertChannelName2newConvention(String channel) {
        void var1_1;
        if (channel.startsWith("private/")) {
            return channel;
        }
        if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        }
        return "private/" + (String)var1_1;
    }

    SharedPreferences getSharedPreferences() {
        return HUI.getSharedPreferences(this.getApplicationContext());
    }

    /*
     * WARNING - void declaration
     */
    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        void var1_1;
        AdpPushClient.get().currentActivity = new WeakReference<void>(var1_1);
        return this;
    }

    public static void setActivityClass(Class activityClass) {
        AdpPushClient.activityClass = activityClass;
    }

    /*
     * WARNING - void declaration
     */
    void notifyNewMessage(PushMessage message) {
        void var1_1;
        void var2_2;
        Class clazz = activityClass;
        if (AdpPushClient.hasNotified(message.getId())) {
            return;
        }
        Iterator<NotificationHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            ChabokNotification notif;
            NotificationHandler h = iterator.next();
            Class theirs = h.getActivityClass(notif = new ChabokNotification(message, 0));
            if (theirs == null) continue;
            clazz = theirs;
        }
        void finalClazz = var2_2;
        void finalMessage = var1_1;
        new WFM(this, (Class)((Object)iterator), (PushMessage)finalMessage).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    /*
     * WARNING - void declaration
     */
    boolean addNotifiedMessage(String id2) {
        void var1_2;
        boolean val = notifs.add(id2);
        this.getSharedPreferences().edit().putStringSet("notifs", new HashSet<String>(Arrays.asList(notifs.toArray(new String[notifs.size()])))).apply();
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        void var2_2;
        Class clazz = activityClass;
        String title = data.getString("title");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h : this.handlers) {
            ChabokNotification gcmNotif;
            Class theirs = h.getActivityClass(gcmNotif = new ChabokNotification(data.getString("messageId"), title, data.getString("message"), (int)Integer.valueOf(data.getString("androidBadge", "0")), data));
            if (theirs == null) continue;
            clazz = theirs;
        }
        return var2_2;
    }

    boolean notificationOpened(Bundle data, ChabokNotificationAction notificationAction) {
        Iterator<NotificationHandler> iterator;
        ChabokNotification chabokNotif;
        this.lastNotificationAction = notificationAction;
        String title = data.getString("title");
        boolean shouldLaunchActivity2 = true;
        if (title == null) {
            title = data.getString("messageFrom");
        }
        this.lastNotificationData = chabokNotif = new ChabokNotification(data.getString("messageId"), (String)((Object)iterator), data.getString("message"), (int)Integer.valueOf(data.getString("androidBadge", "0")), data);
        for (NotificationHandler shouldLaunchActivity2 : this.handlers) {
            shouldLaunchActivity2 = shouldLaunchActivity2.notificationOpened(chabokNotif, notificationAction);
        }
        return shouldLaunchActivity2;
    }

    public ChabokNotificationAction getLastNotificationAction() {
        return this.lastNotificationAction;
    }

    public ChabokNotification getLastNotificationData() {
        return this.lastNotificationData;
    }

    /*
     * WARNING - void declaration
     */
    public boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        void var3_3;
        boolean showNotification = true;
        for (NotificationHandler h : this.handlers) {
            showNotification &= h.buildNotification(notif, builder);
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void addNotificationHandler(NotificationHandler handler) {
        void var1_1;
        this.handlers.add((NotificationHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void launchSingleTaskUri(String uri, String logMessage) {
        Exception exception;
        try {
            void var3_3;
            void var2_2;
            String url = uri;
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            Intent i = new Intent("android.intent.action.VIEW");
            i.addFlags(0x10020000);
            i.setData(Uri.parse((String)url));
            HGC.d(HGC.TAG, (String)var2_2 + " " + (String)((Object)exception));
            context.startActivity((Intent)var3_3);
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener deeplinkResponseListener) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.onDeeplinkResponseListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDeferredDataListener(DeferredDataListener deferredDataListener) {
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.deferredDataListener = var1_1;
    }

    private void getDeferredDeepLink() {
        com.MRR.NZV.NZV.NZV nZV = this.getLocalInstallation();
        nZV.deferredDeepLink(this.getInstallationId(), new QHG(this));
    }

    /*
     * WARNING - void declaration
     */
    public void appWillOpenUrl(Uri url) {
        Exception exception;
        if (url == null || url.toString().trim().isEmpty()) {
            HGC.d(TAG, "Deeplink url is not vaild!!");
            return;
        }
        long clickTime = System.currentTimeMillis();
        JSONObject json = new JSONObject();
        try {
            void var2_2;
            json.put("type", 0);
            json.put("deepLinkClickTs", (long)var2_2);
            json.put("deepLinkUrl", (Object)url.toString());
            PWW communicateEvent = new PWW(json, JZR.GotDeepLink);
            this.eventBus.post(exception);
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasProtectedAppSupport() {
        void var1_1;
        String deviceManufacturer = this.getDeviceManufacturer().toLowerCase();
        return !TextUtils.isEmpty((CharSequence)deviceManufacturer) && (deviceManufacturer.contains("huawei") || var1_1.contains("xiaomi"));
    }

    /*
     * WARNING - void declaration
     */
    private String getDeviceManufacturer() {
        void var1_1;
        String deviceMan = Build.MANUFACTURER;
        HGC.d("deviceMan", deviceMan);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void showProtectedAppSettings(Activity ctx, String app_name, String title, String msg) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        title = title != null && !title.isEmpty() ? title : "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647";
        msg = msg != null && !msg.isEmpty() ? msg : String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", var2_2);
        this.showGuide((Activity)var1_1, (String)var3_3, msg);
    }

    /*
     * WARNING - void declaration
     */
    private void showGuide(Activity ctx, String title, String message) {
        this.getApplicationContext();
        SharedPreferences settings = ctx.getSharedPreferences("ProtectedApps", 0);
        boolean bl = settings.getBoolean("skipProtectedAppsMessage", false);
        if (!bl) {
            SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                void var3_3;
                void var2_2;
                void var1_1;
                CheckBox dontShowAgain = new CheckBox(this.getApplicationContext());
                dontShowAgain.setTextColor(-16777216);
                dontShowAgain.setText((CharSequence)"     \u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                dontShowAgain.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new NHW(this, editor));
                new AlertDialog.Builder((Context)var1_1).setIcon(17301543).setTitle((CharSequence)var2_2).setMessage((CharSequence)var3_3).setView((View)dontShowAgain).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)new WGR(this)).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
                return;
            }
            editor.putBoolean("skipProtectedAppsMessage", true);
            editor.apply();
        }
    }

    private boolean isCallable(Intent intent) {
        List list;
        list = this.getApplicationContext().getPackageManager().queryIntentActivities((Intent)list, 65536);
        return list.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private void huaweiProtectedApps() {
        try {
            void var1_1;
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec((String)var1_1);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getUserSerial() {
        Object userManager = this.getApplicationContext().getSystemService("user");
        if (userManager == null) {
            return "";
        }
        try {
            Method method = Process.class.getMethod("myUserHandle", null);
            Object myUserHandle = method.invoke(Process.class, null);
            Method method2 = userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass());
            Long userSerial = (Long)method2.invoke(userManager, method);
            if (userSerial != null) {
                void var1_1;
                return String.valueOf(var1_1);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !this.isPlayServicesSupported();
    }

    public boolean isPlayServicesSupported() {
        return !HUI.isSupportPlayServices(this.getApplicationContext());
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateDeviceToken(LPP token) {
        void var1_1;
        this.updateDeviceToken((LPP)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateDeviceToken(LPP token, @Nullable Callback callback) {
        void var2_2;
        void var3_6;
        com.MRR.NZV.NZV.NZV nZV;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            HGC.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }
        if (token == null || TextUtils.isEmpty((CharSequence)token.getToken())) {
            String msg = "updateDeviceToken: token is empty";
            HGC.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to update device token...";
            HGC.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        long ts = System.currentTimeMillis();
        String userId = this.getUserId();
        String installationId = this.getInstallationId();
        HashMap<String, Object> tokenError = null;
        if (token.getTokenErr() != null) {
            tokenError = new HashMap<String, Object>();
            tokenError.put("code", token.getTokenErrCode());
            tokenError.put("message", token.getTokenErr());
        }
        data.put("createdAt", ts);
        data.put("userId", userId);
        data.put("installationId", installationId);
        data.put("deviceType", "android");
        data.put("deviceToken", token.getToken());
        if (tokenError != null) {
            data.put("tokenError", tokenError);
        }
        if (token.getTokenStatus() != null) {
            data.put("tokenStatus", ((LPP)((Object)nZV)).getTokenStatus());
        }
        nZV = this.getLocalInstallation();
        nZV.updateDeviceToken((Map<String, Object>)var3_6, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String tagName, Callback callback) {
        void var2_2;
        void var1_1;
        String msg;
        if (this.userId == null) {
            msg = "userId not initialized yet";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "addTag: tag is empty";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{msg};
        this.addTag((String[])var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String[] tagsName, Callback callback) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            String msg = "userId not initialized yet";
            HGC.e(TAG, msg);
            if (callback != null) {
                void var3_3;
                callback.onFailure(new Throwable((String)var3_3));
            }
            return;
        }
        Object object = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            String string = object[i];
            if (!TextUtils.isEmpty((CharSequence)string)) continue;
            String msg = "addTags: tag is empty";
            HGC.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable((String)var1_1));
            }
            return;
        }
        object = this.getLocalInstallation();
        object.addTag((String[])var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeTag(String tagName, Callback callback) {
        void var2_2;
        void var1_1;
        String msg;
        if (this.userId == null) {
            msg = "userId not initialized yet";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = "removeTag: tag is empty";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{msg};
        this.removeTag((String[])var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeTag(String[] tagsName, Callback callback) {
        void var2_2;
        void var1_1;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId == null) {
            void var3_3;
            String msg = "userId not initialized yet";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable((String)var3_3));
            return;
        }
        Object object = tagsName;
        int n = tagsName.length;
        for (int i = 0; i < n; ++i) {
            String string = object[i];
            if (!TextUtils.isEmpty((CharSequence)string)) continue;
            String msg = "removeTag: tag is empty";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable((String)var1_1));
            return;
        }
        object = this.getLocalInstallation();
        object.removeTag((String[])var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void sendEventData(JSONArray datas, Callback callback) {
        void var2_2;
        void var3_5;
        Object object;
        Object appSignature;
        if (datas == null) {
            String msg = "Please provide a data parameter";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to send fallback event...";
            HGC.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        long ts = System.currentTimeMillis();
        String userId = this.getUserId();
        String installationId = this.getInstallationId();
        body.put("createdAt", ts);
        body.put("userId", userId);
        body.put("installationId", installationId);
        body.put("deviceType", "android");
        try {
            appSignature = DYH.getAppSignature(context);
            if (appSignature != null) {
                body.put("appSessionId", appSignature);
            } else {
                body.put("appSessionId", "INVALID");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            appSignature = nameNotFoundException;
            nameNotFoundException.printStackTrace();
        }
        body.put("appTokenId", DYH.base64CreateFingerprint(context));
        body.put("eventData", datas);
        try {
            appSignature = String.valueOf(GKV.OJW.toJson(body)).replaceAll("(\\\\.)", "/");
            Integer l = ((String)appSignature).length();
            String type = body.get("deviceType").toString();
            String manId = AdpPushClient.get().getManufacturerId(userId, installationId, type, ts, l);
            if (manId != null) {
                void var1_1;
                body.put("sessionId", var1_1);
            }
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        HGC.d(TAG, "-- Sending eventData");
        object = this.getLocalInstallation();
        ((com.MRR.NZV.NZV.NZV)object).events((Map<String, Object>)var3_5, (Callback)var2_2);
    }

    boolean hasInstallReferrerData() {
        return this.getSharedPreferences().contains("CHK_INSTALL_REFERRER") && this.getSharedPreferences().contains("CHK_INSTALL_REF_CLICK_TS_L") && this.getSharedPreferences().contains("CHK_INSTALL_REF_BEGIN_TS_L");
    }

    /*
     * WARNING - void declaration
     */
    String getInstallReferrer() {
        void var1_1;
        String encryptInstallReferrer = this.getSharedPreferences().getString("CHK_INSTALL_REFERRER", null);
        if (encryptInstallReferrer == null) {
            return null;
        }
        return RTB.decrypt(context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    long getInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            void var1_1;
            HGC.e("AdpPushLibrary", "Exception happen to get ReferrerClickTimestampSeconds", (Throwable)var1_1);
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    long getInstallReferrerInstallBeginTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_BEGIN_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            void var1_1;
            HGC.e("AdpPushLibrary", "Exception happen to get InstallBeginTimestampSeconds", (Throwable)var1_1);
            return 0L;
        }
    }

    void getApplicationInstallReferrer() {
        new OWQ(context, new JAZ(this));
    }

    /*
     * WARNING - void declaration
     */
    void sendInstallReferrer(String rawReferrer, Context context) {
        void var3_3;
        void var1_1;
        void var2_2;
        long clickTime = System.currentTimeMillis();
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }
        AdpPushClient.context = context;
        this.getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REFERRER", RTB.encrypt((Context)var2_2, (String)var1_1)).apply();
        this.getSharedPreferences().edit().putLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", (long)var3_3).apply();
    }

    /*
     * WARNING - void declaration
     */
    private String getRawInstallReferrer() {
        void var1_1;
        String encryptRawInstallReferrer = this.getSharedPreferences().getString("CHK_RAW_INSTALL_REFERRER", null);
        if (encryptRawInstallReferrer == null) {
            return null;
        }
        return RTB.decrypt(context, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private long getRawInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException ex) {
            void var1_1;
            HGC.e("AdpPushLibrary", "Exception happen to get RawInstallRefClickTs", (Throwable)var1_1);
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getRawInstallReferrerParams() {
        void var1_1;
        Iterator iterator;
        String referrer = this.getRawInstallReferrer();
        try {
            referrer = URLDecoder.decode(referrer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            referrer = "malformed";
            HGC.d(HGC.TAG, "Referrer decoding failed due to UnsupportedEncodingException. Message: (" + e.getMessage() + ")");
        }
        catch (IllegalArgumentException e) {
            referrer = "malformed";
            HGC.d(HGC.TAG, "Referrer decoding failed due to IllegalArgumentException. Message: (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            referrer = "malformed";
            HGC.d(HGC.TAG, "Referrer decoding failed. Message: (" + e.getMessage() + ")");
        }
        HGC.v(HGC.TAG, "Referrer to parse (" + referrer + ")");
        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        for (UrlQuerySanitizer.ParameterValuePair params : iterator.getParameterList()) {
            void var3_6;
            extraParameters.put(params.mParameter, var3_6.mValue);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    String getManufacturerId(String userId, String uid, String type, long launchTs, Integer len) {
        try {
            void var3_7;
            void var1_1;
            Object object;
            void var2_2;
            int n;
            int n2;
            Object[] objectArray;
            long l;
            WAW manufacturer;
            block8: {
                manufacturer = new WAW();
                Object object2 = type;
                int n3 = 2;
                if (((String)object2).length() > 2) {
                    n3 = ((String)object2).charAt(2);
                }
                int v322 = n3;
                l = Long.parseLong(Long.toString(launchTs));
                int n4 = v322;
                object2 = manufacturer;
                objectArray = Long.toString(l);
                n2 = n4;
                Object[] objectArray2 = objectArray;
                char[] v322 = objectArray.toCharArray();
                for (n4 = v322.length - 1; n4 >= 0; --n4) {
                    if (Character.toString(v322[n4]).contains("0")) continue;
                    n = Integer.parseInt(Character.toString(v322[n4]));
                    break block8;
                }
                n = 9;
            }
            int n5 = n2 % n;
            int v322 = Integer.parseInt(Character.toString(objectArray.charAt(objectArray.length() - 3)));
            long l2 = l;
            String string = Long.valueOf(l2).toString();
            char[] cArray = string.toCharArray();
            long[] lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = Character.getNumericValue(cArray[i]);
            }
            Object object3 = lArray;
            Object object4 = Arrays.copyOfRange(lArray, 0, v322);
            object4 = WAW.NZV((long[])object4);
            Object v322 = Arrays.copyOfRange((long[])object3, v322, objectArray.length());
            v322 = WAW.NZV((long[])v322);
            object4.add(Long.valueOf(n5));
            object4.addAll(v322);
            Object object5 = object4;
            v322 = new StringBuilder();
            object3 = object5.iterator();
            while (object3.hasNext()) {
                long l3 = (Long)object3.next();
                ((StringBuilder)v322).append(Long.toString(l3));
            }
            String sugar = ((StringBuilder)v322).toString();
            sugar = new StringBuilder(sugar).insert(sugar.length() / 2, len).toString();
            String string2 = Long.toString(launchTs);
            void var13_17 = var2_2;
            object3 = userId;
            Object object6 = manufacturer;
            if (object3 == null || var13_17 == null || string2 == null) {
                object = "";
            } else {
                objectArray = new String[]{object3, var13_17, string2};
                object = object6 = TextUtils.join((CharSequence)((WAW)object6).NZV(), (Object[])objectArray);
            }
            String ManufacturerId = object;
            return WAW.NZV((String)var1_1 + (String)var3_7);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static void configureEnvironment(Environment environment) {
        AdpPushClient.configureEnvironment(environment, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void configureEnvironment(Environment environment, String guestId) {
        void var1_1;
        void var2_2;
        if (context == null) {
            throw new IllegalStateException("AdpPushClient is not initialized in this process " + FOL.getMyProcessName() + ". Make sure to call AdpPushClient.setApplicationContext(Context) first.");
        }
        com.adpdigital.push.config.NZV config = com.adpdigital.push.config.MRR.getConfiguration(environment);
        if (config == null) {
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to configure correct environment. Please see http://bit.ly/32x1Tsn");
        }
        AdpPushClient.init(config.appId(), config.apiKey(), config.username(), config.password());
        chabokEnvironment = environment;
        if (environment == null) {
            AdpPushClient.get().setDevelopment(true);
        } else {
            AdpPushClient.get().setDevelopment(environment != Environment.PRODUCTION);
        }
        AdpPushClient.get().setEnableRealtime(config.realtime());
        AdpPushClient.get().setConfiguration((com.adpdigital.push.config.NZV)var2_2);
        Object userId = AdpPushClient.get().getUserId();
        if (userId != null) {
            Object object;
            AdpPushClient.get().register((String)object);
            return;
        }
        AdpPushClient.get().registerAsGuest((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setConfiguration(com.adpdigital.push.config.NZV config) {
        void var1_1;
        this.config = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId) {
        void var1_1;
        this.register((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId, @Nullable Callback<String> loginCallback) {
        void var2_2;
        void var1_1;
        this.register((String)var1_1, (Callback<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId, String[] tagsName) {
        void var2_2;
        void var1_1;
        this.login((String)var1_1, (String[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void login(String userId, String[] tagsName, @Nullable Callback<String> loginCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.register((String)var1_1, new KTB(this, (String[])var2_2, (Callback)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId, HashMap<String, Object> attributes) {
        void var2_2;
        void var1_1;
        this.login((String)var1_1, (HashMap<String, Object>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private void login(String userId, HashMap<String, Object> attributes, @Nullable Callback<String> loginCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.register((String)var1_1, new IXL(this, (HashMap)var2_2, (Callback)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId, String eventName, JSONObject data) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.login((String)var1_1, (String)var2_2, (JSONObject)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private void login(String userId, String eventName, JSONObject data, @Nullable Callback<String> loginCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.register((String)var1_1, new WVK(this, (String)var2_2, (JSONObject)var3_3, loginCallback));
    }

    /*
     * WARNING - void declaration
     */
    public void login(String userId, String userHash) {
        void var1_1;
        void var2_2;
        this.userHash = var2_2;
        this.register((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void login(String userId, String userHash, @Nullable Callback loginCallback) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.userHash = var2_2;
        this.register((String)var1_1, new UIR(this, (Callback)var3_3));
    }

    public void logout() {
        this.logout(null);
    }

    /*
     * WARNING - void declaration
     */
    private void logout(@Nullable Callback<String> logoutCallback) {
        void var1_1;
        this.registerAsGuest((Callback<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ WeakReference access$002(AdpPushClient x0, WeakReference x1) {
        void var1_1;
        x0.currentActivity = var1_1;
        return x0.currentActivity;
    }

    static /* synthetic */ boolean access$100(AdpPushClient x0) {
        return x0.isFreshStart;
    }

    static /* synthetic */ void access$200(AdpPushClient x0) {
        x0.updateLaunchStats();
    }

    static /* synthetic */ NZV.NZV.NZV.OJW access$300(AdpPushClient x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$400(AdpPushClient x0) {
        return x0.isNewInstall;
    }

    static /* synthetic */ void access$500(AdpPushClient x0) {
        x0.doRegister();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.isFreshStart = var1_1;
        return x0.isFreshStart;
    }

    static /* synthetic */ Context access$600(AdpPushClient x0) {
        return x0.getApplicationContext();
    }

    static /* synthetic */ void access$700(AdpPushClient x0) {
        x0.resetBackgroundTimer();
    }

    static /* synthetic */ void access$800(AdpPushClient x0) {
        x0.startBackgroundTimer();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(AdpPushClient x0, PZH x1, String x2, String x3, JSONObject x4, boolean x5, boolean x6) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.emit((PZH)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ AdpPushClient access$1000(AdpPushClient x0, String x1, String[] x2, Callback x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0._register((String)var1_1, (String[])var2_2, (Callback<String>)var3_3);
    }

    static /* synthetic */ boolean access$1100(AdpPushClient x0) {
        return x0.registeredOnce;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1202(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.registering = var1_1;
        return x0.registering;
    }

    static /* synthetic */ ForegroundManager access$1300(AdpPushClient x0) {
        return x0.foreground;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ AdpPushClient access$1400(AdpPushClient x0, boolean x1) {
        void var1_1;
        return x0.updateRegistration((boolean)var1_1);
    }

    static /* synthetic */ Object access$1500(AdpPushClient x0) {
        return x0._tokenLock;
    }

    static /* synthetic */ void access$1600(AdpPushClient x0) {
        x0.retryGetTokenBackoff();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1700(AdpPushClient x0, LPP x1) {
        void var1_1;
        x0.updateDeviceToken((LPP)var1_1);
    }

    static /* synthetic */ boolean access$1800(AdpPushClient x0) {
        return x0.restartServiceState;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1900(AdpPushClient x0, com.MRR.NZV.NZV.NZV x1, boolean x2) {
        void var2_2;
        void var1_1;
        x0.saveInstallation((com.MRR.NZV.NZV.NZV)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1802(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.restartServiceState = var1_1;
        return x0.restartServiceState;
    }

    static /* synthetic */ Object access$2000(AdpPushClient x0) {
        return x0._installationLock;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1102(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.registeredOnce = var1_1;
        return x0.registeredOnce;
    }

    static /* synthetic */ int access$2102(int x0) {
        installationRetries = x0;
        return installationRetries;
    }

    static /* synthetic */ Callback access$2200(AdpPushClient x0) {
        return x0.registerCallback;
    }

    static /* synthetic */ String access$2300(AdpPushClient x0) {
        return x0.userId;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Callback access$2202(AdpPushClient x0, Callback x1) {
        void var1_1;
        x0.registerCallback = var1_1;
        return x0.registerCallback;
    }

    static /* synthetic */ OnDeeplinkResponseListener access$2400(AdpPushClient x0) {
        return x0.onDeeplinkResponseListener;
    }

    static /* synthetic */ DeferredDataListener access$2500(AdpPushClient x0) {
        return x0.deferredDataListener;
    }

    static /* synthetic */ void access$2600(AdpPushClient x0) {
        x0.getDeferredDeepLink();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$2702(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0._isLoggedInNow = var1_1;
        return x0._isLoggedInNow;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$402(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.isNewInstall = var1_1;
        return x0.isNewInstall;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2802(AdpPushClient x0, String x1) {
        void var1_1;
        x0.userHash = var1_1;
        return x0.userHash;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$2902(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.isLaunched = var1_1;
        return x0.isLaunched;
    }

    static /* synthetic */ void access$3000(AdpPushClient x0) {
        x0.retryRegistrationBackoff();
    }

    static /* synthetic */ com.MRR.NZV.NZV.NZV.YCE access$3100(AdpPushClient x0) {
        return x0.beforeSend();
    }

    static /* synthetic */ boolean access$3200(AdpPushClient x0) {
        return x0.isGuestUser();
    }

    static /* synthetic */ long access$3300(AdpPushClient x0) {
        return x0.getRegisterTs();
    }

    static /* synthetic */ String access$3400(AdpPushClient x0) {
        return x0.getUniqueID();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$3500(AdpPushClient x0, boolean x1) {
        void var1_1;
        x0.getToken((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$3600(AdpPushClient x0, HashMap x1) {
        void var1_1;
        x0.saveUserAttributes((HashMap<String, Object>)var1_1);
    }

    static /* synthetic */ void access$3700(AdpPushClient x0) {
        x0.huaweiProtectedApps();
    }

    static /* synthetic */ Context access$3800() {
        return context;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$3900(AdpPushClient x0, HashMap x1, Callback x2) {
        void var2_2;
        void var1_1;
        x0.setUserAttributes((HashMap<String, Object>)var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$4000(AdpPushClient x0, String x1, JSONObject x2, Callback x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.track((String)var1_1, (JSONObject)var2_2, (Callback)var3_3);
    }

    static {
        FORCE_STICKY = false;
        installationRetries = 0;
        tokenRetries = 0;
        notifs = new EIW<String>(200);
        pushClientInstance = null;
        tokenWorker = Executors.newSingleThreadScheduledExecutor();
    }
}

