/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class GSY {
    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static InputStream bitmapToInputStream(Bitmap bitmap) {
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getHeight() * bitmap.getRowBytes());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        return new ByteArrayInputStream(buffer.array());
    }

    public static int getDrawableId(String name, Context context) {
        return context.getResources().getIdentifier(name, "drawable", context.getPackageName());
    }

    public static int getMipmapId(String name, Context context) {
        return context.getResources().getIdentifier(name, "mipmap", context.getPackageName());
    }

    public static int getResourceId(String name, String def, Context context) {
        return context.getResources().getIdentifier(name, def, context.getPackageName());
    }

    public static boolean isResourceFileExists(String filename, String dir, Context context) {
        return context.getResources().getIdentifier(filename, dir, context.getPackageName()) != 0;
    }
}

