/*
 * Decompiled with CFR 0.152.
 */
package AOP;

import AOP.DYH;
import AOP.HUI;
import AOP.HXH;
import AOP.IRK;
import AOP.IZX;
import AOP.KEM;
import AOP.MRR;
import AOP.NZV;
import AOP.QHM;
import AOP.RGI;
import AOP.RPN;
import AOP.SUU;
import AOP.UFF;
import AOP.VLN;
import AOP.VMB;
import AOP.YCE;
import DYH.AOP;
import HXH.OJW;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class XTU
implements MRR {
    private static final String NZV = XTU.class.getName();
    private static final HXH.MRR MRR = HXH.OJW.getLogger(HXH.OJW.CLIENT_MSG_CAT, NZV);
    private String OJW;
    private String HUI;
    protected DYH.NZV comms;
    private Hashtable YCE;
    private DYH XTU;

    public XTU(String serverURI, String clientId) throws HXH {
        this(serverURI, clientId, new UFF.MRR());
    }

    public XTU(String serverURI, String clientId, DYH persistence) throws HXH {
        this(serverURI, clientId, persistence, new RPN());
    }

    public XTU(String serverURI, String clientId, DYH persistence, QHM pingSender) throws HXH {
        MRR.setResourceName(clientId);
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (AOP.XTU.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        KEM.validateURI(serverURI);
        this.HUI = serverURI;
        this.OJW = clientId;
        this.XTU = persistence;
        if (this.XTU == null) {
            this.XTU = new UFF.NZV();
        }
        MRR.fine(NZV, "BrokerAsyncClient", "101", new Object[]{clientId, serverURI, persistence});
        this.XTU.open(clientId, serverURI);
        this.comms = new DYH.NZV(this, this.XTU, pingSender);
        this.XTU.close();
        this.YCE = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected DYH.UFF[] createNetworkModules(String address, KEM options) throws HXH, VLN {
        MRR.fine(NZV, "createNetworkModules", "116", new Object[]{address});
        String[] serverURIs = options.getServerURIs();
        String[] array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        DYH.UFF[] networkModules = new DYH.UFF[array.length];
        for (int i = 0; i < array.length; ++i) {
            DYH.UFF uFF;
            KEM kEM = options;
            String string = array[i];
            XTU xTU = this;
            MRR.fine(NZV, "createNetworkModule", "115", new Object[]{string});
            SocketFactory socketFactory = kEM.getSocketFactory();
            switch (KEM.validateURI(string)) {
                case 0: {
                    String string2 = string.substring(6);
                    String string3 = AOP.XTU.NZV(string2);
                    int n = AOP.XTU.NZV(string2, 1883);
                    if (socketFactory == null) {
                        socketFactory = SocketFactory.getDefault();
                    } else if (socketFactory instanceof SSLSocketFactory) {
                        throw AOP.createBrokerException(32105);
                    }
                    uFF = new DYH.QHM(socketFactory, string3, n, xTU.OJW);
                    ((DYH.QHM)uFF).setConnectTimeout(kEM.getConnectionTimeout());
                    break;
                }
                case 1: {
                    String[] stringArray;
                    String string2 = string.substring(6);
                    String string3 = AOP.XTU.NZV(string2);
                    int n = AOP.XTU.NZV(string2, 8883);
                    KEM.NZV nZV = null;
                    if (socketFactory == null) {
                        nZV = new KEM.NZV();
                        stringArray = kEM.getSSLProperties();
                        if (stringArray != null) {
                            nZV.initialize((Properties)stringArray, null);
                        }
                        socketFactory = nZV.createSocketFactory(null);
                    } else if (!(socketFactory instanceof SSLSocketFactory)) {
                        throw AOP.createBrokerException(32105);
                    }
                    uFF = new DYH.SUU((SSLSocketFactory)socketFactory, string3, n, xTU.OJW);
                    ((DYH.SUU)uFF).setSSLhandshakeTimeout(kEM.getConnectionTimeout());
                    if (nZV == null || (stringArray = nZV.getEnabledCipherSuites(null)) == null) break;
                    ((DYH.SUU)uFF).setEnabledCiphers(stringArray);
                    break;
                }
                case 2: {
                    uFF = new DYH.KEM(string.substring(8));
                    break;
                }
                default: {
                    uFF = null;
                }
            }
            networkModules[i] = uFF;
        }
        MRR.fine(NZV, "createNetworkModules", "108");
        return networkModules;
    }

    private static int NZV(String uri, int defaultPort) {
        int portIndex = uri.lastIndexOf(58);
        int port = portIndex == -1 ? defaultPort : Integer.parseInt(uri.substring(portIndex + 1));
        return port;
    }

    private static String NZV(String uri) {
        int schemeIndex = uri.lastIndexOf(47);
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(schemeIndex + 1, portIndex);
    }

    @Override
    public YCE connect(Object userContext, NZV callback) throws HXH, VLN {
        return this.connect(new KEM(), userContext, callback);
    }

    @Override
    public YCE connect() throws HXH, VLN {
        return this.connect(null, null);
    }

    @Override
    public YCE connect(KEM options) throws HXH, VLN {
        return this.connect(options, null, null);
    }

    @Override
    public YCE connect(KEM options, Object userContext, NZV callback) throws HXH, VLN {
        if (this.comms.isConnected()) {
            throw AOP.createBrokerException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new HXH(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new HXH(32102);
        }
        if (this.comms.isClosed()) {
            throw new HXH(32111);
        }
        MRR.fine(NZV, "connect", "103", new Object[]{options.isCleanSession(), new Integer(options.getConnectionTimeout()), new Integer(options.getKeepAliveInterval()), options.getUserName(), null == options.getPassword() ? "[null]" : "[notnull]", null == options.getWillMessage() ? "[null]" : "[notnull]", userContext, callback});
        this.comms.setNetworkModules(this.createNetworkModules(this.HUI, options));
        IRK userToken = new IRK(this.getClientId());
        DYH.VMB connectActionListener = new DYH.VMB(this, this.XTU, this.comms, options, userToken, userContext, callback);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public YCE disconnect(Object userContext, NZV callback) throws HXH {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public YCE disconnect() throws HXH {
        return this.disconnect(null, null);
    }

    @Override
    public YCE disconnect(long quiesceTimeout) throws HXH {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public YCE disconnect(long quiesceTimeout, Object userContext, NZV callback) throws HXH {
        MRR.fine(NZV, "disconnect", "104", new Object[]{new Long(quiesceTimeout), userContext, callback});
        IRK token = new IRK(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        IZX.YCE disconnect = new IZX.YCE();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
        }
        catch (HXH ex) {
            MRR.fine(NZV, "disconnect", "105", null, ex);
            throw ex;
        }
        MRR.fine(NZV, "disconnect", "108");
        return token;
    }

    @Override
    public void disconnectForcibly() throws HXH {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws HXH {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws HXH {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.OJW;
    }

    @Override
    public String getServerURI() {
        return this.HUI;
    }

    protected RGI getTopic(String topic) {
        RGI.validate(topic, false);
        RGI result = (RGI)this.YCE.get(topic);
        if (result == null) {
            result = new RGI(topic, this.comms);
            this.YCE.put(topic, result);
        }
        return result;
    }

    public YCE checkPing(Object userContext, NZV callback) throws HXH {
        MRR.fine(NZV, "ping", "117");
        IRK token = this.comms.checkForActivity();
        MRR.fine(NZV, "ping", "118");
        return token;
    }

    @Override
    public YCE subscribe(String topicFilter, int qos, Object userContext, NZV callback) throws HXH {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public YCE subscribe(String topicFilter, int qos) throws HXH {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public YCE subscribe(String[] topicFilters, int[] qos) throws HXH {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public YCE subscribe(String[] topicFilters, int[] qos, Object userContext, NZV callback) throws HXH {
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + "topic=" + topicFilters[i] + " qos=" + qos[i];
            RGI.validate(topicFilters[i], true);
        }
        MRR.fine(NZV, "subscribe", "106", new Object[]{subs, userContext, callback});
        IRK token = new IRK(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        IZX.IRK register = new IZX.IRK(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        MRR.fine(NZV, "subscribe", "109");
        return token;
    }

    @Override
    public YCE unsubscribe(String topicFilter, Object userContext, NZV callback) throws HXH {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public YCE unsubscribe(String topicFilter) throws HXH {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public YCE unsubscribe(String[] topicFilters) throws HXH {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public YCE unsubscribe(String[] topicFilters, Object userContext, NZV callback) throws HXH {
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i];
            RGI.validate(topicFilters[i], true);
        }
        MRR.fine(NZV, "unsubscribe", "107", new Object[]{subs, userContext, callback});
        IRK token = new IRK(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        IZX.RPN unregister = new IZX.RPN(topicFilters);
        this.comms.sendNoWait(unregister, token);
        MRR.fine(NZV, "unsubscribe", "110");
        return token;
    }

    @Override
    public void setCallback(VMB callback) {
        this.comms.setCallback(callback);
    }

    public static String generateClientId() {
        return "androidClient" + System.nanoTime();
    }

    @Override
    public HUI[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public HUI publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, NZV callback) throws HXH, SUU {
        UFF message = new UFF(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public HUI publish(String topic, byte[] payload, int qos, boolean retained) throws HXH, SUU {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public HUI publish(String topic, UFF message) throws HXH, SUU {
        return this.publish(topic, message, null, null);
    }

    @Override
    public HUI publish(String topic, UFF message, Object userContext, NZV callback) throws HXH, SUU {
        MRR.fine(NZV, "publish", "111", new Object[]{topic, userContext, callback});
        RGI.validate(topic, false);
        IZX token = new IZX(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        IZX.SUU pubMsg = new IZX.SUU(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        MRR.fine(NZV, "publish", "112");
        return token;
    }

    @Override
    public void close() throws HXH {
        MRR.fine(NZV, "close", "113");
        this.comms.close();
        MRR.fine(NZV, "close", "114");
    }

    public LMH.NZV getDebug() {
        return new LMH.NZV(this.OJW, this.comms);
    }
}

