/*
 * Decompiled with CFR 0.152.
 */
package AOP;

import AOP.DYH;
import AOP.HUI;
import AOP.HXH;
import AOP.IRK;
import AOP.KEM;
import AOP.OJW;
import AOP.RGI;
import AOP.SUU;
import AOP.UFF;
import AOP.VLN;
import AOP.VMB;
import AOP.XTU;
import AOP.YCE;
import LMH.NZV;
import UFF.MRR;

public final class AOP
implements OJW {
    protected XTU aClient = null;
    protected long timeToWait = -1L;

    public AOP(String serverURI, String clientId) throws HXH {
        this(serverURI, clientId, new MRR());
    }

    public AOP(String serverURI, String clientId, DYH persistence) throws HXH {
        this.aClient = new XTU(serverURI, clientId, persistence);
    }

    @Override
    public final void connect() throws VLN, HXH {
        this.connect(new KEM());
    }

    @Override
    public final void connect(KEM options) throws VLN, HXH {
        this.aClient.connect(options, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public final YCE connectWithResult(KEM options) throws VLN, HXH {
        YCE tok = this.aClient.connect(options, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        return tok;
    }

    @Override
    public final void disconnect() throws HXH {
        this.aClient.disconnect().waitForCompletion();
    }

    @Override
    public final void disconnect(long quiesceTimeout) throws HXH {
        this.aClient.disconnect(quiesceTimeout, null, null).waitForCompletion();
    }

    @Override
    public final void disconnectForcibly() throws HXH {
        this.aClient.disconnectForcibly();
    }

    @Override
    public final void disconnectForcibly(long disconnectTimeout) throws HXH {
        this.aClient.disconnectForcibly(disconnectTimeout);
    }

    @Override
    public final void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws HXH {
        this.aClient.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public final void subscribe(String topicFilter) throws HXH {
        this.subscribe(new String[]{topicFilter}, new int[]{1});
    }

    @Override
    public final void subscribe(String[] topicFilters) throws HXH {
        int[] qos = new int[topicFilters.length];
        for (int i = 0; i < qos.length; ++i) {
            qos[i] = 1;
        }
        this.subscribe(topicFilters, qos);
    }

    @Override
    public final void subscribe(String topicFilter, int qos) throws HXH {
        this.subscribe(new String[]{topicFilter}, new int[]{qos});
    }

    @Override
    public final void subscribe(String[] topicFilters, int[] qos) throws HXH {
        YCE tok = this.aClient.subscribe(topicFilters, qos, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        int[] grantedQos = tok.getGrantedQos();
        for (int i = 0; i < grantedQos.length; ++i) {
            qos[i] = grantedQos[i];
        }
        if (grantedQos.length == 1 && qos[0] == 128) {
            throw new HXH(128);
        }
    }

    @Override
    public final void unsubscribe(String topicFilter) throws HXH {
        this.unsubscribe(new String[]{topicFilter});
    }

    @Override
    public final void unsubscribe(String[] topicFilters) throws HXH {
        this.aClient.unsubscribe(topicFilters, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public final void publish(String topic, byte[] payload, int qos, boolean retained) throws HXH, SUU {
        UFF message = new UFF(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.publish(topic, message);
    }

    @Override
    public final void publish(String topic, UFF message) throws HXH, SUU {
        this.aClient.publish(topic, message, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public final IRK sendKeepAlive() {
        if (this.aClient != null && this.aClient.isConnected()) {
            return this.aClient.comms.checkForActivity();
        }
        return null;
    }

    public final void setTimeToWait(long timeToWaitInMillis) throws IllegalArgumentException {
        if (timeToWaitInMillis < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = timeToWaitInMillis;
    }

    public final long getTimeToWait() {
        return this.timeToWait;
    }

    @Override
    public final void close() throws HXH {
        this.aClient.close();
    }

    @Override
    public final String getClientId() {
        return this.aClient.getClientId();
    }

    @Override
    public final HUI[] getPendingDeliveryTokens() {
        return this.aClient.getPendingDeliveryTokens();
    }

    @Override
    public final String getServerURI() {
        return this.aClient.getServerURI();
    }

    @Override
    public final RGI getTopic(String topic) {
        return this.aClient.getTopic(topic);
    }

    @Override
    public final boolean isConnected() {
        return this.aClient.isConnected();
    }

    @Override
    public final void setCallback(VMB callback) {
        this.aClient.setCallback(callback);
    }

    public static String generateClientId() {
        return XTU.generateClientId();
    }

    public final NZV getDebug() {
        return this.aClient.getDebug();
    }
}

