/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.UYC;
import com.adpdigital.push.location.AOP;
import com.adpdigital.push.location.DYH;
import com.adpdigital.push.location.GeofenceParams;
import com.adpdigital.push.location.HXH;
import com.adpdigital.push.location.KEM;
import com.adpdigital.push.location.LocationAccuracy;
import com.adpdigital.push.location.LocationEvent;
import com.adpdigital.push.location.LocationMode;
import com.adpdigital.push.location.LocationParams;
import com.adpdigital.push.location.LocationService;
import com.adpdigital.push.location.OJW;
import com.adpdigital.push.location.OnLocationUpdateListener;
import com.adpdigital.push.location.VMB;
import com.adpdigital.push.location.XTU;
import com.adpdigital.push.location.YCE;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static final String LOCATION_KEY = "location-key";
    private static LocationManager NZV;
    private GoogleApiClient MRR;
    private LocationRequest OJW;
    private OnLocationUpdateListener HUI;
    private Context YCE;
    private Location XTU;
    private LocationAccuracy VMB;
    private boolean AOP = false;
    private long DYH = 1000L;
    private long KEM;
    private float IZX;
    private SharedPreferences HXH;
    private boolean UFF = false;
    private Intent LMH;
    private NZV SUU;

    public void setWaitDurationBeforePublish(long waitDuration) {
        this.DYH = waitDuration * 1000L;
    }

    public static LocationManager init(Context context) {
        UYC.d("LocationManager", "Called init in LocationManager.");
        if (NZV == null) {
            NZV = new LocationManager(context);
        }
        return NZV;
    }

    private LocationManager(Context context) {
        this.YCE = context;
        this.HXH = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.MRR = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.MRR.connect();
        AdpPushClient.get().addListener(this);
    }

    public void onEvent(PushMessage message) {
        UYC.d("LocationManager", "Got a push, is it a geofence?");
        if (message.getData() != null && message.getData().has("geofence")) {
            UYC.d("LocationManager", "Yes it is a geofence push");
            try {
                JSONObject geofence = message.getData().getJSONObject("geofence");
                JSONArray center = geofence.has("center") ? geofence.getJSONArray("center") : null;
                if (center != null) {
                    long expireTime = geofence.has("expire") && geofence.get("expire") != null ? geofence.getLong("expire") : Calendar.getInstance().getTime().getTime() + 3600000L;
                    UYC.d("LocationManager", "setUpGeofence " + geofence);
                    this.setUpGeofence(new GeofenceParams.Builder().setCenter(geofence.getString("id"), center.optDouble(0), center.optDouble(1)).setExpire(expireTime).setRadius(geofence.getInt("r")).build(), geofence.has("enter") ? geofence.getString("enter") : "entering", geofence.has("exit") ? geofence.getString("exit") : "exiting", geofence.getInt("count"));
                    return;
                }
                if (geofence.has("id")) {
                    UYC.d("LocationManager", "removeGeofenceById " + geofence.getString("id"));
                    this.removeGeofenceById(geofence.getString("id"));
                }
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setUpGeofence(GeofenceParams params, String enterMessage, String exitMessage, int count) {
        UYC.d("LocationManager", "setUpGeofence: called");
        long now = Calendar.getInstance().getTime().getTime();
        if (params.getExpire() - now > 0L) {
            long duration = params.getExpire() - now;
            Geofence geofence = new Geofence.Builder().setRequestId(params.getId()).setCircularRegion(params.getLatitude(), params.getLongitude(), params.getRadius()).setTransitionTypes(3).setExpirationDuration(duration).build();
            if (!TextUtils.isEmpty((CharSequence)enterMessage)) {
                this.HXH.edit().putString("enter_message" + params.getId(), enterMessage).apply();
            }
            if (!TextUtils.isEmpty((CharSequence)exitMessage)) {
                this.HXH.edit().putString("exit_message" + params.getId(), exitMessage).apply();
            }
            if (count > 0) {
                this.HXH.edit().putInt("key_count" + params.getId(), count).apply();
            }
            if (this.MRR.isConnected()) {
                this.NZV(geofence);
                return;
            }
            AdpPushClient.get().addListener(new OJW(this, geofence));
            this.MRR.connect();
        }
    }

    public void removeGeofenceById(String geofenceId) {
        ArrayList<String> geofenceIds = new ArrayList<String>();
        geofenceIds.add(geofenceId);
        this.removeGeofencesByIds(geofenceIds);
    }

    public void removeGeofencesByIds(List<String> geofenceIds) {
        if (this.MRR != null && this.MRR.isConnected()) {
            LocationServices.GeofencingApi.removeGeofences(this.MRR, geofenceIds).setResultCallback((ResultCallback)new YCE(this));
        }
    }

    private void NZV(Geofence geofence) {
        ArrayList<Geofence> mGeofenceList = new ArrayList<Geofence>();
        mGeofenceList.add(geofence);
        ArrayList<Geofence> arrayList = mGeofenceList;
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(arrayList);
        LocationServices.GeofencingApi.addGeofences(this.MRR, builder.build(), this.HUI()).setResultCallback((ResultCallback)new XTU(this));
    }

    public void startTrackingMe(long duration, long interval, float distance) {
        UYC.d("LocationManager", "startTrackingMe: called, duration: " + duration + " ,interval: " + interval);
        this.HXH.edit().putString("location_mode", "Tracking").apply();
        this.enableBackgroundMode();
        this.HXH.edit().putLong("duration", duration).apply();
        this.HXH.edit().putFloat("distance", distance).apply();
        this.HXH.edit().putLong("interval", interval).apply();
        this.HXH.edit().putLong("start_time", Calendar.getInstance().getTimeInMillis()).apply();
        this.XTU = null;
        this.NZV();
    }

    private void NZV() {
        LocationParams initialParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(0L).build();
        this.startLocationUpdates(initialParams);
    }

    public void startLocationUpdates(LocationParams params) {
        UYC.d("LocationManager", "startLocationUpdates: called");
        LocationParams locationParams = params;
        LocationManager locationManager = this;
        this.KEM = locationParams.getInterval();
        locationManager.IZX = locationParams.getDistance();
        locationManager.VMB = locationParams.getAccuracy();
        LocationRequest locationRequest = LocationRequest.create().setFastestInterval(locationManager.KEM).setInterval(locationManager.KEM).setSmallestDisplacement(locationManager.IZX);
        switch (locationParams.getAccuracy()) {
            case HIGH: {
                locationRequest.setPriority(100);
                break;
            }
            case MEDIUM: {
                locationRequest.setPriority(102);
                break;
            }
            case LOW: {
                locationRequest.setPriority(104);
                break;
            }
            case LOWEST: {
                locationRequest.setPriority(105);
            }
        }
        this.OJW = locationRequest;
        if (this.MRR.isConnected()) {
            this.OJW();
            return;
        }
        this.SUU = new VMB(this);
        this.MRR.connect();
    }

    public void requestSingleLocation(LocationListener listener) {
        if (this.XTU()) {
            UYC.d("LocationManager", "requestSingleLocation is ignored when in tracking mode!");
            return;
        }
        UYC.d("LocationManager", "requestSingleLocation: called");
        this.HXH.edit().putString("location_mode", "Single").apply();
        this.enableBackgroundMode();
        this.XTU = null;
        this.NZV();
    }

    private void MRR() {
        this.HXH.edit().putLong("listening_start_time", Calendar.getInstance().getTimeInMillis()).apply();
    }

    public void connect() {
        UYC.d("LocationManager", "connect: ");
        if (this.MRR != null && !this.MRR.isConnected()) {
            this.MRR.connect();
        }
    }

    public void resume() {
        UYC.d("LocationManager", "resume Connected=" + this.MRR.isConnected());
        if (this.MRR.isConnected()) {
            this.OJW();
            return;
        }
        this.MRR.connect();
    }

    public void stop() {
        UYC.d("LocationManager", "stop");
        if (this.MRR != null && this.MRR.isConnected()) {
            AOP callback = new AOP(this);
            com.adpdigital.push.location.NZV handler = new com.adpdigital.push.location.NZV(1, callback);
            if (!this.AOP) {
                LocationManager locationManager = this;
                UYC.d("LocationManager", "stopService: called");
                PendingIntent pendingIntent = locationManager.HUI();
                PendingResult result1 = LocationServices.FusedLocationApi.removeLocationUpdates(locationManager.MRR, pendingIntent);
                handler.check((PendingResult<Status>)result1);
            }
        }
    }

    public boolean isConnected() {
        return this.MRR.isConnected();
    }

    private void OJW() {
        UYC.d("LocationManager", "start: called, backgoundMode: " + this.AOP);
        if (ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            UYC.w("LocationManager", "Permission check failed. Please handle it in your app before setting up location");
            return;
        }
        LocationManager locationManager = this;
        UYC.d("LocationManager", "startService: Creating location service request");
        PendingIntent pendingIntent = locationManager.HUI();
        LocationServices.FusedLocationApi.requestLocationUpdates(locationManager.MRR, locationManager.OJW, pendingIntent);
    }

    private PendingIntent HUI() {
        Intent intent = new Intent(this.YCE, LocationService.class);
        return PendingIntent.getService((Context)this.YCE, (int)1, (Intent)intent, (int)0);
    }

    public Location getLastLocation() {
        if (this.XTU != null) {
            return this.XTU;
        }
        if (this.MRR != null && this.MRR.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.YCE, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                UYC.e("LocationManager", "No permission available to get last location");
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.MRR);
            if (location != null) {
                return location;
            }
            UYC.e("LocationManager", "No location from fused getLastLocation");
        }
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        UYC.d("LocationManager", "onConnected: called");
        AdpPushClient.get().notify((Object)LocationEvent.CONNECTED);
        if (this.SUU != null) {
            this.SUU.onConnect();
            this.SUU = null;
        }
        if (this.HUI != null) {
            this.HUI.onConnected(bundle);
        }
    }

    public void onConnectionSuspended(int i) {
        if (this.HUI != null) {
            this.HUI.onSuspended();
        }
        UYC.d("LocationManager", "onConnectionSuspended: ");
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        if (this.HUI != null) {
            this.HUI.onConnectionFailed(connectionResult);
        }
        UYC.d("LocationManager", "onConnectionFailed: ");
    }

    private void YCE() {
        UYC.d("LocationManager", "updateStateAndSendLocation: called");
        if (this.LMH == null) {
            this.LMH = this.VMB();
        }
        if (this.LMH != null) {
            LocationManager locationManager = this;
            try {
                UYC.d("LocationManager", "sendPendingIntent: called");
                Bundle bundle = new Bundle();
                bundle.putParcelable(LOCATION_KEY, (Parcelable)locationManager.XTU);
                locationManager.LMH.putExtras(bundle);
                PendingIntent.getService((Context)locationManager.YCE, (int)0, (Intent)locationManager.LMH, (int)0).send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                canceledException.printStackTrace();
            }
        }
        AdpPushClient.get().notify(this.XTU);
        this.publishLocation(this.XTU);
        this.MRR();
        if (this.HUI != null) {
            this.HUI.onLocationUpdated(this.XTU);
        }
        if (this.XTU()) {
            UYC.d("LocationManager", "updateStateAndSendLocation: isInTrackingMode");
            if ("Tracking".equalsIgnoreCase(this.HXH.getString("location_mode", ""))) {
                this.disableBackgroundMode();
                this.stop();
                new Handler().postDelayed((Runnable)new KEM(this), 500L);
                return;
            }
        } else if ("Single".equalsIgnoreCase(this.HXH.getString("location_mode", "")) || this.HXH.getLong("duration", 0L) != 0L) {
            UYC.d("LocationManager", "updateStateAndSendLocation: time elapsed, provider: " + this.XTU.getProvider() + " ," + this.XTU);
            this.HXH.edit().putString("location_mode", "").apply();
            this.disableBackgroundMode();
            this.stop();
            AdpPushClient.get().notify((Object)LocationMode.TRACKING_STOPPED);
            if (this.HXH.getLong("duration", 0L) != 0L) {
                this.HXH.edit().putLong("duration", 0L).apply();
                UYC.d("LocationManager", "updateStateAndSendLocation, tracking stopped");
            }
            if (AdpPushClient.get().isBackground()) {
                PushService.performAction(this.YCE, "DISCONNECT");
            }
        }
    }

    private boolean XTU() {
        long duration = this.HXH.getLong("duration", 0L);
        long start = this.HXH.getLong("start_time", 0L);
        return duration > 0L && Calendar.getInstance().getTimeInMillis() - start < duration * 1000L;
    }

    public void enableLocationOnLaunch() {
        if (this.XTU()) {
            UYC.d("LocationManager", "enableLocationOnLaunch is ignored when in tracking mode!");
            return;
        }
        this.requestSingleLocation(new HXH(this));
    }

    public void publishLocation(Location location) {
        try {
            JSONObject data = new JSONObject();
            data.put("lat", location.getLatitude());
            data.put("lng", location.getLongitude());
            data.put("ts", location.getTime());
            AdpPushClient.get().publishEvent("geo", data);
            return;
        }
        catch (JSONException e) {
            UYC.e("LocationManager", "Cant publish geo location event ", e);
            return;
        }
    }

    public void addListener(OnLocationUpdateListener listener) {
        this.HUI = listener;
    }

    public void removeListener() {
        this.HUI = null;
    }

    public long getIntervel() {
        return this.KEM;
    }

    public float getDistance() {
        return this.IZX;
    }

    public LocationAccuracy getAccuracy() {
        return this.VMB;
    }

    public void enableBackgroundMode() {
        this.AOP = true;
    }

    public void disableBackgroundMode() {
        UYC.d("LocationManager", "disableBackgroundMode: called");
        this.AOP = false;
    }

    public boolean isBackgoundModeEnabled() {
        return this.AOP;
    }

    public void onEnteredGeofences(String[] geofenceIds, Location location) {
        UYC.d("LocationManager", "onEnteredGeofences: called");
        String[] stringArray = geofenceIds;
        int n = geofenceIds.length;
        for (int i = 0; i < n; ++i) {
            String id2 = stringArray[i];
            int count = this.HXH.getInt("key_count" + id2, 0);
            if (count > 0) {
                UYC.d("LocationManager", "onEnteredGeofences: count: " + count + "location = " + location);
                String message = this.HXH.getString("enter_message" + id2, "");
                this.NZV(id2 + count, id2, message);
                this.HXH.edit().putInt("key_count" + id2, count - 1).apply();
                continue;
            }
            this.HXH.edit().remove("key_count" + id2).apply();
            this.HXH.edit().remove("enter_message" + id2).apply();
            this.removeGeofenceById(id2);
        }
    }

    public void onExitedGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n = geofenceIds.length;
        for (int i = 0; i < n; ++i) {
            String id2 = stringArray[i];
            int count = this.HXH.getInt("key_count" + id2, 0);
            if (count > 0) {
                UYC.d("LocationManager", "onExitedGeofences: count: " + count);
                String message = this.HXH.getString("exit_message" + id2, "");
                this.NZV(id2 + count, id2, message);
                this.HXH.edit().putInt("key_count" + id2, count - 1).apply();
                continue;
            }
            this.HXH.edit().remove("key_count" + id2).apply();
            this.HXH.edit().remove("exit_message" + id2).apply();
            this.removeGeofenceById(id2);
        }
    }

    private void NZV(String id2, String title, String message) {
        Class activityClass = AdpPushClient.get().getActivityClass();
        Intent intent = new Intent(this.YCE, activityClass);
        intent.setFlags(0x24000000);
        int uniqueInt = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.YCE, (int)uniqueInt, (Intent)intent, (int)0);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.YCE, "default");
        builder.setContentTitle((CharSequence)title).setContentText((CharSequence)message).setContentIntent(pendingIntent).setAutoCancel(true);
        try {
            builder.setSound(RingtoneManager.getActualDefaultRingtoneUri((Context)this.YCE, (int)2));
            if (Build.VERSION.SDK_INT >= 21) {
                builder.setVisibility(1);
            }
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message).setBigContentTitle((CharSequence)title));
            if (Build.VERSION.SDK_INT >= 16) {
                builder.setPriority(2);
            }
            PackageInfo packageInfo = this.YCE.getPackageManager().getPackageInfo(this.YCE.getPackageName(), 0);
            ApplicationInfo appInfo = this.YCE.getPackageManager().getApplicationInfo(packageInfo.packageName, 0);
            Bitmap bm = BitmapFactory.decodeResource((Resources)this.YCE.getResources(), (int)appInfo.icon);
            builder.setLargeIcon(bm);
            builder.setSmallIcon(Build.VERSION.SDK_INT >= 21 ? AdpPushClient.get().getNotificationIconSilhouette() : AdpPushClient.get().getNotificationIcon());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.YCE.getSystemService("notification");
        ChabokNotification notification = new ChabokNotification(id2, title, message, 0);
        if (mNotificationManager != null && AdpPushClient.get().prepareNotification(notification, builder)) {
            mNotificationManager.notify(0, builder.build());
        }
    }

    public void addCallbackIntent(Intent callbackIntent) {
        this.LMH = callbackIntent;
        String string = callbackIntent.toUri(0);
        this.HXH.edit().putString("host_intent_uri_key", string).apply();
    }

    public void removeCallbackIntent() {
        this.LMH = null;
        this.HXH.edit().remove("host_intent_uri_key").apply();
    }

    @Nullable
    private Intent VMB() {
        String uri = this.HXH.getString("host_intent_uri_key", "");
        UYC.d("LocationManager", "restoreIntent: uri: " + uri);
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            try {
                return Intent.parseUri((String)uri, (int)0);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return null;
    }

    static /* synthetic */ void NZV(LocationManager x0, Geofence x1) {
        x0.NZV(x1);
    }

    static /* synthetic */ OnLocationUpdateListener NZV(LocationManager x0) {
        return x0.HUI;
    }

    static /* synthetic */ void MRR(LocationManager x0) {
        x0.OJW();
    }

    static /* synthetic */ GoogleApiClient OJW(LocationManager x0) {
        return x0.MRR;
    }

    static /* synthetic */ boolean HUI(LocationManager x0) {
        return x0.UFF;
    }

    static /* synthetic */ Location YCE(LocationManager x0) {
        return x0.XTU;
    }

    static /* synthetic */ void XTU(LocationManager x0) {
        x0.YCE();
    }

    static /* synthetic */ SharedPreferences VMB(LocationManager x0) {
        return x0.HXH;
    }

    static /* synthetic */ void AOP(LocationManager x0) {
        LocationManager locationManager = x0;
        float f = locationManager.HXH.getFloat("distance", 0.0f);
        long l = locationManager.HXH.getLong("interval", 0L);
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(f).setInterval(l * 1000L).build();
        locationManager.enableBackgroundMode();
        locationManager.startLocationUpdates(locationParams);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ void NZV(LocationManager x0, Location x1) {
        block10: {
            block11: {
                block9: {
                    var3_2 = x1;
                    var2_3 = x0;
                    UYC.d("LocationManager", "handleLocation, provider: " + var3_2.getProvider() + " ," + var3_2);
                    if (var2_3.XTU == null) {
                        var2_3.MRR();
                        var2_3.UFF = false;
                        new Handler().postDelayed((Runnable)new DYH(var2_3), var2_3.DYH + 500L);
                    }
                    var9_4 = var2_3.XTU;
                    var8_5 = var3_2;
                    if (var9_4 != null) break block9;
                    v0 = true;
                    break block10;
                }
                var10_6 = var8_5.getTime() - var9_4.getTime();
                var12_7 = var10_6 > 120000L;
                var13_8 = var10_6 < -120000L;
                v1 = var14_9 = var10_6 > 0L;
                if (!var12_7) break block11;
                v0 = true;
                break block10;
            }
            if (var13_8) ** GOTO lbl-1000
            var15_10 = (int)(var8_5.getAccuracy() - var9_4.getAccuracy());
            var16_11 = var15_10 > 0;
            var17_12 = var15_10 < 0;
            var18_13 = var15_10 > 200;
            var21_14 = var9_4.getProvider();
            var20_15 = var8_5.getProvider();
            v2 = var20_15 == null ? var21_14 == null : (var19_16 = var20_15.equals(var21_14));
            if (var17_12) {
                v0 = true;
            } else if (var14_9 && !var16_11) {
                v0 = true;
            } else if (var14_9 && !var18_13 && var19_16) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            var2_3.XTU = var3_2;
        }
        var4_17 = var2_3.HXH.getLong("listening_start_time", 0L);
        var6_18 = Calendar.getInstance().getTimeInMillis() - var4_17;
        if (var2_3.XTU != null && var4_17 != 0L && var6_18 > var2_3.DYH) {
            var2_3.UFF = true;
            var2_3.YCE();
        }
    }

    static interface NZV {
        public void onConnect();
    }
}

