/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

public final class GeofenceParams {
    private String NZV;
    private final double MRR;
    private final double OJW;
    private final float HUI;
    private long YCE;

    GeofenceParams(String id2, double lat, double lng, float radius, long expire) {
        this.NZV = id2;
        this.MRR = lat;
        this.OJW = lng;
        this.HUI = radius;
        this.YCE = expire;
    }

    public final long getExpire() {
        return this.YCE;
    }

    public final float getRadius() {
        return this.HUI;
    }

    public final double getLatitude() {
        return this.MRR;
    }

    public final double getLongitude() {
        return this.OJW;
    }

    public final String getId() {
        return this.NZV;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeofenceParams)) {
            return false;
        }
        GeofenceParams that = (GeofenceParams)o;
        return Float.compare(that.HUI, this.HUI) == 0 && this.MRR == that.MRR && this.OJW == that.OJW;
    }

    public static class Builder {
        private double latitude;
        private double longitude;
        private float radius = 100.0f;
        private long expire;
        private String id;

        public Builder setCenter(String id2, double lat, double lng) {
            this.id = id2;
            this.latitude = lat;
            this.longitude = lng;
            return this;
        }

        public Builder setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder setExpire(long time) {
            this.expire = time;
            return this;
        }

        public GeofenceParams build() {
            return new GeofenceParams(this.id, this.latitude, this.longitude, this.radius, this.expire);
        }
    }
}

