/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.HWU;
import com.adpdigital.push.IMV;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.QMT;
import com.adpdigital.push.UEW;
import com.adpdigital.push.UYC;
import com.adpdigital.push.ZWK;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        UYC.d(NZV, "PushService action " + action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            UYC.w(NZV, "Couldn't start service in foreground (" + AdpPushClient.get().isForeground() + ") with action " + action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        UYC.d(NZV, "Creating Chabok PushService");
        HWU hWU = HWU.getInstance((Context)this);
        hWU.NZV();
        hWU.AOP = (WifiManager)hWU.IZX.getSystemService("wifi");
        hWU.DYH = (AlarmManager)hWU.IZX.getSystemService("alarm");
        HWU hWU2 = hWU;
        hWU2.HUI();
        hWU2.cancelReconnect();
        Set set = IMV.getSharedPreferences(hWU.IZX).getStringSet("dataCache", null);
        if (set != null) {
            HWU.MRR.addAll(set);
        }
        hWU.XTU.register(hWU);
        hWU.KEM = new HWU.MRR<HWU>(hWU, hWU);
        if (hWU.HUI == null) {
            hWU.HUI = new NetworkConnectionIntentReceiver(hWU.IZX, new QMT(hWU));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        hWU.YCE = new UEW(hWU);
        if (hWU.IZX != null) {
            try {
                hWU.IZX.getApplicationContext().registerReceiver(hWU.YCE, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    hWU.IZX.registerReceiver(hWU.YCE, intentFilter);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (HWU.OJW == null) {
            HWU.OJW = new HWU.OJW(hWU);
        } else {
            UYC.w(HWU.NZV, "Already have a connection? Is this service being created twice?");
        }
        hWU.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        UYC.i(NZV, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + flags + ", " + startId);
        if (intent == null || intent.getAction() == null) {
            UYC.i(NZV, "Start PushService with empty action");
            HWU.getInstance((Context)this).OJW();
        } else {
            UYC.i(NZV, "PushService action " + intent.getAction() + ", foreground:" + AdpPushClient.get().isForeground() + ", screenOn:" + HWU.MRR());
            switch (intent.getAction()) {
                case "START": {
                    HWU.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    HWU hWU = HWU.getInstance((Context)this);
                    if (AdpPushClient.isDisabledSdk() || !AdpPushClient.get().isEnabledRealtime()) break;
                    if (!ZWK.isConnected(hWU.IZX)) {
                        UYC.d(HWU.NZV, "We are not online, Don't restart!");
                        break;
                    }
                    if (HWU.OJW != null && (HWU.OJW.isConnecting() || HWU.OJW.isConnected())) {
                        UYC.w(HWU.NZV, "Attempt to disconnect existing client first");
                        HWU.OJW.disconnectExistingClient();
                    }
                    UYC.d(HWU.NZV, "Restart connection");
                    new HWU.NZV(hWU).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    HWU hWU = HWU.getInstance((Context)this);
                    if (HWU.OJW.isConnected()) {
                        UYC.i(HWU.NZV, "send keepalive");
                        new HWU.HUI(hWU).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                        break;
                    }
                    UYC.w(HWU.NZV, "Don't send keepalive, not connected.");
                    break;
                }
                case "RECONNECT": {
                    HWU.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    HWU.getInstance((Context)this).cancelReconnect();
                    HWU.getInstance((Context)this).HUI();
                    if (HWU.OJW == null) break;
                    HWU.OJW.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    HWU.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    UYC.w(NZV, "Unrecognized action " + intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            UYC.d(NZV, "service is sticky");
            return 1;
        }
        UYC.d(NZV, "service is not sticky");
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        UYC.w(NZV, "PushService removed: " + rootIntent.getAction() + rootIntent);
        HWU.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        UYC.w(NZV, "push service low memory...");
        HWU.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        UYC.w(NZV, "push service trim memory " + level);
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        UYC.i(NZV, "destroying push service");
        HWU.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

