/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.os.Bundle;
import com.adpdigital.push.LPP;
import com.adpdigital.push.UYC;
import org.json.JSONException;
import org.json.JSONObject;

public class ChabokEvent {
    protected Double revenue;
    protected JSONObject data;
    protected String currency;

    public ChabokEvent(double revenue) {
        this.setRevenue(revenue);
    }

    public ChabokEvent(double revenue, String currency) {
        this.setRevenue(revenue, currency);
    }

    public void setRevenue(double revenue) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        this.revenue = revenue;
    }

    public void setRevenue(double revenue, String currency) {
        if (!this.checkRevenue(revenue)) {
            return;
        }
        if (!this.checkCurrency(currency)) {
            return;
        }
        this.revenue = revenue;
        this.currency = currency;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public void setData(Bundle data) {
        if (data == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : data.keySet()) {
            try {
                jsonObject.put(key, LPP.NZV(data.get(key)));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.data = jsonObject;
    }

    private boolean checkRevenue(Double revenue) {
        if (revenue == null) {
            UYC.e(UYC.TAG, "Amount is null");
            return false;
        }
        if (revenue < 0.0) {
            UYC.e(UYC.TAG, "Invalid amount " + revenue);
            return false;
        }
        return true;
    }

    private boolean checkCurrency(String currency) {
        if (currency == null) {
            UYC.e(UYC.TAG, "Currency must be set with revenue");
            return false;
        }
        if (currency.equals("")) {
            UYC.e(UYC.TAG, "Currency is empty");
            return false;
        }
        return true;
    }
}

