/*
 * Decompiled with CFR 0.152.
 */
package AOP;

import AOP.RGI;
import AOP.UFF;
import LMH.NZV;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.net.SocketFactory;

public final class KEM {
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int CONNECTION_TIMEOUT_DEFAULT = 30;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    public static final int BROKER_VERSION_DEFAULT = 0;
    public static final int BROKER_VERSION_3_1 = 3;
    public static final int BROKER_VERSION_3_1_1 = 4;
    protected static final int URI_TYPE_TCP = 0;
    protected static final int URI_TYPE_SSL = 1;
    protected static final int URI_TYPE_LOCAL = 2;
    private int NZV = 60;
    private String MRR = null;
    private UFF OJW = null;
    private String HUI;
    private char[] YCE;
    private SocketFactory XTU;
    private Properties VMB = null;
    private boolean AOP = true;
    private int DYH = 30;
    private String[] KEM = null;
    private int IZX = 0;

    public final char[] getPassword() {
        return this.YCE;
    }

    public final void setPassword(char[] password) {
        this.YCE = password;
    }

    public final String getUserName() {
        return this.HUI;
    }

    public final void setUserName(String userName) {
        if (userName != null && userName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.HUI = userName;
    }

    public final void setWill(RGI topic, byte[] payload, int qos, boolean retained) {
        String topicS = topic.getName();
        AOP.KEM.NZV(topicS, payload);
        this.setWill(topicS, new UFF(payload), qos, retained);
    }

    public final void setWill(String topic, byte[] payload, int qos, boolean retained) {
        AOP.KEM.NZV(topic, payload);
        this.setWill(topic, new UFF(payload), qos, retained);
    }

    private static void NZV(String dest, Object payload) {
        if (dest == null || payload == null) {
            throw new IllegalArgumentException();
        }
        RGI.validate(dest, false);
    }

    protected final void setWill(String topic, UFF msg, int qos, boolean retained) {
        this.MRR = topic;
        this.OJW = msg;
        this.OJW.setQos(qos);
        this.OJW.setRetained(retained);
        this.OJW.setMutable(false);
    }

    public final int getKeepAliveInterval() {
        return this.NZV;
    }

    public final int getBrokerVersion() {
        return this.IZX;
    }

    public final void setKeepAliveInterval(int keepAliveInterval) throws IllegalArgumentException {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.NZV = keepAliveInterval;
    }

    public final int getConnectionTimeout() {
        return this.DYH;
    }

    public final void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.DYH = connectionTimeout;
    }

    public final SocketFactory getSocketFactory() {
        return this.XTU;
    }

    public final void setSocketFactory(SocketFactory socketFactory) {
        this.XTU = socketFactory;
    }

    public final String getWillDestination() {
        return this.MRR;
    }

    public final UFF getWillMessage() {
        return this.OJW;
    }

    public final Properties getSSLProperties() {
        return this.VMB;
    }

    public final void setSSLProperties(Properties props) {
        this.VMB = props;
    }

    public final boolean isCleanSession() {
        return this.AOP;
    }

    public final void setCleanSession(boolean cleanSession) {
        this.AOP = cleanSession;
    }

    public final String[] getServerURIs() {
        return this.KEM;
    }

    public final void setServerURIs(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            AOP.KEM.validateURI(array[i]);
        }
        this.KEM = array;
    }

    protected static int validateURI(String srvURI) {
        try {
            URI vURI = new URI(srvURI);
            if (!vURI.getPath().equals("")) {
                throw new IllegalArgumentException(srvURI);
            }
            if (vURI.getScheme().equals("tcp")) {
                return 0;
            }
            if (vURI.getScheme().equals("ssl")) {
                return 1;
            }
            if (vURI.getScheme().equals("local")) {
                return 2;
            }
            throw new IllegalArgumentException(srvURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(srvURI);
        }
    }

    public final void setBrokerVersion(int MqttVersion) throws IllegalArgumentException {
        if (MqttVersion != 0 && MqttVersion != 3 && MqttVersion != 4) {
            throw new IllegalArgumentException();
        }
        this.IZX = MqttVersion;
    }

    public final Properties getDebug() {
        Properties p = new Properties();
        p.put("Version", new Integer(this.getBrokerVersion()));
        p.put("CleanSession", (Object)this.isCleanSession());
        p.put("ConTimeout", new Integer(this.getConnectionTimeout()));
        p.put("KeepAliveInterval", new Integer(this.getKeepAliveInterval()));
        p.put("UserName", this.getUserName() == null ? "null" : this.getUserName());
        p.put("WillDestination", this.getWillDestination() == null ? "null" : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            p.put("SocketFactory", "null");
        } else {
            p.put("SocketFactory", this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            p.put("SSLProperties", "null");
        } else {
            p.put("SSLProperties", this.getSSLProperties());
        }
        return p;
    }

    public final String toString() {
        return LMH.NZV.dumpProperties(this.getDebug(), "Connection options");
    }
}

