/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.config;

import android.content.Context;
import android.content.res.Resources;

public final class YCE {
    public static String getResourceValue(Context context, String resourceName) {
        if (resourceName == null || resourceName.isEmpty()) {
            return "";
        }
        String trimmedKey = resourceName.trim();
        if (!YCE.isValidResourceName(trimmedKey)) {
            return "";
        }
        int apiKeyId = YCE.getStringResId(context, trimmedKey);
        return context.getResources().getString(apiKeyId);
    }

    public static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    public static int getStringResId(Context context, String name) {
        String packageName;
        Resources resources = context.getResources();
        if (resources != null && (packageName = context.getPackageName()) != null) {
            return resources.getIdentifier(name, "string", packageName);
        }
        return 0;
    }
}

