/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.FOL;
import com.adpdigital.push.GSY;
import com.adpdigital.push.LPP;
import com.adpdigital.push.NetworkConnectionIntentReceiver;
import com.adpdigital.push.OLN;
import com.adpdigital.push.RFF;
import com.adpdigital.push.RTB;
import java.util.Set;

public class PushService
extends Service {
    private static final String NZV = PushService.class.getName();

    public static void performAction(Context context, String action) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        Intent actionIntent = new Intent(context, PushService.class);
        actionIntent.setAction(action);
        LPP.d(NZV, "PushService action " + action);
        try {
            if (Build.VERSION.SDK_INT >= 26 && !AdpPushClient.get().isForeground()) {
                return;
            }
            context.startService(actionIntent);
            return;
        }
        catch (Exception exc) {
            LPP.w(NZV, "Couldn't start service in foreground (" + AdpPushClient.get().isForeground() + ") with action " + action);
            exc.printStackTrace();
            return;
        }
    }

    public static boolean isRunning(Context ctx) {
        for (ActivityManager.RunningServiceInfo service : ((ActivityManager)ctx.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!PushService.class.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void onCreate() {
        super.onCreate();
        LPP.d(NZV, "Creating Chabok PushService");
        RFF rFF = RFF.getInstance((Context)this);
        rFF.NZV();
        rFF.AOP = (WifiManager)rFF.IZX.getSystemService("wifi");
        rFF.DYH = (AlarmManager)rFF.IZX.getSystemService("alarm");
        RFF rFF2 = rFF;
        rFF2.HUI();
        rFF2.cancelReconnect();
        Set set = OLN.getSharedPreferences(rFF.IZX).getStringSet("dataCache", null);
        if (set != null) {
            RFF.MRR.addAll(set);
        }
        rFF.XTU.register(rFF);
        rFF.KEM = new RFF.MRR<RFF>(rFF, rFF);
        if (rFF.HUI == null) {
            rFF.HUI = new NetworkConnectionIntentReceiver(rFF.IZX, new GSY(rFF));
        }
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        rFF.YCE = new FOL(rFF);
        if (rFF.IZX != null) {
            try {
                rFF.IZX.getApplicationContext().registerReceiver(rFF.YCE, intentFilter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    rFF.IZX.registerReceiver(rFF.YCE, intentFilter);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
        }
        if (RFF.OJW == null) {
            RFF.OJW = new RFF.OJW(rFF);
        } else {
            LPP.w(RFF.NZV, "Already have a connection? Is this service being created twice?");
        }
        rFF.VMB();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LPP.i(NZV, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ onStartCommand " + flags + ", " + startId);
        if (intent == null || intent.getAction() == null) {
            LPP.i(NZV, "Start PushService with empty action");
            RFF.getInstance((Context)this).OJW();
        } else {
            LPP.i(NZV, "PushService action " + intent.getAction() + ", foreground:" + AdpPushClient.get().isForeground() + ", screenOn:" + RFF.MRR());
            switch (intent.getAction()) {
                case "START": {
                    RFF.getInstance((Context)this).OJW();
                    break;
                }
                case "RESTART": {
                    RFF rFF = RFF.getInstance((Context)this);
                    if (AdpPushClient.isDisabledSdk() || !AdpPushClient.get().isEnabledRealtime()) break;
                    if (!RTB.isConnected(rFF.IZX)) {
                        LPP.d(RFF.NZV, "We are not online, Don't restart!");
                        break;
                    }
                    if (RFF.OJW != null && (RFF.OJW.isConnecting() || RFF.OJW.isConnected())) {
                        LPP.w(RFF.NZV, "Attempt to disconnect existing client first");
                        RFF.OJW.disconnectExistingClient();
                    }
                    LPP.d(RFF.NZV, "Restart connection");
                    new RFF.NZV(rFF).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                    break;
                }
                case "KEEP_ALIVE": {
                    RFF rFF = RFF.getInstance((Context)this);
                    if (RFF.OJW.isConnected()) {
                        LPP.i(RFF.NZV, "send keepalive");
                        new RFF.HUI(rFF).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Integer[]{0});
                        break;
                    }
                    LPP.w(RFF.NZV, "Don't send keepalive, not connected.");
                    break;
                }
                case "RECONNECT": {
                    RFF.getInstance((Context)this).YCE();
                    break;
                }
                case "DISCONNECT": {
                    RFF.getInstance((Context)this).cancelReconnect();
                    RFF.getInstance((Context)this).HUI();
                    if (RFF.OJW == null) break;
                    RFF.OJW.disconnectExistingClient();
                    break;
                }
                case "BackgroundTimeExceeded": {
                    RFF.getInstance((Context)this).XTU();
                    break;
                }
                default: {
                    LPP.w(NZV, "Unrecognized action " + intent.getAction());
                }
            }
        }
        if (AdpPushClient.get().shouldBeSticky()) {
            LPP.d(NZV, "service is sticky");
            return 1;
        }
        LPP.d(NZV, "service is not sticky");
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        LPP.w(NZV, "PushService removed: " + rootIntent.getAction() + rootIntent);
        RFF.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onTaskRemoved(rootIntent);
    }

    public void onLowMemory() {
        LPP.w(NZV, "push service low memory...");
        RFF.getInstance((Context)this).XTU();
        AdpPushClient.get().dismiss();
        super.onLowMemory();
    }

    public void onTrimMemory(int level) {
        LPP.w(NZV, "push service trim memory " + level);
        super.onTrimMemory(level);
    }

    public void onDestroy() {
        LPP.i(NZV, "destroying push service");
        RFF.getInstance((Context)this).XTU();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

