/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import MRR.NZV;
import XTU.OJW;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.EIW;
import com.adpdigital.push.GTE;
import com.adpdigital.push.HCZ;
import com.adpdigital.push.HKJ;
import com.adpdigital.push.LPP;
import com.adpdigital.push.PWW;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.RFF;
import com.adpdigital.push.WQD;
import com.adpdigital.push.WXQ;
import com.adpdigital.push.XXU;
import com.adpdigital.push.service.ChabokNotificationOpenedReceiver;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChabokFirebaseMessaging
extends FirebaseMessagingService {
    public static final String TAG = ChabokFirebaseMessaging.class.getName();
    private static int NZV = 0;
    private OJW MRR = XTU.OJW.getDefault();
    private static final ScheduledExecutorService OJW = Executors.newSingleThreadScheduledExecutor();

    public ChabokFirebaseMessaging() {
        this.MRR.register((Object)this);
    }

    public void onDestroy() {
        this.MRR.unregister((Object)this);
        super.onDestroy();
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        ChabokFirebaseMessaging.refreshToken(token, this.getApplicationContext());
    }

    public static boolean isChabokPushNotification(Bundle data) {
        return data != null && data.containsKey("deviceId") && data.containsKey("fromChabok");
    }

    public static boolean isChabokPushNotification(Map<String, String> data) {
        return data != null && data.containsKey("deviceId") && data.containsKey("fromChabok");
    }

    public static void refreshToken(String token, Context context) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!AdpPushClient.get().isEnabledPushNotification()) {
            return;
        }
        if (token == null) {
            LPP.w(TAG, "Push notification token is null. Please provide valid token");
            return;
        }
        if (context == null) {
            Log.e((String)TAG, (String)"The context parameter is null in refreshToken method");
            return;
        }
        String currentToken = ChabokFirebaseMessaging.MRR(context).getString("deviceToken", null);
        if (token.equalsIgnoreCase(currentToken)) {
            LPP.i(TAG, "GOT same token, don't update installation");
            return;
        }
        LPP.d(TAG, "FCM Registration Token is : " + token + "\n\n");
        XTU.OJW.getDefault().post(new WXQ(token));
        for (String topic : AdpPushClient.get().getSubscriptions()) {
            if (topic.startsWith("private/")) continue;
            ChabokFirebaseMessaging.subscribe(topic);
        }
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        ChabokFirebaseMessaging.onMessageReceived(remoteMessage, this.getApplicationContext());
    }

    public static void onMessageReceived(RemoteMessage remoteMessage, Context context) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!AdpPushClient.get().isEnabledPushNotification()) {
            return;
        }
        String from = remoteMessage.getFrom();
        Map data = remoteMessage.getData();
        LPP.d(TAG, "Received FCM Notification for " + from + " \n\n Data : " + data);
        if (context == null) {
            Log.e((String)TAG, (String)"The context parameter is null in onMessageReceived method");
            return;
        }
        String deviceId = (String)data.get("deviceId");
        if (deviceId != null) {
            String currentDeviceId = AdpPushClient.get().getInstallationId();
            if (!deviceId.equalsIgnoreCase(currentDeviceId)) {
                LPP.w(TAG, "Ignoring FCM, unmatched deviceId " + deviceId + " != " + currentDeviceId);
                return;
            }
        } else if (AdpPushClient.get().preventShowNonChabokNotifications()) {
            LPP.w(TAG, "This not chabok FCM notification. Ignore show notification not related to chabok");
            return;
        }
        if (data.containsKey("cancelNotif")) {
            try {
                Integer notifId = Integer.parseInt((String)data.get("cancelNotif"));
                NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
                if (mNotificationManager != null) {
                    if (notifId == -1) {
                        mNotificationManager.cancelAll();
                        return;
                    }
                    mNotificationManager.cancel(notifId.intValue());
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        String alertText = (String)data.get("message");
        String title = (String)data.get("title");
        if ((alertText == null || alertText.equalsIgnoreCase("")) && (title == null || title.equalsIgnoreCase(""))) {
            LPP.i(TAG, "Silent FCM, no title or text");
            return;
        }
        String messageId = (String)data.get("messageId");
        if (messageId != null && RFF.NZV(messageId)) {
            LPP.i(TAG, "MessageId already received, Swallow FCM!");
            return;
        }
        String pushPayload = (String)data.get("push");
        String topicName = "app/" + AdpPushClient.get().getAppId() + "/user/" + AdpPushClient.get().getUserId() + "/" + (String)data.get("collapse_key");
        if (title == null) {
            title = (String)data.get("messageFrom");
        }
        int badgeNumber = 0;
        if (data.get("androidBadge") != null) {
            badgeNumber = Integer.valueOf((String)data.get("androidBadge"));
        }
        ChabokNotification notification = new ChabokNotification(messageId, title, alertText, badgeNumber, data);
        String trackId = (String)data.get("trackId");
        if (trackId != null) {
            notification.setTrackId(trackId);
        }
        notification.setTopicName((String)data.get("collapse_key"));
        Bundle extraData = notification.getExtras();
        try {
            try {
                if (messageId != null && (RFF.NZV(messageId) || AdpPushClient.hasNotified(messageId))) {
                    Log.w((String)TAG, (String)"Don't notify, messageId already delivered!");
                    return;
                }
                Class activityToOpen = AdpPushClient.get().getNotifActivityClass(extraData);
                Context ctx = context;
                HKJ notifTask = new HKJ(pushPayload, context, topicName, ctx, activityToOpen, notification);
                OJW.schedule(notifTask, 0L, TimeUnit.SECONDS);
                return;
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"cannot send notification when no subscriber for Intents", (Throwable)e);
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error handling FCM ", (Throwable)e);
            ChabokFirebaseMessaging.sendNotification(context, null, notification);
            return;
        }
    }

    public void onEvent(WQD event) {
        Log.w((String)TAG, (String)("Should? Notify FCM message (canNotify,isCanceled): " + event.isCanNofity() + "," + event.isCanceled()));
        if (!event.isCanceled()) {
            WQD wQD = event;
            ChabokFirebaseMessaging chabokFirebaseMessaging = this;
            String string = wQD.getIntent().getExtras().getString("title");
            if (string == null) {
                string = wQD.getIntent().getExtras().getString("messageFrom");
            }
            ChabokNotification chabokNotification = new ChabokNotification(wQD.getIntent().getExtras().getString("messageId"), string, wQD.getIntent().getExtras().getString("message"), Integer.valueOf(wQD.getIntent().getExtras().getString("androidBadge", "0")) + chabokFirebaseMessaging.getApplicationContext().getSharedPreferences(MRR.NZV.SHARED_PREFERENCES_NAME, 0).getInt("androidUnseenBadge", 0), wQD.getIntent().getExtras());
            ChabokFirebaseMessaging.sendNotification((Context)chabokFirebaseMessaging, wQD.getClient().getActivityClass(), chabokNotification);
        }
    }

    @TargetApi(value=16)
    public static void sendNotification(Context ctx, Class viewClass, ChabokNotification msg) {
        try {
            HashMap<String, HashMap> settings;
            String json;
            boolean notifDelivery = false;
            PackageInfo packageInfo = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            ApplicationInfo appInfo = ctx.getPackageManager().getApplicationInfo(packageInfo.packageName, 0);
            CharSequence title = appInfo.nonLocalizedLabel;
            String body = null;
            String channelName = "default";
            Intent intent = new Intent(ctx, ChabokNotificationOpenedReceiver.class);
            if (Build.VERSION.SDK_INT <= 19) {
                intent.setFlags(0);
            } else {
                intent.setFlags(0x4000000);
            }
            intent.putExtra("CHABOK_NOTIFICATION", true);
            if (viewClass != null) {
                intent.putExtra("CHABOK_NOTIFICATION_HANDLER", viewClass.getName());
            }
            int notificationId = ++NZV;
            if (!intent.hasExtra("notificationId")) {
                intent.putExtra("notificationId", notificationId);
            } else {
                notificationId = intent.getIntExtra("notificationId", notificationId);
            }
            String msgId = msg.getId();
            String trackId = msg.getTrackId();
            if (msg.getExtras() != null) {
                Log.i((String)TAG, (String)("Notification Extras " + msg.getExtras()));
                intent.putExtras(msg.getExtras());
                if (msg.getExtras().getString("messageId") != null) {
                    msgId = msg.getExtras().getString("messageId");
                }
                if (msg.getExtras().getString("trackId") != null) {
                    trackId = msg.getExtras().getString("trackId");
                }
                if (msg.getExtras().getString("title") != null) {
                    title = msg.getExtras().getString("title");
                }
                if (msg.getExtras().getString("body") != null) {
                    body = msg.getExtras().getString("body");
                } else if (msg.getExtras().getString("message", null) != null) {
                    body = msg.getExtras().getString("message");
                }
            }
            if (msg != null && msg.getTopicName() != null) {
                channelName = ChabokFirebaseMessaging.NZV(msg.getTopicName());
            }
            if (msg.getMessage() != null) {
                channelName = ChabokFirebaseMessaging.NZV(msg.getMessage().getChannel());
                msg.setTopicName(msg.getMessage().getChannel());
                intent.putExtra("collapse_key", msg.getMessage().getChannel());
                intent.putExtra("messageId", msg.getMessage().getId());
                intent.putExtra("trackId", msg.getMessage().getTrackId());
                if (msg.getMessage().getData() != null) {
                    intent.putExtra("data", msg.getMessage().getData().toString());
                }
                intent.putExtra("live", msg.getMessage().isLive());
                intent.putExtra("stateful", msg.getMessage().isStateful());
                intent.putExtra("inapp", msg.getMessage().isInApp());
                intent.putExtra("topicName", msg.getMessage().getChannel());
                intent.putExtra("expireAt", msg.getMessage().getExpireAt());
                intent.putExtra("receivedAt", msg.getMessage().getReceivedAt());
                if (msg.getMessage() instanceof PushMessage) {
                    intent.putExtra("title", msg.getMessage().getAlertTitle());
                    intent.putExtra("body", msg.getMessage().getAlertText());
                    if (msg.getMessage().getAlertText() == null || msg.getMessage().getAlertText().trim() == "") {
                        intent.putExtra("body", msg.getMessage().getBody());
                        body = msg.getMessage().getBody();
                    } else {
                        body = msg.getMessage().getAlertText();
                    }
                }
                title = msg.getMessage().getAlertTitle();
            }
            if (msgId != null) {
                AdpPushClient.get().addNotifiedMessage(msgId);
            }
            NotificationManager notificationManager = (NotificationManager)ctx.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                if (channelName.equals(AdpPushClient.get().getInstallationId()) || channelName.equals("This Device")) {
                    channelName = "default";
                }
                if (!AdpPushClient.get().hasNotificationChannel(channelName.toString())) {
                    if (!AdpPushClient.get().hasNotificationChannel("default")) {
                        AdpPushClient.get().setDefaultNotificationChannel("Personal default");
                        channelName = "default";
                    }
                    if ("Personal default".contains(channelName)) {
                        channelName = "default";
                    } else {
                        AdpPushClient.get().createNotificationChannel(channelName.toString(), channelName.toString(), 3);
                    }
                }
            }
            JSONObject notificationObject = null;
            if (msg.getMessage() != null) {
                notificationObject = msg.getMessage().getNotification();
            } else if (msg.getExtras() != null && (notificationObject = new JSONObject(json = ChabokFirebaseMessaging.NZV(msg.getExtras()))).has("notifDelivery")) {
                notifDelivery = notificationObject.getBoolean("notifDelivery");
            }
            if (notificationObject != null && notificationObject.has("clickUrl")) {
                intent.putExtra("clickUrl", notificationObject.getString("clickUrl"));
            }
            int uniqueInt = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
            PendingIntent contentIntent = PendingIntent.getBroadcast((Context)ctx, (int)uniqueInt, (Intent)intent, (int)0x8000000);
            Object object = intent.getExtras();
            Object object2 = trackId;
            String string = msgId;
            Object object3 = ctx;
            Intent intent2 = new Intent((Context)object3, ChabokNotificationOpenedReceiver.class);
            intent2.putExtra("CHABOK_DISMISS_NOTIFICATION", true);
            intent2.putExtra("messageId", string);
            intent2.putExtra("trackId", (String)object2);
            if (object != null) {
                intent2.putExtras((Bundle)object);
            }
            int n = (int)(System.currentTimeMillis() & 0xFFFFFFFL);
            PendingIntent dismissPendingIntent = PendingIntent.getBroadcast((Context)object3, (int)n, (Intent)intent2, (int)0x8000000);
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(ctx, channelName.toString()).setAutoCancel(true).setPriority(1).setTicker((CharSequence)msg.getText()).setContentTitle(title).setContentText((CharSequence)msg.getText()).setContentIntent(contentIntent).setDeleteIntent(dismissPendingIntent);
            if (body != null && body.toString().trim() != "") {
                mBuilder.setContentText((CharSequence)body);
            }
            mBuilder.setSmallIcon(Build.VERSION.SDK_INT >= 21 ? AdpPushClient.get().getNotificationIconSilhouette() : AdpPushClient.get().getNotificationIcon());
            Bitmap bm = BitmapFactory.decodeResource((Resources)ctx.getResources(), (int)appInfo.icon);
            mBuilder.setLargeIcon(bm);
            int badge = -1;
            if (notificationObject != null) {
                Bitmap largeIconBitmap;
                String largeIcon;
                String colorHex;
                Bitmap bigPictureBitmap;
                String mediaUrl;
                String ledColorHex;
                int icon;
                String smallIcon;
                if (notificationObject.has("androidBadge")) {
                    badge = notificationObject.getInt("androidBadge");
                }
                if (notificationObject.has("smallIcon") && (smallIcon = notificationObject.getString("smallIcon")) != null && smallIcon.trim() != "" && (icon = ChabokFirebaseMessaging.NZV(smallIcon, ctx)) != 0) {
                    mBuilder.setSmallIcon(icon);
                }
                if (notificationObject.has("ledColor") && (ledColorHex = notificationObject.getString("ledColor")) != null && ledColorHex.trim() != "") {
                    String sharpSign = "#";
                    if (ledColorHex.startsWith("#")) {
                        sharpSign = "";
                    }
                    if (ChabokFirebaseMessaging.MRR(ledColorHex = sharpSign + ledColorHex)) {
                        mBuilder.setLights(Color.parseColor((String)ledColorHex), 300, 3000);
                    }
                }
                if (notificationObject.has("actions")) {
                    JSONArray actions;
                    if (notificationObject.get("actions").getClass() == String.class) {
                        String jsonActions = notificationObject.getString("actions");
                        actions = new JSONArray(jsonActions);
                    } else {
                        actions = notificationObject.getJSONArray("actions");
                    }
                    if (actions != null) {
                        ChabokFirebaseMessaging.NZV(mBuilder, actions, ctx, msgId, trackId, intent.getExtras());
                    }
                }
                if (notificationObject.has("mediaUrl") && (mediaUrl = notificationObject.getString("mediaUrl")) != null && mediaUrl.trim() != "" && (bigPictureBitmap = ChabokFirebaseMessaging.OJW(mediaUrl)) != null) {
                    NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle().bigPicture(bigPictureBitmap);
                    if (title != null) {
                        bigPictureStyle.setBigContentTitle(title);
                    }
                    if (body != null) {
                        bigPictureStyle.setSummaryText((CharSequence)body);
                    }
                    mBuilder.setStyle((NotificationCompat.Style)bigPictureStyle);
                    if (notificationObject.has("useAsLargeIcon") && notificationObject.getBoolean("useAsLargeIcon")) {
                        mBuilder.setLargeIcon(bigPictureBitmap);
                    }
                }
                if (notificationObject.has("color") && (colorHex = notificationObject.getString("color")) != null && colorHex.trim() != "") {
                    String sharpSign = "#";
                    if (colorHex.startsWith("#")) {
                        sharpSign = "";
                    }
                    if (ChabokFirebaseMessaging.MRR(colorHex = sharpSign + colorHex)) {
                        mBuilder.setColor(Color.parseColor((String)colorHex));
                    }
                }
                if (notificationObject.has("largeIcon") && (largeIcon = notificationObject.getString("largeIcon")) != null && largeIcon.trim() != "" && (largeIconBitmap = ChabokFirebaseMessaging.OJW(largeIcon)) != null) {
                    mBuilder.setLargeIcon(largeIconBitmap);
                }
                if (notificationObject.has("groupKey")) {
                    mBuilder.setGroup(notificationObject.getString("groupKey"));
                }
                if (notificationObject.has("groupSummery")) {
                    boolean groupSummery = notificationObject.getBoolean("notificationObject");
                    mBuilder.setGroupSummary(groupSummery);
                }
            }
            if ((settings = AdpPushClient.get().getNotificationSettings()) != null && settings.containsKey(msg.getTopicName())) {
                msg.setAlert(Boolean.getBoolean(settings.get(msg.getTopicName()).get("alert").toString()));
                if (settings.get(msg.getTopicName()).get("sound") != null) {
                    msg.setSound((String)settings.get(msg.getTopicName()).get("sound"));
                }
            } else if (settings != null) {
                LPP.d(TAG, "No Notification settings? " + Arrays.toString(settings.keySet().toArray()) + ", " + msg.getTopicName());
            } else {
                LPP.d(TAG, "No Notification settings = null " + msg.getTopicName());
            }
            if (msg.isAlert()) {
                String soundName = msg.getSound();
                if (soundName != null && !soundName.isEmpty()) {
                    String extension = MimeTypeMap.getFileExtensionFromUrl((String)msg.getSound());
                    if (extension != null && extension != "") {
                        soundName = soundName.replace("." + extension, "");
                    }
                    mBuilder.setSound(Uri.parse((String)("android.resource://" + ctx.getPackageName() + "/raw/" + soundName)));
                } else {
                    mBuilder.setSound(RingtoneManager.getActualDefaultRingtoneUri((Context)ctx, (int)2));
                }
            }
            if (Build.VERSION.SDK_INT >= 21) {
                mBuilder.setVisibility(1);
            }
            object3 = msg;
            boolean bl = false;
            if (((ChabokNotification)object3).getExtras() != null) {
                bl = ((ChabokNotification)object3).getExtras().containsKey("mediaUrl");
            } else if (((ChabokNotification)object3).getMessage() != null && ((PushMessage)(object2 = ((ChabokNotification)object3).getMessage())).getNotification() != null) {
                bl = ((PushMessage)object2).getNotification().has("mediaUrl");
            }
            if (!bl) {
                NotificationCompat.Builder builder = mBuilder;
                object3 = msg;
                try {
                    object2 = ((ChabokNotification)object3).getText();
                    if (((ChabokNotification)object3).getExtras() != null) {
                        object = ((ChabokNotification)object3).getExtras();
                        if (object.containsKey("body")) {
                            object2 = object.getString("body");
                        }
                    } else if (((ChabokNotification)object3).getMessage() != null && ((PushMessage)(object = ((ChabokNotification)object3).getMessage())).getNotification() != null && ((PushMessage)object).getNotification().has("body")) {
                        object2 = ((PushMessage)object).getNotification().getString("body");
                    }
                    if (object2 != null) {
                        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)object2));
                        if (Build.VERSION.SDK_INT >= 16) {
                            builder.setPriority(2);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (AdpPushClient.get().prepareNotification(msg, mBuilder)) {
                Notification notif = mBuilder.build();
                if (badge >= 0) {
                    AdpPushClient.get().setBadge(badge);
                    if (AdpPushClient.get().isBadgeEnabled()) {
                        ShortcutBadger.applyNotification((Context)ctx, (Notification)notif, (int)AdpPushClient.get().getBadge());
                    }
                } else if (AdpPushClient.get().isBackground()) {
                    AdpPushClient.get().incBadge();
                }
                notif.flags |= 0x10;
                notificationManager.notify(notificationId, notif);
                long clickTime = System.currentTimeMillis();
                JSONObject notifActionJson = ChabokFirebaseMessaging.NZV(intent, clickTime, null);
                if (notifDelivery) {
                    XXU shownNotificationEvent = new XXU(notifActionJson, GTE.ShownNotification);
                    XTU.OJW.getDefault().post(shownNotificationEvent);
                }
                ChabokFirebaseMessaging.NZV(notifActionJson);
                EIW.XTU();
            }
            return;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error notifying user ", (Throwable)e);
            return;
        }
    }

    static String NZV(String topic) {
        if (topic == null) {
            return "UNKNOWN";
        }
        String[] channels = topic.split("/");
        String deviceId = AdpPushClient.get().getInstallationId();
        String userId = AdpPushClient.get().getUserId();
        if (channels.length > 1) {
            if (channels[0].contentEquals("public")) {
                return channels[1];
            }
            if (deviceId != null && channels[1].contentEquals(deviceId)) {
                return "This Device";
            }
            if (channels[0].contentEquals("private") || userId != null && channels[0].contentEquals(userId)) {
                return "Personal " + channels[1];
            }
        }
        return channels[0];
    }

    private static boolean MRR(String color) {
        if (color == null) {
            return false;
        }
        return Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$").matcher(color).matches();
    }

    private static String NZV(Bundle bundle) {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException jSONException) {}
        }
        return json.toString();
    }

    private static Bitmap OJW(String strURL) {
        try {
            String string = strURL;
            if (!Pattern.compile("^((https?|ftp)://|(www|ftp)\\.)?[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].*)?$").matcher(string).find()) {
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)new URL(strURL).openConnection();
            connection.setDoInput(true);
            connection.connect();
            return BitmapFactory.decodeStream((InputStream)connection.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void NZV(NotificationCompat.Builder mBuilder, JSONArray actions, Context ctx, String msgId, String trackId, Bundle bundle) throws JSONException {
        if (actions != null) {
            for (int i = 0; i < actions.length(); ++i) {
                JSONObject action = actions.getJSONObject(i);
                String id = "";
                String title = "";
                String iconName = "";
                if (action.has("id")) {
                    id = action.getString("id");
                }
                if (action.has("title")) {
                    title = action.getString("title");
                }
                if (action.has("icon")) {
                    iconName = action.getString("icon");
                }
                if (title.trim() == "" || id.trim() == "") continue;
                int icon = ChabokFirebaseMessaging.NZV(iconName, ctx);
                Intent actionReceive = new Intent(ctx, ChabokNotificationOpenedReceiver.class);
                actionReceive.putExtra("CHABOK_ACTION_BUTTON", true);
                actionReceive.putExtra("CHABOK_ACTION_ID", id);
                actionReceive.putExtra("CHABOK_ACTION_TITLE", title);
                if (action.has("url")) {
                    String url = action.getString("url");
                    actionReceive.putExtra("CHABOK_ACTION_URL", url);
                }
                if (msgId != null) {
                    actionReceive.putExtra("messageId", msgId);
                }
                if (trackId != null) {
                    actionReceive.putExtra("trackId", trackId);
                }
                if (bundle != null) {
                    actionReceive.putExtras(bundle);
                }
                actionReceive.putExtra("action_button", true);
                actionReceive.setAction(id);
                PendingIntent pendingIntentAction = PendingIntent.getBroadcast((Context)ctx, (int)i, (Intent)actionReceive, (int)0x8000000);
                mBuilder.addAction(icon, (CharSequence)title, pendingIntentAction);
            }
        }
    }

    private static int NZV(String iconName, Context ctx) {
        String string;
        String trimmedIconName;
        if (iconName == null) {
            return 0;
        }
        String string2 = trimmedIconName = iconName.trim();
        if (!(trimmedIconName != null && !string2.matches("^[0-9]"))) {
            return 0;
        }
        Context context = ctx;
        string2 = trimmedIconName;
        Resources resources = context.getResources();
        int notificationIcon = resources != null && (string = context.getPackageName()) != null ? resources.getIdentifier(string2, "drawable", string) : 0;
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 0;
    }

    private static SharedPreferences MRR(Context context) {
        return context.getSharedPreferences(MRR.NZV.SHARED_PREFERENCES_NAME, 0);
    }

    public static void subscribe(String channel) {
        new PWW(channel).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    public static void unsubscribe(String topic) {
        new HCZ(topic).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null, null, null});
    }

    private static boolean NZV(Intent intent) {
        return intent != null && intent.getBooleanExtra("CHABOK_ACTION_BUTTON", false);
    }

    private static boolean MRR(Intent intent) {
        return intent != null && intent.getBooleanExtra("CHABOK_DISMISS_NOTIFICATION", false);
    }

    public static void handleClickNotification(Context context, Intent intent) {
        Intent intent2;
        long clickTime = System.currentTimeMillis();
        if (!(ChabokFirebaseMessaging.MRR(intent) || ChabokFirebaseMessaging.NZV(intent) || (intent2 = intent) != null && intent2.hasExtra("CHABOK_NOTIFICATION"))) {
            LPP.d(LPP.TAG, "----> It's not chabok intent :/ = " + intent);
            return;
        }
        intent2 = intent;
        ChabokNotificationAction chabokNotificationAction = new ChabokNotificationAction();
        if (ChabokFirebaseMessaging.MRR(intent2)) {
            chabokNotificationAction.type = ChabokNotificationAction.ActionType.Dismissed;
            LPP.d(LPP.TAG, "----> Notification dismissed " + intent2.getExtras());
        } else if (ChabokFirebaseMessaging.NZV(intent2)) {
            chabokNotificationAction.type = ChabokNotificationAction.ActionType.ActionTaken;
            chabokNotificationAction.actionID = intent2.getStringExtra("CHABOK_ACTION_ID");
            if (intent2.hasExtra("CHABOK_ACTION_URL")) {
                chabokNotificationAction.actionUrl = intent2.getStringExtra("CHABOK_ACTION_URL");
            }
            LPP.d(LPP.TAG, "----> User tapped on ('" + intent2.getStringExtra("CHABOK_ACTION_TITLE") + "') action with id = " + chabokNotificationAction.actionID + " from the notification");
        } else {
            chabokNotificationAction.type = ChabokNotificationAction.ActionType.Opened;
            if (intent2.hasExtra("clickUrl")) {
                chabokNotificationAction.actionUrl = intent2.getStringExtra("clickUrl");
            }
            LPP.d(LPP.TAG, "----> Notification was tapped on");
        }
        ChabokNotificationAction notificationAction = chabokNotificationAction;
        JSONObject notifActionJson = ChabokFirebaseMessaging.NZV(intent, clickTime, notificationAction);
        XXU communicateEvent = new XXU(notifActionJson, GTE.ClickedNotification);
        if (notificationAction.type == ChabokNotificationAction.ActionType.Dismissed) {
            communicateEvent.status = GTE.DismissedNotification;
        }
        XTU.OJW.getDefault().post(communicateEvent);
        EIW.XTU();
        ChabokFirebaseMessaging.NZV(notifActionJson);
        boolean preventStartActivity = !AdpPushClient.get().notificationOpened(intent.getExtras(), notificationAction);
        if (preventStartActivity || ChabokFirebaseMessaging.MRR(intent)) {
            LPP.d(LPP.TAG, "-- prevent start activity = " + preventStartActivity + " , isDismissed = " + ChabokFirebaseMessaging.MRR(intent));
            return;
        }
        if (notificationAction.type == ChabokNotificationAction.ActionType.ActionTaken) {
            ChabokNotificationAction chabokNotificationAction2 = notificationAction;
            chabokNotificationAction = intent;
            intent2 = context;
            Intent intent3 = new Intent();
            intent3.setAction(chabokNotificationAction2.actionID);
            intent3.replaceExtras((Intent)chabokNotificationAction);
            intent2.sendBroadcast(intent3);
            if (intent.hasExtra("CHABOK_ACTION_URL")) {
                ChabokFirebaseMessaging.NZV(context, intent, "CHABOK_ACTION_URL", "----> Start launch action url = ");
            }
            return;
        }
        if (notificationAction.type == ChabokNotificationAction.ActionType.Opened && intent.hasExtra("clickUrl")) {
            ChabokFirebaseMessaging.NZV(context, intent, "clickUrl", "----> Start launch click url = ");
            return;
        }
        chabokNotificationAction = intent;
        intent2 = context;
        try {
            Class clazz = AdpPushClient.get().getNotifActivityClass(chabokNotificationAction.getExtras());
            Intent intent4 = new Intent((Context)intent2, clazz);
            intent4.setFlags(0x10020000);
            LPP.d(LPP.TAG, "----> Start launching activity = " + clazz);
            intent2.startActivity(intent4);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void NZV(JSONObject notifActionJson) {
        try {
            JSONObject influenceData = new JSONObject(notifActionJson.toString());
            influenceData.remove("type");
            influenceData.remove("dirty");
            EIW.MRR(influenceData);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private static JSONObject NZV(Intent intent, long clickTime, ChabokNotificationAction notificationAction) {
        JSONObject notifActionJson = new JSONObject();
        try {
            notifActionJson.put("type", 1);
            notifActionJson.put("actionTs", clickTime);
            String messageId = intent.getExtras().getString("messageId", null);
            LPP.d(TAG, "-- MessageId is " + messageId);
            if (messageId != null) {
                notifActionJson.put("msgId", (Object)messageId);
            }
            String trackId = intent.getExtras().getString("trackId");
            LPP.d(TAG, "-- trackId is " + trackId);
            if (trackId != null) {
                notifActionJson.put("trackId", (Object)trackId);
            }
            if (notificationAction == null) {
                notifActionJson.put("actionType", (Object)"SHOWN");
                return notifActionJson;
            }
            String actionId = notificationAction.actionID;
            if (actionId != null) {
                notifActionJson.put("actionId", (Object)actionId);
            }
            if (notificationAction.type == ChabokNotificationAction.ActionType.Opened) {
                notifActionJson.put("actionType", (Object)"OPENED");
            } else if (notificationAction.type == ChabokNotificationAction.ActionType.Dismissed) {
                notifActionJson.put("actionType", (Object)"DISMISSED");
            } else if (notificationAction.type == ChabokNotificationAction.ActionType.ActionTaken) {
                notifActionJson.put("actionType", (Object)"ACTION_TAKEN");
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return notifActionJson;
    }

    private static void NZV(Context context, Intent intent, String actionUrl, String logMessage) {
        try {
            String url = intent.getStringExtra(actionUrl);
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            Intent i = new Intent("android.intent.action.VIEW");
            i.addFlags(0x58080000);
            i.setData(Uri.parse((String)url));
            LPP.d(LPP.TAG, logMessage + url);
            context.startActivity(i);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ SharedPreferences NZV(Context x0) {
        return ChabokFirebaseMessaging.MRR(x0);
    }
}

