/*
 * Decompiled with CFR 0.152.
 */
package NZV;

import NZV.UFF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.ByteArrayBuffer;

public class XTU
implements UFF {
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    protected static final int BUFFER_SIZE = 4096;
    private Handler NZV;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String MRR = "UTF-8";
    private Boolean OJW = false;
    private URI HUI = null;
    private Header[] YCE = null;

    @Override
    public URI getRequestURI() {
        return this.HUI;
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.YCE;
    }

    @Override
    public void setRequestURI(URI requestURI) {
        this.HUI = requestURI;
    }

    @Override
    public void setRequestHeaders(Header[] requestHeaders) {
        this.YCE = requestHeaders;
    }

    public boolean getUseSynchronousMode() {
        return this.OJW;
    }

    @Override
    public void setUseSynchronousMode(boolean value) {
        this.OJW = value;
    }

    public void setCharset(String charset) {
        this.MRR = charset;
    }

    public String getCharset() {
        if (this.MRR == null) {
            return DEFAULT_CHARSET;
        }
        return this.MRR;
    }

    public XTU() {
        if (Looper.myLooper() != null) {
            this.NZV = new NZV(this);
        }
    }

    public void onProgress(int bytesWritten, int totalSize) {
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    @Deprecated
    public void onSuccess(String content) {
    }

    @Deprecated
    public void onSuccess(int statusCode, Header[] headers, String content) {
        this.onSuccess(statusCode, content);
    }

    @Deprecated
    public void onSuccess(int statusCode, String content) {
        this.onSuccess(content);
    }

    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        try {
            String response = responseBody == null ? null : new String(responseBody, this.getCharset());
            this.onSuccess(statusCode, headers, response);
            return;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"AsyncHttpResponseHandler", (String)e.toString());
            this.onFailure(statusCode, headers, e, null);
            return;
        }
    }

    @Deprecated
    public void onFailure(Throwable error) {
    }

    @Deprecated
    public void onFailure(Throwable error, String content) {
        this.onFailure(error);
    }

    @Deprecated
    public void onFailure(int statusCode, Throwable error, String content) {
        this.onFailure(error, content);
    }

    @Deprecated
    public void onFailure(int statusCode, Header[] headers, Throwable error, String content) {
        this.onFailure(statusCode, error, content);
    }

    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        try {
            String response = responseBody == null ? null : new String(responseBody, this.getCharset());
            this.onFailure(statusCode, headers, error, response);
            return;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"AsyncHttpResponseHandler", (String)e.toString());
            this.onFailure(statusCode, headers, e, null);
            return;
        }
    }

    public void onRetry() {
    }

    @Override
    public final void sendProgressMessage(int bytesWritten, int bytesTotal) {
        this.sendMessage(this.obtainMessage(4, new Object[]{bytesWritten, bytesTotal}));
    }

    @Override
    public final void sendSuccessMessage(int statusCode, Header[] headers, byte[] responseBody) {
        this.sendMessage(this.obtainMessage(0, new Object[]{statusCode, headers, responseBody}));
    }

    @Override
    public final void sendFailureMessage(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, headers, responseBody, error}));
    }

    @Override
    public final void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    @Override
    public final void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    @Override
    public final void sendRetryMessage() {
        this.sendMessage(this.obtainMessage(5, null));
    }

    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                Object[] response = (Object[])msg.obj;
                if (response != null && response.length >= 3) {
                    this.onSuccess((int)((Integer)response[0]), (Header[])response[1], (byte[])response[2]);
                    return;
                }
                Log.e((String)"AsyncHttpResponseHandler", (String)"SUCCESS_MESSAGE didn't got enough params");
                return;
            }
            case 1: {
                Object[] response = (Object[])msg.obj;
                if (response != null && response.length >= 4) {
                    this.onFailure((int)((Integer)response[0]), (Header[])response[1], (byte[])response[2], (Throwable)response[3]);
                    return;
                }
                Log.e((String)"AsyncHttpResponseHandler", (String)"FAILURE_MESSAGE didn't got enough params");
                return;
            }
            case 2: {
                this.onStart();
                return;
            }
            case 3: {
                this.onFinish();
                return;
            }
            case 4: {
                Object[] response = (Object[])msg.obj;
                if (response != null && response.length >= 2) {
                    try {
                        this.onProgress((Integer)response[0], (Integer)response[1]);
                        return;
                    }
                    catch (Throwable t) {
                        Log.e((String)"AsyncHttpResponseHandler", (String)"custom onProgress contains an error", (Throwable)t);
                        return;
                    }
                }
                Log.e((String)"AsyncHttpResponseHandler", (String)"PROGRESS_MESSAGE didn't got enough params");
                return;
            }
            case 5: {
                this.onRetry();
            }
        }
    }

    protected void sendMessage(Message msg) {
        if (this.getUseSynchronousMode() || this.NZV == null) {
            this.handleMessage(msg);
            return;
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.NZV.sendMessage(msg);
        }
    }

    protected void postRunnable(Runnable r) {
        if (r != null) {
            this.NZV.post(r);
        }
    }

    protected Message obtainMessage(int responseMessage, Object response) {
        Message msg;
        if (this.NZV != null) {
            msg = this.NZV.obtainMessage(responseMessage, response);
        } else {
            msg = Message.obtain();
            if (msg != null) {
                msg.what = responseMessage;
                msg.obj = response;
            }
        }
        return msg;
    }

    @Override
    public void sendResponseMessage(HttpResponse response) throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            StatusLine status = response.getStatusLine();
            byte[] responseBody = this.NZV(response.getEntity());
            if (!Thread.currentThread().isInterrupted()) {
                if (status.getStatusCode() >= 300) {
                    this.sendFailureMessage(status.getStatusCode(), response.getAllHeaders(), responseBody, (Throwable)new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()));
                    return;
                }
                this.sendSuccessMessage(status.getStatusCode(), response.getAllHeaders(), responseBody);
            }
        }
    }

    private byte[] NZV(HttpEntity entity) throws IOException {
        InputStream instream;
        byte[] responseBody = null;
        if (entity != null && (instream = entity.getContent()) != null) {
            long contentLength = entity.getContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            if (contentLength < 0L) {
                contentLength = 4096L;
            }
            try {
                ByteArrayBuffer buffer = new ByteArrayBuffer((int)contentLength);
                try {
                    int l;
                    byte[] tmp = new byte[4096];
                    int count = 0;
                    while ((l = instream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        buffer.append(tmp, 0, l);
                        this.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                finally {
                    instream.close();
                }
                responseBody = buffer.toByteArray();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
        }
        return responseBody;
    }

    static final class NZV
    extends Handler {
        private final WeakReference<XTU> NZV;

        NZV(XTU service) {
            this.NZV = new WeakReference<XTU>(service);
        }

        public final void handleMessage(Message msg) {
            XTU service = (XTU)this.NZV.get();
            if (service != null) {
                service.handleMessage(msg);
            }
        }
    }
}

