/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.IntentService;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;

public abstract class GeoEventsIntentService
extends IntentService {
    public GeoEventsIntentService() {
        super("GeoEventsIntentService");
    }

    /*
     * WARNING - void declaration
     */
    public GeoEventsIntentService(String name) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onHandleIntent(@Nullable Intent intent) {
        Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: called");
        GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
        if (event != null) {
            if (event.hasError()) {
                this.onError(event.getErrorCode());
                return;
            }
            int transition = event.getGeofenceTransition();
            if (transition == 1 || transition == 4 || transition == 2) {
                void var2_2;
                Location location = event.getTriggeringLocation();
                String[] geofenceIds = new String[event.getTriggeringGeofences().size()];
                for (int index = 0; index < event.getTriggeringGeofences().size(); ++index) {
                    geofenceIds[index] = ((Geofence)event.getTriggeringGeofences().get(index)).getRequestId();
                }
                if (transition == 1 || transition == 4) {
                    this.onEnteredGeofences(geofenceIds, location);
                    return;
                }
                if (var2_2 == 2) {
                    void var3_3;
                    this.onExitedGeofences(geofenceIds, (Location)var3_3);
                }
                return;
            }
            Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: transition invalid");
        }
    }

    protected abstract void onEnteredGeofences(String[] var1, Location var2);

    protected abstract void onExitedGeofences(String[] var1, Location var2);

    protected abstract void onError(int var1);
}

