/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.R;
import com.adpdigital.push.location.GeofenceParams;
import com.adpdigital.push.location.LocationAccuracy;
import com.adpdigital.push.location.LocationEvent;
import com.adpdigital.push.location.LocationMode;
import com.adpdigital.push.location.LocationParams;
import com.adpdigital.push.location.LocationService;
import com.adpdigital.push.location.OnLocationUpdateListener;
import com.adpdigital.push.location.c;
import com.adpdigital.push.location.e;
import com.adpdigital.push.location.f;
import com.adpdigital.push.location.g;
import com.adpdigital.push.location.h;
import com.adpdigital.push.location.i;
import com.adpdigital.push.location.j;
import com.adpdigital.push.location.l;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static final String LOCATION_KEY = "location-key";
    private static LocationManager a;
    private GoogleApiClient b;
    private LocationRequest c;
    private OnLocationUpdateListener d;
    private Context e;
    private Location f;
    private LocationAccuracy g;
    private boolean h = false;
    private long i = 1000L;
    private long j;
    private float k;
    private SharedPreferences l;
    private boolean m = false;
    private Intent n;
    private a o;

    /*
     * WARNING - void declaration
     */
    public void setWaitDurationBeforePublish(long waitDuration) {
        void var1_1;
        this.i = var1_1 * 1000L;
    }

    public static LocationManager init(Context context) {
        if (a == null) {
            Context context2;
            a = new LocationManager(context2);
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    private LocationManager(Context context) {
        void var1_1;
        this.e = context;
        this.l = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.b = new GoogleApiClient.Builder((Context)var1_1).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.b.connect();
        AdpPushClient.get().addListener(this);
    }

    /*
     * WARNING - void declaration
     */
    public void onEvent(PushMessage message) {
        if (message.getData() != null && message.getData().has("geofence")) {
            try {
                JSONObject geofence = message.getData().getJSONObject("geofence");
                JSONArray center = geofence.has("center") ? geofence.getJSONArray("center") : null;
                if (center != null) {
                    void var3_3;
                    void var2_2;
                    long expireTime = geofence.has("expire") && geofence.get("expire") != null ? geofence.getLong("expire") : Calendar.getInstance().getTime().getTime() + 3600000L;
                    new StringBuilder("setUpGeofence ").append(geofence);
                    this.setUpGeofence(new GeofenceParams.Builder().setCenter(geofence.getString("id"), center.optDouble(0), var2_2.optDouble(1)).setExpire((long)var3_3).setRadius(geofence.getInt("r")).build(), geofence.has("enter") ? geofence.getString("enter") : "entering", geofence.has("exit") ? geofence.getString("exit") : "exiting", geofence.getInt("count"));
                    return;
                }
                if (geofence.has("id")) {
                    void var1_1;
                    new StringBuilder("removeGeofenceById ").append(geofence.getString("id"));
                    this.removeGeofenceById(var1_1.getString("id"));
                }
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUpGeofence(GeofenceParams params, String enterMessage, String exitMessage, int count) {
        long now = Calendar.getInstance().getTime().getTime();
        if (params.getExpire() - now > 0L) {
            long duration = params.getExpire() - now;
            Geofence geofence = new Geofence.Builder().setRequestId(params.getId()).setCircularRegion(params.getLatitude(), params.getLongitude(), params.getRadius()).setTransitionTypes(3).setExpirationDuration(duration).build();
            if (!TextUtils.isEmpty((CharSequence)enterMessage)) {
                void var2_2;
                this.l.edit().putString("enter_message" + params.getId(), (String)var2_2).apply();
            }
            if (!TextUtils.isEmpty((CharSequence)exitMessage)) {
                void var3_3;
                this.l.edit().putString("exit_message" + params.getId(), (String)var3_3).apply();
            }
            if (count > 0) {
                void var1_1;
                this.l.edit().putInt("key_count" + var1_1.getId(), count).apply();
            }
            if (this.b.isConnected()) {
                this.a(geofence);
                return;
            }
            AdpPushClient.get().addListener(new c(this, geofence));
            this.b.connect();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeGeofenceById(String geofenceId) {
        void var2_2;
        void var1_1;
        ArrayList<void> geofenceIds = new ArrayList<void>();
        geofenceIds.add(var1_1);
        this.removeGeofencesByIds((List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeGeofencesByIds(List<String> geofenceIds) {
        if (this.b != null && this.b.isConnected()) {
            void var1_1;
            LocationServices.GeofencingApi.removeGeofences(this.b, (List)var1_1).setResultCallback((ResultCallback)new e(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(Geofence geofence) {
        GeofencingRequest.Builder builder;
        void var1_1;
        ArrayList<void> mGeofenceList = new ArrayList<void>();
        mGeofenceList.add(var1_1);
        var1_1 = builder;
        builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences((List)var1_1);
        LocationServices.GeofencingApi.addGeofences(this.b, builder.build(), this.d()).setResultCallback((ResultCallback)new f(this));
    }

    /*
     * WARNING - void declaration
     */
    public void startTrackingMe(long duration, long interval, float distance) {
        void var3_2;
        void var1_1;
        new StringBuilder("startTrackingMe: called, duration: ").append(duration).append(" ,interval: ").append(interval);
        this.l.edit().putString("location_mode", "Tracking").apply();
        this.enableBackgroundMode();
        this.l.edit().putLong("duration", (long)var1_1).apply();
        this.l.edit().putFloat("distance", distance).apply();
        this.l.edit().putLong("interval", (long)var3_2).apply();
        this.l.edit().putLong("start_time", Calendar.getInstance().getTimeInMillis()).apply();
        this.f = null;
        this.a();
    }

    /*
     * WARNING - void declaration
     */
    private void a() {
        void var1_1;
        LocationParams initialParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(0L).build();
        this.startLocationUpdates((LocationParams)var1_1);
    }

    public void startLocationUpdates(LocationParams params) {
        LocationManager locationManager;
        void var2_2 = locationManager;
        locationManager = this;
        this.j = var2_2.getInterval();
        locationManager.k = var2_2.getDistance();
        locationManager.g = var2_2.getAccuracy();
        locationManager = LocationRequest.create().setFastestInterval(locationManager.j).setInterval(locationManager.j).setSmallestDisplacement(locationManager.k);
        switch (var2_2.getAccuracy()) {
            case HIGH: {
                locationManager.setPriority(100);
                break;
            }
            case MEDIUM: {
                locationManager.setPriority(102);
                break;
            }
            case LOW: {
                locationManager.setPriority(104);
                break;
            }
            case LOWEST: {
                locationManager.setPriority(105);
            }
        }
        this.c = locationManager;
        if (this.b.isConnected()) {
            this.c();
            return;
        }
        this.o = new g(this);
        this.b.connect();
    }

    public void requestSingleLocation(LocationListener listener) {
        if (this.f()) {
            return;
        }
        this.l.edit().putString("location_mode", "Single").apply();
        this.enableBackgroundMode();
        this.f = null;
        this.a();
    }

    private void b() {
        this.l.edit().putLong("listening_start_time", Calendar.getInstance().getTimeInMillis()).apply();
    }

    public void connect() {
        if (this.b != null && !this.b.isConnected()) {
            this.b.connect();
        }
    }

    public void resume() {
        new StringBuilder("resume Connected=").append(this.b.isConnected());
        if (this.b.isConnected()) {
            this.c();
            return;
        }
        this.b.connect();
    }

    /*
     * WARNING - void declaration
     */
    public void stop() {
        if (this.b != null && this.b.isConnected()) {
            h callback = new h(this);
            com.adpdigital.push.location.a handler = new com.adpdigital.push.location.a(1, callback);
            if (!this.h) {
                void var1_1;
                LocationManager locationManager = this;
                PendingIntent pendingIntent = locationManager.d();
                PendingResult result1 = LocationServices.FusedLocationApi.removeLocationUpdates(locationManager.b, pendingIntent);
                var1_1.check((PendingResult<Status>)locationManager);
            }
        }
    }

    public boolean isConnected() {
        return this.b.isConnected();
    }

    private void c() {
        new StringBuilder("start: called, backgoundMode: ").append(this.h);
        if (ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationManager locationManager = this;
        PendingIntent pendingIntent = locationManager.d();
        LocationServices.FusedLocationApi.requestLocationUpdates(locationManager.b, locationManager.c, pendingIntent);
    }

    /*
     * WARNING - void declaration
     */
    private PendingIntent d() {
        void var1_1;
        Intent intent = new Intent(this.e, LocationService.class);
        return PendingIntent.getService((Context)this.e, (int)1, (Intent)var1_1, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public Location getLastLocation() {
        if (this.f != null) {
            return this.f;
        }
        if (this.b != null && this.b.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.b);
            if (location != null) {
                void var1_1;
                return var1_1;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void onConnected(@Nullable Bundle bundle) {
        AdpPushClient.get().notify((Object)LocationEvent.CONNECTED);
        if (this.o != null) {
            this.o.onConnect();
            this.o = null;
        }
        if (this.d != null) {
            void var1_1;
            this.d.onConnected((Bundle)var1_1);
        }
    }

    public void onConnectionSuspended(int i2) {
        if (this.d != null) {
            this.d.onSuspended();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        if (this.d != null) {
            void var1_1;
            this.d.onConnectionFailed((ConnectionResult)var1_1);
        }
    }

    private void e() {
        Bundle bundle;
        LocationManager locationManager;
        if (this.n == null) {
            this.n = this.g();
        }
        if (this.n != null) {
            locationManager = this;
            try {
                bundle = new Bundle();
                bundle.putParcelable(LOCATION_KEY, (Parcelable)locationManager.f);
                locationManager.n.putExtras(bundle);
                PendingIntent.getService((Context)locationManager.e, (int)0, (Intent)locationManager.n, (int)0).send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                canceledException.printStackTrace();
            }
        }
        AdpPushClient.get().notify(this.f);
        locationManager = this.f;
        try {
            bundle = new JSONObject();
            bundle.put("lat", locationManager.getLatitude());
            bundle.put("lng", locationManager.getLongitude());
            bundle.put("ts", locationManager.getTime());
            AdpPushClient.get().publishEvent("geo", (JSONObject)bundle, false, true);
        }
        catch (JSONException jSONException) {}
        this.b();
        if (this.d != null) {
            this.d.onLocationUpdated(this.f);
        }
        if (this.f()) {
            if ("Tracking".equalsIgnoreCase(this.l.getString("location_mode", ""))) {
                this.disableBackgroundMode();
                this.stop();
                new Handler().postDelayed((Runnable)new j(this), 500L);
                return;
            }
        } else if ("Single".equalsIgnoreCase(this.l.getString("location_mode", "")) || this.l.getLong("duration", 0L) != 0L) {
            new StringBuilder("updateStateAndSendLocation: time elapsed, provider: ").append(this.f.getProvider()).append(" ,").append(this.f);
            this.l.edit().putString("location_mode", "").apply();
            this.disableBackgroundMode();
            this.stop();
            AdpPushClient.get().notify((Object)LocationMode.TRACKING_STOPPED);
            if (this.l.getLong("duration", 0L) != 0L) {
                this.l.edit().putLong("duration", 0L).apply();
            }
            if (AdpPushClient.get().isBackground()) {
                PushService.performAction(this.e, "DISCONNECT");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean f() {
        void var1_1;
        void var3_2;
        long duration = this.l.getLong("duration", 0L);
        long start = this.l.getLong("start_time", 0L);
        return duration > 0L && Calendar.getInstance().getTimeInMillis() - var3_2 < var1_1 * 1000L;
    }

    public void enableLocationOnLaunch() {
        if (this.f()) {
            return;
        }
        this.requestSingleLocation(new l(this));
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(OnLocationUpdateListener listener) {
        void var1_1;
        this.d = var1_1;
    }

    public void removeListener() {
        this.d = null;
    }

    public long getIntervel() {
        return this.j;
    }

    public float getDistance() {
        return this.k;
    }

    public LocationAccuracy getAccuracy() {
        return this.g;
    }

    public void enableBackgroundMode() {
        this.h = true;
    }

    public void disableBackgroundMode() {
        this.h = false;
    }

    public boolean isBackgoundModeEnabled() {
        return this.h;
    }

    public void onEnteredGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n2 = geofenceIds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String id = stringArray[i2];
            int count = this.l.getInt("key_count" + id, 0);
            if (count > 0) {
                String message = this.l.getString("enter_message" + id, "");
                this.a(id, message);
                this.l.edit().putInt("key_count" + id, count - 1).apply();
                continue;
            }
            this.l.edit().remove("key_count" + id).apply();
            this.l.edit().remove("enter_message" + id).apply();
            this.removeGeofenceById(id);
        }
    }

    public void onExitedGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n2 = geofenceIds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String id = stringArray[i2];
            int count = this.l.getInt("key_count" + id, 0);
            if (count > 0) {
                String message = this.l.getString("exit_message" + id, "");
                this.a(id, message);
                this.l.edit().putInt("key_count" + id, count - 1).apply();
                continue;
            }
            this.l.edit().remove("key_count" + id).apply();
            this.l.edit().remove("exit_message" + id).apply();
            this.removeGeofenceById(id);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(String id, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.e);
        builder.setSmallIcon(R.drawable.common_full_open_on_phone).setLargeIcon(BitmapFactory.decodeResource((Resources)this.e.getResources(), (int)R.drawable.common_full_open_on_phone)).setColor(-65536).setContentTitle((CharSequence)var1_1).setContentText((CharSequence)var2_2);
        builder.setAutoCancel(true);
        ((NotificationManager)this.e.getSystemService("notification")).notify(0, var3_3.build());
    }

    public void addCallbackIntent(Intent callbackIntent) {
        String string2;
        this.n = callbackIntent;
        string2 = string2.toUri(0);
        this.l.edit().putString("host_intent_uri_key", string2).apply();
    }

    public void removeCallbackIntent() {
        this.n = null;
        this.l.edit().remove("host_intent_uri_key").apply();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Intent g() {
        String uri = this.l.getString("host_intent_uri_key", "");
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            try {
                void var1_1;
                return Intent.parseUri((String)var1_1, (int)0);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void a(LocationManager x0, Geofence x1) {
        void var1_1;
        x0.a((Geofence)var1_1);
    }

    static /* synthetic */ OnLocationUpdateListener a(LocationManager x0) {
        return x0.d;
    }

    static /* synthetic */ void b(LocationManager x0) {
        x0.c();
    }

    static /* synthetic */ GoogleApiClient c(LocationManager x0) {
        return x0.b;
    }

    static /* synthetic */ boolean d(LocationManager x0) {
        return x0.m;
    }

    static /* synthetic */ Location e(LocationManager x0) {
        return x0.f;
    }

    static /* synthetic */ void f(LocationManager x0) {
        x0.e();
    }

    static /* synthetic */ SharedPreferences g(LocationManager x0) {
        return x0.l;
    }

    static /* synthetic */ void h(LocationManager x0) {
        LocationManager locationManager = x0;
        float f2 = locationManager.l.getFloat("distance", 0.0f);
        long l2 = locationManager.l.getLong("interval", 0L);
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(f2).setInterval(l2 * 1000L).build();
        locationManager.enableBackgroundMode();
        locationManager.startLocationUpdates(locationParams);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ void a(LocationManager x0, Location x1) {
        block10: {
            block11: {
                block9: {
                    new StringBuilder("handleLocation, provider: ").append(var1_1.getProvider()).append(" ,").append(var1_1);
                    if (var0.f == null) {
                        var0.b();
                        var0.m = false;
                        new Handler().postDelayed((Runnable)new i(var0), var0.i + 500L);
                    }
                    var4_2 /* !! */  = var0.f;
                    var3_4 = var1_1;
                    if (var4_2 /* !! */  != null) break block9;
                    v0 = true;
                    break block10;
                }
                var8_6 = var3_4.getTime() - var4_2 /* !! */ .getTime();
                var2_7 = var8_6 > 120000L ? 1 : 0;
                var5_8 = var8_6 < -120000L;
                v1 = var6_9 = var8_6 > 0L;
                if (var2_7 == 0) break block11;
                v0 = true;
                break block10;
            }
            if (var5_8) ** GOTO lbl-1000
            var2_7 = (int)(var3_4.getAccuracy() - var4_2 /* !! */ .getAccuracy());
            var5_8 = var2_7 > 0;
            var7_11 = var2_7 < 0;
            var2_7 = var2_7 > 200 ? 1 : 0;
            var4_2 /* !! */  = var4_2 /* !! */ .getProvider();
            v2 = (var3_4 = var3_4.getProvider()) == null ? var4_2 /* !! */  == null : (var3_5 = var3_4.equals(var4_2 /* !! */ ));
            if (var7_11) {
                v0 = true;
            } else if (var6_9 && !var5_8) {
                v0 = true;
            } else if (var6_9 && var2_7 == 0 && var3_5) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            var0.f = var1_1;
        }
        var4_3 = var0.l.getLong("listening_start_time", 0L);
        var6_10 = Calendar.getInstance().getTimeInMillis() - var4_3;
        if (var0.f != null && var4_3 != 0L && var6_10 > var0.i) {
            var0.m = true;
            var0.e();
        }
    }

    static interface a {
        public void onConnect();
    }
}

