/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import com.adpdigital.push.location.LocationAccuracy;

public final class LocationParams {
    public static final LocationParams NAVIGATION = new Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(500L).build();
    public static final LocationParams BEST_EFFORT = new Builder().setAccuracy(LocationAccuracy.MEDIUM).setDistance(150.0f).setInterval(2500L).build();
    public static final LocationParams LAZY = new Builder().setAccuracy(LocationAccuracy.LOW).setDistance(500.0f).setInterval(5000L).build();
    private long a;
    private float b;
    private LocationAccuracy c;

    LocationParams(LocationAccuracy locationAccuracy, long l2, float f2) {
        this.a = l2;
        this.b = f2;
        this.c = locationAccuracy;
    }

    public final long getInterval() {
        return this.a;
    }

    public final float getDistance() {
        return this.b;
    }

    public final LocationAccuracy getAccuracy() {
        return this.c;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationParams)) {
            return false;
        }
        object = (LocationParams)object;
        return Float.compare(((LocationParams)object).b, this.b) == 0 && this.a == ((LocationParams)object).a && this.c == ((LocationParams)object).c;
    }

    public final int hashCode() {
        int n2 = (int)(this.a ^ this.a >>> 32);
        n2 = 31 * n2 + (this.b != 0.0f ? Float.floatToIntBits(this.b) : 0);
        return 31 * n2 + this.c.hashCode();
    }

    public static class Builder {
        private LocationAccuracy accuracy = LocationAccuracy.MEDIUM;
        private long interval = 2500L;
        private float distance = 150.0f;

        public Builder setAccuracy(LocationAccuracy locationAccuracy) {
            this.accuracy = locationAccuracy;
            return this;
        }

        public Builder setInterval(long l2) {
            this.interval = l2;
            return this;
        }

        public Builder setDistance(float f2) {
            this.distance = f2;
            return this;
        }

        public LocationParams build() {
            return new LocationParams(this.accuracy, this.interval, this.distance);
        }
    }
}

