/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.R;
import com.adpdigital.push.location.GeofenceParams;
import com.adpdigital.push.location.LocationAccuracy;
import com.adpdigital.push.location.LocationEvent;
import com.adpdigital.push.location.LocationParams;
import com.adpdigital.push.location.OnLocationUpdateListener;
import com.adpdigital.push.location.a;
import com.adpdigital.push.location.b;
import com.adpdigital.push.location.c;
import com.adpdigital.push.location.d;
import com.adpdigital.push.location.e;
import com.adpdigital.push.location.f;
import com.adpdigital.push.location.g;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static LocationManager b;
    private GoogleApiClient c;
    private LocationRequest d;
    private OnLocationUpdateListener e;
    private Context f;
    private Location g;
    private LocationAccuracy h;
    private boolean i = false;
    private long j;
    private float k;
    SharedPreferences a;

    public static LocationManager init(Context context) {
        if (b == null) {
            b = new LocationManager(context);
        }
        return b;
    }

    private LocationManager(Context context) {
        this.f = context;
        this.a = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.c = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.c.connect();
        AdpPushClient.get().addListener(this);
    }

    public void onEvent(PushMessage pushMessage) {
        if (pushMessage.getData() != null && pushMessage.getData().has("geofence")) {
            try {
                pushMessage = pushMessage.getData().getJSONObject("geofence");
                JSONArray jSONArray = pushMessage.has("center") ? pushMessage.getJSONArray("center") : null;
                if (jSONArray != null) {
                    long l2 = pushMessage.has("expire") && pushMessage.get("expire") != null ? pushMessage.getLong("expire") : Calendar.getInstance().getTime().getTime() + 3600000L;
                    new StringBuilder("setUpGeofence ").append(pushMessage);
                    this.setUpGeofence(new GeofenceParams.Builder().setCenter(pushMessage.getString("id"), jSONArray.optDouble(0), jSONArray.optDouble(1)).setExpire(l2).setRadius(pushMessage.getInt("r")).build(), pushMessage.has("enter") ? pushMessage.getString("enter") : "entering", pushMessage.has("exit") ? pushMessage.getString("exit") : "exiting", pushMessage.getInt("count"));
                    return;
                }
                if (pushMessage.has("id")) {
                    new StringBuilder("removeGeofenceById ").append(pushMessage.getString("id"));
                    this.removeGeofenceById(pushMessage.getString("id"));
                }
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setUpGeofence(GeofenceParams geofenceParams, String string2, String string3, int n2) {
        Log.d((String)"LocationManager", (String)"setUpGeofence: called");
        long l2 = Calendar.getInstance().getTime().getTime();
        if (geofenceParams.getExpire() - l2 > 0L) {
            long l3 = geofenceParams.getExpire() - l2;
            Geofence geofence = new Geofence.Builder().setRequestId(geofenceParams.getId()).setCircularRegion(geofenceParams.getLatitude(), geofenceParams.getLongitude(), geofenceParams.getRadius()).setTransitionTypes(3).setExpirationDuration(l3).build();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.a.edit().putString("enter_message" + geofenceParams.getId(), string2).apply();
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.a.edit().putString("exit_message" + geofenceParams.getId(), string3).apply();
            }
            if (n2 > 0) {
                this.a.edit().putInt("key_count" + geofenceParams.getId(), n2).apply();
            }
            if (this.c.isConnected()) {
                this.a(geofence);
                return;
            }
            AdpPushClient.get().addListener(new a(this, geofence));
            this.c.connect();
        }
    }

    public void removeGeofenceById(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.removeGeofencesByIds(arrayList);
    }

    public void removeGeofencesByIds(List<String> list) {
        if (this.c != null && this.c.isConnected()) {
            LocationServices.GeofencingApi.removeGeofences(this.c, list).setResultCallback((ResultCallback)new b(this));
        }
    }

    private void a(Geofence object) {
        GeofencingRequest.Builder builder = new ArrayList();
        builder.add(object);
        object = builder;
        builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences((List)object);
        LocationServices.GeofencingApi.addGeofences(this.c, builder.build(), this.b("com.adpdigital.push.location.LOCATION_UPDATE")).setResultCallback((ResultCallback)new c(this));
    }

    public void startTrackingMe(long l2, long l3, float f2) {
        new StringBuilder("startTrackingMe: called, duration: ").append(l2).append(" ,interval: ").append(l3);
        this.enableBackgroundMode();
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(f2).setInterval(l3 * 1000L).build();
        this.a.edit().putLong("duration", l2).apply();
        this.a.edit().putLong("start_time", Calendar.getInstance().getTimeInMillis()).apply();
        AdpPushClient.get().addListener(new d(this));
        this.startLocationUpdates(locationParams);
    }

    public void startLocationUpdates(LocationParams object) {
        LocationParams locationParams = object;
        object = this;
        this.j = locationParams.getInterval();
        ((LocationManager)object).k = locationParams.getDistance();
        ((LocationManager)object).h = locationParams.getAccuracy();
        object = LocationRequest.create().setFastestInterval(((LocationManager)object).j).setInterval(((LocationManager)object).j).setSmallestDisplacement(((LocationManager)object).k);
        switch (locationParams.getAccuracy()) {
            case HIGH: {
                object.setPriority(100);
                break;
            }
            case MEDIUM: {
                object.setPriority(102);
                break;
            }
            case LOW: {
                object.setPriority(104);
                break;
            }
            case LOWEST: {
                object.setPriority(105);
            }
        }
        this.d = object;
        if (this.c.isConnected()) {
            this.b();
            return;
        }
        AdpPushClient.get().addListener(new e(this));
        this.c.connect();
    }

    public void requestSingleLocation(LocationListener locationListener) {
        if (this.a()) {
            return;
        }
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(0L).build();
        AdpPushClient.get().addListener(new f(this, locationListener));
        this.startLocationUpdates(locationParams);
    }

    public void connect() {
        if (this.c != null && !this.c.isConnected()) {
            this.c.connect();
        }
    }

    public void resume() {
        new StringBuilder("resume Connected=").append(this.c.isConnected());
        if (this.c.isConnected()) {
            this.b();
            return;
        }
        this.c.connect();
    }

    public void stop() {
        if (this.c != null && this.c.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.c, (LocationListener)this);
            if (!this.i) {
                this.c("com.adpdigital.push.location.LOCATION_UPDATE");
                this.c("com.adpdigital.push.intent.action.PENDING_INTENT_SERVICE");
            }
            this.c.disconnect();
        }
    }

    public boolean isConnected() {
        return this.c.isConnected();
    }

    private void b() {
        if (ActivityCompat.checkSelfPermission((Context)this.f, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.f, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationServices.FusedLocationApi.requestLocationUpdates(this.c, this.d, (LocationListener)this);
        if (this.i) {
            this.a("com.adpdigital.push.intent.action.PENDING_INTENT_SERVICE");
            this.a("com.adpdigital.push.location.LOCATION_UPDATE");
        }
    }

    private void a(String string2) {
        string2 = this.b(string2);
        LocationServices.FusedLocationApi.requestLocationUpdates(this.c, this.d, (PendingIntent)string2);
    }

    private PendingIntent b(String string2) {
        string2 = new Intent(string2);
        return PendingIntent.getService((Context)this.f, (int)1, (Intent)string2, (int)0);
    }

    private void c(String string2) {
        string2 = this.b(string2);
        LocationServices.FusedLocationApi.removeLocationUpdates(this.c, (PendingIntent)string2);
    }

    public Location getLastLocation() {
        if (this.g != null) {
            return this.g;
        }
        if (this.c != null && this.c.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.f, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.f, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.c);
            if (location != null) {
                return location;
            }
        }
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        AdpPushClient.get().notify((Object)LocationEvent.CONNECTED);
        if (this.e != null) {
            this.e.onConnected(bundle);
        }
    }

    public void onConnectionSuspended(int n2) {
        if (this.e != null) {
            this.e.onSuspended();
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        if (this.e != null) {
            this.e.onConnectionFailed(connectionResult);
        }
    }

    public void onLocationChanged(Location location) {
        new StringBuilder("GEOGEOGEOGEOGEOGEOGEOGEOGEO onLocationChanged ").append(location);
        this.g = location;
        AdpPushClient.get().notify(location);
        if (this.e != null) {
            this.e.onLocationUpdated(location);
        }
    }

    final boolean a() {
        long l2 = this.a.getLong("duration", 0L);
        long l3 = this.a.getLong("start_time", 0L);
        return l2 > 0L && Calendar.getInstance().getTimeInMillis() - l3 < l2 * 1000L;
    }

    public void enableLocationOnLaunch() {
        if (this.a()) {
            return;
        }
        this.requestSingleLocation(new g(this));
    }

    public void publishLocation(Location location) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("lat", location.getLatitude());
            jSONObject.put("lng", location.getLongitude());
            jSONObject.put("ts", location.getTime());
            AdpPushClient.get().publishEvent("geo", jSONObject, false, true);
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    public void addListener(OnLocationUpdateListener onLocationUpdateListener) {
        this.e = onLocationUpdateListener;
    }

    public void removeListener() {
        this.e = null;
        if (this.c != null && this.c.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.c, (LocationListener)this);
            this.c.disconnect();
        }
    }

    public long getIntervel() {
        return this.j;
    }

    public float getDistance() {
        return this.k;
    }

    public LocationAccuracy getAccuracy() {
        return this.h;
    }

    public void enableBackgroundMode() {
        this.i = true;
    }

    public void disableBackgroundMode() {
        this.i = false;
    }

    public boolean isBackgoundModeEnabled() {
        return this.i;
    }

    public void onEnteredGeofences(String[] stringArray, Location location) {
        Log.d((String)"LocationManager", (String)"onEnteredGeofences: called");
        for (String string2 : stringArray) {
            int n2 = this.a.getInt("key_count" + string2, 0);
            if (n2 > 0) {
                Log.d((String)"LocationManager", (String)("onEnteredGeofences: count: " + n2));
                String string3 = this.a.getString("enter_message" + string2, "");
                this.a(string2, string3);
                this.a.edit().putInt("key_count" + string2, n2 - 1).apply();
                continue;
            }
            this.a.edit().remove("key_count" + string2).apply();
            this.a.edit().remove("enter_message" + string2).apply();
            this.removeGeofenceById(string2);
        }
    }

    public void onExitedGeofences(String[] stringArray, Location location) {
        for (String string2 : stringArray) {
            int n2 = this.a.getInt("key_count" + string2, 0);
            if (n2 > 0) {
                Log.d((String)"LocationManager", (String)("onEnteredGeofences: count: " + n2));
                String string3 = this.a.getString("exit_message" + string2, "");
                this.a(string2, string3);
                this.a.edit().putInt("key_count" + string2, n2 - 1).apply();
                continue;
            }
            this.a.edit().remove("key_count" + string2).apply();
            this.a.edit().remove("exit_message" + string2).apply();
            this.removeGeofenceById(string2);
        }
    }

    private void a(String string2, String string3) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.f);
        builder.setSmallIcon(R.drawable.common_full_open_on_phone).setLargeIcon(BitmapFactory.decodeResource((Resources)this.f.getResources(), (int)R.drawable.common_full_open_on_phone)).setColor(-65536).setContentTitle((CharSequence)string2).setContentText((CharSequence)string3);
        builder.setAutoCancel(true);
        ((NotificationManager)this.f.getSystemService("notification")).notify(0, builder.build());
    }

    static /* synthetic */ void a(LocationManager locationManager, Geofence geofence) {
        locationManager.a(geofence);
    }

    static /* synthetic */ OnLocationUpdateListener a(LocationManager locationManager) {
        return locationManager.e;
    }

    static /* synthetic */ Context b(LocationManager locationManager) {
        return locationManager.f;
    }

    static /* synthetic */ void c(LocationManager locationManager) {
        locationManager.b();
    }

    static /* synthetic */ Location a(LocationManager locationManager, Location location) {
        locationManager.g = location;
        return locationManager.g;
    }
}

