/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.IntentService;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;

public abstract class GeoEventsIntentService
extends IntentService {
    public GeoEventsIntentService() {
        super("GeoEventsIntentService");
    }

    public GeoEventsIntentService(String string2) {
        super(string2);
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: called");
        intent = GeofencingEvent.fromIntent((Intent)intent);
        if (intent != null) {
            if (intent.hasError()) {
                this.onError(intent.getErrorCode());
                return;
            }
            int n2 = intent.getGeofenceTransition();
            if (n2 == 1 || n2 == 4 || n2 == 2) {
                Location location = intent.getTriggeringLocation();
                String[] stringArray = new String[intent.getTriggeringGeofences().size()];
                for (int i2 = 0; i2 < intent.getTriggeringGeofences().size(); ++i2) {
                    stringArray[i2] = ((Geofence)intent.getTriggeringGeofences().get(i2)).getRequestId();
                }
                if (n2 == 1 || n2 == 4) {
                    this.onEnteredGeofences(stringArray, location);
                    return;
                }
                if (n2 == 2) {
                    this.onExitedGeofences(stringArray, location);
                }
                return;
            }
            Log.d((String)"GeoEventsIntentService", (String)"onHandleIntent: transition invalid");
        }
    }

    protected abstract void onEnteredGeofences(String[] var1, Location var2);

    protected abstract void onExitedGeofences(String[] var1, Location var2);

    protected abstract void onError(int var1);
}

