/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.ak;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessage
extends ak {
    private long createdAt;
    private boolean inApp = false;
    private boolean live = false;
    private boolean stateful = false;
    private long expireAt;
    protected String body;
    private JSONObject data;
    private String senderId;
    private String sentId;
    private boolean notify = true;
    private boolean useAsAlert = false;
    private String alertText;

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long l2) {
        this.createdAt = l2;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string2) {
        this.body = string2;
    }

    public boolean isInApp() {
        return this.inApp;
    }

    public void setInApp(boolean bl2) {
        this.inApp = bl2;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean bl2) {
        this.live = bl2;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean bl2) {
        this.stateful = bl2;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(long l2) {
        this.expireAt = l2;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setData(JSONObject jSONObject) {
        this.data = jSONObject;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String string2) {
        this.senderId = string2;
    }

    public String getSentId() {
        return this.sentId;
    }

    public void setSentId(String string2) {
        this.sentId = string2;
    }

    public boolean isUseAsAlert() {
        return this.useAsAlert;
    }

    public void setUseAsAlert(boolean bl2) {
        this.useAsAlert = bl2;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public void setAlertText(String string2) {
        this.alertText = string2;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl2) {
        this.notify = bl2;
    }

    public static PushMessage fromJson(String stringArray, String string2) {
        PushMessage pushMessage = new PushMessage();
        try {
            stringArray = new JSONObject((String)stringArray);
            pushMessage.setTopicName(string2);
            pushMessage.setId(stringArray.getString("id"));
            pushMessage.setCreatedAt(stringArray.getLong("createdAt"));
            pushMessage.setReceivedAt(System.currentTimeMillis());
            pushMessage.setBody(stringArray.optString("content"));
            pushMessage.setData(stringArray.optJSONObject("data"));
            long l2 = stringArray.optLong("ttl", 0L);
            if (l2 > 0L) {
                pushMessage.setExpireAt(pushMessage.getCreatedAt() + l2 * 1000L);
            }
            pushMessage.setInApp(stringArray.optBoolean("inApp"));
            pushMessage.setLive(stringArray.optBoolean("live"));
            pushMessage.setNotify(!stringArray.optBoolean("silent", false));
            pushMessage.setStateful(stringArray.optBoolean("stateful"));
            stringArray = stringArray.optString("publishId");
            if (stringArray != null && (stringArray = stringArray.split("/")).length == 3) {
                pushMessage.setSenderId(stringArray[0]);
                pushMessage.setSentId(stringArray[2]);
            }
            return pushMessage;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Invalid Json " + jSONException.getMessage());
        }
    }

    public String toJson() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", (Object)this.id);
            jSONObject.put("createdAt", this.createdAt);
            if (this.body != null) {
                jSONObject.put("content", (Object)this.body);
            }
            if (this.expireAt > 0L) {
                long l2 = (this.getExpireAt() - this.getCreatedAt()) / 1000L;
                jSONObject.put("ttl", l2);
            }
            if (this.inApp) {
                jSONObject.put("inApp", true);
            }
            if (!this.notify) {
                jSONObject.put("silent", true);
            }
            if (this.stateful) {
                jSONObject.put("stateful", true);
            }
            if (this.useAsAlert) {
                jSONObject.put("useAsAlert", true);
            }
            if (this.alertText != null) {
                jSONObject.put("alertText", (Object)this.alertText);
            }
            if (this.data != null) {
                jSONObject.put("data", (Object)this.data);
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Invalid Json " + jSONException.getMessage());
        }
    }

    public String toString() {
        return "PushMessage{id='" + this.id + '\'' + ", createdAt=" + this.createdAt + ", topic='" + this.topicName + '\'' + ", inapp='" + this.inApp + '\'' + ", stateful='" + this.stateful + '\'' + ", data='" + (this.data != null ? this.data.toString() : "null") + '\'' + '}';
    }

    @Override
    public String getIntentType() {
        return "com.adpdigital.push.client.MSGRECEIVE";
    }

    public void markAsRead() {
        PushMessage.markAsRead(this.id);
    }

    public static void markAsRead(String string2) {
        AdpPushClient.get().publishMessageEvent("seen", string2);
    }

    public void dismiss() {
        PushMessage.messageDismissed(this.id);
    }

    public static void messageDismissed(String string2) {
        AdpPushClient.get().publishMessageEvent("dismiss", string2);
    }
}

